/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.card;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.formplugin.card.BaseCostCardPlugin;
import kd.macc.aca.formplugin.card.TotalCostCardPlugin;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class UnitCostCardPlugin
extends BaseCostCardPlugin
implements BeforeF7SelectListener {
    protected static final Log logger = LogFactory.getLog(TotalCostCardPlugin.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit materialRange = (BasedataEdit)this.getControl("materialrange");
        materialRange.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getControl("periodunitcost");
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (name) {
            case "periodunitcost": {
                DynamicObject parentData = this.getView().getParentView().getModel().getDataEntity();
                DynamicObject org = parentData.getDynamicObject("org");
                if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"UnitCostCardPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObject acct = parentData.getDynamicObject("costaccount");
                if (CadEmptyUtils.isEmpty((DynamicObject)acct)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"UnitCostCardPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                listShowParameter.getListFilterParameter().getQFilters().add(StartCostHelper.getUsePeriodFilter((Long)org.getLong("id"), (Long)acct.getLong("id")));
                break;
            }
            case "materialrange": {
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                List<QFilter> orgFilter = this.getOrgFilter();
                orgFilter.add(new QFilter("entryentity.material.masterid", ">", (Object)0));
                DynamicObjectCollection matId = QueryServiceHelper.query((String)"aca_calcresult", (String)"entryentity.material.masterid material", (QFilter[])orgFilter.toArray(new QFilter[0]));
                List<Long> matIds = this.getMaterialId(matId, 0);
                filters.add(new QFilter("masterid", "in", matIds));
                List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
                qFilters.addAll(filters);
            }
        }
    }

    protected List<QFilter> getOrgFilter() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        try {
            DynamicObject parentData = this.getView().getParentView().getModel().getDataEntity();
            DynamicObject org = parentData.getDynamicObject("org");
            if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
                filters.add(new QFilter("org", "=", org.getPkValue()));
            } else {
                filters.add(new QFilter("org", "=", (Object)-1L));
            }
            DynamicObject acct = parentData.getDynamicObject("costaccount");
            if (!CadEmptyUtils.isEmpty((DynamicObject)acct)) {
                filters.add(new QFilter("costaccount", "=", acct.getPkValue()));
            } else {
                filters.add(new QFilter("costaccount", "=", (Object)-1L));
            }
            DynamicObject cc = parentData.getDynamicObject("costcenter");
            if (!CadEmptyUtils.isEmpty((DynamicObject)cc)) {
                filters.add(new QFilter("costcenter", "=", cc.getPkValue()));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return filters;
    }

    protected DataSet queryData() {
        DynamicObject period = (DynamicObject)this.getModel().getValue("periodunitcost");
        List<QFilter> filters = this.getOrgFilter();
        if (!CadEmptyUtils.isEmpty((DynamicObject)period)) {
            filters.add(new QFilter("period", "=", period.getPkValue()));
        }
        String selectFields = "id,entryentity.feetype feetype,entryentity.type type,entryentity.pdcurramount amount,entryentity.pdcurrqty qty,entryentity.material.masterid material,entryentity.material.name matname,entryentity.element element";
        DataSet dataSetQuery = QueryServiceHelper.queryDataSet((String)"TotalCostCardPlugin.queryData", (String)"aca_calcresult", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        DataSet dataSetFinal = dataSetQuery.filter("type = 'finalResult'").select("id,qty as calqty");
        DataSet dataSetDetail = dataSetQuery.filter("type = 'detail'").select("id,feetype,type,amount,qty,material,matname,element");
        DataSet dataSet = dataSetDetail.join(dataSetFinal).on("id", "id").select(new String[]{"feetype", "amount", "qty", "material", "matname", "element"}, new String[]{"calqty"}).finish().filter("material>0 and element>0");
        dataSet = dataSet.select(new String[]{"feetype", "amount", "case when feetype='mfgFee' then calqty else qty end as qty", "material", "matname", "element"}).filter("qty != 0 and amount != 0");
        return dataSet;
    }

    private void query() {
        DynamicObjectCollection materialrange = (DynamicObjectCollection)this.getModel().getValue("materialrange");
        DataSet dataSet = this.queryData();
        dataSet = dataSet.groupBy(new String[]{"element", "material", "matname"}).sum("amount").sum("qty").finish();
        HashMap<Long, String> matMap = new HashMap<Long, String>(16);
        DataSet matDataSet = dataSet.copy().select("material,matname,amount,qty").groupBy(new String[]{"material", "matname"}).sum("amount").sum("qty").finish().filter("qty != 0");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)materialrange)) {
            matDataSet = matDataSet.select("material,matname,amount,qty, amount/qty price").orderBy(new String[]{"price desc"}).top(10);
            for (Iterator row : matDataSet) {
                matMap.put(row.getLong("material"), row.getString("matname"));
            }
        } else {
            List<Long> materialList = this.getMaterialId(materialrange, 1);
            for (Row row : matDataSet) {
                if (!materialList.contains(row.getLong("material"))) continue;
                matMap.put(row.getLong("material"), row.getString("matname"));
            }
        }
        String elementId = "";
        BigDecimal sumOtherAmount = BigDecimal.ZERO;
        BigDecimal sumOtherQty = BigDecimal.ZERO;
        ArrayList<Group> groupList = new ArrayList<Group>(10);
        HashMap<Long, Map<String, Object>> dataMap = new HashMap<Long, Map<String, Object>>(16);
        block16: for (Row row : dataSet) {
            if (!matMap.containsKey(row.getLong("material"))) continue;
            elementId = row.getLong("element") == null ? "" : row.getLong("element").toString();
            Double value = this.getNotEmptyBigdecimal(row.getBigDecimal("amount")).divide(CadEmptyUtils.isEmpty((BigDecimal)row.getBigDecimal("qty")) ? new BigDecimal(1) : row.getBigDecimal("qty"), 2, RoundingMode.HALF_UP).doubleValue();
            switch (elementId) {
                case "773126985240072192": {
                    dataMap.computeIfAbsent(row.getLong("material"), k -> new HashMap()).put("material", value);
                    groupList.add(new Group(this.getGroupName("773126985240072192"), "material", "#40A9FF", ChartType.bar, 0));
                    continue block16;
                }
                case "773141433937984512": {
                    dataMap.computeIfAbsent(row.getLong("material"), k -> new HashMap()).put("materialFee", value);
                    groupList.add(new Group(this.getGroupName("773141433937984512"), "materialFee", "#73D13D", ChartType.bar, 0));
                    continue block16;
                }
                case "773177371976173568": {
                    dataMap.computeIfAbsent(row.getLong("material"), k -> new HashMap()).put("mfgFee", value);
                    groupList.add(new Group(this.getGroupName("773177371976173568"), "mfgFee", "#FFA940", ChartType.bar, 0));
                    continue block16;
                }
                case "773173188837423104": {
                    dataMap.computeIfAbsent(row.getLong("material"), k -> new HashMap()).put("resource", value);
                    groupList.add(new Group(this.getGroupName("773173188837423104"), "resource", "#45DAD1", ChartType.bar, 0));
                    continue block16;
                }
                case "773173574319126528": {
                    dataMap.computeIfAbsent(row.getLong("material"), k -> new HashMap()).put("outWork", value);
                    groupList.add(new Group(this.getGroupName("773173574319126528"), "outWork", "#6682F5", ChartType.bar, 0));
                    continue block16;
                }
            }
            sumOtherAmount = sumOtherAmount.add(this.getNotEmptyBigdecimal(row.getBigDecimal("amount")));
            sumOtherQty = sumOtherQty.add(this.getNotEmptyBigdecimal(row.getBigDecimal("qty")));
            dataMap.computeIfAbsent(row.getLong("material"), k -> new HashMap()).put("other", sumOtherAmount.divide(sumOtherQty, 2, RoundingMode.HALF_UP));
            groupList.add(new Group(this.getGroupName("other"), "other", "#FFC53D", ChartType.bar, 0));
        }
        this.drawChart(dataMap, matMap, groupList);
    }

    private List<Long> getMaterialId(DynamicObjectCollection materialrange, int type) {
        ArrayList<Long> resultList = new ArrayList<Long>();
        for (DynamicObject mat : materialrange) {
            if (type == 1) {
                resultList.add(mat.getDynamicObject("fbasedataid").getLong("masterid"));
                continue;
            }
            resultList.add(mat.getLong("material"));
        }
        return resultList;
    }

    private String getGroupName(String elementId) {
        switch (elementId) {
            case "773126985240072192": {
                return ResManager.loadKDString((String)"\u7269\u6599", (String)"UnitCostCardPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]);
            }
            case "773141433937984512": {
                return ResManager.loadKDString((String)"\u7269\u6599\u8d39\u7528", (String)"UnitCostCardPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]);
            }
            case "773177371976173568": {
                return ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528", (String)"UnitCostCardPlugin_4", (String)"macc-aca-formplugin", (Object[])new Object[0]);
            }
            case "773173188837423104": {
                return ResManager.loadKDString((String)"\u8d44\u6e90", (String)"UnitCostCardPlugin_5", (String)"macc-aca-formplugin", (Object[])new Object[0]);
            }
            case "773173574319126528": {
                return ResManager.loadKDString((String)"\u5916\u534f\u52a0\u5de5\u8d39", (String)"UnitCostCardPlugin_6", (String)"macc-aca-formplugin", (Object[])new Object[0]);
            }
        }
        return ResManager.loadKDString((String)"\u5176\u4ed6", (String)"UnitCostCardPlugin_7", (String)"macc-aca-formplugin", (Object[])new Object[0]);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "periodunitcost": 
            case "materialrange": {
                this.query();
            }
        }
    }

    public void drawChart(Map<Long, Map<String, Object>> dataMap, Map<Long, String> matMap, List<Group> groupList) {
        if (CadEmptyUtils.isEmpty(dataMap)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"histogramchartap"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"histogramchartap"});
        HistogramChart customchart = this.getMainChart();
        customchart.clearData();
        customchart.setShowLegend(true);
        customchart.setShowTitle(false);
        customchart.setMargin(Position.right, "80");
        customchart.setMargin(Position.top, "5");
        customchart.setMargin(Position.bottom, "100");
        customchart.setShowLegend(true);
        customchart.setLegendPropValue("right", (Object)0);
        customchart.setLegendPropValue("top", (Object)20);
        customchart.setLegendPropValue("itemWidth", (Object)8);
        customchart.setLegendPropValue("itemHeight", (Object)8);
        customchart.setLegendVertical(true);
        ArrayList<String> materiaName = new ArrayList<String>(10);
        for (Map.Entry<Long, Map<String, Object>> entry : dataMap.entrySet()) {
            materiaName.add(matMap.get(entry.getKey()));
        }
        Map<Group, List<Double>> sortedData = this.getData(dataMap, groupList);
        sortedData.forEach((group, data) -> this.createBarSeries((Group)group, (List<Double>)data));
        Axis xAxis = this.createCategoryAxis("", true);
        xAxis.setCategorys(materiaName);
        HashMap xAxisPointer = Maps.newHashMap();
        xAxisPointer.put("show", Boolean.TRUE);
        xAxisPointer.put("type", "shadow");
        Label xAxisLabel = new Label();
        xAxisLabel.setShow(true);
        xAxisPointer.put("label", xAxisLabel);
        xAxis.setName(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"UnitCostCardPlugin_8", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        xAxis.setPropValue("axisPointer", (Object)xAxisPointer);
        Axis yAxis = this.createValueAxis(ResManager.loadKDString((String)"\u5355\u4f4d\u6210\u672c", (String)"UnitCostCardPlugin_9", (String)"macc-aca-formplugin", (Object[])new Object[0]), false);
        HashMap axisLabel1 = Maps.newHashMap();
        axisLabel1.put("formatter", "{value}");
        yAxis.setPropValue("axisLabel", (Object)axisLabel1);
        yAxis.setPropValue("minInterval", (Object)1);
        HashMap yAxisPointer = Maps.newHashMap();
        yAxisPointer.put("show", Boolean.TRUE);
        yAxisPointer.put("type", "line");
        Label yAxisLabel = new Label();
        yAxisLabel.setShow(true);
        yAxisLabel.setBackgroundColor("black");
        yAxisPointer.put("label", xAxisLabel);
        HashMap lineStyle = Maps.newHashMap();
        lineStyle.put("type", "dotted");
        yAxisPointer.put("lineStyle", lineStyle);
        yAxisPointer.put("triggerTooltip", Boolean.FALSE);
        yAxis.setPropValue("axisPointer", (Object)yAxisPointer);
        customchart.refresh();
    }

    private void createBarSeries(Group group, List<Double> data) {
        BarSeries barSeries = this.getMainChart().createBarSeries(group.groupName);
        Label label = new Label();
        label.setBackgroundColor("#0000FF");
        label.setShow(false);
        label.setPosition(Position.insideRight);
        barSeries.setLabel(label);
        barSeries.setColor(group.color);
        barSeries.setType(group.chartType);
        barSeries.setAnimationDuration(2000);
        barSeries.setStack("stack");
        barSeries.setPropValue("yAxisIndex", (Object)group.yAxisIndex);
        barSeries.setData((Number[])data.toArray(new Double[0]));
    }

    private Map<Group, List<Double>> getData(Map<Long, Map<String, Object>> dataMap, List<Group> groups) {
        LinkedHashMap<Group, List<Double>> summaryResult = new LinkedHashMap<Group, List<Double>>(16);
        for (Group group : groups) {
            ArrayList<Object> list = new ArrayList<Object>(10);
            for (int i = 0; i < dataMap.size(); ++i) {
                list.add(null);
            }
            summaryResult.put(group, list);
        }
        int index = 0;
        for (Map.Entry<Long, Map<String, Object>> matEntry : dataMap.entrySet()) {
            for (Map.Entry<String, Object> priceEntry : matEntry.getValue().entrySet()) {
                ((List)summaryResult.get(groups.get(this.getGroupSeq(priceEntry.getKey(), groups)))).set(index, Double.parseDouble(priceEntry.getValue().toString()));
            }
            ++index;
        }
        return summaryResult;
    }

    private int getGroupSeq(String key, List<Group> groups) {
        for (int i = 0; i < groups.size(); ++i) {
            if (!key.equals(groups.get(i).groupKey)) continue;
            return i;
        }
        return 0;
    }

    private Axis createCategoryAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.category) : this.getMainChart().createYAxis(name, AxisType.category);
        HashMap<String, Integer> axisTick = new HashMap<String, Integer>();
        axisTick.put("interval", 0);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private Axis createValueAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.value) : this.getMainChart().createYAxis(name, AxisType.value);
        HashMap axisTick = new HashMap();
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#999999");
        this.getMainChart().setShowTooltip(true);
        return axis;
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private HistogramChart getMainChart() {
        return (HistogramChart)this.getControl("histogramchartap");
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject parentData = this.getView().getParentView().getModel().getDataEntity();
        DynamicObject org = parentData.getDynamicObject("org");
        DynamicObject costAccount = parentData.getDynamicObject("costaccount");
        if (!CadEmptyUtils.isEmpty((DynamicObject)costAccount) && !CadEmptyUtils.isEmpty((DynamicObject)org)) {
            this.getModel().setValue("periodunitcost", (Object)UnitCostCardPlugin.getLastPeriod(org.getPkValue(), costAccount.getPkValue()));
            this.getView().updateView("periodunitcost");
        }
        this.query();
    }

    public static Long getLastPeriod(Object org, Object costAccount) {
        QFilter orgQF = new QFilter("org", "=", org);
        QFilter costaccountQF = new QFilter("entry.costaccount", "=", costAccount);
        DynamicObjectCollection res = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id, entry.currentperiod.number AS number", (QFilter[])new QFilter[]{orgQF, costaccountQF});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)res)) {
            return null;
        }
        String number = ((DynamicObject)res.get(0)).getString("number");
        if (CadEmptyUtils.isEmpty((String)number)) {
            return null;
        }
        String lastNumber = number;
        if (number.endsWith("01")) {
            String yearNum = number.substring(0, 4);
            long year = Long.parseLong(yearNum) - 1L;
            lastNumber = String.valueOf(year).concat("12");
        } else {
            lastNumber = String.valueOf(Long.parseLong(number) - 1L);
        }
        QFilter qfNumber = new QFilter("number", "=", (Object)lastNumber);
        DynamicObject query = QueryServiceHelper.queryOne((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{qfNumber});
        return query == null ? null : Long.valueOf(query.getLong("id"));
    }

    static class Group {
        private String groupName;
        private String groupKey;
        private String color;
        private ChartType chartType;
        private Integer yAxisIndex;

        public Group(String groupName, String groupkey, String color, ChartType chartType, Integer yAxisIndex) {
            this.groupName = groupName;
            this.groupKey = groupkey;
            this.color = color;
            this.chartType = chartType;
            this.yAxisIndex = yAxisIndex;
        }
    }
}

