/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.feealloc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.aca.algox.alloc.AcaMatAllocHelper;
import kd.macc.aca.algox.alloc.output.AllocResult;
import kd.macc.aca.algox.enums.AcaMutexEnum;
import kd.macc.aca.algox.enums.ScaAllocEnum;
import kd.macc.aca.algox.utils.AcaMutexHelper;
import kd.macc.aca.algox.utils.ProgressHelper;
import kd.macc.aca.business.matalloc.MatAllocBiz;
import kd.macc.aca.common.helper.AcaCloseAccountHelper;
import kd.macc.aca.formplugin.base.BaseOrgAndCostAccountListPlugin;
import kd.macc.cad.common.constants.CommonConstant;
import kd.macc.cad.common.enums.BgParamEnum;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadPermissionUtil;
import kd.macc.cad.common.utils.ListViewUtils;
import kd.macc.cad.common.utils.MessgeBoxUtils;
import kd.macc.cad.common.utils.MsgUtils;
import org.apache.commons.lang3.StringUtils;

public class MatAllocateListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private static final Log logger = LogFactory.getLog(MatAllocateListPlugin.class);
    private boolean isFirstInitFilterByMainPage = false;
    private boolean isfirstSetFilterByMainPage = false;
    private static final String closeBack_importResult = "importResult";
    private static final String closeBack_doImport = "doImport";
    private static final String TBL_SCHEMA = "tblschema";
    private static final String IMP_ALLOC_RESULT = "importAllocResult";
    private static final String RETURN_ITEM = "1";
    private static final String NO_RETURN_ITEM = "0";

    public MatAllocateListPlugin() {
        this.isCostAccountDef = Boolean.FALSE;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        boolean linkQuery = false;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        try {
            LinkQueryPkIdCollection linkQueryPkIdCollection = ((ListShowParameter)formShowParameter).getLinkQueryPkIdCollection();
            linkQuery = !CadEmptyUtils.isEmpty((List)linkQueryPkIdCollection);
        }
        catch (Exception ex) {
            logger.error("getLinkQueryPkIdCollection error ->{}", (Object)ex.getMessage());
        }
        if (AppIdHelper.isMacc((IFormView)this.getView())) {
            e.getQFilters().add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
        }
        boolean hasAccount = false;
        for (QFilter filter : e.getQFilters()) {
            if (!"costaccount.id".equals(filter.getProperty()) && !"costaccount.name".equals(filter.getProperty()) && !"org.id".equals(filter.getProperty())) continue;
            hasAccount = true;
            break;
        }
        String source = (String)formShowParameter.getCustomParam("source");
        if (!(hasAccount || linkQuery || kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"HyperLink", (CharSequence)source) || !AppIdHelper.isMacc((IFormView)this.getView()) || "eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView())))) {
            e.getQFilters().add(new QFilter("costaccount", "=", (Object)0L));
        }
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"HyperLink", (CharSequence)source) && this.isfirstSetFilterByMainPage) {
            Map paramMap = formShowParameter.getCustomParams();
            String filterStr = (String)paramMap.get("otherFilter");
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)filterStr)) {
                QFilter filter = QFilter.fromSerializedString((String)filterStr);
                e.getQFilters().add(filter);
            }
            this.isfirstSetFilterByMainPage = false;
        }
    }

    private boolean isMatchCondition(Map<String, Object> paramMap) {
        boolean flag = false;
        String key = (String)paramMap.get("source");
        if ("GardHomePlugin".equals(key)) {
            flag = true;
        }
        return flag;
    }

    public void initialize() {
        super.initialize();
        if ("eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5f52\u96c6\u5217\u8868", (String)"MatAllocateListPlugin_11", (String)"macc-aca-formplugin", (Object[])new Object[0])));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!"eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_trackup"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_voucher", "bar_queryvoucher", "bar_previewvoucher"});
        }
        if (CadBgParamUtils.getBgParamBoolean((BgParamEnum)BgParamEnum.DIRECT_MAT_ALLOC).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"importcollc", "bar_allocate"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{TBL_SCHEMA, "commonalloc", "colreport"});
        }
        this.getView().setVisible(Boolean.valueOf("eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))), new String[]{"colreport"});
        this.getView().setVisible(CadBgParamUtils.getBgParamBoolean((BgParamEnum)BgParamEnum.DIRECT_MAT_ALLOC), new String[]{"importconfigdata"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.isFirstInitFilterByMainPage = true;
        this.isfirstSetFilterByMainPage = true;
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Map paramMap = formShowParameter.getCustomParams();
        if (this.isMatchCondition(paramMap) && this.isFirstInitFilterByMainPage) {
            this.mainPageFilterInit(filterColumns, paramMap);
            this.isFirstInitFilterByMainPage = false;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"subentryentity"});
    }

    private void mainPageFilterInit(List<FilterColumn> filterColumns, Map<String, Object> paramMap) {
        for (int i = filterColumns.size() - 1; i >= 0; --i) {
            FilterColumn filterColumn = filterColumns.get(i);
            CommonFilterColumn schemeFilterColumn = (CommonFilterColumn)filterColumn;
            String schemeFilterColumnName = schemeFilterColumn.getFieldName();
            if ("costaccount.name".equals(schemeFilterColumnName) && paramMap.get("costaccount") != null) {
                ArrayList<Object> orgIdList = new ArrayList<Object>();
                orgIdList.add(paramMap.get("org"));
                List<ComboItem> comboItems = this.getCostAccountComboItemListBy(orgIdList);
                schemeFilterColumn.setComboItems(comboItems);
                schemeFilterColumn.setDefaultValue(paramMap.get("costaccount").toString());
                this.getPageCache().put("costaccount", paramMap.get("costaccount").toString());
                continue;
            }
            if ("org.id".equals(schemeFilterColumnName) && paramMap.get("org") != null) {
                schemeFilterColumn.setDefaultValue(paramMap.get("org").toString());
                continue;
            }
            if ("allocstatus".equals(schemeFilterColumnName) && paramMap.get("allocstatus") != null) {
                List parseArray = JSONArray.parseArray((String)paramMap.get("allocstatus").toString(), String.class);
                schemeFilterColumn.setDefaultValues(parseArray.toArray());
                continue;
            }
            schemeFilterColumn.setDefaultValue((String)null);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemKey;
        super.beforeItemClick(e);
        switch (itemKey = e.getItemKey()) {
            case "importcollc": {
                if (!CadPermissionUtil.check((Long)RequestContext.get().getCurrUserId(), (String)this.getPageCache().get("org"), (boolean)true, (String)"aca", (String)"aca_matalloc", (String)"47156aff000000ac")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6750\u6599\u8017\u7528\u5206\u914d\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MatAllocateListPlugin_22", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    return;
                }
                List<Object> orgIds = this.getOrgCache();
                Long orgId = orgIds == null ? 0L : Long.parseLong(orgIds.get(0).toString());
                if (!this.isExistCostAccount(orgId)) break;
                this.showImportPage();
                break;
            }
            case "tblschema": {
                List<Object> orgCache = this.getOrgCache();
                if (orgCache == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MatAllocateListPlugin_13", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                Long selectedOrgId = Long.parseLong(orgCache.get(0).toString());
                DynamicObjectCollection initedCostAccounts = StartCostHelper.getCostAccounts((Long)selectedOrgId, (Boolean)Boolean.TRUE, (String)this.getView().getFormShowParameter().getAppId());
                if (initedCostAccounts == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u7ed3\u675f\u521d\u59cb\u5316\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"MatAllocateListPlugin_14", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                String costAccountId = this.getPageCache().get("costaccount");
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)costAccountId)) break;
                this.importMatAlloc(selectedOrgId, Long.parseLong(costAccountId));
                break;
            }
            case "tbldel": {
                BillList billist = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection rows = billist.getSelectedRows();
                if (rows == null || rows.isEmpty()) {
                    return;
                }
                e.setCancel(true);
                if (!QueryServiceHelper.exists((String)"aca_matalloc", (QFilter[])this.getAllocQF(rows))) {
                    this.delete();
                    break;
                }
                DynamicObjectCollection res = QueryServiceHelper.query((String)"aca_matalloc", (String)"billno", (QFilter[])this.getAllocQF(rows));
                StringBuilder sb = new StringBuilder();
                for (DynamicObject alloc : res) {
                    String billno = alloc.getString("billno");
                    sb.append(billno).append(",");
                }
                sb.append(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u8bb0\u5f55\u5df2\u7ecf\u5206\u914d\uff0c\u5220\u9664\u540e\u9700\u8981\u91cd\u65b0\u5f15\u5165\u6570\u636e\u5e76\u5206\u914d\u3002\u786e\u8ba4\u5220\u9664\uff1f", (String)"MatAllocateListPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                this.getView().showConfirm(sb.toString(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete", (IFormPlugin)this));
                break;
            }
            case "bar_allocate": {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows == null || selectedRows.size() > 0) {
                    return;
                }
                billList.selectAllRows();
                this.getView().invokeOperation("op_allocate");
                e.setCancel(true);
                break;
            }
            case "colreport": {
                this.viewColReport();
                break;
            }
            case "allocreport": {
                this.viewAllocReport();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "commonalloc": {
                List<Object> orgCache = this.getOrgCache();
                if (orgCache == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MatAllocateListPlugin_13", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long selectedOrgId = Long.parseLong(orgCache.get(0).toString());
                DynamicObjectCollection initedCostAccounts = StartCostHelper.getCostAccounts((Long)selectedOrgId, (Boolean)Boolean.TRUE, (String)this.getView().getFormShowParameter().getAppId());
                if (initedCostAccounts == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u7ed3\u675f\u521d\u59cb\u5316\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"MatAllocateListPlugin_14", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    return;
                }
                String costAccountId = this.getPageCache().get("costaccount");
                Long costAccount = 0L;
                Long periodId = 0L;
                if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)costAccountId)) {
                    for (DynamicObject initedCostAccount : initedCostAccounts) {
                        DynamicObject period;
                        costAccount = initedCostAccount.getLong("id");
                        if (Long.parseLong(costAccountId) != costAccount || (period = PeriodHelper.getCurrentPeriod((Long)costAccount)) == null) continue;
                        periodId = period.getLong("id");
                    }
                }
                List commonAllocBills = MatAllocBiz.getCommonAllocBills((Long)costAccount, (Long)periodId);
                List partition = Lists.partition((List)commonAllocBills, (int)50000);
                AllocResult allocResult = new AllocResult();
                for (List partitionCommonAlloc : partition) {
                    AllocResult result = AcaMatAllocHelper.doAlloc(new HashSet(partitionCommonAlloc), (String)"2");
                    allocResult = allocResult.union(result);
                }
                Map reasonMap = allocResult.getReasonMap();
                if (allocResult.isSuccess()) {
                    if (commonAllocBills.size() == 0) {
                        allocResult.setSuccess(false);
                        reasonMap.put("false", ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\u3002\u5f53\u524d\u671f\u95f4\u5185\u6ca1\u6709\u53ef\u5206\u914d\u7684\u6570\u636e\u3002", (String)"MatAllocateListPlugin_15", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    } else {
                        reasonMap.put("success", ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"MatAllocateListPlugin_16", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    ArrayList<String[]> errorList = new ArrayList<String[]>(reasonMap.size());
                    String titleMsg = ResManager.loadKDString((String)"\u5206\u914d\u6570\u636e", (String)"MatAllocateListPlugin_17", (String)"macc-aca-formplugin", (Object[])new Object[0]);
                    for (Map.Entry entry : reasonMap.entrySet()) {
                        String key = (String)entry.getKey();
                        String msg = String.format(ResManager.loadKDString((String)("%s: " + (String)entry.getValue()), (String)"MatAllocateListPlugin_18", (String)"macc-aca-formplugin", (Object[])new Object[0]), key);
                        errorList.add(new String[]{titleMsg, "Error", msg});
                    }
                    reasonMap.clear();
                    allocResult.setErrorList(errorList);
                }
                IFormView view = this.getView();
                if (allocResult.isSuccess()) {
                    String successInfo = (String)reasonMap.get("success");
                    logger.info("\u5206\u914d\u6210\u529f\uff1a", (Object)successInfo);
                    view.showSuccessNotification(successInfo);
                    view.updateView("billlistap");
                    break;
                }
                List errorList = allocResult.getErrorList();
                if (errorList != null && errorList.size() > 0) {
                    MessgeBoxUtils.showDetailsMessageBox((IFormView)view, (String)ResManager.loadKDString((String)"\u5206\u914d\u6570\u636e", (String)"MatAllocateListPlugin_17", (String)"macc-aca-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5bfc\u5165\u6570\u636e\u3002", (String)"MatAllocateListPlugin_8", (String)"macc-aca-formplugin", (Object[])new Object[0]), (List)errorList);
                } else {
                    String failInfo = (String)reasonMap.get("false");
                    logger.info("\u5206\u914d\u6570\u636e\u5931\u8d25\uff1a", (Object)failInfo);
                    if (failInfo != null) {
                        view.showMessage(failInfo);
                    }
                }
                view.updateView("billlistap");
                break;
            }
        }
    }

    private void importMatAlloc(Long selectedOrgId, Long costAccountId) {
        String progressId = UUID.randomUUID().toString();
        ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"MatAllocateListPlugin_4", (String)"macc-aca-formplugin", (Object[])new Object[0]), () -> {
            Map<Object, Object> responseInfo = new HashMap(2);
            try {
                responseInfo = this.importMatAlloc(selectedOrgId, costAccountId, this.getView().getFormShowParameter().getAppId(), this.getBillEntityId(), progressId);
            }
            catch (Exception e) {
                MsgUtils.putMsg2Map((String)"error", (String)String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff1a%s", (String)"MatAllocateListPlugin_19", (String)"macc-aca-formplugin", (Object[])new Object[0]), e.toString()), responseInfo);
                kd.macc.cad.common.helper.ProgressHelper.showError((String)progressId, (String)e.getMessage());
            }
            String responseInfoStr = SerializationUtils.toJsonString(responseInfo);
            this.getPageCache().put("responseInfo", responseInfoStr);
        }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), IMP_ALLOC_RESULT));
    }

    private boolean isExistCostAccount(Long orgId) {
        List costAccountItems = StartCostHelper.getCostAccountItems((Long)orgId, null, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
        if (costAccountItems.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u6210\u672c\u8d26\u7c3f\u3002", (String)"MatAllocateListPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void showImportPage() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("sca_matallocimport");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam(this.ORG_FIELD, this.getOrgCache());
        fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_doImport));
        this.getView().showForm(fsp);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "delete": {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                this.delete();
                break;
            }
            case "showReport": {
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                this.showColReport((String)responseInfo.get("colReportId"));
                break;
            }
        }
    }

    private void showColReport(String colReportId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("cad_colreport");
        billShowParameter.setCustomParam("id", (Object)colReportId);
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5f52\u96c6\u62a5\u544a", (String)"MatAllocateListPlugin_20", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void delete() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"aca_matalloc", (Object[])selectedRows.getPrimaryKeyValues(), (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"MatAllocateListPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    private QFilter[] getAllocQF(ListSelectedRowCollection rows) {
        ArrayList<Object> idList = new ArrayList<Object>();
        for (ListSelectedRow row : rows) {
            idList.add(row.getPrimaryKeyValue());
        }
        QFilter idQF = new QFilter("id", "in", idList);
        QFilter allocStatusQF = new QFilter("allocstatus", "=", (Object)ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue());
        return new QFilter[]{idQF, allocStatusQF};
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "doImport": {
                this.doImport(e);
                break;
            }
            case "importResult": {
                if ("eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
                    BillList billList = (BillList)this.getControl("billlistap");
                    String responseInfoStr = this.getPageCache().get("responseInfo");
                    if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                        return;
                    }
                    Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                    if ("confirm".equals(responseInfo.get("type"))) {
                        billList.refresh();
                        this.getView().showConfirm((String)responseInfo.get("msg"), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("showReport", (IFormPlugin)this));
                    } else {
                        MsgUtils.showMsgAndRefresh((Map)responseInfo, (IFormView)this.getView(), (BillList)billList);
                    }
                } else {
                    this.dealAllocRes(e);
                }
                this.getView().invokeOperation("extensionpoint");
                break;
            }
            case "importAllocResult": {
                BillList billList = (BillList)this.getControl("billlistap");
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                if ("confirm".equals(responseInfo.get("type"))) {
                    billList.refresh();
                    this.getView().showConfirm((String)responseInfo.get("msg"), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("showReport", (IFormPlugin)this));
                    break;
                }
                MsgUtils.showMsgAndRefresh((Map)responseInfo, (IFormView)this.getView(), (BillList)billList);
                break;
            }
        }
    }

    private void doImport(ClosedCallBackEvent e) {
        Map map;
        Long costAccountId;
        Object data22;
        List selectData = (List)e.getReturnData();
        if (selectData == null || selectData.size() == 0) {
            return;
        }
        long manuOrg = 0L;
        String manuOrgStr = this.getPageCache().get("manuorg");
        if (!CadEmptyUtils.isEmpty((String)manuOrgStr)) {
            manuOrg = Long.parseLong(manuOrgStr);
        }
        boolean closeAccountFlag = false;
        String costAccountName = null;
        String manuOrgNameTip = null;
        String appNum = this.getView().getFormShowParameter().getAppId();
        ArrayList costaccountList = new ArrayList(10);
        for (Object data22 : selectData) {
            DynamicObject dynamicObject = data22.getDynamicObject("currentperiod");
            if (dynamicObject == null) continue;
            DynamicObject calOrg = data22.getDynamicObject("org");
            DynamicObject costAccount = data22.getDynamicObject("costaccount");
            List manuOrgIds = AcaCloseAccountHelper.isCloseAccount((Long)calOrg.getLong("id"), (Long)costAccount.getLong("id"), (Long)manuOrg, (Long)dynamicObject.getLong("id"), (String)this.getBillEntityId());
            if (manuOrgIds != null && manuOrgIds.size() > 0) {
                closeAccountFlag = true;
                costAccountName = costAccount.getString("name");
                QFilter qfId = new QFilter("id", "in", (Object)manuOrgIds);
                DynamicObjectCollection manuOrgNames = QueryServiceHelper.query((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{qfId});
                if (manuOrgNames == null || manuOrgNames.size() <= 0) break;
                List names = manuOrgNames.stream().map(manuOrgName -> manuOrgName.getString("name")).collect(Collectors.toList());
                manuOrgNameTip = StringUtils.join(names, (String)";");
                break;
            }
            DynamicObject costaccount = data22.getDynamicObject("costaccount");
            DynamicObject org = data22.getDynamicObject("org");
            Long orgId = org.getLong("id");
            HashMap<String, Object> costaccountMap = new HashMap<String, Object>();
            costaccountMap.put("org", orgId);
            costaccountMap.put("costaccountnum", costaccount.getString("number"));
            costaccountMap.put("costaccountId", costaccount.getLong("id"));
            costaccountMap.put("currencyId", this.getCurrency(costaccount));
            costaccountMap.put("costtypeId", this.getCosttype(costaccount));
            costaccountMap.put("currentperiodId", dynamicObject.getLong("id"));
            costaccountMap.put("appnum", appNum);
            costaccountList.add(costaccountMap);
        }
        if (closeAccountFlag) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u3001\u751f\u4ea7\u7ec4\u7ec7\u201c%2$s\u201d\u5f53\u524d\u671f\u95f4\u5df2\u5173\u8d26\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5bfc\u5165\u3002", (String)"MatAllocateListPlugin_9", (String)"macc-aca-formplugin", (Object[])new Object[0]), costAccountName, manuOrgNameTip));
            return;
        }
        String errorTip = null;
        data22 = costaccountList.iterator();
        while (data22.hasNext() && !kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)(errorTip = AcaMutexHelper.requireMutex((AcaMutexEnum)AcaMutexEnum.MATALLOC_ALLOCATE, (long)(costAccountId = (Long)(map = (Map)data22.next()).get("costaccountId")))))) {
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank(errorTip)) {
            for (Map map2 : costaccountList) {
                costAccountId = (Long)map2.get("costaccountId");
                AcaMutexHelper.releaseMutex((AcaMutexEnum)AcaMutexEnum.MATALLOC_ALLOCATE, (long)costAccountId);
            }
            this.getView().showErrorNotification(errorTip);
            return;
        }
        String progressId = UUID.randomUUID().toString();
        ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"MatAllocateListPlugin_4", (String)"macc-aca-formplugin", (Object[])new Object[0]), () -> {
            AllocResult alloc = null;
            try {
                switch (appNum) {
                    case "aca": {
                        alloc = AcaMatAllocHelper.toAlloc((List)costaccountList, (String)progressId, null);
                        break;
                    }
                    case "eca": {
                        List<Object> orgIds = this.getOrgCache();
                        Long orgId = orgIds == null ? 0L : Long.parseLong(orgIds.get(0).toString());
                        Map<String, String> responseInfo = this.importMatUse(orgId, costaccountList, progressId, appNum, "aca_matalloc");
                        String responseInfoStr = SerializationUtils.toJsonString(responseInfo);
                        this.getPageCache().put("responseInfo", responseInfoStr);
                        alloc = this.getMatAllocResult(responseInfo);
                        break;
                    }
                }
                ProgressHelper.showSuccess((String)progressId, (String)ResManager.loadKDString((String)"\u5904\u7406\u5b8c\u6210", (String)"MatAllocateListPlugin_5", (String)"macc-aca-formplugin", (Object[])new Object[0]), (int)0);
            }
            catch (Throwable ex) {
                try {
                    logger.error("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165-\u62a5\u9519", ex);
                    alloc = new AllocResult();
                    alloc.setSuccess(false);
                    HashMap<String, String> reasonMap = new HashMap<String, String>();
                    reasonMap.put("false", String.format(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\u5931\u8d25\uff1a%s", (String)"MatAllocateListPlugin_10", (String)"macc-aca-formplugin", (Object[])new Object[0]), ex.getMessage()));
                    alloc.setReasonMap(reasonMap);
                    ProgressHelper.showError((String)progressId, (String)ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5bfc\u5165\u5931\u8d25\u3002", (String)"MatAllocateListPlugin_7", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                }
                catch (Throwable throwable) {
                    for (Map costAccountMap : costaccountList) {
                        Long costAccountId = (Long)costAccountMap.get("costaccountId");
                        AcaMutexHelper.releaseMutex((AcaMutexEnum)AcaMutexEnum.MATALLOC_ALLOCATE, (long)costAccountId);
                    }
                    String resJsonString = SerializationUtils.toJsonString(alloc);
                    this.getPageCache().put("allocRes", resJsonString);
                    throw throwable;
                }
                for (Map costAccountMap : costaccountList) {
                    Long costAccountId = (Long)costAccountMap.get("costaccountId");
                    AcaMutexHelper.releaseMutex((AcaMutexEnum)AcaMutexEnum.MATALLOC_ALLOCATE, (long)costAccountId);
                }
                String resJsonString = SerializationUtils.toJsonString((Object)alloc);
                this.getPageCache().put("allocRes", resJsonString);
            }
            for (Map costAccountMap : costaccountList) {
                Long costAccountId = (Long)costAccountMap.get("costaccountId");
                AcaMutexHelper.releaseMutex((AcaMutexEnum)AcaMutexEnum.MATALLOC_ALLOCATE, (long)costAccountId);
            }
            String resJsonString = SerializationUtils.toJsonString((Object)alloc);
            this.getPageCache().put("allocRes", resJsonString);
        }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_importResult));
    }

    @Override
    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    private AllocResult getMatAllocResult(Map<String, String> responseInfo) {
        AllocResult alloc = new AllocResult();
        ArrayList errorList = Lists.newArrayList();
        alloc.setSuccess("success".equals(responseInfo.get("type")));
        HashMap<String, String> reasonMap = new HashMap<String, String>(16);
        reasonMap.put("success", responseInfo.get("msg"));
        alloc.setReasonMap(reasonMap);
        String titleMsg = ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5bfc\u5165\u6570\u636e\u3002", (String)"MatAllocateListPlugin_8", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        for (Map.Entry<String, String> info : responseInfo.entrySet()) {
            if (!info.getKey().startsWith("error")) continue;
            errorList.add(new String[]{titleMsg, "Error", info.getValue()});
        }
        alloc.setErrorList((List)errorList);
        return alloc;
    }

    private void dealAllocRes(ClosedCallBackEvent e) {
        String resJsonString = this.getPageCache().get("allocRes");
        logger.info("resJsonString:{}", (Object)resJsonString);
        AllocResult alloc = null;
        try {
            alloc = (AllocResult)SerializationUtils.fromJsonString((String)resJsonString, AllocResult.class);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        if (alloc == null) {
            return;
        }
        Map reasonMap = alloc.getReasonMap();
        IFormView view = this.getView();
        if (alloc.isReportContainError()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5206\u914d\u62a5\u544a\u3002", (String)"MatAllocateListPlugin_32", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            view.updateView("billlistap");
            return;
        }
        if (alloc.isSuccess()) {
            String successInfo = (String)reasonMap.get("success");
            logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\u6210\u529f\uff1a", (Object)successInfo);
            view.showSuccessNotification(successInfo);
            view.updateView("billlistap");
        } else {
            List errorList = alloc.getErrorList();
            if (errorList != null && errorList.size() > 0) {
                MessgeBoxUtils.showDetailsMessageBox((IFormView)view, (String)ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5bfc\u5165\u6570\u636e\u3002", (String)"MatAllocateListPlugin_8", (String)"macc-aca-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5bfc\u5165\u6570\u636e\u3002", (String)"MatAllocateListPlugin_8", (String)"macc-aca-formplugin", (Object[])new Object[0]), (List)errorList);
            } else {
                String failInfo = (String)reasonMap.get("false");
                logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\u5931\u8d25\uff1a", (Object)failInfo);
                if (failInfo != null) {
                    view.showMessage(failInfo);
                }
            }
            view.updateView("billlistap");
        }
    }

    private Long getCosttype(DynamicObject costaccount) {
        if (costaccount == null) {
            return null;
        }
        DynamicObject costtype = costaccount.getDynamicObject("costtype");
        if (costtype == null) {
            return CommonConstant.ACA_COST_TYPE_ID;
        }
        return costtype.getLong("id");
    }

    private Long getCurrency(DynamicObject costaccount) {
        if (costaccount == null) {
            return null;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            return null;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        return result.getLong("currency");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        BillList billList = (BillList)e.getHyperLinkClickEvent().getSource();
        Long pkVal = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        if (CadEmptyUtils.isEmpty((Long)pkVal)) {
            return;
        }
        QFilter filter = new QFilter("id", "=", (Object)pkVal);
        filter.and(QFilter.of((String)"allocstatus =? or costobject > 0 or alloctype ='2'", (Object[])new Object[]{ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue()}));
        if (QueryServiceHelper.exists((String)"aca_matalloc", (QFilter[])new QFilter[]{filter})) {
            return;
        }
        HashSet<Long> ids = new HashSet<Long>(16);
        ids.add(pkVal);
        AcaMatAllocHelper.setMatAllocStdNull(ids);
        AcaMatAllocHelper.doAlloc(ids);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "op_allocate": {
                ListSelectedRowCollection list = e.getListSelectedData();
                Object[] ids = list.getPrimaryKeyValues();
                HashSet<Long> idsSet = new HashSet<Long>(16);
                for (Object obj : ids) {
                    idsSet.add(Long.valueOf(obj.toString()));
                }
                AcaMatAllocHelper.setMatAllocStdNull(idsSet);
                break;
            }
            case "generatevoucher": {
                Object[] primaryKeyValues = e.getListSelectedData().getPrimaryKeyValues();
                String msg = this.volidateStatus(Arrays.asList(primaryKeyValues));
                if (!CadEmptyUtils.isEmpty((String)msg)) {
                    this.getView().showTipNotification(msg);
                    e.setCancel(true);
                    return;
                }
                if (!RETURN_ITEM.equals(CadBgParamUtils.getCadBgParamForString((String)"matAllocVhSyncCal", (String)RETURN_ITEM)) || CadEmptyUtils.isEmpty((String)(msg = this.volidate(Arrays.asList(primaryKeyValues))))) break;
                this.getView().showTipNotification(msg);
                e.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        BillList billList = (BillList)this.getControl("billlistap");
        if ("op_allocate".equals(e.getOperateKey())) {
            billList.clearSelection();
            this.getView().updateView("billlistap");
        }
        if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) {
            return;
        }
        switch (e.getOperateKey()) {
            case "op_confirm": 
            case "op_unconfirm": {
                billList.clearSelection();
                this.getView().updateView("billlistap");
                break;
            }
            case "op_trackup": {
                this.trackUp();
                break;
            }
            case "generatevoucher": {
                if (e.getOperationResult().isSuccess()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u51ed\u8bc1\u751f\u6210\u5931\u8d25\uff0c\u9519\u8bef\u8be6\u60c5\u8bf7\u67e5\u770b\u51ed\u8bc1\u751f\u6210\u62a5\u544a\u3002", (String)"MatAllocateListPlugin_23", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                break;
            }
            case "op_isreturnitem": {
                this.updateIsReturnItem(billList, RETURN_ITEM);
                break;
            }
            case "op_noreturnitem": {
                this.updateIsReturnItem(billList, NO_RETURN_ITEM);
                break;
            }
        }
    }

    private void updateIsReturnItem(BillList billList, String returnitem) {
        Long currPeriod;
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CadEmptyUtils.isEmpty((ListSelectedRowCollection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8fd4\u5de5\u7684\u6570\u636e\u3002", (String)"MatAllocateListPlugin_24", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Object> orgIds = this.getOrgCache();
        Long orgId = orgIds == null ? 0L : Long.parseLong(orgIds.get(0).toString());
        Long costaccount = Long.valueOf(this.getPageCache().get("costaccount"));
        Long period = Long.valueOf(this.getPageCache().get("period"));
        if (!period.equals(currPeriod = CalcRptHelper.getCurrPeriod((Long)orgId, (Long)costaccount))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u671f\u95f4\u9700\u4e3a\u5f53\u524d\u671f\u95f4\u3002", (String)"MatAllocateListPlugin_25", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] billIdObj = selectedRows.getPrimaryKeyValues();
        List<Long> billIds = Arrays.asList(billIdObj).stream().map(x -> Long.parseLong(x.toString())).collect(Collectors.toList());
        DataSet allocDs = this.getMatAllocCollectDs(billIds);
        ArrayList<Long> matAllocIds = new ArrayList<Long>(billIds.size());
        for (Row row : allocDs) {
            matAllocIds.add(row.getLong("matcollect"));
        }
        DataSet matCollectDataSet = this.getMatCollectDs(matAllocIds);
        HashSet sourceBillEntryIds = Sets.newHashSetWithExpectedSize((int)128);
        for (Row row : matCollectDataSet) {
            sourceBillEntryIds.add(row.getLong("srcEntryId"));
        }
        DataSet costRecordDs = this.getCalCostRecordDs(sourceBillEntryIds);
        Set<Long> costRecordEntryIds = this.getLongIdSetFromDs(costRecordDs, "billentryId", false);
        DBRoute route = new DBRoute("cal");
        try (TXHandle handle = TX.requiresNew();){
            String updateSql = "update t_sca_matalloc set fisreturnitem=%s  where fid in(%s) ";
            String updateCostRecordSql = "update t_cal_calcostrecordentry set fisrework=%s  where fentryid in(%s) ";
            this.updateData(updateSql, returnitem, billIds, route);
            this.updateData(updateCostRecordSql, returnitem, new ArrayList<Long>(costRecordEntryIds), route);
        }
        this.getView().updateView("billlistap");
        if (RETURN_ITEM.equals(returnitem)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u8fd4\u5de5\u6210\u529f", (String)"MatAllocateListPlugin_26", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u8fd4\u5de5\u6210\u529f", (String)"MatAllocateListPlugin_27", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        }
    }

    private DataSet getMatCollectDs(List<Long> matColIds) {
        QFilter filter = new QFilter("entryentity.id", "in", matColIds);
        return QueryServiceHelper.queryDataSet((String)"matUseCollect", (String)"aca_matusecollect", (String)"sourcebillid as srcBillId,entryentity.sourcebillentryid as srcEntryId,entryentity.id as entryId,entryentity.material.id as matId", (QFilter[])filter.toArray(), null);
    }

    public Set<Long> getLongIdSetFromDs(DataSet ds, String colField, boolean isCopy) {
        DataSet result = ds;
        if (isCopy) {
            result = ds.copy();
        }
        HashSet longIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : result) {
            longIdSet.add(row.getLong(colField));
        }
        return longIdSet;
    }

    private DataSet getCalCostRecordDs(Set<Long> sourceBillEntryIds) {
        QFilter filter = new QFilter("costaccount", "=", (Object)Long.parseLong(this.getPageCache().get("costaccount")));
        filter.and("entry.bizbillentryid", "in", sourceBillEntryIds);
        String selectFields = "entry.id billentryId";
        return QueryServiceHelper.queryDataSet((String)"calCostRecord", (String)"cal_costrecord_subentity", (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    protected void executeBatch(String sql, DBRoute route) {
        DB.execute((DBRoute)route, (String)sql);
    }

    private DataSet getMatAllocCollectDs(List<Long> billIds) {
        String useOrg = this.getPageCache().get("org");
        if (useOrg != null) {
            List orgList = JSON.parseArray((String)useOrg, String.class);
            useOrg = (String)orgList.get(0);
        }
        QFilter filter = new QFilter("org", "=", (Object)Long.valueOf(useOrg));
        filter.and("appnum", "=", (Object)"aca");
        filter.and("costaccount", "=", (Object)Long.parseLong(this.getPageCache().get("costaccount")));
        String period = this.getPageCache().get("period");
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)period)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7684\u6838\u7b97\u5468\u671f\u3002", (String)"MatAllocateListPlugin_28", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        }
        filter.and("period", "=", (Object)Long.parseLong(period));
        filter.and("id", "in", billIds);
        String selectFields = "id,billno,matcollect";
        return QueryServiceHelper.queryDataSet((String)"matAlloc", (String)"aca_matalloc", (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    private String getUpdateInSql(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return NO_RETURN_ITEM;
        }
        StringBuilder sb = new StringBuilder();
        for (Long costcenter : ids) {
            sb.append(",").append(costcenter);
        }
        return sb.substring(1);
    }

    private void updateData(String sqlFmt, String returnitem, List<Long> billIds, DBRoute route) {
        List splitLists = Lists.partition(new ArrayList<Long>(billIds), (int)2000);
        for (List ids : splitLists) {
            String sql = String.format(sqlFmt, returnitem, this.getUpdateInSql(ids));
            this.executeBatch(sql, route);
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        super.beforeCreateListColumns(o);
        List listColumns = o.getListColumns();
        listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            if (!column.toString().equals("billno")) continue;
            column.setFixed(true);
        }
        HashSet hiddenKeys = Sets.newHashSet((Object[])new String[]{"creatvoucher", "vouchernum"});
        if ("eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)o, (Set)hiddenKeys);
        }
    }

    @Override
    protected void getCostAccountIdsFilter(BeforeFilterF7SelectEvent args, Long orgId) {
        if (!CadEmptyUtils.isEmpty((Long)orgId)) {
            QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledFilter(Collections.singletonList(orgId), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            args.getQfilters().add(enabledCostAccountIdsFilter);
        }
    }

    private void viewColReport() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"cad_colreport", (boolean)true, (int)1, (boolean)false);
        List<Object> orgIds = this.getOrgCache();
        Long orgId = orgIds == null ? 0L : Long.parseLong(orgIds.get(0).toString());
        listShowParameter.setCustomParam("appnum", (Object)this.getView().getFormShowParameter().getAppId());
        listShowParameter.setCustomParam("org", (Object)orgId);
        listShowParameter.setCustomParam("colobj", (Object)CollectObjectEnum.MAT_ALLOC.getObj());
        if ("eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5f52\u96c6\u5f15\u5165\u62a5\u544a", (String)"MatAllocateListPlugin_29", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        } else {
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\u62a5\u544a", (String)"MatAllocateListPlugin_21", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void viewAllocReport() {
        List<Object> orgIds = this.getOrgCache();
        Long orgId = orgIds == null ? 0L : Long.parseLong(orgIds.get(0).toString());
        String costAccoutId = this.getPageCache().get("costaccount");
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("cad_allocreport");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        showParameter.getCustomParams().put("taskname", "8");
        showParameter.getCustomParams().put("orgId", String.valueOf(orgId));
        if (!CadEmptyUtils.isEmpty((String)costAccoutId)) {
            showParameter.getCustomParams().put("accountId", costAccoutId);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void trackUp() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CadEmptyUtils.isEmpty((ListSelectedRowCollection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4e0a\u67e5\u7684\u6570\u636e\u3002", (String)"MatAllocateListPlugin_12", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] pkIds = selectedRows.getPrimaryKeyValues();
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)pkIds), new QFilter("appnum", "=", (Object)"eca")};
        DynamicObjectCollection records = QueryServiceHelper.query((String)"aca_matalloc", (String)"matcollect", (QFilter[])filters);
        if (records.isEmpty()) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(records.size());
        records.forEach(p -> ids.add(p.getLong("matcollect")));
        this.showBillByPkId(ids);
    }

    private void showBillByPkId(List<Long> pkIds) {
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_list");
        param.setBillFormId("cal_costrecord_subentity");
        param.setCustomParam("sqlQuery", (Object)"true");
        param.setCustomParam("isShowTitle", (Object)"true");
        pkIds.forEach(t -> param.addLinkQueryPkId(t));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    private Map<String, String> importMatUse(Long orgId, List<Map<String, Object>> costAccountList, String progressId, String appNum, String entityId) {
        Map resultInfo = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"matUseService", (String)"importMatUse", (Object[])new Object[]{orgId, costAccountList, progressId, appNum, entityId});
        return resultInfo;
    }

    private Map<String, String> importMatAlloc(Long orgId, Long costAccountId, String appNum, String entityId, String progressId) {
        return (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"MatAllocConfigService", (String)"importMatAlloc", (Object[])new Object[]{orgId, costAccountId, appNum, entityId, progressId});
    }

    private Set<Long> getMatAllocSrcBillIds(List<Object> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getMatAllocSrcBillIds", (String)"aca_matalloc", (String)"sourcebillid", (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> resIds = new HashSet<Long>(10);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long sourcebillid = row.getLong("sourcebillid");
            if (CadEmptyUtils.isEmpty((Long)sourcebillid)) continue;
            resIds.add(sourcebillid);
        }
        return resIds;
    }

    private String volidate(List<Object> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"volidate", (String)"aca_matalloc", (String)"costaccount,sourcebillid,1 as sumcount", (QFilter[])new QFilter[]{filter}, null);
        dataSet = dataSet.groupBy(new String[]{"costaccount", "sourcebillid"}).sum("sumcount").finish();
        DataSet copyDataSet = dataSet.copy();
        HashSet<Long> resIds = new HashSet<Long>(10);
        Long costAccount = 0L;
        while (copyDataSet.hasNext()) {
            Row row = copyDataSet.next();
            Long sourcebillid = row.getLong("sourcebillid");
            if (!CadEmptyUtils.isEmpty((Long)sourcebillid)) {
                resIds.add(sourcebillid);
            }
            if (!CadEmptyUtils.isEmpty((Long)costAccount)) continue;
            costAccount = row.getLong("costaccount");
        }
        if (CadEmptyUtils.isEmpty(resIds)) {
            return "";
        }
        filter = new QFilter("sourcebillid", "in", resIds);
        filter.and(new QFilter("costaccount", "=", (Object)costAccount));
        DataSet allDataSet = QueryServiceHelper.queryDataSet((String)"volidate", (String)"aca_matalloc", (String)"billno,sourcebillid as allsourcebillid,1 as allsumcount", (QFilter[])new QFilter[]{filter}, null);
        DataSet copyAllDataSet = allDataSet.copy();
        allDataSet = allDataSet.groupBy(new String[]{"allsourcebillid"}).sum("allsumcount").finish();
        DataSet finish = dataSet.join(allDataSet, JoinType.LEFT).on("sourcebillid", "allsourcebillid").select(dataSet.getRowMeta().getFieldNames(), new String[]{"allsourcebillid", "allsumcount"}).finish();
        finish = finish.filter("sumcount != allsumcount");
        if (finish.isEmpty()) {
            return "";
        }
        finish = finish.join(copyAllDataSet, JoinType.LEFT).on("sourcebillid", "allsourcebillid").select(finish.getRowMeta().getFieldNames(), new String[]{"billno"}).finish();
        String msg = ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5bf9\u5e94\u6e90\u5355\u4e0e\u672c\u6279\u6b21\u751f\u6210\u51ed\u8bc1\u7684\u5355\u636e\u5bf9\u5e94\u6e90\u5355\u4e00\u81f4\uff0c\u5e94\u4e00\u5e76\u9009\u4e0a\u8fdb\u884c\u751f\u6210\u51ed\u8bc1\u3002", (String)"MatAllocateListPlugin_30", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        String billnoStr = "";
        while (finish.hasNext()) {
            Row row = finish.next();
            String billno = row.getString("billno");
            if (CadEmptyUtils.isEmpty((String)billnoStr)) {
                billnoStr = billno;
                continue;
            }
            billnoStr = billnoStr + "\u3001" + billno;
        }
        return String.format(msg, billnoStr);
    }

    private String volidateStatus(List<Object> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"volidate", (String)"aca_matalloc", (String)"billno,allocstatus", (QFilter[])new QFilter[]{filter}, null);
        HashSet<String> notConfirmBills = new HashSet<String>(10);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String billno = row.getString("billno");
            String allocstatus = row.getString("allocstatus");
            if ("2".equals(allocstatus)) continue;
            notConfirmBills.add(billno);
        }
        if (CadEmptyUtils.isEmpty(notConfirmBills)) {
            return "";
        }
        String msg = ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u7684\u5206\u914d\u72b6\u6001\u4e0d\u662f\u5df2\u786e\u8ba4\u72b6\u6001\uff0c\u4e0d\u80fd\u751f\u6210\u51ed\u8bc1\u3002", (String)"MatAllocateListPlugin_31", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        String billnoStr = "";
        for (String billno : notConfirmBills) {
            if (CadEmptyUtils.isEmpty((String)billnoStr)) {
                billnoStr = billno;
                continue;
            }
            billnoStr = billnoStr + "\u3001" + billno;
        }
        return String.format(msg, billnoStr);
    }
}

