/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.feealloc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.business.wipallocstd.WipAllocStdService;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.ProAllocStdHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ProAllocStdEdit
extends AbstractBillPlugIn
implements RowClickEventListener,
EntryGridBindDataListener {
    private static final String ELEMENT = "element";
    private static final String SUBELEMENT = "subelement";
    private static final String ASSEMBLEY = "3";
    private static final String FIXED_VALUE = "1";
    private static final String CALMETHOD = "calmethod";
    private static final String ADD_ROW = "advconbaritemap2";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object acctOrg = formShowParameter.getCustomParam("orgId");
        Object costaccount = formShowParameter.getCustomParam("costaccount");
        Object org = this.getModel().getValue("org");
        if (acctOrg != null && org == null) {
            this.getModel().setValue("org", acctOrg);
        }
        Object costaccObj = this.getModel().getValue("costaccount");
        if (costaccount != null && costaccObj == null) {
            this.getCostAccountToPageCache();
            this.getModel().setValue("costaccount", costaccount);
        }
        this.hideCostType();
        DynamicObjectCollection allocEntry = this.getModel().getEntryEntity("allocentry");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)allocEntry)) {
            this.viewAddRow((DynamicObject)allocEntry.get(0));
        }
        this.getModel().setValue("appnum", (Object)this.getView().getFormShowParameter().getAppId());
        this.getModel().setDataChanged(false);
    }

    private void hideCostType() {
        DynamicObjectCollection allocEntry = this.getModel().getEntryEntity("allocentry");
        if (allocEntry != null) {
            for (int j = 0; j < allocEntry.size(); ++j) {
                DynamicObject entry = (DynamicObject)allocEntry.get(j);
                DynamicObjectCollection productSubEntry = entry.getDynamicObjectCollection("productsubentry");
                if (productSubEntry != null) {
                    for (int i = 0; i < productSubEntry.size(); ++i) {
                        DynamicObject subEntry = (DynamicObject)productSubEntry.get(i);
                        String costDriverDetail = subEntry.getString("costdriverdetail");
                        this.getView().setEnable(Boolean.valueOf("5".equals(costDriverDetail)), i, new String[]{"costtype"});
                    }
                }
                String costdriver = entry.getString("costdriver");
                this.getView().setEnable(Boolean.valueOf("6".equals(costdriver)), j, new String[]{"costagent"});
                this.getView().setEnable(Boolean.valueOf("6".equals(costdriver)), j, new String[]{CALMETHOD});
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        int[] selectRows = entryGrid.getSelectRows();
        int selectRow = selectRows[0];
        DynamicObjectCollection allocentry = this.getModel().getEntryEntity("allocentry");
        for (int i = 0; i < allocentry.size(); ++i) {
            if (selectRow != i) continue;
            DynamicObject entry = (DynamicObject)allocentry.get(i);
            DynamicObjectCollection productsubentry = entry.getDynamicObjectCollection("productsubentry");
            for (int j = 0; j < productsubentry.size(); ++j) {
                DynamicObject subEntry = (DynamicObject)productsubentry.get(j);
                String costdriverdetail = subEntry.getString("costdriverdetail");
                if ("5".equals(costdriverdetail)) {
                    this.getView().setEnable(Boolean.valueOf(true), j, new String[]{"costtype"});
                    continue;
                }
                this.getView().setEnable(Boolean.valueOf(false), j, new String[]{"costtype"});
            }
            String costdriver = entry.getString("costdriver");
            if ("6".equals(costdriver)) {
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"costagent"});
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{CALMETHOD});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"costagent"});
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{CALMETHOD});
            }
            this.viewAddRow(entry);
        }
    }

    private void viewAddRow(DynamicObject entry) {
        if (entry == null) {
            return;
        }
        String calmethod = entry.getString(CALMETHOD);
        if (FIXED_VALUE.equals(calmethod)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ADD_ROW});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{ADD_ROW});
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        int startIndex = e.getStartIndex();
        DynamicObjectCollection allocentry = this.getModel().getEntryEntity("allocentry");
        for (int i = 0; i < allocentry.size(); ++i) {
            if (startIndex != i) continue;
            DynamicObject entry = (DynamicObject)allocentry.get(i);
            DynamicObjectCollection productsubentry = entry.getDynamicObjectCollection("productsubentry");
            for (int j = 0; j < productsubentry.size(); ++j) {
                DynamicObject subEntry = (DynamicObject)productsubentry.get(j);
                String costdriverdetail = subEntry.getString("costdriverdetail");
                if ("5".equals(costdriverdetail)) {
                    this.getView().setEnable(Boolean.valueOf(true), j, new String[]{"costtype"});
                    continue;
                }
                this.getView().setEnable(Boolean.valueOf(false), j, new String[]{"costtype"});
            }
            String costdriver = entry.getString("costdriver");
            if ("6".equals(costdriver)) {
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"costagent"});
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{CALMETHOD});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"costagent"});
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{CALMETHOD});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        BasedataEdit costCenter = (BasedataEdit)this.getControl("costcenter");
        BasedataEdit subElement = (BasedataEdit)this.getControl(SUBELEMENT);
        BasedataEdit costtype = (BasedataEdit)this.getControl("costtype");
        BasedataEdit costagent = (BasedataEdit)this.getControl("costagent");
        BasedataEdit costagentdetail = (BasedataEdit)this.getControl("costagentdetail");
        EntryGrid allocentry = (EntryGrid)this.getControl("allocentry");
        allocentry.addRowClickListener((RowClickEventListener)this);
        allocentry.addDataBindListener((EntryGridBindDataListener)this);
        costAccount.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                ProAllocStdEdit.this.getCostAccountToPageCache();
                QFilter filters = ProAllocStdEdit.this.getCostAccountFilter();
                List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
                qFilters.add(filters);
            }
        });
        costCenter.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                QFilter[] filters = ProAllocStdEdit.this.getCostCenterFilter();
                List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
                qFilters.addAll(Arrays.asList(filters));
            }
        });
        subElement.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter idFilter = ProAllocStdEdit.this.getSubElementFilter();
                QFilter enableFilter = new QFilter("enable", "=", (Object)ProAllocStdEdit.FIXED_VALUE);
                listShowParameter.getListFilterParameter().getQFilters().add(enableFilter);
                if (idFilter != null) {
                    listShowParameter.getListFilterParameter().getQFilters().add(idFilter);
                }
            }
        });
        costtype.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"ProAllocStdEdit_17", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                return;
            }
            List costTypeIds = CostTypeHelper.getCostTypeIdsByOrg((long)org.getLong("id"));
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (!CadEmptyUtils.isEmpty((List)costTypeIds)) {
                QFilter idQFilter = new QFilter("id", "in", (Object)costTypeIds);
                listShowParameter.getListFilterParameter().getQFilters().add(idQFilter);
            }
        });
        costagent.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
                qFilters.addAll(ProAllocStdEdit.this.getCostagentFilter());
            }
        });
        costagentdetail.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
                qFilters.addAll(ProAllocStdEdit.this.getCostagentFilter());
            }
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        RefObject afterConfirm = new RefObject();
        switch (operateKey) {
            case "save": {
                this.showConfirmForm(e, operate, (RefObject<String>)afterConfirm, "ProAllocStdEdit_0", "save");
                break;
            }
            case "submit": {
                this.showConfirmForm(e, operate, (RefObject<String>)afterConfirm, "ProAllocStdEdit_1", "submit");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "costaccount": {
                if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                    this.deleteProAllocStdData();
                    break;
                }
                if (!this.getModel().getDataChanged()) break;
                this.getModel().setValue("costaccount", (Object)this.getPageCache().get("costaccount"));
                break;
            }
            case "calmethod": {
                String calmethod = String.valueOf(this.getModel().getValue(CALMETHOD));
                if (MessageBoxResult.Yes.equals((Object)e.getResult()) && FIXED_VALUE.equals(calmethod)) {
                    this.getModel().deleteEntryData("productsubentry");
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{ADD_ROW});
                    break;
                }
                this.getModel().setValue(CALMETHOD, (Object)"0");
                this.getView().setEnable(Boolean.valueOf(true), new String[]{ADD_ROW});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        switch (proName) {
            case "subelement": {
                this.setElement(e);
                break;
            }
            case "costdriver": {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"costagent"});
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{CALMETHOD});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{ADD_ROW});
                if (newValue == null) break;
                this.getModel().setValue("costagent", null, rowIndex);
                this.getModel().setValue(CALMETHOD, null, rowIndex);
                if (!"6".equals(newValue.toString())) break;
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"costagent"});
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{CALMETHOD});
                this.getModel().setValue(CALMETHOD, (Object)"0");
                if (FIXED_VALUE.equals(this.getModel().getValue(CALMETHOD))) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{ADD_ROW});
                } else {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{ADD_ROW});
                }
                this.getView().updateView("costagent", rowIndex);
                this.getView().updateView(CALMETHOD, rowIndex);
                break;
            }
            case "costcenter": {
                break;
            }
            case "costaccount": {
                String count = this.getPageCache().get("count");
                String costaccount = this.getPageCache().get("costaccount");
                if (Integer.parseInt(count) == 1 && costaccount != null) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6210\u672c\u8d26\u7c3f\uff0c\u4f1a\u6e05\u7a7a\u5f53\u524d\u672a\u4fdd\u5b58\u7684\u5206\u914d\u6807\u51c6\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProAllocStdEdit_0", (String)"macc-aca-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("costaccount", (IFormPlugin)this));
                }
                int temp_count = Integer.parseInt(count) + 1;
                this.getPageCache().put("count", String.valueOf(temp_count));
                break;
            }
            case "costdriverdetail": {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"costtype"});
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"costagentdetail"});
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"calmethoddetail"});
                if (newValue == null) break;
                this.getModel().setValue("costtype", null, rowIndex);
                this.getModel().setValue("costagentdetail", null, rowIndex);
                this.getModel().setValue("calmethoddetail", null, rowIndex);
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex("allocentry");
                if (ASSEMBLEY.equals(newValue.toString())) {
                    DynamicObject costCenterDy = (DynamicObject)this.getModel().getValue("costcenter", currentRowIndex);
                    String costDriverDy = (String)this.getModel().getValue("costdriver", currentRowIndex);
                    if (StringUtils.isEmpty((String)costDriverDy)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u914d\u6807\u51c6\u7b2c%s\u884c\u7efc\u5408\u5206\u914d\u6807\u51c6\u3002", (String)"ProAllocStdEdit_14", (String)"macc-aca-formplugin", (Object[])new Object[0]), String.valueOf(currentRowIndex + 1)));
                        this.getModel().beginInit();
                        this.getModel().setValue("costdriverdetail", oldValue, rowIndex);
                        this.getModel().endInit();
                        break;
                    }
                    DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
                    EntryGrid subGrid = (EntryGrid)this.getView().getControl("productsubentry");
                    int subRow = subGrid.getSelectRows()[0];
                    DynamicObject subElementDy = (DynamicObject)this.getModel().getValue(SUBELEMENT, subRow);
                    if (subElementDy == null) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u5b50\u8981\u7d20\u660e\u7ec6\u7b2c%s\u884c\u6210\u672c\u5b50\u8981\u7d20\u3002", (String)"ProAllocStdEdit_15", (String)"macc-aca-formplugin", (Object[])new Object[0]), String.valueOf(subRow + 1)));
                        this.getModel().beginInit();
                        this.getModel().setValue("costdriverdetail", oldValue, rowIndex);
                        this.getModel().endInit();
                        break;
                    }
                    String type = subElementDy.getString("type");
                    if (costCenterDy != null) {
                        String errorMsg = WipAllocStdService.isAllowAssemblyByOrgCc((long)org.getLong("id"), (long)costCenterDy.getLong("id"), (String)costCenterDy.getString("name"), (String)type);
                        if (StringUtils.isNotEmpty((String)errorMsg)) {
                            this.getView().showErrorNotification(errorMsg);
                            this.getModel().beginInit();
                            this.getModel().setValue("costdriverdetail", oldValue, rowIndex);
                            this.getModel().endInit();
                            break;
                        }
                    } else {
                        String errorMsg = WipAllocStdService.isAllowAssemblyByOrgCc((long)org.getLong("id"), (String)type);
                        if (StringUtils.isNotEmpty((String)errorMsg)) {
                            if (ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u7c7b\u578b\u4e0d\u4e3a\u7269\u6599\u3002", (String)"WipAllocStdService_2", (String)"macc-aca-business", (Object[])new Object[0]).equals(errorMsg)) {
                                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u660e\u7ec6\u7b2c%s\u884c\u6210\u672c\u5b50\u8981\u7d20\u5c5e\u6027\u4e0d\u4e3a\u7269\u6599\uff0c\u4e0d\u80fd\u9009\u62e9\u5b8c\u5de5\u6750\u6599\u6210\u672c\u6309\u7ec4\u4ef6\u6e05\u5355\u8ba1\u7b97\u3002", (String)"ProAllocStdEdit_21", (String)"macc-aca-formplugin", (Object[])new Object[0]), String.valueOf(subRow + 1)));
                            } else {
                                this.getView().showErrorNotification(errorMsg);
                            }
                            this.getModel().beginInit();
                            this.getModel().setValue("costdriverdetail", oldValue, rowIndex);
                            this.getModel().endInit();
                            break;
                        }
                    }
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{SUBELEMENT});
                    this.getView().setEnable(Boolean.FALSE, currentRowIndex, new String[]{"costcenter"});
                    break;
                }
                if ("4".equals(newValue.toString())) {
                    String costDriverDy = (String)this.getModel().getValue("costdriver", currentRowIndex);
                    if (StringUtils.isEmpty((String)costDriverDy)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u914d\u6807\u51c6\u7b2c%s\u884c\u7efc\u5408\u5206\u914d\u6807\u51c6\u3002", (String)"ProAllocStdEdit_14", (String)"macc-aca-formplugin", (Object[])new Object[0]), String.valueOf(currentRowIndex + 1)));
                        this.getModel().beginInit();
                        this.getModel().setValue("costdriverdetail", oldValue, rowIndex);
                        this.getModel().endInit();
                        break;
                    }
                    EntryGrid subGrid = (EntryGrid)this.getView().getControl("productsubentry");
                    int subRow = subGrid.getSelectRows()[0];
                    DynamicObject subElementDy = (DynamicObject)this.getModel().getValue(SUBELEMENT, subRow);
                    if (subElementDy == null) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u5b50\u8981\u7d20\u660e\u7ec6\u7b2c%s\u884c\u6210\u672c\u5b50\u8981\u7d20\u3002", (String)"ProAllocStdEdit_15", (String)"macc-aca-formplugin", (Object[])new Object[0]), String.valueOf(subRow + 1)));
                        this.getModel().beginInit();
                        this.getModel().setValue("costdriverdetail", oldValue, rowIndex);
                        this.getModel().endInit();
                        break;
                    }
                    String type = subElementDy.getString("type");
                    if (!"001".equals(type)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u660e\u7ec6\u7b2c%s\u884c\u6210\u672c\u5b50\u8981\u7d20\u5c5e\u6027\u4e0d\u4e3a\u7269\u6599\uff0c\u4e0d\u80fd\u9009\u62e9\u5728\u4ea7\u6210\u672c\u6309\u6750\u6599\u76d8\u70b9\u8ba1\u7b97\u3002", (String)"ProAllocStdEdit_22", (String)"macc-aca-formplugin", (Object[])new Object[0]), String.valueOf(subRow + 1)));
                        this.getModel().beginInit();
                        this.getModel().setValue("costdriverdetail", oldValue, rowIndex);
                        this.getModel().endInit();
                        break;
                    }
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{SUBELEMENT});
                    this.getView().setEnable(Boolean.FALSE, currentRowIndex, new String[]{"costcenter"});
                    break;
                }
                if ("5".equals(newValue.toString())) {
                    List costTypeIds;
                    EntryGrid subGrid = (EntryGrid)this.getView().getControl("productsubentry");
                    int subRow = subGrid.getSelectRows()[0];
                    String costDriverDy = (String)this.getModel().getValue("costdriver", currentRowIndex);
                    if (StringUtils.isEmpty((String)costDriverDy)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u914d\u6807\u51c6\u7b2c%s\u884c\u7efc\u5408\u5206\u914d\u6807\u51c6\u3002", (String)"ProAllocStdEdit_14", (String)"macc-aca-formplugin", (Object[])new Object[0]), String.valueOf(currentRowIndex + 1)));
                        this.getModel().beginInit();
                        this.getModel().setValue("costdriverdetail", oldValue, rowIndex);
                        this.getModel().endInit();
                        break;
                    }
                    DynamicObject subElementDy = (DynamicObject)this.getModel().getValue(SUBELEMENT, subRow);
                    if (subElementDy == null) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u5b50\u8981\u7d20\u660e\u7ec6\u7b2c%s\u884c\u6210\u672c\u5b50\u8981\u7d20\u3002", (String)"ProAllocStdEdit_15", (String)"macc-aca-formplugin", (Object[])new Object[0]), String.valueOf(subRow + 1)));
                        this.getModel().beginInit();
                        this.getModel().setValue("costdriverdetail", oldValue, rowIndex);
                        this.getModel().endInit();
                        break;
                    }
                    String type = subElementDy.getString("type");
                    if (!"001".equals(type)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u660e\u7ec6\u7b2c%s\u884c\u6210\u672c\u5b50\u8981\u7d20\u5c5e\u6027\u4e0d\u4e3a\u7269\u6599\uff0c\u4e0d\u80fd\u9009\u62e9\u5b8c\u5de5\u6750\u6599\u6210\u672c\u6309\u6210\u672cBOM\u8ba1\u7b97\u3002", (String)"ProAllocStdEdit_19", (String)"macc-aca-formplugin", (Object[])new Object[0]), String.valueOf(subRow + 1)));
                        this.getModel().beginInit();
                        this.getModel().setValue("costdriverdetail", oldValue, rowIndex);
                        this.getModel().endInit();
                        break;
                    }
                    this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"costtype"});
                    DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
                    if (org != null && (costTypeIds = CostTypeHelper.getCostTypeIdsByOrg((long)org.getLong("id"))).size() == 1) {
                        this.getModel().setValue("costtype", costTypeIds.get(0), rowIndex);
                    }
                    this.getView().updateView("costtype", rowIndex);
                    break;
                }
                if ("6".equals(newValue.toString())) {
                    this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"costagentdetail"});
                    this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"calmethoddetail"});
                    this.getModel().setValue("calmethoddetail", (Object)"0");
                    this.getView().updateView("costagentdetail", rowIndex);
                    this.getView().updateView("calmethoddetail", rowIndex);
                    break;
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{SUBELEMENT});
                this.getView().setEnable(Boolean.TRUE, currentRowIndex, new String[]{"costcenter"});
                break;
            }
            case "calmethod": {
                if (FIXED_VALUE.equals(String.valueOf(newValue))) {
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(CALMETHOD, (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u8ba1\u7b97\u65b9\u5f0f=\u56fa\u5b9a\u503c\u65f6\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u660e\u7ec6\u5206\u914d\u6807\u51c6\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProAllocStdEdit_20", (String)"macc-aca-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(true), new String[]{ADD_ROW});
                break;
            }
        }
    }

    private void getCostAccountToPageCache() {
        DynamicObject tempCostAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (tempCostAccount != null) {
            this.getPageCache().put("costaccount", tempCostAccount.getString("id"));
        }
        int count = 1;
        this.getPageCache().put("count", String.valueOf(count));
    }

    public void afterImportData(ImportDataEventArgs e) {
        String billNos;
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        DynamicObject costAccountDy = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccountDy != null && !CadEmptyUtils.isEmpty((String)(billNos = ProAllocStdHelper.checkExistProAllocStd((Object)costAccountDy.getPkValue(), (Object)pkValue, (String)"aca_proallocstd")))) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u8be5\u6210\u672c\u8d26\u7c3f\u5df2\u7ecf\u88ab\u5355\u636e\u201c%s\u201d\u4f7f\u7528\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"ProAllocStdEdit_5", (String)"macc-aca-formplugin", (Object[])new Object[0]), billNos));
        }
    }

    private void showConfirmForm(BeforeDoOperationEventArgs e, FormOperate operate, RefObject<String> afterConfirm, String resourceID, String callBackId) {
        QFilter effectStatusFilter;
        QFilter pkFilter;
        QFilter qFilter;
        QFilter[] filter;
        DynamicObjectCollection proallostds;
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        DynamicObject costAccountDy = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccountDy != null && !CollectionUtils.isEmpty((Collection)(proallostds = QueryServiceHelper.query((String)"aca_proallocstd", (String)"billno", (QFilter[])(filter = new QFilter[]{qFilter = new QFilter("costaccount", "=", costAccountDy.getPkValue()), pkFilter = new QFilter("id", "!=", pkValue == null ? Long.valueOf(0L) : pkValue), effectStatusFilter = new QFilter("effectstatus", "=", (Object)FIXED_VALUE)}))))) {
            StringBuilder stringBuilder = new StringBuilder("\u201c");
            for (DynamicObject proallocstd : proallostds) {
                stringBuilder.append(proallocstd.getString("billno")).append("\uff0c");
            }
            int length = stringBuilder.length();
            stringBuilder.setLength(length - 1);
            stringBuilder.append("\u201d");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u8be5\u6210\u672c\u8d26\u7c3f\u5df2\u7ecf\u88ab\u5355\u636e\u201c%s\u201d\u4f7f\u7528\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)resourceID, (String)"ProAllocStdEdit_5", (Object[])new Object[0]), stringBuilder.toString()));
            e.setCancel(true);
        }
    }

    private void deleteProAllocStdData() {
        this.getModel().deleteEntryData("allocentry");
        this.getModel().deleteEntryData("productsubentry");
    }

    private void setElement(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            DynamicObject row = changeData.getDataEntity();
            DynamicObject subelement = row.getDynamicObject(SUBELEMENT);
            if (subelement == null) {
                return;
            }
            QFilter subeleIdFilter = new QFilter(SUBELEMENT, "=", (Object)subelement.getLong("id"));
            DynamicObject elementDetail = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element.id AS element", (QFilter[])new QFilter[]{subeleIdFilter});
            if (elementDetail != null) {
                int seq = row.getInt("seq");
                int rowIndex = seq - 1;
                this.getModel().setValue(ELEMENT, (Object)elementDetail.getLong(ELEMENT), rowIndex);
            }
        }
    }

    private QFilter getSubElementFilter() {
        ArrayList<Long> ids = new ArrayList<Long>();
        int rowCount = this.getModel().getEntryRowCount("productsubentry");
        for (int row = 0; row < rowCount; ++row) {
            DynamicObject subelement = (DynamicObject)this.getModel().getValue(SUBELEMENT, row);
            if (subelement == null) continue;
            ids.add((Long)subelement.getPkValue());
        }
        if (CadEmptyUtils.isEmpty(ids)) {
            return null;
        }
        return new QFilter("id", "not in", ids);
    }

    private QFilter[] getCostCenterFilter() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        ArrayList<Long> ids = new ArrayList<Long>();
        int rowCount = this.getModel().getEntryRowCount("allocentry");
        for (int row = 0; row < rowCount; ++row) {
            DynamicObject costcenter = (DynamicObject)this.getModel().getValue("costcenter", row);
            if (costcenter == null) continue;
            ids.add((Long)costcenter.getPkValue());
        }
        QFilter idFilter = new QFilter("id", "not in", ids);
        QFilter orgFilter = new QFilter("accountorg", "=", org.getPkValue());
        QFilter orgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
        return new QFilter[]{idFilter, orgFilter, orgDutyFilter};
    }

    private List<QFilter> getCostagentFilter() {
        ArrayList<QFilter> qList = new ArrayList<QFilter>();
        ArrayList<String> allocclassList = new ArrayList<String>();
        allocclassList.add("COSTCENTER");
        allocclassList.add("COSTOBJECT");
        qList.add(new QFilter("enable", "=", (Object)FIXED_VALUE));
        qList.add(new QFilter("status", "=", (Object)"C"));
        qList.add(new QFilter("costtype", "=", (Object)0L));
        qList.add(new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()));
        qList.add(new QFilter("isrelatedwork", "=", (Object)"0"));
        qList.add(new QFilter("islinkresource", "=", (Object)"0"));
        qList.add(new QFilter("allocclass", "in", allocclassList));
        return qList;
    }

    private QFilter getCostAccountFilter() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        ArrayList<Long> ids = new ArrayList<Long>();
        ArrayList<Long> costaccountIds = new ArrayList<Long>();
        QFilter orgFilter = new QFilter("org", "=", org == null ? Long.valueOf(0L) : org.getPkValue());
        QFilter isStartStdCostFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)"aca");
        DynamicObjectCollection costaccounts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount.id id", (QFilter[])new QFilter[]{orgFilter, isStartStdCostFilter, qfAppNum});
        for (DynamicObject costaccount : costaccounts) {
            costaccountIds.add(costaccount.getLong("id"));
        }
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        QFilter[] filter = new QFilter[]{orgFilter};
        if (pkValue != null) {
            QFilter pkFilter = new QFilter("id", "!=", pkValue);
            filter = new QFilter[]{orgFilter, pkFilter};
        }
        DynamicObjectCollection proallostds = QueryServiceHelper.query((String)"aca_proallocstd", (String)"costaccount.id id", (QFilter[])filter);
        for (DynamicObject proallocstd : proallostds) {
            Long costaccount = proallocstd.getLong("id");
            ids.add(costaccount);
        }
        costaccountIds.removeAll(ids);
        return new QFilter("id", "in", costaccountIds);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        RowDataEntity rowDataEntity = rowDataEntities[0];
        int rowIndex = rowDataEntity.getRowIndex();
        this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"costtype"});
        this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"costagentdetail"});
        this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"calmethoddetail"});
        String entryProp = String.valueOf(e.getEntryProp());
        if ("allocentry".equals(entryProp)) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"costagent"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{CALMETHOD});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{ADD_ROW});
        } else if ("productsubentry".equals(entryProp) && "0".equals(this.getModel().getValue(CALMETHOD))) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"productsubentry"});
        }
    }
}

