/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.init;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.CostaccountHelper;
import kd.macc.aca.algox.utils.DataSetHelper;
import kd.macc.aca.common.constants.WipInitSubItem;
import kd.macc.aca.common.helper.AcaCostAccountHelper;
import kd.macc.aca.formplugin.base.BaseOrgAndCostAccountListPlugin;
import kd.macc.cad.common.constants.CommonConstant;
import kd.macc.cad.common.dto.ProgressParamDto;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.MatHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.WipCostInitHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadPermissionUtil;
import kd.macc.cad.common.utils.MsgUtils;

public class WipCostInitList
extends BaseOrgAndCostAccountListPlugin {
    private static final String COSTACCOUNT = "costaccount";
    private static final String ORG_FIELD = "org";
    private static final String BIZ_TYPE_RO = "RO";
    private static final String closeBack_importResult = "importResult";
    private static final String ALGOKEY = "WipCostInitList";

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("costcenter.number ASC, billno ASC");
    }

    @Override
    protected List<ComboItem> getCostAccountComboItemListBy(List<Object> orgId) {
        DynamicObjectCollection ccs;
        QFilter filter = null;
        if (!CadEmptyUtils.isEmpty(orgId)) {
            ArrayList lOrgIds = new ArrayList();
            orgId.forEach(id -> lOrgIds.add(Long.valueOf(id.toString())));
            filter = new QFilter("calorg", "in", lOrgIds);
        } else {
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            filter = new QFilter("calorg", "in", (Object)orgIds);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(orgId)) {
            filter.and("id", "in", this.getCostAccountNotCurrentAppId(Long.valueOf(orgId.get(0).toString())));
        }
        if (CollectionUtils.isEmpty((Collection)(ccs = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,name", (QFilter[])new QFilter[]{filter, statusFilter, enableFilter}, (String)"ismainaccount desc,number asc")))) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        List<ComboItem> acctOrgs;
        String fieldName = args.getFieldName();
        if (fieldName.startsWith(COSTACCOUNT)) {
            List<Object> orgCache = this.getOrgCache();
            if (!CadEmptyUtils.isEmpty(orgCache)) {
                List costAccountIds;
                long orgId = Long.parseLong(String.valueOf(orgCache.get(0)));
                QFilter filter = new QFilter("calorg", "=", (Object)orgId);
                QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                QFilter statusFilter = new QFilter("status", "=", (Object)"C");
                if (!CadEmptyUtils.isEmpty((Long)orgId)) {
                    filter.and("id", "in", this.getCostAccountNotCurrentAppId(orgId));
                }
                if (!CadEmptyUtils.isEmpty((List)(costAccountIds = QueryServiceHelper.queryPrimaryKeys((String)"cal_bd_costaccount", (QFilter[])new QFilter[]{filter, statusFilter, enableFilter}, null, (int)-1)))) {
                    QFilter idQFilter = new QFilter("id", "in", (Object)costAccountIds);
                    args.getQfilters().add(idQFilter);
                }
            } else {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            }
        } else if (fieldName.startsWith(String.format("%s.", ORG_FIELD)) && CadEmptyUtils.isEmpty(acctOrgs = this.getORGComboItemList())) {
            args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
        }
    }

    private List<Long> getCostAccountNotCurrentAppId(Long orgId) {
        ArrayList<Long> costAccountId = new ArrayList<Long>(10);
        QFilter orgFilter = new QFilter(ORG_FIELD, "=", (Object)orgId);
        QFilter useFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection startStdCosts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"appnum,entryentity.costaccount costaccount", (QFilter[])new QFilter[]{orgFilter, useFilter});
        String appId = this.getView().getFormShowParameter().getAppId();
        for (DynamicObject startStdCost : startStdCosts) {
            if (appId == null || !appId.equals(startStdCost.getString("appnum"))) continue;
            costAccountId.add(startStdCost.getLong(COSTACCOUNT));
        }
        return costAccountId;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemkey = evt.getItemKey();
        String orgId = this.getPageCache().get(ORG_FIELD);
        if ("tblnew".equals(itemkey)) {
            this.orgValidate(evt, orgId);
        } else if ("importmftstock".equals(itemkey)) {
            List<String> orgList;
            String costAccountId = this.getPageCache().get(COSTACCOUNT);
            if (!StringUtils.isEmpty((Object)orgId) && !CadEmptyUtils.isEmpty((List)(orgList = (List<String>)SerializationUtils.fromJsonString((String)orgId, List.class)))) {
                orgId = (String)orgList.get(0);
            }
            if (StringUtils.isEmpty((Object)orgId) || "0".equals(orgId) || !OrgUnitServiceHelper.checkOrgFunction((Long)Long.parseLong(orgId), (String)"10")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u9009\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipCostInitList_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            orgList = Collections.singletonList(orgId);
            if (this.paramValidate(costAccountId, orgList)) {
                evt.setCancel(true);
                return;
            }
        }
    }

    private void orgValidate(BeforeItemClickEvent evt, String orgId) {
        List orgList;
        if (!StringUtils.isEmpty((Object)orgId) && !CadEmptyUtils.isEmpty((List)(orgList = (List)SerializationUtils.fromJsonString((String)orgId, List.class)))) {
            orgId = (String)orgList.get(0);
        }
        if (StringUtils.isEmpty((Object)orgId) || "0".equals(orgId) || !OrgUnitServiceHelper.checkOrgFunction((Long)Long.parseLong(orgId), (String)"10")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u9009\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipCostInitList_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().setCustomParam("costaccountId", (Object)this.getPageCache().get(COSTACCOUNT));
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "exportlist": {
                break;
            }
            case "exportlist_expt": {
                break;
            }
            case "exportlistbyselectfields": {
                break;
            }
            case "exportdetails": {
                break;
            }
            case "refresh": {
                break;
            }
            case "close": {
                break;
            }
            case "modify": {
                break;
            }
            case "new": {
                String costAccountId = this.getPageCache().get(COSTACCOUNT);
                if (CadEmptyUtils.isEmpty((String)costAccountId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"WipCostInitList_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (!AcaCostAccountHelper.isInited((long)Long.parseLong(costAccountId), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u5931\u8d25\u3002\u8be5\u6210\u672c\u8d26\u7c3f\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"WipCostInitList_2", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "submit": {
                if (!this.checkCostAccountInit(args)) break;
                ListSelectedRowCollection listSelectedData = args.getListSelectedData();
                Object[] pkValues = listSelectedData.getPrimaryKeyValues();
                this.clearEntryEntity(listSelectedData, pkValues);
                break;
            }
            default: {
                this.checkCostAccountInit(args);
            }
        }
    }

    private void clearEntryEntity(ListSelectedRowCollection listSelectedData, Object[] pkValues) {
        HashSet<DynamicObject> deleteDynamicObjects = new HashSet<DynamicObject>();
        if (!CadEmptyUtils.isEmpty((ListSelectedRowCollection)listSelectedData)) {
            DynamicObject[] dynamicObjectCollection;
            for (DynamicObject dynamicObject : dynamicObjectCollection = BusinessDataServiceHelper.load((Object[])pkValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"aca_wipcostinit"))) {
                DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
                ArrayList<DynamicObject> deleteDynamicObject = new ArrayList<DynamicObject>();
                for (DynamicObject row : entryEntity) {
                    BigDecimal amount = BigDecimalUtil.getOrZero((Object)row.getBigDecimal("amount"));
                    BigDecimal yearInputAmount = BigDecimalUtil.getOrZero((Object)row.getBigDecimal("yearinputamt"));
                    BigDecimal yearFinishAmount = BigDecimalUtil.getOrZero((Object)row.getBigDecimal("yearfinishamt"));
                    if (amount.compareTo(BigDecimal.ZERO) != 0 || yearInputAmount.compareTo(BigDecimal.ZERO) != 0 || yearFinishAmount.compareTo(BigDecimal.ZERO) != 0) continue;
                    deleteDynamicObject.add(row);
                }
                for (DynamicObject dy : deleteDynamicObject) {
                    entryEntity.remove((Object)dy);
                    deleteDynamicObjects.add(dynamicObject);
                }
            }
            SaveServiceHelper.save((DynamicObject[])deleteDynamicObjects.toArray(new DynamicObject[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().invokeOperation("refresh");
        String actionId = closedCallBackEvent.getActionId();
        if (closeBack_importResult.equals(actionId)) {
            String responseInfoStr = this.getPageCache().get("responseInfo");
            if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                return;
            }
            Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
            if (responseInfo.containsKey("error")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f15\u5165\u7ec4\u4ef6\u6e05\u5355\u5931\u8d25", (String)"WipCostInitList_22", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            } else if (responseInfo.containsKey("success")) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f15\u5165\u7ec4\u4ef6\u6e05\u5355\u6210\u529f", (String)"WipCostInitList_20", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> improtWipCostInit(String costAccountId, String progressId, String orgId) {
        HashMap<String, String> responseInfo = new HashMap<String, String>(2);
        try {
            if (!CadEmptyUtils.isEmpty((String)progressId)) {
                ProgressHelper.setProgress((String)progressId, (String)ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"WipCostInitList_7", (String)"macc-aca-formplugin", (Object[])new Object[0]), (int)0, (int)100, (String)"%");
            }
            DynamicObject costAccount = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(costAccountId), (String)"cal_bd_costaccount");
            this.costObjectImport(orgId, AppIdHelper.getCurAppNum((IFormView)this.getView()));
            ProgressHelper.setProgress((String)progressId, (String)ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"WipCostInitList_7", (String)"macc-aca-formplugin", (Object[])new Object[0]), (int)40, (int)100, (String)"%");
            logger.info("\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316\u5f15\u5165\u5f00\u59cb\uff1a{}", (Object)costAccountId);
            QFilter filter = new QFilter(ORG_FIELD, "=", (Object)Long.valueOf(orgId));
            filter.and(new QFilter("producttype", "=", (Object)"C"));
            filter.and(new QFilter("biztype", "=", (Object)BIZ_TYPE_RO));
            filter.and(new QFilter("billstatus", "=", (Object)"C"));
            DynamicObjectCollection costObjectIdDy = QueryServiceHelper.query((String)"cad_costobject", (String)"id", (QFilter[])filter.toArray());
            ProgressHelper.setProgress((String)progressId, (String)ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"WipCostInitList_7", (String)"macc-aca-formplugin", (Object[])new Object[0]), (int)45, (int)100, (String)"%");
            if (costObjectIdDy.isEmpty()) {
                logger.info("\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316\u5f15\u5165\uff1acostObjectRows\u4e3a\u7a7a");
                responseInfo.put("successQty", "0");
                responseInfo.put("success", ResManager.loadKDString((String)"\u5f15\u5165\u6210\u529f", (String)"WipCostInitList_21", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                HashMap<String, String> hashMap = responseInfo;
                return hashMap;
            }
            List costObjectIdList = costObjectIdDy.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
            List partition = Lists.partition(costObjectIdList, (int)2000);
            ProgressHelper.setProgress((String)progressId, (String)ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"WipCostInitList_7", (String)"macc-aca-formplugin", (Object[])new Object[0]), (int)50, (int)100, (String)"%");
            int partitionProcess = 45 / partition.size();
            int queryDataProcess = 0;
            for (List costObjectIds : partition) {
                queryDataProcess += partitionProcess;
                QFilter costObjectIdfilter = new QFilter("id", "in", (Object)costObjectIds);
                DataSet costObjectRows = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_costobject", (String)"id,probill,isoutsource,costcenter,material.masterid as costmaterial,auxpty as costauxpty", (QFilter[])costObjectIdfilter.toArray(), null);
                DynamicObjectCollection elementDetail = this.getElementDetail();
                HashMap<Long, String> elementDetailMap = new HashMap(5);
                if (elementDetail != null) {
                    elementDetailMap = elementDetail.stream().collect(Collectors.toMap(x -> x.getLong("element.id"), y -> y.getString("element.type"), (x, y) -> x));
                }
                HashSet<Long> mftorderIds = new HashSet<Long>(16);
                HashSet<Long> omMftorderIds = new HashSet<Long>(16);
                HashMap<Long, Long> proEntryToCostObjIdMap = new HashMap<Long, Long>(32);
                DataSet costObjectRowsCopy = costObjectRows.copy();
                while (costObjectRowsCopy.hasNext()) {
                    Row costObjectRow = costObjectRowsCopy.next();
                    Long probill = costObjectRow.getLong("probill");
                    Long costObjId = costObjectRow.getLong("id");
                    if (costObjectRow.getBoolean("isoutsource").booleanValue()) {
                        omMftorderIds.add(probill);
                    } else {
                        mftorderIds.add(probill);
                    }
                    proEntryToCostObjIdMap.put(probill, costObjId);
                }
                if (CadEmptyUtils.isEmpty(omMftorderIds) && CadEmptyUtils.isEmpty(mftorderIds)) {
                    logger.info("\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316\u5f15\u5165\uff1a\u751f\u4ea7\u5de5\u5355id\u3001\u59d4\u5916\u5de5\u5355id\u4e3a\u7a7a");
                    continue;
                }
                DynamicObject startPeriod = PeriodHelper.getStartPeriod((Long)Long.valueOf(costAccountId));
                if (startPeriod == null) {
                    logger.info("\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316\u5f15\u5165\uff1a\u6210\u672c\u8d26\u7c3f\u5f00\u59cb\u671f\u95f4\u4e3a\u7a7a");
                    continue;
                }
                Date costAccountStartPeriod = startPeriod.getDate("begindate");
                if (costAccountStartPeriod == null) {
                    logger.info("\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316\u5f15\u5165\uff1a\u6210\u672c\u8d26\u7c3f\u5f00\u59cb\u6838\u7b97\u671f\u95f4\u4e3a\u7a7a");
                    continue;
                }
                DataSet orderEntryQtyDataSet = this.buildComAssemblyDataSet(mftorderIds, omMftorderIds, costAccountStartPeriod);
                DataSet mftOrderRows = this.getMftOrderRows(mftorderIds, omMftorderIds);
                if (mftOrderRows == null) {
                    logger.info("\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316\u5f15\u5165\uff1a\u83b7\u53d6\u7ec4\u4ef6\u6e05\u5355\u3001\u59d4\u5916\u5de5\u5355\u6570\u636e\u4e3a\u7a7a");
                    continue;
                }
                mftorderIds.addAll(omMftorderIds);
                HashSet<Long> costObjectIdSet = new HashSet<Long>();
                mftorderIds.forEach(x -> costObjectIdSet.add((Long)proEntryToCostObjIdMap.get(x)));
                DataSet wipCostInitDataSet = this.getWipCostInitDataSet(orderEntryQtyDataSet, mftOrderRows, costObjectRows.copy());
                if (wipCostInitDataSet.isEmpty()) continue;
                this.saveData(costAccountId, orgId, costAccount, wipCostInitDataSet, proEntryToCostObjIdMap, elementDetail, elementDetailMap, costObjectIdSet);
                ProgressHelper.setProgress((String)progressId, (String)ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"WipCostInitList_7", (String)"macc-aca-formplugin", (Object[])new Object[0]), (int)(50 + queryDataProcess), (int)100, (String)"%");
            }
            responseInfo.put("success", ResManager.loadKDString((String)"\u5f15\u5165\u6210\u529f", (String)"WipCostInitList_21", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        }
        catch (Throwable e) {
            logger.info("\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316\u5f15\u5165\u51fa\u9519\uff1a", (Object)e);
            responseInfo.put("error", ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25", (String)"WipCostInitList_24", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            MsgUtils.putMsg2Map((String)"error", (String)e.toString(), responseInfo);
            MsgUtils.putMsg2Map((String)"error", (String)String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff1a%s", (String)"WipCostInitList_8", (String)"macc-aca-formplugin", (Object[])new Object[0]), e.toString()), responseInfo);
            ProgressHelper.showError((String)progressId, (String)e.getMessage());
        }
        finally {
            WipCostInitList.refreshProgress(ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316\u5f15\u5165\u5b8c\u6210", (String)"WipCostInitList_9", (String)"macc-aca-formplugin", (Object[])new Object[0]), -1, 0, false, progressId);
        }
        return responseInfo;
    }

    private boolean paramValidate(String costaccountId, List<String> orgIdList) {
        if (CadEmptyUtils.isEmpty((String)costaccountId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"WipCostInitList_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return true;
        }
        String appNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
        if (AcaCostAccountHelper.isInited((long)Long.parseLong(costaccountId), (String)appNum)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u8d26\u7c3f\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u5f53\u524d\u64cd\u4f5c", (String)"WipCostInitList_23", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (CadEmptyUtils.isEmpty(orgIdList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipCostInitList_10", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        }
        QFilter orgQf = new QFilter("accountorg", "=", (Object)Long.valueOf(orgIdList.get(0)));
        QFilter billStatusQf = new QFilter("status", "=", (Object)"C");
        DynamicObjectCollection costObjRule = QueryServiceHelper.query((String)"cad_costobjectrule", (String)"biztype", (QFilter[])new QFilter[]{orgQf, billStatusQf});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costObjRule)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5168\u90e8\u6210\u672c\u4e2d\u5fc3\u672a\u8bbe\u7f6e\u6210\u672c\u8ba1\u7b97\u65b9\u6cd5=\u5de5\u5355\u6cd5\uff0c\u4e0d\u652f\u6301\u6309\u7ec4\u4ef6\u6e05\u5355\u5f15\u5165\u5b50\u7269\u6599\u6570\u636e\u3002", (String)"WipCostInitList_11", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return true;
        }
        AtomicInteger i = new AtomicInteger();
        costObjRule.forEach(x -> {
            if (BIZ_TYPE_RO.equals(x.getString("bizType"))) {
                i.set(i.get() + 1);
            }
        });
        if (0 == i.get()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5168\u90e8\u6210\u672c\u4e2d\u5fc3\u672a\u8bbe\u7f6e\u6210\u672c\u8ba1\u7b97\u65b9\u6cd5=\u5de5\u5355\u6cd5\uff0c\u4e0d\u652f\u6301\u6309\u7ec4\u4ef6\u6e05\u5355\u5f15\u5165\u5b50\u7269\u6599\u6570\u636e\u3002", (String)"WipCostInitList_11", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (i.get() < costObjRule.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u90e8\u5206\u6210\u672c\u4e2d\u5fc3\u672a\u8bbe\u7f6e\u6210\u672c\u8ba1\u7b97\u65b9\u6cd5=\u5de5\u5355\u6cd5\uff0c\u5f15\u5165\u6570\u636e\u53ef\u80fd\u5b58\u5728\u504f\u5dee\u3002", (String)"WipCostInitList_12", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (!CadPermissionUtil.check((Long)RequestContext.get().getCurrUserId(), (String)orgIdList.get(0), (boolean)false, (String)appNum, (String)"aca_wipcostinit", (String)"47156aff000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WipCostInitList_13", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void saveData(String costaccountId, String orgId, DynamicObject costAccount, DataSet wipCostInitDataSet, Map<Long, Long> proEntryToCostObjIdMap, DynamicObjectCollection elementDetail, Map<Long, String> elementDetailMap, Set<Long> costObjectIdSet) {
        logger.info("\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316\u5f15\u5165\uff1a\u5c01\u88c5\u4fdd\u5b58\u6570\u636e\u5f00\u59cb");
        this.getSaveDataList(costaccountId, orgId, costAccount, wipCostInitDataSet, proEntryToCostObjIdMap, elementDetail, elementDetailMap, costObjectIdSet);
    }

    private void getSaveDataList(String costAccountId, String orgId, DynamicObject costAccount, DataSet wipCostInitDataSet, Map<Long, Long> proEntryToCostObjIdMap, DynamicObjectCollection elementDetail, Map<Long, String> elementDetailMap, Set<Long> costObjectIdSet) {
        Long preOrderentryid = 0L;
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency AS currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(costAccountId))});
        Long currency = result.getLong("currency");
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        DynamicObjectCollection existWipCostInitIdsDy = WipCostInitHelper.getWipCostInitDyCollection((Long)Long.valueOf(orgId), (Long)Long.valueOf(costAccountId));
        Map existWipCostInit = new HashMap(16);
        Set<Object> wipCostInitIdSet = new HashSet(16);
        Map<Object, Object> existWipCostInitIdsMap = new HashMap(16);
        if (!existWipCostInitIdsDy.isEmpty()) {
            logger.info("\u7ec4\u4ef6\u6e05\u5355\u91cd\u590d\u5f15\u5165\u95ee\u9898-existWipCostInitIdsDy\uff1a{}", (Object)existWipCostInitIdsDy.size());
            existWipCostInitIdsMap = existWipCostInitIdsDy.stream().collect(Collectors.toMap(x -> x.getLong("probill"), y -> y.getString("billstatus"), (o1, o2) -> o1));
            wipCostInitIdSet = existWipCostInitIdsDy.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
            logger.info("\u7ec4\u4ef6\u6e05\u5355\u91cd\u590d\u5f15\u5165\u95ee\u9898-wipCostInitIdSet\uff0c\u957f\u5ea6===={},\u503c===={}", (Object)existWipCostInit.size(), wipCostInitIdSet);
            existWipCostInit = WipCostInitHelper.getExistWipCostInit(wipCostInitIdSet);
            logger.info("\u7ec4\u4ef6\u6e05\u5355\u91cd\u590d\u5f15\u5165\u95ee\u9898-existWipCostInit\uff0c\u957f\u5ea6===={}", (Object)existWipCostInit.size());
        }
        boolean isViewSubItem = CostaccountHelper.getCostElementByCostAccount((long)Long.parseLong(costAccountId));
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u5f15\u5165-\u6210\u672c\u8d26\u7c3f\u662f\u5426\u4e3a\u5206\u9879\uff1a{}", (Object)isViewSubItem);
        DataSet priceDataSet = this.getPrice(costAccountId, orgId, isViewSubItem, wipCostInitDataSet.copy());
        HashMap<Long, List<Row>> priceMap = new HashMap<Long, List<Row>>();
        if (priceDataSet != null) {
            for (Row row : priceDataSet) {
                DynamicObject[] material = row.getLong("material");
                if (!priceMap.containsKey(material)) {
                    priceMap.put((Long)material, new ArrayList());
                }
                ((List)priceMap.get(material)).add(row);
            }
        }
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u5f15\u5165\uff0c\u53d6\u4ef7\u63a5\u53e3\u5206\u9879\u4fe1\u606f\uff0c\u662f\u5426\u5206\u9879==={}\uff0c\u503c==={}", (Object)isViewSubItem, priceMap);
        DynamicObject[] costObjectDynamicObjects = BusinessDataServiceHelper.load((Object[])costObjectIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_costobject"));
        HashMap<Long, DynamicObject> costObjectMap = new HashMap<Long, DynamicObject>();
        if (costObjectDynamicObjects != null) {
            for (DynamicObject costObjectDynamicObject : costObjectDynamicObjects) {
                costObjectMap.put(costObjectDynamicObject.getLong("id"), costObjectDynamicObject);
            }
        }
        DynamicObject wipCostInitListDy = null;
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(16);
        HashSet<Long> materialSet = new HashSet<Long>(16);
        DataSet wipCostInitDataSetCopy = wipCostInitDataSet.copy();
        for (Row row : wipCostInitDataSetCopy) {
            materialSet.add(row.getLong("material"));
        }
        Map matIdToPairMap = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"SubElementAndMatService", (String)"getSubElementByOrg", (Object[])new Object[]{Long.valueOf(orgId), materialSet, new Date(), Boolean.TRUE});
        HashSet elementSet = new HashSet();
        HashSet subElementSet = new HashSet();
        if (!CadEmptyUtils.isEmpty((Map)matIdToPairMap)) {
            matIdToPairMap.values().forEach(x -> {
                elementSet.add(x[0]);
                subElementSet.add(x[1]);
            });
        }
        while (wipCostInitDataSet.hasNext()) {
            Long material;
            Row wipCostInit;
            block19: {
                block21: {
                    BigDecimal initqty;
                    Long probillId;
                    Long costCenterId;
                    block20: {
                        DynamicObjectCollection entryentityDy;
                        wipCostInit = wipCostInitDataSet.next();
                        costCenterId = wipCostInit.getLong("costcenter");
                        material = wipCostInit.getLong("material");
                        probillId = wipCostInit.getLong("probill");
                        BigDecimal stockqty = wipCostInit.getBigDecimal("stockqty");
                        BigDecimal quainwaqty = wipCostInit.getBigDecimal("quainwaqty");
                        BigDecimal unquainwaqty = wipCostInit.getBigDecimal("unquainwaqty");
                        BigDecimal scrinwaqty = wipCostInit.getBigDecimal("scrinwaqty");
                        initqty = stockqty.subtract(quainwaqty).subtract(unquainwaqty).subtract(scrinwaqty);
                        if (CadEmptyUtils.isEmpty((Long)material)) continue;
                        if (wipCostInitListDy != null && preOrderentryid.equals(probillId)) break block19;
                        if (!existWipCostInit.containsKey(probillId)) break block20;
                        preOrderentryid = probillId;
                        if (!"A".equals(existWipCostInitIdsMap.get(probillId))) break block21;
                        wipCostInitListDy = (DynamicObject)existWipCostInit.get(probillId);
                        if (CadEmptyUtils.isEmpty((DynamicObject)wipCostInitListDy) || (entryentityDy = wipCostInitListDy.getDynamicObjectCollection("entryentity")).isEmpty()) continue;
                        ArrayList<DynamicObject> removeDynamicObjects = new ArrayList<DynamicObject>();
                        for (DynamicObject dynamicObject : entryentityDy) {
                            String elementTypeStr = null;
                            long elementType = 0L;
                            try {
                                elementTypeStr = elementDetailMap.get(dynamicObject.getLong("element"));
                            }
                            catch (Exception e) {
                                logger.error("getSaveDataList error -> {}", (Object)e.getMessage());
                                elementType = dynamicObject.getLong("element.type");
                            }
                            if (!"001".equals(elementTypeStr) && elementType != 1L) continue;
                            DynamicObjectCollection subentryentity = dynamicObject.getDynamicObjectCollection("subentryentity");
                            subentryentity.clear();
                            removeDynamicObjects.add(dynamicObject);
                        }
                        if (!CadEmptyUtils.isEmpty(removeDynamicObjects)) {
                            removeDynamicObjects.forEach(arg_0 -> ((DynamicObjectCollection)entryentityDy).remove(arg_0));
                        }
                        if (CadEmptyUtils.isEmpty(subElementSet)) break block21;
                        AtomicInteger size = new AtomicInteger();
                        subElementSet.forEach(x -> {
                            DynamicObject dynamicObjectEntry = entryentityDy.addNew();
                            dynamicObjectEntry.set("seq", (Object)size.incrementAndGet());
                            dynamicObjectEntry.set("element", new ArrayList(elementSet).get(0));
                            dynamicObjectEntry.set("subelement", x);
                        });
                        break block21;
                    }
                    preOrderentryid = probillId;
                    wipCostInitListDy = BusinessDataServiceHelper.newDynamicObject((String)"aca_wipcostinit");
                    wipCostInitListDy.set("billno", (Object)this.setBillNo(wipCostInitListDy, orgId));
                    wipCostInitListDy.set(ORG_FIELD, (Object)orgId);
                    wipCostInitListDy.set(COSTACCOUNT, (Object)costAccount);
                    wipCostInitListDy.set("costcenter", (Object)costCenterId);
                    wipCostInitListDy.set("costobject", (Object)proEntryToCostObjIdMap.get(probillId));
                    wipCostInitListDy.set("billstatus", (Object)"A");
                    wipCostInitListDy.set("source", (Object)"importmftstock");
                    wipCostInitListDy.set("currency", (Object)currency);
                    wipCostInitListDy.set("initqty", (Object)initqty);
                    DynamicObject costObject = (DynamicObject)costObjectMap.get(proEntryToCostObjIdMap.get(probillId));
                    DynamicObject materialDy = costObject.getDynamicObject("material");
                    Map matBaseUnit = MatHelper.getMatBaseUnit(Collections.singleton((Long)materialDy.getPkValue()));
                    if (!matBaseUnit.isEmpty()) {
                        wipCostInitListDy.set("baseunit", matBaseUnit.get(materialDy.getPkValue()));
                    }
                    wipCostInitListDy.set("auxpty", (Object)costObject.getLong("auxpty.id"));
                    wipCostInitListDy.set("assignedproduct", (Object)materialDy);
                    wipCostInitListDy.set("creator", (Object)currUserId);
                    wipCostInitListDy.set("createtime", (Object)date);
                    wipCostInitListDy.set("modifier", (Object)currUserId);
                    wipCostInitListDy.set("modifytime", (Object)date);
                    DynamicObjectCollection entryentity = wipCostInitListDy.getDynamicObjectCollection("entryentity");
                    AtomicInteger size = new AtomicInteger();
                    if (elementDetail != null) {
                        if (!CadEmptyUtils.isEmpty(subElementSet)) {
                            subElementSet.forEach(x -> {
                                DynamicObject dynamicObjectEntry = entryentity.addNew();
                                dynamicObjectEntry.set("seq", (Object)size.incrementAndGet());
                                dynamicObjectEntry.set("element", new ArrayList(elementSet).get(0));
                                dynamicObjectEntry.set("subelement", x);
                            });
                        }
                        for (DynamicObject ele : elementDetail) {
                            long elementId = ele.getLong("element.id");
                            if ("001".equals(elementDetailMap.get(elementId))) continue;
                            size.set(size.get() + 1);
                            DynamicObject dynamicObjectEntry = entryentity.addNew();
                            dynamicObjectEntry.set("seq", (Object)size);
                            dynamicObjectEntry.set("element", (Object)elementId);
                            dynamicObjectEntry.set("subelement", (Object)ele.getLong("subelement.id"));
                        }
                    }
                }
                saveList.add(wipCostInitListDy);
            }
            this.getEntryEntity(elementDetailMap, wipCostInitListDy, material, wipCostInit, priceMap, isViewSubItem, matIdToPairMap);
        }
        if (!CadEmptyUtils.isEmpty(saveList)) {
            this.updateEntryEntity(elementDetailMap, saveList, matIdToPairMap);
            logger.info("\u7ec4\u4ef6\u6e05\u5355\u5f15\u5165-\u4fdd\u5b58\uff0c\u4e2a\u6570\uff1a{}", (Object)saveList.size());
            OperationResult resultOp = OperationServiceHelper.executeOperate((String)"save", (String)"aca_wipcostinit", (DynamicObject[])saveList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (!resultOp.isSuccess()) {
                String message = ((OperateErrorInfo)((ValidateResult)resultOp.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage();
                logger.info("\u7ec4\u4ef6\u6e05\u5355\u5f15\u5165-\u4fdd\u5b58\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)message);
            }
            logger.info("\u7ec4\u4ef6\u6e05\u5355\u5f15\u5165-\u4fdd\u5b58\uff0c\u4e2a\u6570\uff1a{}", (Object)resultOp);
        }
    }

    private void updateEntryEntity(Map<Long, String> elementDetailMap, List<DynamicObject> saveList, Map<Long, Long[]> matIdToPairMap) {
        saveList.forEach(x -> {
            DynamicObjectCollection entryentityDy = x.getDynamicObjectCollection("entryentity");
            int removeIndex = 0;
            int count = 0;
            int removeCount = 0;
            ArrayList<Integer> removeIndexList = new ArrayList<Integer>();
            if (!entryentityDy.isEmpty()) {
                for (DynamicObject dynamicObject : entryentityDy) {
                    ++removeIndex;
                    String elementTypeStr = null;
                    long elementType = 0L;
                    try {
                        elementTypeStr = (String)elementDetailMap.get(dynamicObject.getLong("element"));
                    }
                    catch (Exception e) {
                        logger.error("updateEntryEntity error -> {}", (Object)e.getMessage());
                        elementType = dynamicObject.getLong("element.type");
                    }
                    if (!"001".equals(elementTypeStr) && elementType != 1L) continue;
                    ++count;
                    BigDecimal amount = BigDecimal.ZERO;
                    DynamicObjectCollection subentryentity = dynamicObject.getDynamicObjectCollection("subentryentity");
                    if (subentryentity.isEmpty()) {
                        ++removeCount;
                        removeIndexList.add(removeIndex);
                        continue;
                    }
                    for (DynamicObject object : subentryentity) {
                        amount = amount.add(object.getBigDecimal("subamount"));
                    }
                    dynamicObject.set("amount", (Object)amount);
                }
                if (!CadEmptyUtils.isEmpty(removeIndexList) && removeCount < count) {
                    removeIndexList.forEach(y -> entryentityDy.remove(y - 1));
                }
            }
        });
    }

    private void getEntryEntity(Map<Long, String> elementDetailMap, DynamicObject wipCostInitListDy, Long material, Row wipCostInit, Map<Long, List<Row>> priceMap, boolean isViewSubItem, Map<Long, Long[]> matIdToPairMap) {
        if (wipCostInitListDy == null) {
            return;
        }
        DynamicObjectCollection entryentityDy = wipCostInitListDy.getDynamicObjectCollection("entryentity");
        if (!entryentityDy.isEmpty()) {
            for (DynamicObject dynamicObject : entryentityDy) {
                long subelementMapperId;
                String elementTypeStr = null;
                long elementType = 0L;
                try {
                    elementTypeStr = elementDetailMap.get(dynamicObject.getLong("element"));
                }
                catch (Exception e) {
                    logger.error("getEntryEntity error -> {}", (Object)e.getMessage());
                    elementType = dynamicObject.getLong("element.type");
                }
                if (!"001".equals(elementTypeStr) && elementType != 1L) continue;
                DynamicObjectCollection subentryentity = dynamicObject.getDynamicObjectCollection("subentryentity");
                int size = subentryentity.size();
                long subelementId = dynamicObject.getLong("subelement_id");
                if (subelementId == 0L) {
                    subelementId = dynamicObject.getLong("subelement");
                }
                if (subelementId != (subelementMapperId = matIdToPairMap.get(material)[1].longValue())) continue;
                DynamicObject subentryentityDy = subentryentity.addNew();
                long entryId = DB.genLongId((String)"t_aca_wipcostinitsubentry");
                subentryentityDy.set("id", (Object)entryId);
                subentryentityDy.set("submateriel", (Object)material);
                subentryentityDy.set("subbaseunit", wipCostInit.get("materialunit"));
                subentryentityDy.set("subauxpty", (Object)wipCostInit.getLong("auxpty"));
                BigDecimal subqty = wipCostInit.getBigDecimal("wipqty");
                subentryentityDy.set("subqty", (Object)subqty);
                subentryentityDy.set("seq", (Object)(size + 1));
                BigDecimal actualCostSum = BigDecimal.ZERO;
                List<Object> rows = new ArrayList(16);
                if (!priceMap.containsKey(material)) continue;
                rows = priceMap.get(material);
                if (!CadEmptyUtils.isEmpty(rows)) {
                    for (Row row : rows) {
                        BigDecimal actualcost = row.getBigDecimal("actualcost");
                        BigDecimal baseqty = row.getBigDecimal("baseqty");
                        actualCostSum = actualCostSum.add(actualcost.divide(baseqty, 10, 4));
                    }
                }
                BigDecimal subamount = subqty.multiply(actualCostSum);
                subentryentityDy.set("subamount", (Object)subamount);
                if (!isViewSubItem) continue;
                ArrayList arrayList = new ArrayList(10);
                if (CadEmptyUtils.isEmpty(rows)) continue;
                rows.forEach(x -> {
                    WipInitSubItem subItem = new WipInitSubItem();
                    subItem.setSelement(x.getLong("costelement"));
                    subItem.setSsubelement(x.getLong("costsubelement"));
                    BigDecimal actualcost = x.getBigDecimal("actualcost");
                    BigDecimal baseqty = x.getBigDecimal("baseqty");
                    subItem.setSamount(actualcost.divide(baseqty, 10, 4));
                    subItems.add(subItem);
                });
                subentryentityDy.set("subitemjson_tag", (Object)JSONObject.toJSONString(arrayList));
            }
        }
    }

    private DataSet getPrice(String costaccountId, String orgId, boolean isViewSubItem, DataSet wipCostInitDataSetCopy) {
        logger.info("\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316-\u5f15\u5165\u7ec4\u4ef6\u6e05\u5355-\u8c03\u7528\u53d6\u4ef7\u63a5\u53e3\u5f00\u59cb");
        HashSet<Long> materialList = new HashSet<Long>(16);
        while (wipCostInitDataSetCopy.hasNext()) {
            Row wipCostInit = wipCostInitDataSetCopy.next();
            Long material = wipCostInit.getLong("material");
            materialList.add(material);
        }
        DataSet priceDataSet = this.getPriceDataSet(Long.valueOf(costaccountId), Long.valueOf(orgId), materialList, isViewSubItem);
        logger.info("\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316-\u5f15\u5165\u7ec4\u4ef6\u6e05\u5355-\u8c03\u7528\u53d6\u4ef7\u63a5\u53e3\u7ed3\u675f");
        return priceDataSet;
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String opKey = event.getOperateKey();
        if ("importmftstock".equals(opKey)) {
            String costaccountId = this.getPageCache().get(COSTACCOUNT);
            String orgId = this.getPageCache().get(ORG_FIELD);
            List<String> orgList = new ArrayList(10);
            if (!StringUtils.isEmpty((Object)orgId) && !CadEmptyUtils.isEmpty(orgList = (List)SerializationUtils.fromJsonString((String)orgId, List.class))) {
                orgId = (String)orgList.get(0);
            }
            if (StringUtils.isEmpty((Object)orgId) || "0".equals(orgId) || !OrgUnitServiceHelper.checkOrgFunction((Long)Long.parseLong(orgId), (String)"10")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u9009\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipCostInitList_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.paramValidate(costaccountId, orgList)) {
                return;
            }
            String lockId = "WipImportmftstock" + orgId;
            DLock lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316-\u7ec4\u4ef6\u6e05\u5355\u5f15\u5165", (String)"WipCostInitList_19", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            boolean isLocked = lock.tryLock();
            if (!isLocked) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u751f\u6210\u66f4\u65b0\u7533\u8bf7\u5355\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"WipCostInitList_25", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                return;
            }
            String progressId = UUID.randomUUID().toString();
            String finalOrgId = orgId;
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"WipCostInitList_26", (String)"macc-aca-formplugin", (Object[])new Object[0]), () -> {
                Map<Object, Object> responseInfo = new HashMap(2);
                try {
                    responseInfo = this.improtWipCostInit(costaccountId, progressId, finalOrgId);
                }
                catch (Exception e) {
                    logger.error("improtWipCostInit error -> {}", (Object)e.getMessage());
                    MsgUtils.putMsg2Map((String)"error", (String)e.toString(), responseInfo);
                    MsgUtils.putMsg2Map((String)"error", (String)String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff1a%s", (String)"WipCostInitList_8", (String)"macc-aca-formplugin", (Object[])new Object[0]), e.toString()), responseInfo);
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                finally {
                    lock.close();
                }
                String responseInfoStr = SerializationUtils.toJsonString(responseInfo);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_importResult));
        }
    }

    private DataSet getWipCostInitDataSet(DataSet orderEntryQtyDataSet, DataSet mftOrderRows, DataSet costObjectRows) {
        logger.info("\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316\u5f15\u5165\uff1agetWipCostInitDataSet-\u8054\u67e5\u83b7\u53d6\u4fdd\u5b58\u65f6\u5168\u90e8\u6570\u636e\u5f00\u59cb");
        HashSet<Long> matIdSet = new HashSet<Long>();
        DataSet mftOrderRowsCopy = mftOrderRows.copy();
        while (mftOrderRowsCopy.hasNext()) {
            Row next = mftOrderRowsCopy.next();
            Long material = next.getLong("material");
            matIdSet.add(material);
        }
        DataSet affectPriceDs = this.getAffectPriceDs(matIdSet);
        DataSet bomVersionDs = this.getBomVersionDs(matIdSet);
        mftOrderRows = mftOrderRows.leftJoin(affectPriceDs).on("material", "effectpricemat").select(new String[]{"orderentryid", "unit", "material", "lot", "wipqty", "matversion", "case when effectpricemat>0  then auxpty else 0L end auxpty", "materialunit"}).finish().leftJoin(bomVersionDs).on("material", "enableVersionMat").select(new String[]{"orderentryid", "unit", "material", "lot", "wipqty", "auxpty", "case when enableVersionMat>0  then matversion else 0L end matversion", "materialunit"}).finish().groupBy(new String[]{"orderentryid", "unit", "material", "matversion", "lot", "auxpty", "materialunit"}).sum("wipqty").finish();
        DataSet wipCostInitDataSet = mftOrderRows.leftJoin(costObjectRows).on("orderentryid", "probill").select(mftOrderRows.getRowMeta().getFieldNames(), costObjectRows.getRowMeta().getFieldNames()).finish().orderBy(new String[]{"orderentryid"});
        wipCostInitDataSet = wipCostInitDataSet.leftJoin(orderEntryQtyDataSet).on("probill", "entryid").select(wipCostInitDataSet.getRowMeta().getFieldNames(), orderEntryQtyDataSet.getRowMeta().getFieldNames()).finish();
        logger.info("\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316\u5f15\u5165\uff1agetWipCostInitDataSet-\u8054\u67e5\u83b7\u53d6\u4fdd\u5b58\u65f6\u5168\u90e8\u6570\u636e\u7ed3\u675f");
        return wipCostInitDataSet;
    }

    private DataSet getMftOrderRows(Set<Long> mftorderIds, Set<Long> omMftorderIds) {
        logger.info("\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316\u5f15\u5165\uff1a\u83b7\u53d6\u7ec4\u4ef6\u6e05\u5355\u3001\u59d4\u5916\u5de5\u5355\u6570\u636e\u5f00\u59cb");
        QFilter mftorderIdsFilter = new QFilter("orderentryid", "in", mftorderIds);
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        DataSet mftOrderRows = QueryServiceHelper.queryDataSet((String)"WipCostInitListpom_mftstock", (String)"pom_mftstock", (String)this.getQueryFileName(), (QFilter[])new QFilter[]{mftorderIdsFilter, billStatusFilter}, null);
        QFilter omMftorderIdsFilter = new QFilter("orderentryid", "in", omMftorderIds);
        DataSet omMftOrderRows = QueryServiceHelper.queryDataSet((String)"WipCostInitListom_mftstock", (String)"om_mftstock", (String)this.getQueryFileName(), (QFilter[])new QFilter[]{omMftorderIdsFilter, billStatusFilter}, null);
        mftOrderRows = mftOrderRows.union(omMftOrderRows);
        if (mftOrderRows.isEmpty()) {
            return null;
        }
        logger.info("\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316\u5f15\u5165\uff1a\u83b7\u53d6\u7ec4\u4ef6\u6e05\u5355\u3001\u59d4\u5916\u5de5\u5355\u6570\u636e\u7ed3\u675f");
        return mftOrderRows;
    }

    private DataSet getPriceDataSet(Long costAccount, Long calorg, Set<Long> materials, boolean isViewSubItem) {
        logger.info("\u671f\u521d\u52a0\u6743\u5e73\u5747\u4ef7-\u5b58\u8d27\u63a5\u53e3-\u6838\u7b97\u4f59\u989d\u8868-\u5f00\u59cb\u3002\u53c2\u6570\uff1a\u6210\u672c\u8d26\u7c3f\uff1a{}\uff1b\u6838\u7b97\u7ec4\u7ec7\uff1a{}\uff0c\u7269\u6599\uff1a{}", new Object[]{costAccount, calorg, materials});
        List hasPermInvOrgs = OrgHelper.getUserHasPermStoreOrgsByAccOrg((Long)calorg, (String)"aca_wipcostinit", (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
        if (hasPermInvOrgs == null || hasPermInvOrgs.isEmpty()) {
            hasPermInvOrgs = Lists.newArrayListWithExpectedSize((int)0);
        }
        HashSet stoOrgs = new HashSet(hasPermInvOrgs);
        DynamicObject curPeriodDy = PeriodHelper.getCurrentPeriod((Long)costAccount);
        if (curPeriodDy == null) {
            return null;
        }
        Long currentPeriodId = curPeriodDy.getLong("id");
        DataSet priceDataSet = WipCostInitHelper.getPriceDataSet((Long)costAccount, (Long)currentPeriodId, stoOrgs, materials, (boolean)isViewSubItem);
        return priceDataSet;
    }

    protected static void refreshProgress(String opContent, int nowComplete, int total, Boolean isAddNum, String progressId) {
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)progressId);
        if (paramDto == null) {
            return;
        }
        paramDto.setOpContent(opContent);
        if (isAddNum.booleanValue()) {
            Integer complete = paramDto.getComplete();
            paramDto.setComplete(Integer.valueOf(complete + nowComplete));
        } else {
            paramDto.setComplete(Integer.valueOf(nowComplete));
        }
        if (!CadEmptyUtils.isEmpty((Integer)total)) {
            paramDto.setTotal(Integer.valueOf(total));
        }
        paramDto.setUnit(ResManager.loadKDString((String)"\u6b65", (String)"WipCostInitList_14", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        paramDto.setDurationTimes(Integer.valueOf(0));
        if (nowComplete == -1) {
            paramDto.setComplete(paramDto.getTotal());
        }
        ProgressHelper.setProgressParam((String)progressId, (ProgressParamDto)paramDto);
    }

    private String setBillNo(DynamicObject addWipCost, String orgId) {
        String number = "";
        try {
            number = CodeRuleServiceHelper.getNumber((String)"aca_wipcostinit", (DynamicObject)addWipCost, (String)String.valueOf(orgId));
        }
        catch (Exception e) {
            logger.error("\u5355\u636e\u7f16\u53f7\u83b7\u53d6\u5931\u8d25,\u8bf7\u68c0\u67e5\u662f\u5426\u542f\u7528\u7f16\u53f7\u89c4\u5219\u3002", (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u542f\u7528\u7f16\u53f7\u89c4\u5219\u3002", (String)"WipCostInitList_15", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        }
        return number;
    }

    private String getQueryFileName() {
        return "orderentryid,baseunitid as unit,stockentry.materielmasterid as material,stockentry.bomreversion as matversion,stockentry.lot as lot,stockentry.wipqty as wipqty,stockentry.childauxpropertyid as auxpty,stockentry.materialunitid materialunit";
    }

    private DataSet getAffectPriceDs(Set<Long> materialIdSet) {
        QFilter filter = new QFilter("id", "in", materialIdSet);
        filter.and("isuseauxpty", "=", (Object)Boolean.TRUE);
        filter.and("auxptyentry.isaffectprice", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.queryDataSet((String)"getAffectPriceDsmat", (String)"bd_material", (String)"id as effectpricemat", (QFilter[])new QFilter[]{filter}, null).distinct();
    }

    private DataSet getBomVersionDs(HashSet<Long> matIdSet) {
        QFilter filter = new QFilter("id", "in", matIdSet);
        filter.and("isenablematerialversion", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.queryDataSet((String)"getBomVersionDs", (String)"bd_material", (String)"id as enableVersionMat", (QFilter[])new QFilter[]{filter}, null).distinct();
    }

    private void setElementInfo() {
        DynamicObjectCollection elementDetail = this.getElementDetail();
        if (elementDetail == null) {
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        HashSet<Long> subEle = new HashSet<Long>();
        for (DynamicObject ele : elementDetail) {
            if (subEle.contains(ele.getLong("subelement.id"))) continue;
            subEle.add(ele.getLong("subelement.id"));
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().beginInit();
            this.getModel().setValue("element", (Object)ele.getLong("element.id"), index);
            this.getModel().setValue("subelement", (Object)ele.getLong("subelement.id"), index);
            this.getModel().endInit();
            this.getModel().setDataChanged(false);
        }
        this.getView().updateView("entryentity");
    }

    private DynamicObjectCollection getElementDetail() {
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        DynamicObject costType = BusinessDataServiceHelper.loadSingle((Object)CommonConstant.ACA_COST_TYPE_ID, (String)"cad_costtype");
        if (costType == null) {
            return null;
        }
        long elementTypeId = costType.getLong("elementtype.id");
        HashSet<Long> elementIds = new HashSet<Long>();
        QFilter qfElementType = new QFilter("elementtype", "=", (Object)elementTypeId);
        QFilter qfEable = new QFilter("enable", "=", (Object)true);
        QFilter qfStatus = new QFilter("status", "=", (Object)"C");
        DynamicObjectCollection element = QueryServiceHelper.query((String)"cad_element", (String)"id", (QFilter[])new QFilter[]{qfElementType, qfEable, qfStatus});
        for (DynamicObject ele : element) {
            elementIds.add(ele.getLong("id"));
        }
        QFilter qfDefaultValue = new QFilter("defaultvalue", "=", (Object)true);
        DynamicObjectCollection subElements = QueryServiceHelper.query((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{qfDefaultValue, qfEable, qfStatus});
        HashSet<Long> subIds = new HashSet<Long>();
        for (DynamicObject sub : subElements) {
            subIds.add(sub.getLong("id"));
        }
        QFilter qfElement = new QFilter("element", "in", elementIds);
        QFilter qfSubElement = new QFilter("subelement", "in", subIds);
        DynamicObjectCollection elementDetail = QueryServiceHelper.query((String)"cad_elementdetail", (String)"element.id,element.type,subelement.id", (QFilter[])new QFilter[]{qfElement, qfSubElement, qfElementType}, (String)"element.number");
        if (elementDetail.size() == 0) {
            return null;
        }
        return elementDetail;
    }

    public DataSet buildComAssemblyDataSet(Set<Long> proBillEntrySet, Set<Long> proOmBillEntrySet, Date costAccountStartPeriod) {
        QFilter filter;
        DataSet mftStockDs = null;
        DataSet mftOmStockDs = null;
        if (!proBillEntrySet.isEmpty() && (mftStockDs = QueryServiceHelper.queryDataSet((String)"WipCostInitListmftOrder", (String)"pom_mftorder", (String)"billno AS mftOrderNo,treeentryentity.id entryid,treeentryentity.material.masterid AS materialId,treeentryentity.baseqty AS stockqty,treeentryentity.quainwaqty quainwaqty,treeentryentity.unquainwaqty unquainwaqty,treeentryentity.scrinwaqty scrinwaqty", (QFilter[])new QFilter[]{filter = this.getqFilter(proBillEntrySet, costAccountStartPeriod)}, null)) != null) {
            proBillEntrySet.clear();
            DataSet mftStockDsCopy = mftStockDs.copy();
            mftStockDsCopy.forEach(x -> proBillEntrySet.add(x.getLong("entryid")));
        }
        if (!proOmBillEntrySet.isEmpty() && (mftOmStockDs = QueryServiceHelper.queryDataSet((String)"WipCostInitListmftOrder", (String)"om_mftorder", (String)"billno AS mftOrderNo,treeentryentity.id entryid,treeentryentity.material.masterid AS materialId,treeentryentity.baseqty AS stockqty,treeentryentity.quainwaqty quainwaqty,treeentryentity.unquainwaqty unquainwaqty,treeentryentity.scrinwaqty scrinwaqty", (QFilter[])new QFilter[]{filter = this.getqFilter(proOmBillEntrySet, costAccountStartPeriod)}, null)) != null) {
            proOmBillEntrySet.clear();
            DataSet mftOmStockDsCopy = mftOmStockDs.copy();
            mftOmStockDsCopy.forEach(x -> proOmBillEntrySet.add(x.getLong("entryid")));
        }
        if (mftStockDs == null || mftOmStockDs == null) {
            if (mftStockDs != null) {
                return mftStockDs;
            }
            if (mftOmStockDs != null) {
                return mftOmStockDs;
            }
            return null;
        }
        return DataSetHelper.union(mftStockDs, mftOmStockDs);
    }

    private QFilter getqFilter(Set<Long> proBillEntrySet, Date costAccountStartPeriod) {
        QFilter filter = new QFilter("treeentryentity.id", "in", proBillEntrySet);
        filter.and(new QFilter("treeentryentity.beginbookdate", "<", (Object)costAccountStartPeriod));
        QFilter notClose = new QFilter("treeentryentity.bizstatus", "!=", (Object)"C");
        QFilter close = new QFilter("treeentryentity.bizstatus", "=", (Object)"C");
        close.and(new QFilter("treeentryentity.closebookdate", ">", (Object)costAccountStartPeriod));
        close = close.or(notClose);
        filter = filter.and(close);
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void costObjectImport(String orgId, String appnum) {
        String lockId = "CostObjectOperExecutor" + orgId;
        Map resultInfo = null;
        try (DLock lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5de5\u4f5c\u53f0-\u6210\u672c\u5bf9\u8c61\u5f15\u5165", (String)"WipCostInitList_16", (String)"macc-aca-formplugin", (Object[])new Object[0]));){
            boolean isLocked = lock.tryLock();
            if (!isLocked) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6b63\u5728\u8fdb\u884c\u6210\u672c\u5bf9\u8c61\u5f15\u5165\uff0c\u8bf7\u7a0d\u5019\u6267\u884c\u3002", (String)"WipCostInitList_17", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                return;
            }
            String progressId = UUID.randomUUID().toString();
            if (OrgHelper.isOrgEnableMultiFactory((Long)Long.valueOf(orgId))) {
                List manuOrgIds = OrgHelper.getProOrgsByOrgEntity((Long)Long.valueOf(orgId), (String)"cad_costobject", (String)appnum);
                Set<Long> ccIds = this.getCenterIdsByManuOrgIds(Long.valueOf(orgId), manuOrgIds, appnum);
                resultInfo = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"costObjectService", (String)"importCostObject", (Object[])new Object[]{null, null, orgId, new ArrayList<Long>(ccIds), manuOrgIds, appnum, progressId});
                logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u81ea\u52a8\u5f52\u96c6\u8fd4\u56de\u503c\uff1a" + resultInfo.toString());
            } else {
                List ccIds = OrgHelper.getCostCentersByOrg((long)Long.parseLong(orgId));
                resultInfo = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"costObjectService", (String)"importCostObject", (Object[])new Object[]{null, null, Long.valueOf(orgId), new ArrayList(ccIds), null, appnum, progressId});
                logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u81ea\u52a8\u5f52\u96c6\u8fd4\u56de\u503c\uff1a" + resultInfo.toString());
            }
        }
    }

    protected Set<Long> getCenterIdsByManuOrgIds(Long orgId, List<Long> manuList, String appId) {
        if (CadEmptyUtils.isEmpty((String)appId)) {
            appId = "sca";
        }
        HashSet<Long> centerIds = new HashSet<Long>(20);
        HashSet<Long> allCenterIds = new HashSet<Long>(20);
        Date nowTime = new Date();
        QFilter qFilter = new QFilter(ORG_FIELD, "=", (Object)orgId);
        qFilter.and("manuorg", "in", manuList);
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("effectdate", "<=", (Object)nowTime);
        qFilter.and("expdate", ">", (Object)nowTime);
        qFilter.and("appnum", "=", (Object)appId);
        DataSet costCenterDs = QueryServiceHelper.queryDataSet((String)"getCenterIdsByManuOrgIds", (String)"cad_centermanuorg", (String)"entryentity.costcenter as costcenterid", (QFilter[])qFilter.toArray(), null);
        for (Row costCenter : costCenterDs) {
            allCenterIds.add(costCenter.getLong("costcenterid"));
        }
        if (!CadEmptyUtils.isEmpty(allCenterIds)) {
            QFilter ccFilter = new QFilter("id", "in", allCenterIds);
            ccFilter.and(new QFilter("orgduty", "=", (Object)4L));
            DataSet basicCostCenterDs = QueryServiceHelper.queryDataSet((String)"getCenterIds", (String)"bos_costcenter", (String)"id", (QFilter[])ccFilter.toArray(), null);
            for (Row costCenter : basicCostCenterDs) {
                centerIds.add(costCenter.getLong("id"));
            }
        }
        if (CadEmptyUtils.isEmpty(centerIds)) {
            centerIds.add(-1L);
        }
        return centerIds;
    }

    private boolean checkCostAccountInit(BeforeDoOperationEventArgs args) {
        String orgId = this.getPageCache().get(ORG_FIELD);
        String costAccountId = this.getPageCache().get(COSTACCOUNT);
        if (CadEmptyUtils.isEmpty((String)orgId) || CadEmptyUtils.isEmpty((String)costAccountId)) {
            return Boolean.TRUE;
        }
        if (AcaCostAccountHelper.isInited((long)Long.parseLong(costAccountId), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u8d26\u7c3f\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u5f53\u524d\u64cd\u4f5c", (String)"WipCostInitList_23", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

