/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.realtime;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.common.helper.MatBaseDataFilterHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class RealTimeMfgFeeRateEditPlugin
extends AbstractBillPlugIn {
    private static final String KEY_BARITEM_NEW = "bar_new";
    private static final String KEY_BARITEM_SAVE = "bar_save";
    private static final String KEY_BARITEM_COPY = "bar_copy";
    private static final String KEY_BARITEM_EFFECT = "bar_effect";
    private static final String KEY_BARITEM_DELETE = "bar_delete";

    public void registerListener(EventObject e) {
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"RealTimeMfgFeeRateEditPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter costAccountFilter = this.getCostAccountFilter(org.getLong("id"), AppIdHelper.getCurAppNum((IFormView)this.getView()));
            qFilters.add(costAccountFilter);
        });
        BasedataEdit costCenterEdit = (BasedataEdit)this.getControl("costcenter");
        costCenterEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject accountOrg = (DynamicObject)this.getModel().getValue("org");
            if (accountOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"RealTimeMfgFeeRateEditPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactory((long)accountOrg.getLong("id"), null, (String)this.getView().getFormShowParameter().getAppId());
            qList.add(costCenterIdFilter);
        });
        BasedataEdit expenseItem = (BasedataEdit)this.getControl("expenseitem");
        expenseItem.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            filterParameter.getQFilters().add(new QFilter("isleaf", "=", (Object)true));
        });
        BasedataEdit subElementCtrl = (BasedataEdit)this.getControl("subelement");
        subElementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject element = (DynamicObject)this.getModel().getValue("element", beforeF7SelectEvent.getRow());
            if (element != null) {
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", this.getSubElement(element.getLong("id"))));
            }
        });
        BasedataEdit attaSubElementCtrl = (BasedataEdit)this.getControl("attsubelement");
        attaSubElementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject attElement = (DynamicObject)this.getModel().getValue("attelement", beforeF7SelectEvent.getRow());
            if (attElement != null) {
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", this.getSubElement(attElement.getLong("id"))));
            }
            DynamicObjectCollection attEntry = this.getModel().getEntryEntity("attentryentity");
            HashSet attSubElementIds = new HashSet(16);
            attEntry.forEach(s -> attSubElementIds.add(s.getLong("attsubelement.id")));
            if (!CadEmptyUtils.isEmpty(attSubElementIds)) {
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "not in", attSubElementIds));
            }
        });
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        material.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject orgObj = this.getModel().getDataEntity().getDynamicObject("org");
            if (orgObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"RealTimeMfgFeeRateEditPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Long orgId = orgObj.getLong("id");
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(Collections.singletonList(orgId)));
        });
    }

    public void afterCreateNewData(EventObject e) {
        Object costAccountId;
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object orgId = fsp.getCustomParam("orgId");
        if (orgId != null) {
            this.getModel().setValue("org", orgId);
        }
        if ((costAccountId = fsp.getCustomParam("costaccount")) != null) {
            this.getModel().setValue("costaccount", costAccountId);
            DynamicObject costAccount = BusinessDataServiceHelper.loadSingle((Object)costAccountId, (String)"cal_bd_costaccount");
            if (costAccount == null) {
                return;
            }
            Long currency = CalcRptHelper.getCurrency((DynamicObject)costAccount);
            this.getModel().setValue("currency", (Object)currency);
        }
        Object costCenterId = fsp.getCustomParam("costcenter");
        this.getModel().setValue("costcenter", costCenterId);
        this.setEffectDate();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "calctype": {
                this.innitVisible();
                break;
            }
            case "expenseitem": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (org == null || newValue == null) break;
                DynamicObject expenseItem = (DynamicObject)newValue;
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                QFilter qFilter = new QFilter("org", "=", (Object)org.getLong("id"));
                qFilter.and("expenseitem", "=", (Object)expenseItem.getLong("id"));
                DynamicObject subElementExpense = BusinessDataServiceHelper.loadSingle((String)"cad_subelementexpense", (String)"subelement", (QFilter[])qFilter.toArray());
                if (subElementExpense == null) break;
                long subElementId = subElementExpense.getLong("subelement.id");
                this.getModel().setValue("subelement", (Object)subElementId, rowIndex);
                QFilter subElementIdFilter = new QFilter("subelement", "=", (Object)subElementId);
                DynamicObject element = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{subElementIdFilter});
                if (element == null) break;
                this.getModel().setValue("element", (Object)element.getLong("element"), rowIndex);
                break;
            }
            case "element": {
                this.setDefaultSubElement(e, false);
                break;
            }
            case "subelement": {
                this.setElement(e, false);
                break;
            }
            case "attelement": {
                this.setDefaultSubElement(e, true);
                break;
            }
            case "attsubelement": {
                this.setElement(e, true);
                break;
            }
        }
    }

    private void setElement(PropertyChangedArgs e, boolean isAttElement) {
        String elementFiled = isAttElement ? "attelement" : "element";
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (newValue == null) {
            return;
        }
        DynamicObject subEle = (DynamicObject)newValue;
        long subElementId = subEle.getLong("id");
        QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
        DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
        if (dySubElement != null) {
            this.getModel().setValue(elementFiled, (Object)dySubElement.getLong("element"), rowIndex);
        }
    }

    private void setDefaultSubElement(PropertyChangedArgs e, boolean isAttSubElement) {
        QFilter qfElementType;
        String subtype;
        String type;
        String subElementField = isAttSubElement ? "attsubelement" : "subelement";
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (newValue == null) {
            return;
        }
        DynamicObject ele = (DynamicObject)newValue;
        long elementId = ele.getLong("id");
        QFilter qfElement = new QFilter("id", "=", (Object)elementId);
        DynamicObject dyElement = QueryServiceHelper.queryOne((String)"cad_element", (String)"elementtype.id", (QFilter[])new QFilter[]{qfElement});
        long elementTypeId = dyElement.getLong("elementtype.id");
        DynamicObject subElement = (DynamicObject)this.getModel().getValue(subElementField, rowIndex);
        if (subElement != null && (type = ele.getString("type")).equalsIgnoreCase(subtype = subElement.getString("type"))) {
            return;
        }
        qfElement = new QFilter("element", "=", (Object)elementId);
        DynamicObjectCollection dyElementRelation = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement", (QFilter[])new QFilter[]{qfElement, qfElementType = new QFilter("elementtype", "=", (Object)elementTypeId)});
        if (dyElementRelation == null) {
            return;
        }
        HashSet<Long> eleIds = new HashSet<Long>();
        for (DynamicObject relation : dyElementRelation) {
            eleIds.add(relation.getLong("subelement"));
        }
        QFilter qfSubElement = new QFilter("id", "in", eleIds);
        QFilter qfDefault = new QFilter("defaultvalue", "=", (Object)true);
        DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{qfSubElement, qfDefault});
        if (dySubElement != null) {
            DynamicObjectCollection attEntry = this.getModel().getEntryEntity("attentryentity");
            HashSet attSubElementIds = new HashSet(16);
            attEntry.forEach(s -> attSubElementIds.add(s.getLong("attsubelement.id")));
            long attSubElementId = dySubElement.getLong("id");
            if (!attSubElementIds.contains(attSubElementId)) {
                this.getModel().setValue(subElementField, (Object)attSubElementId, rowIndex);
            } else {
                this.getModel().setValue(subElementField, null, rowIndex);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        this.initOrgAndCostcenter(os);
        this.innitVisible();
    }

    private void setEffectDate() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        this.getModel().setValue("effectdate", (Object)DateUtils.getDefaultEffectDate());
        long orgId = org.getLong("id");
        Boolean isEnableEffect = SysParamHelper.getEnableEffectByOrg((Long)orgId, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()), (String)"aca_mfgplanfeerate");
        if (isEnableEffect.booleanValue()) {
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
            DynamicObject costCenter = (DynamicObject)this.getModel().getValue("costcenter");
            String calcType = (String)this.getModel().getValue("calctype");
            QFilter qFilter = new QFilter("org", "=", (Object)orgId);
            qFilter.and("costaccount", "=", (Object)(costAccount == null ? 0L : costAccount.getLong("id")));
            qFilter.and("costcenter", "=", (Object)(costCenter == null ? 0L : costCenter.getLong("id")));
            qFilter.and("calctype", "=", (Object)calcType);
            qFilter.and("effectstatus", "=", (Object)"E");
            if (QueryServiceHelper.exists((String)"aca_mfgplanfeerate", (QFilter[])qFilter.toArray())) {
                this.getModel().setValue("effectdate", (Object)new Date());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus operationStatus = formShowParameter.getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)operationStatus)) {
            boolean dataChanged = this.getModel().getDataChanged();
            this.getPageCache().put("dataChanged", String.valueOf(dataChanged));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult opResult = args.getOperationResult();
        if (opResult == null || !opResult.isSuccess()) {
            return;
        }
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        if ("save".equals(args.getOperateKey())) {
            String dataChanged = this.getPageCache().get("dataChanged");
            if (StringUtils.equals((CharSequence)"true", (CharSequence)dataChanged)) {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                dataEntity.set("effectstatus", (Object)"A");
                dataEntity.set("expdate", null);
                SaveServiceHelper.update((DynamicObject)dataEntity);
                this.getView().updateView("expdate");
            }
            this.initOrgAndCostcenter(os);
            this.innitVisible();
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_BARITEM_EFFECT});
            this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        } else if ("effect".equals(args.getOperateKey())) {
            this.initOrgAndCostcenter(os);
            this.getView().invokeOperation("refresh");
        }
    }

    private void initOrgAndCostcenter(OperationStatus os) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        boolean isEnableEffect = org == null ? false : this.isEnableEffectByOrg(org.getLong("id"));
        String effectStatus = (String)this.getModel().getValue("effectstatus");
        boolean isUnEffect = "A".equals(effectStatus);
        this.getView().setEnable(Boolean.valueOf(isEnableEffect && isUnEffect), new String[]{"effectdate"});
        if (OperationStatus.ADDNEW.equals((Object)os)) {
            Object costcenter;
            FormShowParameter fsp = this.getView().getFormShowParameter();
            String costAccountId = (String)fsp.getCustomParam("costaccount");
            if (StringUtils.isNotBlank((CharSequence)costAccountId)) {
                this.getModel().setValue("costaccount", (Object)Long.parseLong(costAccountId));
            }
            if ((costcenter = fsp.getCustomParam("costcenter")) != null && !"".equals(costcenter.toString())) {
                this.getModel().setValue("costcenter", costcenter);
            }
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"remark", "calctype", "costcenter", "entryentity", "bar_newentry", "bar_deleteentry", "attentryentity", "att_bar_newentry", "att_bar_deleteentry"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_BARITEM_SAVE});
        } else {
            switch (effectStatus) {
                case "A": {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"remark", "calctype", "costcenter", "entryentity", "bar_newentry", "bar_deleteentry", "attentryentity", "att_bar_newentry", "att_bar_deleteentry"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_BARITEM_SAVE, KEY_BARITEM_EFFECT, KEY_BARITEM_DELETE});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_BARITEM_COPY});
                    break;
                }
                case "E": {
                    if (isEnableEffect) {
                        this.setEnable(false);
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_BARITEM_COPY});
                    } else {
                        this.getView().setEnable(Boolean.valueOf(true), new String[]{"entryentity", "bar_newentry", "bar_deleteentry", "attentryentity", "att_bar_newentry", "att_bar_deleteentry"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_BARITEM_COPY});
                    }
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"billno", "remark", "calctype", "costcenter"});
                    this.getView().setVisible(Boolean.valueOf(!isEnableEffect), new String[]{KEY_BARITEM_SAVE});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_BARITEM_EFFECT, KEY_BARITEM_DELETE});
                    break;
                }
                case "F": {
                    this.setEnable(false);
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"remark", "calctype", "costcenter"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_BARITEM_EFFECT, KEY_BARITEM_DELETE, KEY_BARITEM_SAVE, KEY_BARITEM_COPY});
                    break;
                }
            }
        }
    }

    private void setEnable(Boolean enable) {
        this.getView().setEnable(enable, new String[]{"billno", "remark", "entryentity", "bar_newentry", "bar_deleteentry", "bar_configure", "attentryentity", "att_bar_newentry", "att_bar_deleteentry"});
    }

    private boolean isEnableEffectByOrg(Long orgId) {
        String appId = this.getView().getFormShowParameter().getAppId();
        return SysParamHelper.getEnableEffectByOrg((Long)orgId, (String)appId, (String)"aca_mfgplanfeerate");
    }

    private void innitVisible() {
        String calcType = (String)this.getModel().getValue("calctype");
        boolean isShowByResource = "R".equals(calcType);
        this.getView().setVisible(Boolean.valueOf(isShowByResource), new String[]{"resource", "resourcename", "unit"});
        this.getView().setVisible(Boolean.valueOf(!isShowByResource), new String[]{"material", "materialname", "expenseitem", "expenseitemname"});
        String effectStatus = (String)this.getModel().getValue("effectstatus");
        boolean isNotEffect = "A".equals(effectStatus);
        this.getView().setEnable(Boolean.valueOf(isNotEffect), new String[]{"costcenter"});
        BasedataEdit resource = (BasedataEdit)this.getView().getControl("resource");
        resource.setMustInput(isShowByResource);
        BasedataEdit material = (BasedataEdit)this.getView().getControl("material");
        material.setMustInput(!isShowByResource);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_BARITEM_EFFECT});
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private Set<Long> getSubElement(long elementId) {
        HashSet<Long> subElementIds = new HashSet<Long>();
        QFilter qfElement = new QFilter("element", "=", (Object)elementId);
        DynamicObjectCollection elementDetail = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement.id", (QFilter[])new QFilter[]{qfElement});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)elementDetail)) {
            return subElementIds;
        }
        for (DynamicObject ele : elementDetail) {
            subElementIds.add(ele.getLong("subelement.id"));
        }
        return subElementIds;
    }

    private QFilter getCostAccountFilter(Long orgId, String appId) {
        List orgUseCostAccountIds = CostAccountHelper.getOrgUseStdCostAccount((Long)orgId, (String)appId);
        QFilter costAccountFilter = new QFilter("id", "in", (Object)orgUseCostAccountIds.toArray());
        return costAccountFilter;
    }
}

