/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.realtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.aca.formplugin.base.BaseOrgAndCostAccountListPlugin;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class RealTimeParamListPlugin
extends BaseOrgAndCostAccountListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        e.setMainOrgQFilter(null);
        List<Object> orgCache = this.getOrgCache();
        if (orgCache == null) {
            qFilters.add(new QFilter("org", "=", (Object)0L));
        } else {
            long org = Long.parseLong(orgCache.get(0).toString());
            Set<Long> realTimeParamIds = RealTimeParamListPlugin.getRealTimeParamId(org);
            qFilters.add(new QFilter("id", "in", realTimeParamIds));
        }
    }

    public static Set<Long> getRealTimeParamId(Long calOrgId) {
        HashSet<Long> realTimeParamIds = new HashSet<Long>(2);
        HashMap<Long, Long> orgRealTimeParamMap = new HashMap<Long, Long>(16);
        HashMap orgRealTimeStatusMap = new HashMap(16);
        List superiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"10", (long)calOrgId);
        superiorOrgs.add(calOrgId);
        QFilter filter = new QFilter("org", "in", (Object)superiorOrgs);
        DynamicObjectCollection realTimeParamDc = QueryServiceHelper.query((String)"aca_realtimeparam", (String)"id,org,billstatus", (QFilter[])new QFilter[]{filter});
        realTimeParamDc.forEach(realTimeParam -> {
            orgRealTimeParamMap.put(realTimeParam.getLong("org"), realTimeParam.getLong("id"));
            orgRealTimeStatusMap.put(realTimeParam.getLong("org"), realTimeParam.getString("billstatus"));
        });
        if (CadEmptyUtils.isEmpty(orgRealTimeParamMap)) {
            return realTimeParamIds;
        }
        Long resultParamId = (Long)orgRealTimeParamMap.get(calOrgId);
        if (!CadEmptyUtils.isEmpty((Long)resultParamId)) {
            realTimeParamIds.add(resultParamId);
        }
        if (orgRealTimeStatusMap.get(calOrgId) != null && "C".equals(orgRealTimeStatusMap.get(calOrgId))) {
            return realTimeParamIds;
        }
        Long upOrgId = (Long)OrgUnitServiceHelper.getDirectSuperiorOrg((String)"10", Collections.singletonList(calOrgId)).values().iterator().next();
        if (!CadEmptyUtils.isEmpty((Long)upOrgId)) {
            resultParamId = RealTimeParamListPlugin.recursionGetParamId(upOrgId, orgRealTimeParamMap, 1);
        }
        realTimeParamIds.add(resultParamId);
        return realTimeParamIds;
    }

    private static long recursionGetParamId(Long orgId, Map<Long, Long> orgRealTimeParamMap, int count) {
        if (CadEmptyUtils.isEmpty((Long)orgId)) {
            return 0L;
        }
        if (count > 30) {
            return 0L;
        }
        Long paramId = orgRealTimeParamMap.get(orgId);
        if (CadEmptyUtils.isEmpty((Long)paramId)) {
            Map directMap = OrgUnitServiceHelper.getDirectSuperiorOrg((String)"10", Collections.singletonList(orgId));
            if (CadEmptyUtils.isEmpty((Map)directMap)) {
                return 0L;
            }
            long upOrgId = (Long)directMap.values().iterator().next();
            return RealTimeParamListPlugin.recursionGetParamId(upOrgId, orgRealTimeParamMap, count++);
        }
        return paramId;
    }
}

