/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class AcaUtil
extends AbstractFormPlugin {
    public static void openSyncCostTypeView(IFormView view, String entityName, ListSelectedRowCollection selectedRows) {
        if (CadEmptyUtils.isEmpty((ListSelectedRowCollection)selectedRows)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u540c\u6b65\u6210\u672c\u7c7b\u578b\u7684\u6570\u636e\u3002", (String)"AcaUtil_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("cad_synccosttype");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("entityname", (Object)entityName);
        fsp.setCustomParam("costtype", Arrays.asList(selectedRows.getPrimaryKeyValues()));
        view.showForm(fsp);
    }

    public static void showForm(IFormView view, String entityName, String costtypeId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(entityName);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("costtype", (Object)costtypeId);
        view.showForm(formShowParameter);
    }

    public static Set<Long> getSubElemnetSupCal(Long[] subElementIds) {
        QFilter qfSubElement = new QFilter("id", "in", (Object)subElementIds);
        QFilter qfSupCal = new QFilter("supmaterielcount", "=", (Object)true);
        DynamicObjectCollection subEelment = QueryServiceHelper.query((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{qfSubElement, qfSupCal});
        HashSet<Long> subIds = new HashSet<Long>();
        subEelment.forEach(p -> subIds.add(p.getLong("id")));
        return subIds;
    }

    public static Map<Long, Long> getDefaulSupCalInfo() {
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        QFilter qfType = new QFilter("type", "=", (Object)"001");
        QFilter qfEnable = new QFilter("enable", "=", (Object)true);
        QFilter qfStatu = new QFilter("status", "=", (Object)"C");
        DynamicObjectCollection dycElement = QueryServiceHelper.query((String)"cad_element", (String)"id,elementtype", (QFilter[])new QFilter[]{qfType, qfEnable, qfStatu});
        HashSet<Long> elementType = new HashSet<Long>();
        HashSet<Long> element = new HashSet<Long>();
        for (DynamicObject ele : dycElement) {
            elementType.add(ele.getLong("elementtype"));
            element.add(ele.getLong("id"));
        }
        QFilter qfElement = new QFilter("element", "in", (Object)element.toArray());
        QFilter qfElementType = new QFilter("elementtype", "in", (Object)elementType.toArray());
        DynamicObjectCollection detail = QueryServiceHelper.query((String)"cad_elementdetail", (String)"element,subelement", (QFilter[])new QFilter[]{qfElement, qfElementType});
        HashSet subElementIds = new HashSet();
        detail.forEach(p -> subElementIds.add(p.getLong("subelement")));
        QFilter qfSubElement = new QFilter("id", "in", (Object)subElementIds.toArray());
        QFilter qfDefault = new QFilter("defaultvalue", "=", (Object)true);
        DynamicObjectCollection dycSubElement = QueryServiceHelper.query((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{qfSubElement, qfDefault});
        HashSet subEle = new HashSet();
        dycSubElement.forEach(p -> subEle.add(p.getLong("id")));
        for (DynamicObject de : detail) {
            Long sub = de.getLong("subelement");
            if (!subEle.contains(sub)) continue;
            result.put(sub, de.getLong("element"));
        }
        QFilter qfSupCal = new QFilter("supmaterielcount", "=", (Object)true);
        dycSubElement = QueryServiceHelper.query((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{qfSupCal});
        HashSet subElement = new HashSet();
        dycSubElement.forEach(p -> subElement.add(p.getLong("id")));
        qfSubElement = new QFilter("subelement", "in", (Object)subElement.toArray());
        detail = QueryServiceHelper.query((String)"cad_elementdetail", (String)"element,subelement", (QFilter[])new QFilter[]{qfSubElement});
        for (DynamicObject de : detail) {
            result.put(de.getLong("subelement"), de.getLong("element"));
        }
        qfElement = new QFilter("element", "in", result.values());
        qfSubElement = new QFilter("subelement", "in", result.keySet());
        detail = QueryServiceHelper.query((String)"cad_elementdetail", (String)"element,subelement", (QFilter[])new QFilter[]{qfElement, qfSubElement}, (String)"subelement.name,element.name");
        result = new HashMap();
        for (DynamicObject de : detail) {
            result.put(de.getLong("subelement"), de.getLong("element"));
        }
        return result;
    }

    public static Map<Long, BigDecimal> getRateInfo(Long costTypeId) {
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>();
        QFilter qfCostType = new QFilter("costtype", "=", (Object)costTypeId);
        DynamicObjectCollection stdRate = QueryServiceHelper.query((String)"cad_stdratesetting", (String)"entryentity.subelement,entryentity.stdrate", (QFilter[])new QFilter[]{qfCostType});
        for (DynamicObject rate : stdRate) {
            result.put(rate.getLong("entryentity.subelement"), rate.getBigDecimal("entryentity.stdrate"));
        }
        return result;
    }

    public static void ctrlVerAndAuxpty(IFormView view) {
        DynamicObject material = (DynamicObject)view.getModel().getValue("material");
        if (material == null) {
            view.setEnable(Boolean.valueOf(false), new String[]{"matversion", "auxpty"});
            return;
        }
        view.setEnable(Boolean.valueOf(true), new String[]{"matversion", "auxpty"});
        Boolean isenablematerialversion = material.getBoolean("isenablematerialversion");
        Boolean isUseAuxpty = material.getBoolean("isuseauxpty");
        view.setVisible(isenablematerialversion, new String[]{"matversion"});
        view.setVisible(isUseAuxpty, new String[]{"auxpty"});
    }

    public static List<ComboItem> getAccountOrg() {
        QFilter qfId;
        DynamicObjectCollection org;
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>();
        String orgId = RequestContext.get().getOrgId() + "";
        List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId())).getHasPermOrgs();
        List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
        if (CadEmptyUtils.isEmpty((List)permOrgIds) && CadEmptyUtils.isEmpty((List)orgIds)) {
            orgIds = OrgUnitServiceHelper.getAllOrg((String)"10");
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(org = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{qfId = new QFilter("id", "in", (Object)orgIds)})))) {
            for (DynamicObject acctOrg : org) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(acctOrg.getString("name")));
                item.setValue(acctOrg.getString("id"));
                if (orgItems.contains(item)) continue;
                if (orgId.equals(item.getValue())) {
                    orgItems.add(0, item);
                    continue;
                }
                orgItems.add(item);
            }
        }
        return orgItems;
    }

    public static List<ComboItem> getCostCenterByAccoutOrg(String orgId, Boolean isProduct) {
        Object[] costCenter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!StringUtils.isEmpty((CharSequence)orgId)) {
            filters.add(new QFilter("accountorg", "=", (Object)Long.valueOf(orgId)));
        }
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)true));
        if (isProduct.booleanValue()) {
            filters.add(new QFilter("orgduty.number", "=", (Object)"4"));
        }
        if (CadEmptyUtils.isEmpty((Object[])(costCenter = BusinessDataServiceHelper.load((String)"bos_costcenter", (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]))))) {
            return null;
        }
        ArrayList<ComboItem> centerItems = new ArrayList<ComboItem>();
        for (Object center : costCenter) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(center.getString("name")));
            item.setValue(center.getString("id"));
            if (centerItems.contains(item)) continue;
            centerItems.add(item);
        }
        return centerItems;
    }

    public static void setDefaultFixedAndVisibleColumes(List<IListColumn> listColumns, List<String> toFixedColList, List<String> toVisibleColList) {
        listColumns.forEach(e -> {
            String fieldKey = e.getListFieldKey();
            if (toFixedColList != null && toFixedColList.contains(fieldKey)) {
                e.setFixed(true);
            }
            if (toVisibleColList != null && toVisibleColList.contains(fieldKey)) {
                e.setVisible(0);
            }
        });
    }
}

