/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.wipadjust;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.CostaccountHelper;
import kd.macc.aca.common.constants.WipAdjustConstants;
import kd.macc.aca.common.constants.WipAdjustSubItem;
import kd.macc.aca.common.helper.PermItemCheckHelper;
import kd.macc.aca.common.helper.WipAdjustHelper;
import kd.macc.cad.common.helper.CalcKeycolHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.ElementHelper;
import kd.macc.cad.common.helper.FillBatchHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class WipAdjustBillEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
SelectRowsEventListener {
    private static final String CONFIRMBACK_ADJUSTZERO = "adjust_zero";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        SubEntryGrid subentryGrid = (SubEntryGrid)this.getView().getControl("subentryentity");
        subentryGrid.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{"bar_new"});
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarap1", "tbmain"});
        BasedataEdit costCenter = (BasedataEdit)this.getControl("costcenter");
        costCenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String org = this.getPageCache().get("org");
            DynamicObject orgObject = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null && orgObject == null) {
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Long acctOrgId = org == null ? orgObject.getLong("id") : Long.parseLong(org);
            QFilter qf = new QFilter("accountorg", "=", (Object)acctOrgId);
            qf.and(new QFilter("orgduty.number", "=", (Object)"4"));
            listShowParameter.getListFilterParameter().getQFilters().add(qf);
        });
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
        manuOrg.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                String org = WipAdjustBillEditPlugin.this.getPageCache().get("org");
                DynamicObject orgObject = WipAdjustBillEditPlugin.this.getModel().getDataEntity().getDynamicObject("org");
                if (org == null && orgObject == null) {
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                Long acctOrgId = org == null ? orgObject.getLong("id") : Long.parseLong(org);
                List manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)acctOrgId, (String)WipAdjustBillEditPlugin.this.getBillEntityId(), (String)WipAdjustBillEditPlugin.this.getView().getFormShowParameter().getAppId());
                QFilter orgfilter = new QFilter("id", "in", (Object)manuorgList);
                listShowParameter.getListFilterParameter().getQFilters().add(orgfilter);
            }
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            String org = this.getPageCache().get("org");
            DynamicObject orgObject = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null && orgObject == null) {
                evt.setCancel(true);
                return;
            }
            Long acctOrgId = org == null ? orgObject.getLong("id") : Long.parseLong(org);
            qFilters.add(StartCostHelper.getEndInitCostAccountIdsFilter((Long)acctOrgId, (String)this.getView().getFormShowParameter().getAppId()));
        });
        BasedataEdit costObject = (BasedataEdit)this.getControl("costobject");
        costObject.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                DynamicObject manuorg;
                DynamicObject costcenter = WipAdjustBillEditPlugin.this.getModel().getDataEntity().getDynamicObject("costcenter");
                if (costcenter == null) {
                    WipAdjustBillEditPlugin.this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6210\u672c\u4e2d\u5fc3\u201d\u3002", (String)"WipAdjustBillEditPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObject costaccount = WipAdjustBillEditPlugin.this.getModel().getDataEntity().getDynamicObject("costaccount");
                if (costaccount == null) {
                    WipAdjustBillEditPlugin.this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"WipAdjustBillEditPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                String org = WipAdjustBillEditPlugin.this.getPageCache().get("org");
                Long acctOrgId = org == null ? WipAdjustBillEditPlugin.this.getModel().getDataEntity().getDynamicObject("org").getLong("id") : Long.parseLong(org);
                QFilter costCenterFilter = new QFilter("org", "=", (Object)acctOrgId);
                costCenterFilter.and(new QFilter("costcenter", "=", costcenter.getPkValue()));
                costCenterFilter.and(new QFilter("producttype", "=", (Object)"C"));
                costCenterFilter.and(new QFilter("billstatus", "=", (Object)"C"));
                if (OrgHelper.isOrgEnableMultiFactory((Long)acctOrgId) && (manuorg = WipAdjustBillEditPlugin.this.getModel().getDataEntity().getDynamicObject("manuorg")) != null) {
                    costCenterFilter.and(new QFilter("manuorg", "=", manuorg.getPkValue()));
                }
                listShowParameter.getListFilterParameter().getQFilters().add(costCenterFilter);
            }
        });
        BasedataEdit subElementCtrl = (BasedataEdit)this.getControl("subelement");
        subElementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = showParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
            if (entries != null && entries.size() > 0) {
                int index = this.getModel().getEntryCurrentRowIndex("entryentity");
                DynamicObject obj = (DynamicObject)entries.get(index);
                HashSet<Long> subElementIdSet = new HashSet<Long>(16);
                for (DynamicObject entrie : entries) {
                    if (entrie.getPkValue() == obj.getPkValue()) continue;
                    subElementIdSet.add((Long)((DynamicObject)entrie.get("subelement")).getPkValue());
                }
                qList.add(new QFilter("id", "not in", subElementIdSet));
            }
        });
        BasedataEdit sSubElementCtrl = (BasedataEdit)this.getControl("ssubelement");
        sSubElementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = showParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObjectCollection entries = this.getModel().getEntryEntity("subitemdetail");
            if (entries != null && !entries.isEmpty()) {
                int index = this.getModel().getEntryCurrentRowIndex("subitemdetail");
                HashSet<Long> subElementIdSet = new HashSet<Long>(16);
                int i = 0;
                for (DynamicObject entrie : entries) {
                    if (i == index) continue;
                    subElementIdSet.add((Long)((DynamicObject)entrie.get("ssubelement")).getPkValue());
                    ++i;
                }
                qList.add(new QFilter("id", "not in", subElementIdSet));
            }
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        String adjustType = (String)formShowParameter.getCustomParam("adjustType");
        String billTitle = ResManager.loadKDString((String)"\u671f\u672b\u5728\u4ea7\u54c1\u6210\u672c\u8c03\u6574\u5355", (String)"WipAdjustBillEditPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        if ("START".equalsIgnoreCase(adjustType)) {
            billTitle = ResManager.loadKDString((String)"\u671f\u521d\u5728\u4ea7\u54c1\u6210\u672c\u8c03\u6574\u5355", (String)"WipAdjustBillEditPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        }
        formShowParameter.setCaption(ResManager.loadKDString((String)billTitle, (String)"AcaAllocEnum_1", (String)"WipAdjustBillEditPlugin_4", (Object[])new Object[0]));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String acctOrg = (String)formShowParameter.getCustomParam("org");
        if (acctOrg == null) {
            return;
        }
        String costCenter = (String)formShowParameter.getCustomParam("costcenter");
        String manuOrg = (String)formShowParameter.getCustomParam("manuorg");
        String adjustType = (String)formShowParameter.getCustomParam("adjustType");
        this.getModel().setValue("adjusttype", (Object)adjustType);
        this.getView().setEnable(Boolean.FALSE, new String[]{"org"});
        this.getModel().setValue("org", (Object)acctOrg);
        this.getPageCache().put("org", acctOrg);
        boolean isMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.valueOf(acctOrg));
        if (!StringUtils.isEmpty((Object)manuOrg) && !"0".equals(manuOrg)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"manuorg"});
            this.getModel().setValue("manuorg", (Object)manuOrg);
        }
        if ("0".equals(manuOrg)) {
            this.getModel().setValue("manuorg", null);
        }
        if (!isMultiFactory) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"manuorg"});
        }
        if (!StringUtils.isEmpty((Object)costCenter)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"costcenter"});
            this.getModel().setValue("costcenter", (Object)costCenter);
        }
        this.setCostAccount(Long.valueOf(acctOrg));
        this.setViewSubItem();
        this.getModel().setDataChanged(false);
    }

    private void setViewSubItem() {
        boolean isViewSubItem = false;
        Long costaccountId = this.getModel().getDataEntity().getLong("costaccount.id");
        if (!CadEmptyUtils.isEmpty((Long)costaccountId)) {
            isViewSubItem = CostaccountHelper.getCostElementByCostAccount((long)costaccountId);
        }
        if (isViewSubItem) {
            this.showSubItemView(0);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"subitementryadvconap"});
        }
        String billstatus = this.getView().getModel().getDataEntity().getString("billstatus");
        this.getView().setVisible(Boolean.valueOf(isViewSubItem && !"A".equals(billstatus)), new String[]{"subitemadvconap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject costObject = (DynamicObject)this.getModel().getValue("costobject");
        if (costObject == null) {
            return;
        }
        this.setAfterAdjustQty();
        this.setEntryentity();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!"A".equals(billStatus)) {
            return;
        }
        this.setEnableCostObjectRel(costObject);
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "newentry": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                DynamicObject costObject = (DynamicObject)this.getModel().getValue("costobject");
                if (costObject == null) break;
                boolean isOutSourType = costObject.getBoolean("isoutsource");
                this.getView().setEnable(Boolean.valueOf(isOutSourType), rowIndex, new String[]{"outsourcetype"});
                break;
            }
            case "deleteentry": {
                int index = this.getModel().getEntryCurrentRowIndex("entryentity");
                String dataType = (String)this.getModel().getValue("datatype", index);
                if (!"sysImport".equals(dataType)) break;
                args.setCancel(true);
                String msg = String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u7cfb\u7edf\u643a\u5e26\u7684\u6570\u636e\u884c\u3002", (String)"WipAdjustBillEditPlugin_5", (String)"macc-aca-formplugin", (Object[])new Object[0]), new Object[0]);
                this.getView().showErrorNotification(msg);
                break;
            }
            case "subdeleteentry": {
                int subIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
                DynamicObjectCollection subEntrys = this.getModel().getEntryEntity("subentryentity");
                DynamicObject subObj = (DynamicObject)subEntrys.get(subIndex);
                String subDataType = subObj.getString("subdatatype");
                if (!"sysImport".equals(subDataType)) break;
                args.setCancel(true);
                String msg = String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u7cfb\u7edf\u643a\u5e26\u7684\u6570\u636e\u884c\u3002", (String)"WipAdjustBillEditPlugin_5", (String)"macc-aca-formplugin", (Object[])new Object[0]), new Object[0]);
                this.getView().showErrorNotification(msg);
                break;
            }
            case "subnewentry": {
                int indexNew = this.getModel().getEntryCurrentRowIndex("entryentity");
                DynamicObject subElement = (DynamicObject)this.getModel().getValue("subelement", indexNew);
                if (this.getModel().getValue("subelement", indexNew) == null) {
                    args.setCancel(true);
                    String msg = String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u65b0\u589e\u5b50\u9879\u7269\u6599\uff0c\u5bf9\u5e94\u7684\u6210\u672c\u4fe1\u606f\u4e2d\u6210\u672c\u5b50\u8981\u7d20\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WipAdjustBillEditPlugin_6", (String)"macc-aca-formplugin", (Object[])new Object[0]), new Object[0]);
                    this.getView().showErrorNotification(msg);
                    return;
                }
                if (WipAdjustConstants.MAT_SUBELE_TYPES.contains(subElement.getString("type"))) break;
                String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u4fe1\u606f\u00b7\u6210\u672c\u5b50\u8981\u7d20\u4e0d\u662f\u7269\u6599\u6216\u8005\u7269\u6599\u8d39\u7528\u5c5e\u6027\uff0c\u4e0d\u80fd\u7f16\u8f91\u5b50\u7269\u6599\u4fe1\u606f\u3002", (String)"WipAdjustBillEditPlugin_7", (String)"macc-aca-formplugin", (Object[])new Object[0]), new Object[0]);
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
                break;
            }
            case "subitemdeleteentry": {
                int ssubIndex = this.getModel().getEntryCurrentRowIndex("subitemdetail");
                DynamicObjectCollection ssubEntrys = this.getModel().getEntryEntity("subitemdetail");
                DynamicObject ssubObj = (DynamicObject)ssubEntrys.get(ssubIndex);
                String sDataType = ssubObj.getString("sdatatype");
                if (!"sysImport".equals(sDataType)) break;
                args.setCancel(true);
                String msg = String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u7cfb\u7edf\u643a\u5e26\u7684\u6570\u636e\u884c\u3002", (String)"WipAdjustBillEditPlugin_5", (String)"macc-aca-formplugin", (Object[])new Object[0]), new Object[0]);
                this.getView().showErrorNotification(msg);
                break;
            }
            case "adjust_zero": {
                args.setCancel(true);
                this.adjustZeroOper();
                break;
            }
        }
    }

    private void adjustZeroOper() {
        String billstatus = this.getModel().getDataEntity().getString("billstatus");
        DynamicObject costobjectDyn = this.getModel().getDataEntity().getDynamicObject("costobject");
        if ("B".equals(billstatus) || "C".equals(billstatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u6570\u636e\u624d\u5141\u8bb8\u8c03\u96f6\u3002", (String)"WipAdjustBillEditPlugin_11", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return;
        }
        if (costobjectDyn == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u6210\u672c\u5bf9\u8c61\u3002", (String)"WipAdjustBillEditPlugin_12", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dyn = this.getModel().getDataEntity(false);
        dyn.set("adjustqty", (Object)dyn.getBigDecimal("wipqty").negate());
        dyn.set("afteradjustqty", (Object)BigDecimal.ZERO);
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : entryentity) {
            DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
            if (subentryentity != null && !subentryentity.isEmpty()) {
                for (DynamicObject subentry : subentryentity) {
                    String json = subentry.getString("subitemjson_tag");
                    List subItems = new ArrayList(10);
                    if (!StringUtils.isEmpty((Object)json)) {
                        subItems = JSON.parseArray((String)json, WipAdjustSubItem.class);
                    }
                    BigDecimal submatamt = BigDecimalUtil.getOrZero((Object)subentry.getBigDecimal("submatamt"));
                    BigDecimal submatqty = BigDecimalUtil.getOrZero((Object)subentry.getBigDecimal("submatqty"));
                    subentry.set("submatadjamt", (Object)submatamt.negate());
                    subentry.set("aftersubmatadjamt", (Object)submatamt.add(submatamt.negate()));
                    subentry.set("submatadjqty", (Object)submatqty.negate());
                    subentry.set("aftersubmatadjqty", (Object)BigDecimal.ZERO);
                    if (!CadEmptyUtils.isEmpty(subItems)) {
                        subItems.forEach(subitem -> {
                            BigDecimal swipamt = subitem.getSwipamt();
                            subitem.setSadjustamt(swipamt.negate());
                            subitem.setSafteradjustamt(swipamt.add(swipamt.negate()));
                        });
                    }
                    subentry.set("subitemjson_tag", (Object)JSONObject.toJSONString(subItems));
                }
            }
            BigDecimal wipAmt = BigDecimalUtil.getOrZero((Object)entry.getBigDecimal("wipamt"));
            entry.set("adjustamt", (Object)wipAmt.negate());
            entry.set("afteradjustamt", (Object)wipAmt.add(wipAmt.negate()));
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"WipAdjustBillEditPlugin_13", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        this.getView().updateView("entryentity");
        this.getView().updateView("subentryentity");
        this.getView().updateView("adjustqty");
        this.getView().updateView("afteradjustqty");
        int index = this.getModel().getEntryCurrentRowIndex("subentryentity");
        if (index >= 0) {
            this.showSubItemView(index);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        super.afterDoOperation(evt);
        switch (operateKey = evt.getOperateKey()) {
            case "subnewentry": {
                int index = this.getModel().getEntryCurrentRowIndex("entryentity");
                int index2 = this.getModel().getEntryCurrentRowIndex("subentryentity");
                this.getModel().setValue("subsubelement", this.getModel().getValue("subelement", index), index2);
                break;
            }
            case "batchfillentry": {
                FillBatchHelper.batchFill((IFormView)this.getView(), (String)"entryentity", (String[])new String[]{"adjustamt"});
                break;
            }
            case "subbatchfillentry": {
                FillBatchHelper.batchFill((IFormView)this.getView(), (String)"subentryentity", (String[])new String[]{"submatadjqty", "submatadjamt"});
                break;
            }
            case "unaudit": {
                DynamicObject costObject = (DynamicObject)this.getModel().getValue("costobject");
                this.setEnableCostObjectRel(costObject);
                break;
            }
            case "save": {
                this.setEnableCostObjectRel((DynamicObject)this.getModel().getValue("costobject"));
                this.getView().invokeOperation("refresh", OperateOption.create());
                break;
            }
            case "submit": {
                if (!evt.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh", OperateOption.create());
                break;
            }
            case "unsubmit": {
                this.getView().invokeOperation("refresh", OperateOption.create());
                break;
            }
            case "adjust_zero": {
                this.getView().invokeOperation("refresh", OperateOption.create());
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        if (!(evt.getSource() instanceof EntryGrid)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if ("entryentity".equals(entryGrid.getEntryKey())) {
            DynamicObject costObject = (DynamicObject)this.getModel().getValue("costobject");
            if (costObject != null) {
                Long orgId = this.getModel().getDataEntity().getLong("org.id");
                Long costaccountId = this.getModel().getDataEntity().getLong("costaccount.id");
                Map keycolFieldMap = CalcKeycolHelper.getWipAdjustKeyColFieldMap((Long)orgId, (Long)costaccountId, (boolean)false);
                DynamicObjectCollection subEntrys = this.getModel().getEntryEntity("subentryentity");
                for (int index = 0; index < subEntrys.size(); ++index) {
                    DynamicObject obj = (DynamicObject)subEntrys.get(index);
                    if ("sysImport".equals(obj.getString("subdatatype"))) {
                        this.getView().setEnable(Boolean.FALSE, index, new String[]{"submaterial"});
                        this.getView().setEnable(Boolean.FALSE, index, new String[]{"submatqty"});
                        if (obj.getDynamicObject("submaterial") == null) {
                            this.getView().setEnable(Boolean.FALSE, index, new String[]{"submatadjqty"});
                        }
                        this.getView().setEnable(Boolean.FALSE, index, new String[]{"version"});
                        this.getView().setEnable(Boolean.FALSE, index, new String[]{"auxpty"});
                        for (Tuple2 tuple : keycolFieldMap.values()) {
                            this.getView().setEnable(Boolean.FALSE, index, new String[]{(String)tuple.t1});
                        }
                    } else {
                        this.getView().setEnable(Boolean.TRUE, index, new String[]{"submatadjqty"});
                        this.getView().setEnable(Boolean.TRUE, index, new String[]{"submaterial"});
                        this.getView().setEnable(Boolean.TRUE, index, new String[]{"submatqty"});
                        this.getView().setEnable(Boolean.TRUE, index, new String[]{"version"});
                        this.getView().setEnable(Boolean.TRUE, index, new String[]{"auxpty"});
                        for (Tuple2 tuple : keycolFieldMap.values()) {
                            this.getView().setEnable(Boolean.TRUE, index, new String[]{(String)tuple.t1});
                        }
                    }
                    this.setAfterSubMatAdjAmt(index);
                    this.setAfterSubMatAdjQty(index);
                }
                this.showSubItemView(0);
                this.getView().updateView("subentryentity");
            }
        } else if ("subentryentity".equals(entryGrid.getEntryKey())) {
            this.showSubItemView(evt.getRow());
        }
    }

    private void showSubItemView(int selectRow) {
        Long costaccountId = this.getModel().getDataEntity().getLong("costaccount.id");
        if (CadEmptyUtils.isEmpty((Long)costaccountId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"subitementryadvconap"});
            return;
        }
        boolean isViewSubItem = CostaccountHelper.getCostElementByCostAccount((long)costaccountId);
        if (!isViewSubItem) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"subitementryadvconap"});
            return;
        }
        DynamicObjectCollection subEntrys = this.getModel().getEntryEntity("subentryentity");
        if (subEntrys == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"subitementryadvconap"});
            return;
        }
        if (subEntrys.size() <= selectRow) {
            this.enableSubItemView();
            return;
        }
        this.getPageCache().put("subIndex", String.valueOf(selectRow));
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"subitementryadvconap"});
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"subitemdel", "subitemadd"});
        DynamicObjectCollection subitemdetail = this.getModel().getDataEntity(true).getDynamicObjectCollection("subitemdetail");
        subitemdetail.clear();
        DynamicObject selectdyn = (DynamicObject)subEntrys.get(selectRow);
        String json = selectdyn.getString("subitemjson_tag");
        List subitems = null;
        if (!StringUtils.isEmpty((Object)json)) {
            subitems = JSON.parseArray((String)json, WipAdjustSubItem.class);
            subitemdetail.beginInit();
            int i = 0;
            for (WipAdjustSubItem subitem : subitems) {
                DynamicObject dyn = subitemdetail.addNew();
                dyn.set("selement_id", (Object)subitem.getSelement());
                dyn.set("seq", (Object)i++);
                dyn.set("ssubelement_id", (Object)subitem.getSsubelement());
                dyn.set("swipamt", (Object)subitem.getSwipamt());
                dyn.set("sadjustamt", (Object)subitem.getSadjustamt());
                dyn.set("safteradjustamt", (Object)subitem.getSafteradjustamt());
                dyn.set("sdatatype", (Object)subitem.getDatatype());
            }
            subitemdetail.endInit();
            BusinessDataServiceHelper.loadRefence((Object[])subitemdetail.toArray((Object[])new DynamicObject[0]), (IDataEntityType)subitemdetail.getDynamicObjectType());
        }
        this.getView().updateView("subitemdetail");
    }

    private void enableSubItemView() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"subitemdel", "subitemadd"});
        DynamicObjectCollection subitemdetail = this.getModel().getDataEntity(true).getDynamicObjectCollection("subitemdetail");
        subitemdetail.clear();
        this.getView().updateView("subitemdetail");
    }

    private void updateSubItemInfo() {
        int subIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
        if (this.getPageCache().get("subIndex") != null) {
            subIndex = Integer.parseInt(this.getPageCache().get("subIndex"));
        }
        DynamicObjectCollection subEntrys = this.getModel().getEntryEntity("subentryentity");
        DynamicObject subObj = (DynamicObject)subEntrys.get(subIndex);
        BigDecimal totalAmt = BigDecimal.ZERO;
        ArrayList<WipAdjustSubItem> subItems = new ArrayList<WipAdjustSubItem>(10);
        DynamicObjectCollection subitemdetail = this.getModel().getEntryEntity("subitemdetail");
        for (DynamicObject dyn : subitemdetail) {
            WipAdjustSubItem subItem = new WipAdjustSubItem();
            subItem.setDatatype(dyn.getString("sdatatype"));
            subItem.setSelement(Long.valueOf(dyn.getLong("selement.id")));
            subItem.setSsubelement(Long.valueOf(dyn.getLong("ssubelement.id")));
            subItem.setSwipamt(dyn.getBigDecimal("swipamt"));
            subItem.setSadjustamt(dyn.getBigDecimal("sadjustamt"));
            subItem.calcAfterAdjustAmt();
            totalAmt = totalAmt.add(subItem.getSadjustamt());
            subItems.add(subItem);
        }
        subEntrys.beginInit();
        subObj.set("subitemjson_tag", (Object)JSONObject.toJSONString(subItems));
        subObj.set("submatadjamt", (Object)totalAmt);
        BigDecimal wipAmt = BigDecimalUtil.getOrZero((Object)subObj.getBigDecimal("submatamt"));
        subObj.set("aftersubmatadjamt", (Object)totalAmt.add(wipAmt));
        this.setAfterSubMatAdjAmt(subIndex);
        subEntrys.endInit();
        this.getView().updateView("subentryentity");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "costcenter": {
                this.getModel().setValue("costobject", null);
                break;
            }
            case "manuorg": {
                this.getModel().setValue("costobject", null);
                break;
            }
            case "costaccount": {
                this.getModel().setValue("costobject", null);
                DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
                Long costAccountId = 0L;
                if (costAccount != null) {
                    costAccountId = costAccount.getLong("id");
                }
                this.setPeriodAndBookdate(costAccountId);
                this.setViewSubItem();
                this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((DynamicObject)costAccount));
                break;
            }
            case "costobject": {
                DynamicObject costObject = (DynamicObject)this.getModel().getValue("costobject");
                if (!this.setCostObjectRel(costObject)) break;
                this.setEnableCostObjectRel(costObject);
                this.showSubItemView(0);
                break;
            }
            case "submaterial": {
                this.setSubMatInfo(rowIndex);
                break;
            }
            case "adjustqty": {
                this.setAfterAdjustQty();
                break;
            }
            case "wipqty": {
                this.setAfterAdjustQty();
                break;
            }
            case "adjustamt": {
                this.setAfterAdjustAmt(rowIndex);
                this.updateSubMatAmt(rowIndex, this.getCurrencyPrecision());
                break;
            }
            case "wipamt": {
                this.setAfterAdjustAmt(rowIndex);
                break;
            }
            case "submatadjamt": {
                this.setAfterSubMatAdjAmt(rowIndex);
                break;
            }
            case "submatamt": {
                this.setAfterSubMatAdjAmt(rowIndex);
                break;
            }
            case "submatadjqty": {
                this.setAfterSubMatAdjQty(rowIndex);
                break;
            }
            case "submatqty": {
                this.setAfterSubMatAdjQty(rowIndex);
                break;
            }
            case "subelement": {
                ElementHelper.setElement((PropertyChangedArgs)e, (IFormView)this.getView());
                this.getModel().deleteEntryData("subentryentity");
                break;
            }
            case "ssubelement": {
                DynamicObject subEle = (DynamicObject)this.getView().getModel().getValue("ssubelement", rowIndex);
                if (subEle == null) {
                    return;
                }
                long subElementId = subEle.getLong("id");
                QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
                DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
                if (dySubElement != null) {
                    this.getView().getModel().setValue("selement", (Object)dySubElement.getLong("element"), rowIndex);
                }
                this.updateSubItemInfo();
                break;
            }
            case "sadjustamt": {
                this.setAfterSubItemAdjAmt(rowIndex);
                this.updateSubItemInfo();
                break;
            }
        }
    }

    private void updateSubMatAmt(int rowIndex, int pricise) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        DynamicObject entryObj = (DynamicObject)entrys.get(rowIndex);
        if (entryObj == null) {
            return;
        }
        DynamicObjectCollection subentryentity = entryObj.getDynamicObjectCollection("subentryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)subentryentity)) {
            return;
        }
        BigDecimal adjamt = entryObj.getBigDecimal("adjustamt");
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal tatalInAmt = BigDecimal.ZERO;
        boolean isHasAdj = false;
        for (Object dyn : subentryentity) {
            BigDecimal subadjamt = BigDecimalUtil.getOrZero((Object)dyn.getBigDecimal("submatadjamt"));
            BigDecimal subinamt = BigDecimalUtil.getOrZero((Object)dyn.getBigDecimal("submatamt"));
            tatalInAmt = tatalInAmt.add(subinamt);
            totalAmt = totalAmt.add(subadjamt);
            if (subadjamt.compareTo(BigDecimal.ZERO) == 0) continue;
            isHasAdj = true;
        }
        if (adjamt.compareTo(totalAmt) == 0) {
            return;
        }
        totalAmt = BigDecimal.ZERO;
        DynamicObject maxDyn = null;
        for (DynamicObject dyn : subentryentity) {
            BigDecimal subadjamt = BigDecimalUtil.getOrZero((Object)dyn.getBigDecimal(isHasAdj ? "submatadjamt" : "submatamt"));
            totalAmt = totalAmt.add(subadjamt);
            if (maxDyn != null && subadjamt.compareTo(BigDecimalUtil.getOrZero((Object)maxDyn.getBigDecimal(isHasAdj ? "submatadjamt" : "submatamt"))) <= 0) continue;
            maxDyn = dyn;
        }
        if (tatalInAmt.compareTo(adjamt.negate()) == 0) {
            for (DynamicObject dyn : subentryentity) {
                dyn.set("submatadjamt", (Object)BigDecimalUtil.getOrZero((Object)dyn.getBigDecimal("submatamt")).negate());
            }
            this.getView().updateView("entryentity");
            return;
        }
        HashMap dynRadioMap = Maps.newHashMapWithExpectedSize((int)10);
        if (totalAmt.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal radio = adjamt.divide(new BigDecimal(subentryentity.size()), 10, RoundingMode.HALF_UP);
            for (DynamicObject dyn : subentryentity) {
                dynRadioMap.put(dyn, radio);
            }
        } else {
            for (DynamicObject dyn : subentryentity) {
                BigDecimal subadjamt = BigDecimalUtil.getOrZero((Object)dyn.getBigDecimal(isHasAdj ? "submatadjamt" : "submatamt"));
                dynRadioMap.put(dyn, subadjamt.divide(totalAmt, 10, RoundingMode.HALF_UP));
            }
        }
        BigDecimal diffAmt = adjamt;
        for (DynamicObject dyn : subentryentity) {
            BigDecimal radio = (BigDecimal)dynRadioMap.get(dyn);
            if (radio == null) continue;
            BigDecimal subAdjAmt = adjamt.multiply(radio).setScale(pricise, RoundingMode.HALF_UP);
            dyn.set("submatadjamt", (Object)subAdjAmt);
            diffAmt = diffAmt.subtract(subAdjAmt);
        }
        if (diffAmt.compareTo(BigDecimal.ZERO) != 0 && maxDyn != null) {
            maxDyn.set("submatadjamt", (Object)maxDyn.getBigDecimal("submatadjamt").add(diffAmt));
        }
        this.getView().updateView("entryentity");
    }

    private void setSubMatInfo(int rowIndex) {
        DynamicObject submaterial = (DynamicObject)this.getModel().getValue("submaterial");
        if (submaterial != null) {
            this.getModel().setValue("baseunit", (Object)submaterial.getLong("baseunit.id"), rowIndex);
        }
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.getModel().setValue("subsubelement", this.getModel().getValue("subelement", index), rowIndex);
        this.setVersionAndAuxpty(submaterial, rowIndex);
    }

    private void setVersionAndAuxpty(DynamicObject submaterial, int rowIndex) {
        Boolean isenablematerialversion = false;
        Boolean isuseauxptyFlag = false;
        if (submaterial != null) {
            isenablematerialversion = submaterial.getBoolean("isenablematerialversion");
            isuseauxptyFlag = submaterial.getBoolean("isuseauxpty");
        }
        this.getView().setEnable(isenablematerialversion, rowIndex, new String[]{"version"});
        this.getView().setEnable(isuseauxptyFlag, rowIndex, new String[]{"auxpty"});
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        super.beforeItemClick(e);
        switch (e.getItemKey()) {
            case "bar_new": {
                this.getModel().setDataChanged(false);
                Long orgId = this.getModel().getDataEntity().getDynamicObject("org").getLong("id");
                if (PermItemCheckHelper.isPerm((String)"aca_wipadjustbill", (String)"47156aff000000ac", (Long)orgId)) break;
                String tips = ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u8be5\u6838\u7b97\u7ec4\u7ec7\u4e0b\u65b0\u589e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WipAdjustBillEditPlugin_8", (String)"macc-aca-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                e.setCancel(true);
                break;
            }
        }
    }

    private void setEntryentity() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
        for (int index = 0; index < entries.size(); ++index) {
            this.setAfterAdjustAmt(index);
            if (index != 0) continue;
            DynamicObjectCollection subEntrys = ((DynamicObject)entries.get(index)).getDynamicObjectCollection("subentryentity");
            for (int subIndex = 0; subIndex < subEntrys.size(); ++subIndex) {
                DynamicObject subObj = (DynamicObject)subEntrys.get(subIndex);
                BigDecimal submatadjamt = WipAdjustHelper.getOrZero((Object)subObj.get("submatadjamt"));
                BigDecimal submatamt = WipAdjustHelper.getOrZero((Object)subObj.get("submatamt"));
                this.getModel().setValue("aftersubmatadjamt", (Object)submatadjamt.add(submatamt), subIndex);
                BigDecimal submatadjqty = WipAdjustHelper.getOrZero((Object)subObj.get("submatadjqty"));
                BigDecimal submatqty = WipAdjustHelper.getOrZero((Object)subObj.get("submatqty"));
                this.getModel().setValue("aftersubmatadjqty", (Object)submatadjqty.add(submatqty), subIndex);
            }
        }
    }

    private void setAfterSubMatAdjQty(int index) {
        BigDecimal submatadjqty = WipAdjustHelper.getOrZero((Object)this.getModel().getValue("submatadjqty", index));
        BigDecimal submatqty = WipAdjustHelper.getOrZero((Object)this.getModel().getValue("submatqty", index));
        this.getModel().setValue("aftersubmatadjqty", (Object)submatadjqty.add(submatqty), index);
    }

    private void setAfterSubMatAdjAmt(int index) {
        DynamicObjectCollection subentryentity;
        BigDecimal submatadjamt = WipAdjustHelper.getOrZero((Object)this.getModel().getValue("submatadjamt", index));
        BigDecimal submatamt = WipAdjustHelper.getOrZero((Object)this.getModel().getValue("submatamt", index));
        this.getModel().setValue("aftersubmatadjamt", (Object)submatadjamt.add(submatamt), index);
        Object json = this.getModel().getValue("subitemjson_tag", index);
        if (json != null && !StringUtils.isEmpty((Object)json.toString())) {
            List subitems = JSON.parseArray((String)json.toString(), WipAdjustSubItem.class);
            WipAdjustHelper.calcAdjustSubItemAmt((List)subitems, (BigDecimal)submatadjamt, (int)this.getCurrencyPrecision());
            this.getModel().setValue("subitemjson_tag", (Object)JSON.toJSONString((Object)subitems), index);
            this.showSubItemView(index);
        }
        int entryindex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        DynamicObject entryObj = (DynamicObject)entrys.get(entryindex);
        if (entryObj != null && !CadEmptyUtils.isEmpty((DynamicObjectCollection)(subentryentity = entryObj.getDynamicObjectCollection("subentryentity")))) {
            BigDecimal totalAmt = BigDecimal.ZERO;
            for (DynamicObject dyn : subentryentity) {
                BigDecimal adjamt = BigDecimalUtil.getOrZero((Object)dyn.getBigDecimal("submatadjamt"));
                totalAmt = totalAmt.add(adjamt);
            }
            this.getModel().setValue("adjustamt", (Object)totalAmt, entryindex);
        }
    }

    private int getCurrencyPrecision() {
        DynamicObject currency = this.getModel().getDataEntity().getDynamicObject("currency");
        if (currency == null) {
            return 2;
        }
        return currency.getInt("amtprecision");
    }

    private void setAfterSubItemAdjAmt(int index) {
        BigDecimal submatadjamt = WipAdjustHelper.getOrZero((Object)this.getModel().getValue("swipamt", index));
        BigDecimal submatamt = WipAdjustHelper.getOrZero((Object)this.getModel().getValue("sadjustamt", index));
        this.getModel().setValue("safteradjustamt", (Object)submatadjamt.add(submatamt), index);
    }

    private void setAfterAdjustAmt(int index) {
        BigDecimal adjustamt = WipAdjustHelper.getOrZero((Object)this.getModel().getValue("adjustamt", index));
        BigDecimal wipamt = WipAdjustHelper.getOrZero((Object)this.getModel().getValue("wipamt", index));
        this.getModel().setValue("afteradjustamt", (Object)adjustamt.add(wipamt), index);
    }

    private void setAfterAdjustQty() {
        BigDecimal adjustqty = WipAdjustHelper.getOrZero((Object)this.getModel().getValue("adjustqty"));
        BigDecimal wipqty = WipAdjustHelper.getOrZero((Object)this.getModel().getValue("wipqty"));
        this.getModel().setValue("afteradjustqty", (Object)adjustqty.add(wipqty));
    }

    private void setEnableCostObjectRel(DynamicObject costObject) {
        if (costObject != null) {
            Long orgId = this.getModel().getDataEntity().getLong("org.id");
            Long costaccountId = this.getModel().getDataEntity().getLong("costaccount.id");
            Map keycolFieldMap = CalcKeycolHelper.getWipAdjustKeyColFieldMap((Long)orgId, (Long)costaccountId, (boolean)false);
            DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
            if (!entries.isEmpty()) {
                for (int row = 0; row < entries.size(); ++row) {
                    String dataType = ((DynamicObject)entries.get(row)).getString("datatype");
                    if ("sysImport".equals(dataType)) {
                        this.getView().setEnable(Boolean.FALSE, row, new String[]{"subelement"});
                    }
                    DynamicObjectCollection subEntrys = ((DynamicObject)entries.get(row)).getDynamicObjectCollection("subentryentity");
                    for (int index = 0; index < subEntrys.size(); ++index) {
                        DynamicObject obj = (DynamicObject)subEntrys.get(index);
                        String subDataType = obj.getString("subdatatype");
                        if ("sysImport".equals(subDataType)) {
                            this.getView().setEnable(Boolean.FALSE, index, new String[]{"outsourcetype"});
                            this.getView().setEnable(Boolean.FALSE, index, new String[]{"submaterial"});
                            if (obj.getDynamicObject("submaterial") == null) {
                                this.getView().setEnable(Boolean.FALSE, index, new String[]{"submatadjqty"});
                            }
                            this.getView().setEnable(Boolean.FALSE, index, new String[]{"submatqty"});
                            this.getView().setEnable(Boolean.FALSE, index, new String[]{"version"});
                            this.getView().setEnable(Boolean.FALSE, index, new String[]{"auxpty"});
                            for (Tuple2 tuple : keycolFieldMap.values()) {
                                this.getView().setEnable(Boolean.FALSE, index, new String[]{(String)tuple.t1});
                            }
                            continue;
                        }
                        this.getView().setEnable(Boolean.TRUE, index, new String[]{"outsourcetype"});
                        this.getView().setEnable(Boolean.TRUE, index, new String[]{"submaterial"});
                        this.getView().setEnable(Boolean.TRUE, index, new String[]{"submatadjqty"});
                        this.getView().setEnable(Boolean.TRUE, index, new String[]{"submatqty"});
                        DynamicObject submaterial = obj.getDynamicObject("submaterial");
                        this.setVersionAndAuxpty(submaterial, index);
                        for (Tuple2 tuple : keycolFieldMap.values()) {
                            this.getView().setEnable(Boolean.TRUE, index, new String[]{(String)tuple.t1});
                        }
                    }
                }
                this.getView().updateView("subentryentity");
                this.getView().updateView("entryentity");
            }
        }
    }

    private boolean setCostObjectRel(DynamicObject costObject) {
        this.getModel().setValue("wipqty", null);
        this.getModel().setValue("adjustqty", null);
        this.getModel().deleteEntryData("entryentity");
        this.getModel().deleteEntryData("subentryentity");
        if (costObject == null) {
            this.getModel().setValue("wipqty", null);
            this.getModel().setValue("material", null);
            this.getModel().setValue("unit", null);
            this.getModel().setValue("matauxpty", null);
        } else {
            Object auxpty;
            Object baseunit;
            String adjustType = (String)this.getView().getFormShowParameter().getCustomParam("adjustType");
            boolean isEnd = "END".equalsIgnoreCase(adjustType);
            Long orgId = this.getModel().getDataEntity().getDynamicObject("org").getLong("id");
            Long costAccountId = this.getModel().getDataEntity().getDynamicObject("costaccount").getLong("id");
            Long periodId = this.getModel().getDataEntity().getDynamicObject("period").getLong("id");
            Long costCenterId = this.getModel().getDataEntity().getDynamicObject("costcenter").getLong("id");
            String billNo = this.getModel().getDataEntity().getString("billno");
            boolean isExistCostObject = WipAdjustHelper.isExistCostObject((String)adjustType, (Long)orgId, (Long)costCenterId, (Long)costAccountId, (Long)periodId, (Long)costObject.getLong("id"), (String)billNo);
            if (isExistCostObject) {
                String msg = String.format(ResManager.loadKDString((String)"\u8be5\u201c\u6838\u7b97\u7ec4\u7ec7+\u6210\u672c\u4e2d\u5fc3+\u6210\u672c\u8d26\u7c3f+\u6838\u7b97\u671f\u95f4\u201d\u4e0b\uff0c\u5bf9\u5e94\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5bf9\u5e94\u8c03\u6574\u5355\u5df2\u5b58\u5728\u3002", (String)"WipAdjustBillEditPlugin_9", (String)"macc-aca-formplugin", (Object[])new Object[0]), new Object[0]);
                this.getView().showTipNotification(msg);
                this.getModel().setValue("costobject", null);
                return false;
            }
            this.getModel().setValue("material", costObject.get("material"));
            DynamicObject material = (DynamicObject)this.getModel().getValue("material");
            if (material != null && (baseunit = material.get("baseunit")) != null) {
                this.getModel().setValue("unit", baseunit);
            }
            if ((auxpty = costObject.get("auxpty")) != null) {
                this.getModel().setValue("matauxpty", auxpty);
            }
            Map keycolFieldMap = CalcKeycolHelper.getWipAdjustKeyColFieldMap((Long)orgId, (Long)costAccountId, (boolean)false);
            Map map = WipAdjustHelper.getCostObjectRelInfo((long)costObject.getLong("id"), (DynamicObject)this.getModel().getDataEntity(), (String)adjustType, (boolean)CostaccountHelper.getCostElementByCostAccount((long)costAccountId));
            if (!map.isEmpty()) {
                BigDecimal pdendqty = WipAdjustHelper.getOrZero(map.get("pdendqty"));
                BigDecimal endadjqty = WipAdjustHelper.getOrZero(map.get("endadjqty"));
                this.getModel().setValue("wipqty", (Object)(isEnd ? pdendqty : pdendqty.add(endadjqty)));
                if (map.get("detailInfo") != null) {
                    List detailList = (List)map.get("detailInfo");
                    Map subMapInfo = (Map)map.get("subMap");
                    DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                    for (Map detailMap : detailList) {
                        DynamicObject entry = entryEntity.addNew();
                        entry.set("element_id", detailMap.get("element"));
                        entry.set("subelement_id", detailMap.get("subelement"));
                        BigDecimal pdendamount = WipAdjustHelper.getOrZero(detailMap.get("pdendamount"));
                        BigDecimal endadjamt = WipAdjustHelper.getOrZero(detailMap.get("endadjamt"));
                        BigDecimal wipamt = isEnd ? pdendamount : pdendamount.add(endadjamt);
                        entry.set("wipamt", (Object)wipamt);
                        entry.set("afteradjustamt", (Object)wipamt);
                        entry.set("datatype", (Object)"sysImport");
                        entry.set("outsourcetype", detailMap.get("outsourcetype"));
                        String keyStr = String.format("%s@%s", detailMap.get("subelement"), detailMap.get("outsourcetype"));
                        List subList = (List)subMapInfo.get(keyStr);
                        if (subList == null) continue;
                        DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("subentryentity");
                        for (Map subMap : subList) {
                            DynamicObject subEntry = subEntrys.addNew();
                            subEntry.set("submaterial_id", subMap.get("submaterial"));
                            subEntry.set("version_id", subMap.get("submatversion"));
                            subEntry.set("auxpty_id", subMap.get("subauxpty"));
                            subEntry.set("calckeycol_id", subMap.get("calckeycol"));
                            for (Map.Entry keyEntry : keycolFieldMap.entrySet()) {
                                if (((Tuple2)keyEntry.getValue()).t2 instanceof BasedataProp) {
                                    subEntry.set((String)((Tuple2)keyEntry.getValue()).t1 + "_id", subMap.get(keyEntry.getKey()));
                                    continue;
                                }
                                subEntry.set((String)((Tuple2)keyEntry.getValue()).t1, subMap.get(keyEntry.getKey()));
                            }
                            BigDecimal subPdendqty = WipAdjustHelper.getOrZero(subMap.get("pdendqty"));
                            BigDecimal subEndadjqty = WipAdjustHelper.getOrZero(subMap.get("endadjqty"));
                            BigDecimal submatqty = isEnd ? subPdendqty : subPdendqty.add(subEndadjqty);
                            subEntry.set("submatqty", (Object)submatqty);
                            subEntry.set("aftersubmatadjqty", (Object)submatqty);
                            subEntry.set("subsubelement_id", subMap.get("subelement"));
                            BigDecimal subPdendamount = WipAdjustHelper.getOrZero(subMap.get("pdendamount"));
                            BigDecimal subEndadjamt = WipAdjustHelper.getOrZero(subMap.get("endadjamt"));
                            BigDecimal submatamt = isEnd ? subPdendamount : subPdendamount.add(subEndadjamt);
                            subEntry.set("submatamt", (Object)submatamt);
                            subEntry.set("aftersubmatadjamt", (Object)submatamt);
                            subEntry.set("baseunit_id", subMap.get("baseunit"));
                            subEntry.set("subdatatype", (Object)"sysImport");
                            subEntry.set("subitemjson_tag", subMap.get("subitemjson"));
                        }
                        BusinessDataServiceHelper.loadRefence((Object[])subEntrys.toArray((Object[])new DynamicObject[0]), (IDataEntityType)subEntrys.getDynamicObjectType());
                        this.getView().updateView("subentryentity");
                    }
                    BusinessDataServiceHelper.loadRefence((Object[])entryEntity.toArray((Object[])new DynamicObject[0]), (IDataEntityType)entryEntity.getDynamicObjectType());
                    this.getView().updateView("entryentity");
                }
            }
        }
        return true;
    }

    private void reloadCostObjectRel(DynamicObject costObject) {
        String adjustType = (String)this.getView().getFormShowParameter().getCustomParam("adjustType");
        Long costAccountId = this.getModel().getDataEntity().getDynamicObject("costaccount").getLong("id");
        Map map = WipAdjustHelper.getCostObjectRelInfo((long)costObject.getLong("id"), (DynamicObject)this.getModel().getDataEntity(), (String)adjustType, (boolean)CostaccountHelper.getCostElementByCostAccount((long)costAccountId));
        if (!map.isEmpty()) {
            Set subelementSet = (Set)map.get("subelementSet");
            if (CadEmptyUtils.isEmpty((Set)subelementSet)) {
                return;
            }
            Set subSubelementSet = (Set)map.get("subSubelementSet");
            DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
            if (!entries.isEmpty()) {
                for (DynamicObject entry : entries) {
                    String outSourceType;
                    Long subelementId = entry.getLong("subelement.id");
                    if (!subelementSet.contains(String.format("%s@%s", subelementId, outSourceType = entry.getString("outsourcetype")))) continue;
                    entry.set("datatype", (Object)"sysImport");
                    DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject subEntry : subEntrys) {
                        String subKey = this.getSubelementSetKey(subEntry, outSourceType);
                        if (subSubelementSet == null || !subSubelementSet.contains(subKey)) continue;
                        subEntry.set("subdatatype", (Object)"sysImport");
                    }
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes && CONFIRMBACK_ADJUSTZERO.equals(e.getCallBackId())) {
            OperateOption operationOption = OperateOption.create();
            operationOption.setVariableValue(CONFIRMBACK_ADJUSTZERO, "true");
            this.getView().invokeOperation(CONFIRMBACK_ADJUSTZERO, operationOption);
        }
    }

    private String getSubelementSetKey(DynamicObject obj, String outSourceType) {
        DynamicObject subsubelement = obj.getDynamicObject("subsubelement");
        Long subsubelementId = subsubelement == null ? 0L : subsubelement.getLong("id");
        DynamicObject submaterial = obj.getDynamicObject("submaterial");
        Long submaterialId = submaterial == null ? 0L : submaterial.getLong("id");
        DynamicObject version = obj.getDynamicObject("version");
        Long versionId = version == null ? 0L : version.getLong("id");
        DynamicObject auxpty = obj.getDynamicObject("auxpty");
        Long auxptyId = auxpty == null ? 0L : auxpty.getLong("id");
        return String.format("%s@%s@%s@%s@%s", subsubelementId, submaterialId, versionId, auxptyId, outSourceType);
    }

    private void setPeriodAndBookdate(Long costAccountId) {
        if (costAccountId != 0L) {
            DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            this.getModel().setValue("period", (Object)curPeriod);
            Date date = PeriodHelper.getCurrentPeriodenddate((Long)costAccountId);
            this.getModel().setValue("bookdate", (Object)date);
        } else {
            this.getModel().setValue("period", null);
            this.getModel().setValue("bookdate", null);
        }
    }

    private void setCostAccount(Long orgId) {
        DynamicObjectCollection costAccountIds = WipAdjustHelper.getCostAccount((Long)orgId, (String)this.getView().getFormShowParameter().getAppId());
        if (costAccountIds != null && costAccountIds.size() == 1) {
            this.getModel().setValue("costaccount", (Object)((DynamicObject)costAccountIds.get(0)).getLong("costaccountid"));
        }
    }
}

