/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.wipadjust;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.common.helper.PermItemCheckHelper;
import kd.macc.aca.formplugin.base.BaseOrgAndCostCenterFilterList;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class WipAdjustBillListPlugin
extends BaseOrgAndCostCenterFilterList {
    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List<ComboItem> comboItems;
            String orgId = this.getPageCache().get(this.ORG_FIELD);
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("manuorg.")) continue;
            if (StringUtils.isEmpty((String)orgId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6240\u5728\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u6709\u6743\u9650\u3002", (String)"WipAdjustBillListPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                return;
            }
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            boolean isMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.valueOf(orgId));
            if (!isMultiFactory || CollectionUtils.isEmpty(comboItems = this.getManuOrgComboItemsList(Long.valueOf(orgId)))) continue;
            commonFilterColumn.setComboItems(comboItems);
            ComboItem item = comboItems.get(0);
            String defVal = "org".equals(this.ORG_FIELD) ? "" : item.getValue();
            commonFilterColumn.setDefaultValue(defVal);
            this.getPageCache().put("manuorg", defVal);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String adjustType = (String)formShowParameter.getCustomParam("adjustType");
        if (!"END".equalsIgnoreCase(adjustType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tbl_trackdown", "tbl_push", "subadjustbillno", "subadjustid"});
        }
    }

    public void setFilter(SetFilterEvent e) {
        QFilter manuorgFilter;
        String orgId;
        super.setFilter(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String adjustType = (String)formShowParameter.getCustomParam("adjustType");
        e.getQFilters().add(new QFilter("adjusttype", "=", (Object)adjustType));
        QFilter costCenterFilter = this.getCostCenterFilter();
        if (costCenterFilter != null) {
            e.getQFilters().add(costCenterFilter);
        }
        if (CadEmptyUtils.isEmpty((String)(orgId = this.getPageCache().get("org")))) {
            if (AppIdHelper.isMacc((IFormView)this.getView())) {
                e.getQFilters().add(new QFilter("org", "=", (Object)0L));
            }
        } else if (OrgHelper.isOrgEnableMultiFactory((Long)Long.valueOf(orgId)) && (manuorgFilter = this.setManuorgFilter()) != null) {
            e.getQFilters().add(manuorgFilter);
        }
        e.setOrderBy("billno desc");
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String accountorgId;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("costcenter") && !CadEmptyUtils.isEmpty((String)(accountorgId = this.getPageCache().get("org")))) {
            args.getQfilters().add(new QFilter("accountorg", "=", (Object)Long.valueOf(accountorgId)).and(new QFilter("enable", "=", (Object)"1")));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (!StringUtils.isBlank((String)itemKey) && itemKey.contains("trackdown")) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
            ListSelectedRowCollection billSelect = selectedRows.getBillListSelectedRowCollection();
            if (billSelect.isEmpty()) {
                return;
            }
            List<Long> wipIds = billSelect.stream().map(e -> (Long)e.getPrimaryKeyValue()).collect(Collectors.toList());
            this.showAdjustBill(wipIds, "tbl_trackdown");
        }
    }

    private void showAdjustBill(List<Long> wipIds, String itemKey) {
        String orgId;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String adjustType = (String)formShowParameter.getCustomParam("adjustType");
        QFilter billnoqf = new QFilter("id", "in", wipIds);
        billnoqf.and(new QFilter("adjusttype", "=", (Object)adjustType));
        billnoqf.and(new QFilter("entryentity.subadjustid", ">", (Object)0L).or("subitementry.sitemadjustid", ">", (Object)0L));
        DynamicObjectCollection wipBills = QueryServiceHelper.query((String)"aca_wipadjustbill", (String)"costaccount,entryentity.subadjustid AS subadjustid,entryentity.subadjustbillno AS subadjustbillno,subitementry.sitemadjustid AS subadjustid1,subitementry.sitemadjustbillno AS subadjustbillno1", (QFilter[])new QFilter[]{billnoqf});
        if (wipBills.isEmpty() && "tbl_trackdown".equals(itemKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u672a\u5b58\u5728\u4e0b\u63a8\u7684\u6210\u672c\u8c03\u6574\u5355\u3002", (String)"WipAdjustBillListPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> adjustbills = new ArrayList<Long>(10);
        ArrayList<Long> costaccounts = new ArrayList<Long>(10);
        for (DynamicObject dyn : wipBills) {
            Long subId;
            Long id = dyn.getLong("subadjustid");
            if (!CadEmptyUtils.isEmpty((Long)id)) {
                adjustbills.add(id);
            }
            if (!CadEmptyUtils.isEmpty((Long)(subId = Long.valueOf(dyn.getLong("subadjustid1"))))) {
                adjustbills.add(subId);
            }
            costaccounts.add(dyn.getLong("costaccount"));
        }
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"cal_costadjust_subentity", (QFilter[])new QFilter[]{new QFilter("id", "in", adjustbills)}, (String)"", (int)adjustbills.size());
        if (ids == null || ids.size() == 0) {
            if ("tbl_trackdown".equals(itemKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u672a\u5b58\u5728\u4e0b\u63a8\u6210\u672c\u8c03\u6574\u5355\u3002", (String)"WipAdjustBillListPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            linkQueryPkIdCollection.addLinkQueryPkId(iterator.next());
        }
        QFilter costaccountFilter = new QFilter("costaccount", "in", costaccounts);
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("cal_costadjust_subentity");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        showParameter.getListFilterParameter().setFilter(costaccountFilter);
        showParameter.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
        if (!costaccounts.isEmpty()) {
            this.getPageCache().put("adj_costaccount", JSON.toJSONString(costaccounts));
        }
        if (!CadEmptyUtils.isEmpty((String)(orgId = this.getPageCache().get("org")))) {
            this.getPageCache().put("adj_calorg", orgId);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        switch (evt.getOperateKey()) {
            case "push_donothing": {
                if (!evt.getOperationResult().isSuccess()) break;
                BillList billlist = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
                ListSelectedRowCollection billSelect = selectedRows.getBillListSelectedRowCollection();
                if (!billSelect.isEmpty()) {
                    List<Long> wipIds = billSelect.stream().map(e -> (Long)e.getPrimaryKeyValue()).collect(Collectors.toList());
                    this.showAdjustBill(wipIds, "push_donothing");
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "adjust_zero": {
                this.getView().invokeOperation("refresh", OperateOption.create());
                break;
            }
        }
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter bsp = e.getParameter();
        String adjustType = (String)this.getView().getFormShowParameter().getCustomParam("adjustType");
        bsp.setCustomParam("adjustType", (Object)adjustType);
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        super.beforeItemClick(e);
        switch (e.getItemKey()) {
            case "tblnew": {
                String orgId = this.getPageCache().get("org");
                if (CadEmptyUtils.isEmpty((String)orgId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipAdjustBillListPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (PermItemCheckHelper.isPerm((String)"aca_wipadjustbill", (String)"47156aff000000ac", (Long)Long.valueOf(orgId))) break;
                String tips = ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u8be5\u6838\u7b97\u7ec4\u7ec7\u4e0b\u65b0\u589e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WipAdjustBillListPlugin_4", (String)"macc-aca-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                e.setCancel(true);
                return;
            }
        }
    }

    private QFilter setManuorgFilter() {
        QFilter qfManuorg = null;
        String manuorgId = this.getPageCache().get("manuorg");
        if (StringUtils.isEmpty((String)manuorgId)) {
            String orgId = this.getPageCache().get("org");
            List manuorgIdComboItems = ImportServiceHelper.getPermProOrgsByAccOrg((Long)Long.valueOf(orgId), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            ArrayList<Long> manuorgIds = new ArrayList<Long>(16);
            manuorgIds.add(0L);
            if (!CollectionUtils.isEmpty((Collection)manuorgIdComboItems)) {
                for (ComboItem combo : manuorgIdComboItems) {
                    manuorgIds.add(Long.valueOf(combo.getValue()));
                }
            }
            qfManuorg = new QFilter("manuorg", "in", manuorgIds);
        }
        return qfManuorg;
    }
}

