/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.wipcostcheck;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.macc.aca.algox.enums.TerminalWipMatEnum;
import kd.macc.aca.algox.utils.AcaCalcRangeHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class TerminalWipMatCheckEditPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("org");
            if (createorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"TerminalWipMatCheckEditPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter costAccountFilter = this.getCostAccountFilter(createorg);
            qFilters.add(costAccountFilter);
        });
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenter");
        costcenter.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("org");
            if (createorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"TerminalWipMatCheckEditPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter showorgduty = new QFilter("orgduty", "=", (Object)4L);
            QFilter calorg = new QFilter("accountorg", "=", createorg.getPkValue());
            qFilters.add(showorgduty);
            qFilters.add(calorg);
        });
        BasedataEdit costobject = (BasedataEdit)this.getControl("costobject");
        costobject.addBeforeF7SelectListener(evt -> {
            DynamicObject costcenterData = (DynamicObject)this.getModel().getValue("costcenter");
            if (costcenterData == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u4e2d\u5fc3\u3002", (String)"TerminalWipMatCheckEditPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            DynamicObject orgDy = (DynamicObject)this.getModel().getValue("org");
            DynamicObject costaccountDy = (DynamicObject)this.getModel().getValue("costaccount");
            DynamicObject periodDy = (DynamicObject)this.getModel().getValue("period");
            if (orgDy == null || costaccountDy == null || periodDy == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u548c\u6210\u672c\u8d26\u7c3f\uff0c\u5e76\u7ef4\u62a4\u6210\u672c\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\u3002", (String)"TerminalWipMatCheckEditPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Set calcCurPeriodCostobjectRange = AcaCalcRangeHelper.getCalResultAndPlanCostObject((Long)orgDy.getLong("id"), (Long)costaccountDy.getLong("id"), (Long)periodDy.getLong("id"), (Long)0L);
            List qFilters = filterParameter.getQFilters();
            if (!CadEmptyUtils.isEmpty((Set)calcCurPeriodCostobjectRange)) {
                QFilter idQf = new QFilter("id", "in", (Object)calcCurPeriodCostobjectRange);
                qFilters.add(idQf);
            }
            QFilter costcenterQf = new QFilter("costcenter", "=", costcenterData.getPkValue());
            QFilter producttypeQf = new QFilter("producttype", "=", (Object)"C");
            qFilters.add(costcenterQf);
            qFilters.add(producttypeQf);
        });
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        material.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("org");
            if (createorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"TerminalWipMatCheckEditPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter qfMat = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)createorg.getLong("id"));
            qFilters.add(qfMat);
        });
        BasedataEdit matVersion = (BasedataEdit)this.getControl("matversion");
        matVersion.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int entryentity = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject mat = (DynamicObject)this.getModel().getValue("material", entryentity);
            if (mat == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6750\u6599\u7f16\u53f7\u3002", (String)"TerminalWipMatCheckEditPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = parameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            qList.add(new QFilter("material", "=", mat.getPkValue()));
        });
        BasedataEdit lot = (BasedataEdit)this.getControl("lot");
        lot.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int entryentity = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject mat = (DynamicObject)this.getModel().getValue("material", entryentity);
            if (mat == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6750\u6599\u7f16\u53f7\u3002", (String)"TerminalWipMatCheckEditPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = parameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            qList.add(new QFilter("material", "=", mat.getPkValue()));
        });
    }

    public void beforeBindData(EventObject e) {
        String costaccount;
        String costcenter;
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String acctOrg = (String)formShowParameter.getCustomParam("orgId");
        if (!StringUtils.isEmpty((CharSequence)acctOrg) && this.getModel().getValue("org") == null) {
            this.getModel().setValue("org", (Object)acctOrg);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        }
        if (!StringUtils.isEmpty((CharSequence)(costcenter = (String)formShowParameter.getCustomParam("costcenter"))) && this.getModel().getValue("costcenter") == null) {
            this.getModel().setValue("costcenter", (Object)costcenter);
        }
        if (!StringUtils.isEmpty((CharSequence)(costaccount = (String)formShowParameter.getCustomParam("costaccount"))) && this.getModel().getValue("costaccount") == null) {
            this.getModel().setValue("costaccount", (Object)costaccount);
        }
        this.setCurrency();
        this.setCurrPeriodEndDate(true);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setMustFileName();
        this.setEnableFileName(-1);
        this.getModel().setDataChanged(false);
    }

    private void setMustFileName() {
        DynamicObject loadData;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String fileName = "qty";
        if (org != null && !CadEmptyUtils.isEmpty((DynamicObject)(loadData = BusinessDataServiceHelper.loadSingle((String)"aca_checksetting", (String)"checktype", (QFilter[])new QFilter[]{new QFilter("org", "=", org.getPkValue())})))) {
            String checktype = loadData.getString("checktype");
            fileName = TerminalWipMatEnum.CHECKTYPE_AMOUNT.getValue().equals(checktype) ? "amount" : "qty";
        }
        DecimalEdit control = (DecimalEdit)this.getView().getControl(fileName);
        control.setMustInput(true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fileName;
        super.propertyChanged(e);
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (fileName = e.getProperty().getName()) {
            case "org": {
                this.getModel().setValue("costcenter", null);
                this.getModel().setValue("costaccount", null);
                break;
            }
            case "costaccount": {
                this.setCurrency();
                this.setCurrPeriodEndDate(false);
                break;
            }
            case "material": {
                this.setEnableFileName(rowIndex);
                this.getModel().setValue("source", (Object)TerminalWipMatEnum.SOURCE_HAND.getValue(), rowIndex);
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
                if (material == null) break;
                this.getModel().setValue("unit", material.get("baseunit"), rowIndex);
                break;
            }
            case "costobject": {
                if (newValue != null) {
                    DynamicObject costObj = (DynamicObject)newValue;
                    this.getModel().setValue("costmaterial", costObj.get("material"), rowIndex);
                    this.getModel().setValue("costauxpty", costObj.get("auxpty"), rowIndex);
                    this.getModel().setValue("srcbillrow", (Object)costObj.getInt("srcbillrow"), rowIndex);
                    break;
                }
                this.getModel().setValue("costmaterial", null, rowIndex);
                this.getModel().setValue("costauxpty", null, rowIndex);
                this.getModel().setValue("srcbillrow", null, rowIndex);
                break;
            }
            case "matversion": 
            case "auxpty": 
            case "batchno": 
            case "unit": 
            case "qty": 
            case "amount": {
                this.getModel().setValue("source", (Object)TerminalWipMatEnum.SOURCE_HAND.getValue(), rowIndex);
            }
        }
    }

    private void setEnableFileName(int changeIndex) {
        int rowIndex = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < rowIndex; ++i) {
            DynamicObject costobjectDy;
            Boolean isenablematerialversion = false;
            Boolean isuseauxptyFlag = false;
            Boolean isenablelotFlag = false;
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", i);
            if (material != null) {
                isenablematerialversion = material.getBoolean("isenablematerialversion");
                DynamicObject enablelo = QueryServiceHelper.queryOne((String)"bd_materialinventoryinfo", (String)"enablelot", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)material.getLong("masterid"))});
                if (enablelo != null) {
                    isenablelotFlag = enablelo.getBoolean("enablelot");
                }
                isuseauxptyFlag = material.getBoolean("isuseauxpty");
            }
            this.getView().setEnable(isenablematerialversion, i, new String[]{"matversion"});
            this.getView().setEnable(isenablelotFlag, i, new String[]{"lot"});
            this.getView().setEnable(isuseauxptyFlag, i, new String[]{"auxpty"});
            if (changeIndex == i) {
                this.getModel().setValue("matversion", null, i);
                this.getModel().setValue("auxpty", null, i);
            }
            if ((costobjectDy = (DynamicObject)this.getModel().getValue("costobject", i)) != null) {
                this.getModel().setValue("srcbillrow", (Object)costobjectDy.getInt("srcbillrow"), i);
                continue;
            }
            this.getModel().setValue("srcbillrow", null, i);
        }
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency AS currency", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccount.get("id"))});
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
    }

    private void setCurrPeriodEndDate(Boolean isinits) {
        Object period;
        QFilter isInitFilter;
        Long costAccountId;
        QFilter qfCostAccount;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org == null) {
            return;
        }
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            return;
        }
        Long orgId = org.getLong("id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod as currentperiod,entry.currentperiod.enddate enddate", (QFilter[])new QFilter[]{qfOrg, qfCostAccount = new QFilter("entry.costaccount", "=", (Object)(costAccountId = Long.valueOf(costAccount.getLong("id")))), isInitFilter = new QFilter("entry.isenabled", "=", (Object)Character.valueOf('1'))});
        if (res == null) {
            return;
        }
        Object bookdate = this.getModel().getValue("bookdate");
        if (bookdate == null || !isinits.booleanValue()) {
            this.getModel().setValue("bookdate", (Object)res.getDate("enddate"));
        }
        if ((period = this.getModel().getValue("period")) == null || !isinits.booleanValue()) {
            this.getModel().setValue("period", res.get("currentperiod"));
        }
    }

    private boolean checkCostAccount(String acctOrg, String costaccount) {
        Long calorgid;
        if (acctOrg == null || costaccount == null || "".equals(costaccount)) {
            return false;
        }
        DynamicObject costAccountData = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calorg.id as calorgid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(costaccount))});
        return costAccountData != null && (calorgid = Long.valueOf(costAccountData.getLong("calorgid"))) != null && calorgid == Long.parseLong(acctOrg);
    }

    private QFilter getCostAccountFilter(DynamicObject org) {
        ArrayList<Long> costaccountIds = new ArrayList<Long>();
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        QFilter isStartStdCostFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)"aca");
        QFilter isinitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        DynamicObjectCollection costaccounts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount.id id", (QFilter[])new QFilter[]{orgFilter, isStartStdCostFilter, qfAppNum, isinitFilter});
        for (DynamicObject costaccount : costaccounts) {
            costaccountIds.add(costaccount.getLong("id"));
        }
        return new QFilter("id", "in", costaccountIds);
    }
}

