/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.wipcostcheck;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.business.wipcostcheck.WipCostCheckService;
import kd.macc.aca.common.vo.WipCostCheckSave;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class WipCostCheckPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(WipCostCheckPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit orgBaseData = (BasedataEdit)this.getControl("org");
        orgBaseData.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getHasPermOrgIdsByOrgViewType((String)"10");
            qFilters.add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
        });
        BasedataEdit costType = (BasedataEdit)this.getControl("manuorgf");
        costType.addBeforeF7SelectListener(evt -> {
            List manuOrg;
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("org");
            if (createorg != null) {
                manuOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)((Long)createorg.getPkValue()), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                DynamicObject manuorg = (DynamicObject)this.getModel().getValue("manuorgf");
                if (!ObjectUtils.isEmpty((Object)manuorg) && !CollectionUtils.isEmpty((Collection)manuOrg)) {
                    manuOrg.remove((Long)manuorg.getPkValue());
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipCostCheckPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("id", "in", (Object)manuOrg));
        });
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("org");
            if (createorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipCostCheckPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(StartCostHelper.getEndInitCostAccountIdsFilter((Long)((Long)createorg.getPkValue()), (String)"aca"));
        });
        BasedataEdit costcenterf = (BasedataEdit)this.getControl("costcenterf");
        costcenterf.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("org");
            if (createorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipCostCheckPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("orgduty", "=", (Object)4L));
            qFilters.add(new QFilter("accountorg", "=", createorg.getPkValue()));
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void afterBindData(EventObject e) {
        Object costaccount;
        super.afterBindData(e);
        Long orgId = 0L;
        Object org = this.getModel().getValue("org");
        if (org == null) {
            orgId = RequestContext.get().getOrgId();
            if (OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10")) {
                this.getModel().setValue("org", (Object)orgId);
                this.getView().updateView("org");
            }
        } else {
            orgId = ((DynamicObject)org).getLong("id");
        }
        if ((costaccount = this.getModel().getValue("costaccount")) == null) {
            Long costAccountByAccoutOrg = this.getCostAccountByAccoutOrg();
            this.getModel().setValue("costaccount", (Object)costAccountByAccoutOrg);
            DynamicObject sysCtrlPeriod = this.getSysCtrlPeriod(orgId, costAccountByAccoutOrg);
            if (sysCtrlPeriod != null) {
                this.getModel().setValue("periodf", (Object)sysCtrlPeriod.getLong("currentperiod"));
                this.getView().updateView("periodf");
            }
            this.getView().updateView("costaccount");
        }
        this.changeManuorgStatus(true);
        Long manuorgfId = this.getDynamicObjectValueId("manuorgf");
        Long costaccountId = this.getDynamicObjectValueId("costaccount");
        Set<Long> costcenterfIds = this.getDynamicObjectCollectionValueId("costcenterf");
        Boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)orgId, (String)"aca", (String)"aca_wipcostcheck", (String)"1MA5KNE0EUUA") == 1;
        if (!hasPerm.booleanValue()) {
            return;
        }
        this.loadDataByCondition(orgId, manuorgfId, costaccountId, costcenterfIds, true);
    }

    private Set<Long> getDynamicObjectCollectionValueId(String costcenterf) {
        Object value = this.getModel().getValue(costcenterf);
        if (value != null) {
            return ((DynamicObjectCollection)value).stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toSet());
        }
        return new HashSet<Long>();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        switch (e.getProperty().getName()) {
            case "checknum": {
                BigDecimal newCheckNum = (BigDecimal)newValue;
                if (newValue == null) {
                    return;
                }
                if (newCheckNum.compareTo(BigDecimal.ZERO) < 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u76d8\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u6216\u8005\u7b49\u4e8e\u96f6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WipCostCheckPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    this.getModel().beginInit();
                    this.getModel().setValue("checknum", oldValue, rowIndex);
                    this.getModel().endInit();
                    return;
                }
                int precision = 0;
                if (material != null) {
                    precision = material.getInt("baseunit.precision");
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u4ea7\u54c1\u7f16\u7801\u7684\u5355\u4f4d\u7cbe\u5ea6\uff0c\u9ed8\u8ba4\u7cbe\u5ea6\u53d60\uff0c\u8bf7\u6ce8\u610f\u3002", (String)"WipCostCheckPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                }
                newCheckNum = newCheckNum.setScale(precision, 4);
                this.getModel().beginInit();
                this.getModel().setValue("checknum", (Object)newCheckNum, rowIndex);
                this.getModel().endInit();
                this.changeValueBychecknum(newCheckNum, rowIndex);
                break;
            }
            case "org": {
                Long orgId;
                DynamicObject sysCtrlPeriod;
                this.changeManuorgStatus(false);
                this.getModel().setValue("periodf", null);
                Long costAccountByAccoutOrg = this.getCostAccountByAccoutOrg();
                this.getModel().setValue("costaccount", (Object)costAccountByAccoutOrg);
                if (newValue != null && !CadEmptyUtils.isEmpty((Long)costAccountByAccoutOrg) && (sysCtrlPeriod = this.getSysCtrlPeriod(orgId = Long.valueOf(((DynamicObject)newValue).getLong("id")), costAccountByAccoutOrg)) != null) {
                    this.getModel().setValue("periodf", (Object)sysCtrlPeriod.getLong("currentperiod"));
                    this.getView().updateView("periodf");
                }
                this.getModel().setValue("manuorgf", null);
                this.getModel().setValue("costcenterf", null);
                break;
            }
            case "costaccount": {
                Long costAccountId;
                Long orgId;
                DynamicObject sysCtrlPeriod;
                Object org = this.getModel().getValue("org");
                this.getModel().setValue("periodf", null);
                if (newValue == null || org == null || (sysCtrlPeriod = this.getSysCtrlPeriod(orgId = Long.valueOf(((DynamicObject)org).getLong("id")), costAccountId = Long.valueOf(((DynamicObject)newValue).getLong("id")))) == null) break;
                this.getModel().setValue("periodf", (Object)sysCtrlPeriod.getLong("currentperiod"));
                this.getView().updateView("periodf");
                break;
            }
            case "finadjustqty": {
                BigDecimal finAdjustQty = (BigDecimal)newValue;
                int precision = 0;
                if (material != null) {
                    precision = material.getInt("baseunit.precision");
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u4ea7\u54c1\u7f16\u7801\u7684\u5355\u4f4d\u7cbe\u5ea6\uff0c\u9ed8\u8ba4\u7cbe\u5ea6\u53d60\uff0c\u8bf7\u6ce8\u610f\u3002", (String)"WipCostCheckPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                }
                finAdjustQty = finAdjustQty.setScale(precision, 4);
                if (newValue == null || BigDecimal.ZERO.compareTo(finAdjustQty) == 0) {
                    return;
                }
                Object currentfinish = this.getModel().getValue("currentfinish", rowIndex);
                if (currentfinish == null) {
                    return;
                }
                BigDecimal finQty = new BigDecimal(currentfinish.toString());
                BigDecimal finCheckQty = finAdjustQty.add(finQty);
                if (BigDecimal.ZERO.compareTo(finCheckQty) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5c06\u5b8c\u5de5\u6570\u91cf\u8c03\u6574\u4e3a\u5c0f\u4e8e\u96f6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WipCostCheckPlugin_20", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    this.getModel().beginInit();
                    this.getModel().setValue("finadjustqty", oldValue, rowIndex);
                    this.getModel().endInit();
                    return;
                }
                BigDecimal startnum = (BigDecimal)this.getModel().getValue("startnum", rowIndex);
                BigDecimal startchangenum = (BigDecimal)this.getModel().getValue("startchangenum", rowIndex);
                BigDecimal currentinput = (BigDecimal)this.getModel().getValue("currentinput", rowIndex);
                BigDecimal endproductchange = (BigDecimal)this.getModel().getValue("endproductchange", rowIndex);
                BigDecimal endproducting = startnum.add(startchangenum).add(currentinput).subtract(finCheckQty);
                BigDecimal checkNum = endproducting.add(endproductchange);
                if (BigDecimal.ZERO.compareTo(endproducting) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5c06\u671f\u672b\u5728\u4ea7\u54c1\u8d26\u5b58\u6570\u8c03\u6574\u4e3a\u5c0f\u4e8e\u96f6,\u8bf7\u68c0\u67e5\u3002", (String)"WipCostCheckPlugin_18", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    this.getModel().beginInit();
                    this.getModel().setValue("finadjustqty", oldValue, rowIndex);
                    this.getModel().endInit();
                    return;
                }
                if (BigDecimal.ZERO.compareTo(checkNum) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5c06\u5728\u4ea7\u54c1\u5b9e\u76d8\u6570\u91cf\u8c03\u6574\u4e3a\u5c0f\u4e8e\u96f6,\u8bf7\u68c0\u67e5\u3002", (String)"WipCostCheckPlugin_19", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    this.getModel().beginInit();
                    this.getModel().setValue("finadjustqty", oldValue, rowIndex);
                    this.getModel().endInit();
                    return;
                }
                this.getModel().setValue("fincheckqty", (Object)finCheckQty, rowIndex);
                this.getModel().setValue("endproducting", (Object)endproducting, rowIndex);
                this.getModel().setValue("checknum", (Object)checkNum, rowIndex);
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        Boolean hasPerm = false;
        Long currUserId = RequestContext.get().getCurrUserId();
        Long orgId = this.getDynamicObjectValueId("org");
        switch (evt.getItemKey()) {
            case "exportentry": {
                hasPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (Long)orgId, (String)"aca", (String)"aca_wipcostcheck", (String)"47150e89000000ac") == 1;
                if (hasPerm.booleanValue()) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5728\u4ea7\u54c1\u76d8\u70b9\u5f55\u5165\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WipCostCheckPlugin_22", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
            case "save": 
            case "showImportstart": 
            case "importdetails": {
                hasPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (Long)orgId, (String)"aca", (String)"aca_wipcostcheck", (String)"0=KX5+QVF5+R") == 1;
                if (hasPerm.booleanValue()) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5728\u4ea7\u54c1\u76d8\u70b9\u5f55\u5165\u201d\u7684\u201c\u4fdd\u5b58\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WipCostCheckPlugin_23", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
            case "refresh": 
            case "refreshsavehand": 
            case "refreshchecknum": {
                hasPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (Long)orgId, (String)"aca", (String)"aca_wipcostcheck", (String)"1MA5KNE0EUUA") == 1;
                if (hasPerm.booleanValue()) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5728\u4ea7\u54c1\u76d8\u70b9\u5f55\u5165\u201d\u7684\u201c\u5237\u65b0\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WipCostCheckPlugin_24", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.isEmpty((Object)itemKey)) {
            return;
        }
        Long currUserId = RequestContext.get().getCurrUserId();
        Long orgId = this.getDynamicObjectValueId("org");
        Boolean hasPerm = false;
        switch (itemKey) {
            case "save": {
                this.saveOP();
                break;
            }
            case "refresh": 
            case "refreshsavehand": {
                Long manuorgfId = this.getDynamicObjectValueId("manuorgf");
                Long costaccountId = this.getDynamicObjectValueId("costaccount");
                Set<Long> costcenterfId = this.getDynamicObjectCollectionValueId("costcenterf");
                String tip = this.loadDataByCondition(orgId, manuorgfId, costaccountId, costcenterfId, "refreshsavehand".equals(itemKey));
                if ("Y".equals(tip)) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6570\u636e\u6210\u529f\u3002", (String)"WipCostCheckPlugin_4", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(tip);
                }
                this.changeManuorgStatus(true);
                break;
            }
            case "refreshchecknum": {
                this.refreshCheckNum();
                break;
            }
            case "showImportstart": {
                this.showImportstart();
                break;
            }
            case "importdetails": {
                ListShowParameter parameter = new ListShowParameter();
                parameter.setCaption(ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u76d8\u70b9\u5f55\u5165\u5bfc\u5165\u7ed3\u679c\u8868", (String)"WipCostCheckPlugin_5", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                parameter.setBillFormId("bos_importlog");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setHasRight(true);
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter("sourceobj", "=", (Object)"aca_wipcostchecksave").and(new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId())));
                Date date = new Date();
                Date dayStartTime = DateUtils.getDayStartTime((Date)date);
                Date dayEndTime = DateUtils.getDayEndTime((Date)date);
                qFilters.add(new QFilter("modifytime", ">=", (Object)dayStartTime).and(new QFilter("modifytime", "<=", (Object)dayEndTime)));
                qFilters.add(new QFilter("createtime", ">=", (Object)dayStartTime).and(new QFilter("createtime", "<=", (Object)dayEndTime)));
                parameter.getListFilterParameter().setQFilters(qFilters);
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    private void refreshCheckNum() {
        Long orgId = this.getDynamicObjectValueId("org");
        if (CadEmptyUtils.isEmpty((Long)orgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipCostCheckPlugin_12", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return;
        }
        long costAccountId = this.getDynamicObjectValueId("costaccount");
        if (CadEmptyUtils.isEmpty((Long)costAccountId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"WipCostCheckPlugin_13", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return;
        }
        Set<Long> costCenterIds = this.getDynamicObjectCollectionValueId("costcenterf");
        Long manuOrg = this.getDynamicObjectValueId("manuorgf");
        WipCostCheckService wipCostCheckService = new WipCostCheckService();
        DynamicObject sysCtrlPeriod = this.getSysCtrlPeriod(orgId, costAccountId);
        if (sysCtrlPeriod == null) {
            return;
        }
        DataSet fullDataSet = wipCostCheckService.loadDataByCondition(orgId, manuOrg, Long.valueOf(costAccountId), costCenterIds, sysCtrlPeriod);
        DataSet costObjectDs = fullDataSet.copy().select("costobject").distinct();
        Map checkNumMap = wipCostCheckService.loadDataDataSetConvertMap(fullDataSet);
        HashSet<Long> costObjectIds = new HashSet<Long>(16);
        for (Row row : costObjectDs) {
            costObjectIds.add(row.getLong("costobject"));
        }
        QFilter idQFilter = new QFilter("id", "in", costObjectIds);
        idQFilter.and("biztype", "=", (Object)"RO");
        DataSet costObjectResult = QueryServiceHelper.queryDataSet((String)"WipCostCheckPlugin.getCostObject", (String)"cad_costobject", (String)"id,probill,manuorg,costcenter,isoutsource", (QFilter[])new QFilter[]{idQFilter}, null);
        HashSet<Long> proBillIds = new HashSet<Long>(16);
        HashSet<Long> omBillIds = new HashSet<Long>(16);
        for (Row row : costObjectResult.copy()) {
            if (row.getBoolean("isoutsource").booleanValue()) {
                omBillIds.add(row.getLong("probill"));
                continue;
            }
            proBillIds.add(row.getLong("probill"));
        }
        QFilter pomQFilter = new QFilter("treeentryentity.id", "in", proBillIds);
        QFilter closeFilter = new QFilter("treeentryentity.bizstatus", "=", (Object)"C");
        closeFilter.and("treeentryentity.closebookdate", "<=", (Object)DateUtils.getDayEndTime((Date)sysCtrlPeriod.getDate("enddate")));
        DataSet closePomDs = QueryServiceHelper.queryDataSet((String)"WipCostCheckPlugin.getMftOrder", (String)"pom_mftorder", (String)"treeentryentity.id as probill", (QFilter[])new QFilter[]{pomQFilter, closeFilter}, null);
        if (!CadEmptyUtils.isEmpty(omBillIds)) {
            QFilter omQFilter = new QFilter("treeentryentity.id", "in", omBillIds);
            DataSet closeOmDs = QueryServiceHelper.queryDataSet((String)"WipCostCheckPlugin.getMftOrder", (String)"om_mftorder", (String)"treeentryentity.id as probill", (QFilter[])new QFilter[]{omQFilter, closeFilter}, null);
            closePomDs = closePomDs.union(closeOmDs);
        }
        DataSet dealCostObjectDs = costObjectResult.join(closePomDs, JoinType.INNER).on("probill", "probill").select(new String[]{"id", "manuorg", "costcenter"}).finish();
        costObjectIds.clear();
        HashMap<Long, String> costObjectInfoMap = new HashMap<Long, String>(16);
        for (Row row : dealCostObjectDs) {
            long costObjectId = row.getLong("id");
            costObjectIds.add(costObjectId);
            costObjectInfoMap.put(costObjectId, String.format("%s@%s@%s", row.getLong("manuorg"), row.getLong("costcenter"), costObjectId));
        }
        if (CadEmptyUtils.isEmpty(costObjectIds)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65e0\u672c\u671f\u5173\u95ed\u5de5\u5355\u7684\u671f\u672b\u5728\u4ea7\u54c1\u6570\u636e\uff0c\u4e0d\u9700\u8981\u5237\u65b0\u3002", (String)"WipCostCheckPlugin_21", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter costAccountQf = new QFilter("costaccount", "=", (Object)costAccountId);
        if (!CadEmptyUtils.isEmpty(costCenterIds)) {
            orgQf.and(new QFilter("costcenter", "in", costCenterIds));
        }
        long currentPeriodId = sysCtrlPeriod.getLong("currentperiod");
        QFilter costObjectFilter = new QFilter("costobject", "in", costObjectIds);
        QFilter periodQf = new QFilter("period", "=", (Object)currentPeriodId);
        DynamicObject[] wipCostChecks = BusinessDataServiceHelper.load((String)"aca_wipcostchecksave", (String)"id,costobject,manuorg,costcenter,checknum,modifier,modifytime", (QFilter[])new QFilter[]{orgQf, costAccountQf, periodQf, costObjectFilter});
        HashSet<Long> updateCostObjectIds = new HashSet<Long>(16);
        long userId = RequestContext.get().getCurrUserId();
        Date modifyTime = new Date();
        ArrayList<DynamicObject> addWipCostChecks = new ArrayList<DynamicObject>(costObjectIds.size());
        ArrayList<DynamicObject> updateWipCostChecks = new ArrayList<DynamicObject>(wipCostChecks.length);
        Boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
        for (DynamicObject wipCost : wipCostChecks) {
            long costObjectId = wipCost.getLong("costobject.id");
            updateCostObjectIds.add(costObjectId);
            long manuOrgId = orgEnableMultiFactory != false ? wipCost.getLong("manuorg.id") : 0L;
            String infoKey = String.format("%s@%s@%s", manuOrgId, wipCost.getLong("costcenter.id"), costObjectId);
            if (checkNumMap.get(infoKey) != null && BigDecimal.ZERO.compareTo((BigDecimal)checkNumMap.get(infoKey)) == 0) continue;
            wipCost.set("checknum", (Object)0);
            wipCost.set("modifier", (Object)userId);
            wipCost.set("modifytime", (Object)modifyTime);
            updateWipCostChecks.add(wipCost);
        }
        costObjectIds.removeAll(updateCostObjectIds);
        for (Long costObjectId : costObjectIds) {
            String infoKey;
            long manuOrgId = 0L;
            long costCenterId = 0L;
            String costObjectInfo = (String)costObjectInfoMap.get(costObjectId);
            if (!CadEmptyUtils.isEmpty((String)costObjectInfo)) {
                String[] split = costObjectInfo.split("@");
                if (orgEnableMultiFactory.booleanValue()) {
                    manuOrgId = Long.parseLong(split[0]);
                }
                costCenterId = Long.parseLong(split[1]);
            }
            if (checkNumMap.get(infoKey = String.format("%s@%s@%s", manuOrgId, costCenterId, costObjectId)) != null && BigDecimal.ZERO.compareTo((BigDecimal)checkNumMap.get(infoKey)) == 0) continue;
            DynamicObject addWipCost = BusinessDataServiceHelper.newDynamicObject((String)"aca_wipcostchecksave");
            addWipCost.set("org", (Object)orgId);
            addWipCost.set("costaccount", (Object)costAccountId);
            addWipCost.set("period", (Object)currentPeriodId);
            addWipCost.set("manuorg", (Object)manuOrgId);
            addWipCost.set("costcenter", (Object)costCenterId);
            addWipCost.set("costobject", (Object)costObjectId);
            addWipCost.set("finadjustqty", (Object)0);
            addWipCost.set("checknum", (Object)0);
            addWipCost.set("modifier", (Object)userId);
            addWipCost.set("modifytime", (Object)modifyTime);
            addWipCostChecks.add(addWipCost);
        }
        if (CadEmptyUtils.isEmpty(addWipCostChecks) && CadEmptyUtils.isEmpty(updateWipCostChecks)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65e0\u672c\u671f\u5173\u95ed\u5de5\u5355\u7684\u671f\u672b\u5728\u4ea7\u54c1\u6570\u636e\uff0c\u4e0d\u9700\u8981\u5237\u65b0\u3002", (String)"WipCostCheckPlugin_21", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!CadEmptyUtils.isEmpty(updateWipCostChecks)) {
            SaveServiceHelper.update((DynamicObject[])updateWipCostChecks.toArray(new DynamicObject[0]));
        }
        if (!CadEmptyUtils.isEmpty(addWipCostChecks)) {
            SaveServiceHelper.save((DynamicObject[])addWipCostChecks.toArray(new DynamicObject[0]));
        }
        this.loadDataByCondition(orgId, manuOrg, costAccountId, costCenterIds, true);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6570\u636e\u6210\u529f\u3002", (String)"WipCostCheckPlugin_4", (String)"macc-aca-formplugin", (Object[])new Object[0]));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
    }

    private void saveOP() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        String org = this.getView().getPageCache().get("org");
        String costaccount = this.getView().getPageCache().get("costaccount");
        String manuorgf = this.getView().getPageCache().get("manuorgf");
        String costcenterf = this.getView().getPageCache().get("costcenterf");
        String period = this.getView().getPageCache().get("period");
        if (StringUtils.isEmpty((Object)org) || StringUtils.isEmpty((Object)costaccount) || StringUtils.isEmpty((Object)period) || entryentity.size() < 1) {
            return;
        }
        Set costcenterfIds = new HashSet();
        if (!StringUtils.isEmpty((Object)costcenterf)) {
            costcenterfIds = (Set)SerializationUtils.fromJsonString((String)costcenterf, Set.class);
        }
        HashMap<String, WipCostCheckSave> needSaveDataMap = new HashMap<String, WipCostCheckSave>(entryentity.size());
        WipCostCheckService wipCostCheckService = new WipCostCheckService();
        Long orgId = Long.parseLong(org);
        Long costAccountId = Long.parseLong(costaccount);
        Long manuorgId = StringUtils.isEmpty((Object)manuorgf) ? 0L : Long.parseLong(manuorgf);
        DynamicObject sysCtrlPeriod = this.getSysCtrlPeriod(orgId, costAccountId);
        DataSet fullDataSet = wipCostCheckService.loadDataByCondition(orgId, manuorgId, costAccountId, costcenterfIds, sysCtrlPeriod);
        Map checkNumMap = wipCostCheckService.loadDataDataSetConvertMap(fullDataSet);
        int i = 0;
        StringBuilder tipsBuilder = new StringBuilder();
        for (DynamicObject entry : entryentity) {
            ++i;
            Long modifier = entry.getLong("user.id");
            Date opTime = entry.getDate("optime");
            BigDecimal finAdjustQty = entry.getBigDecimal("finadjustqty");
            BigDecimal finCheckQty = entry.getBigDecimal("fincheckqty");
            BigDecimal checknum = entry.getBigDecimal("checknum");
            if (CadEmptyUtils.isEmpty((Long)modifier) || Long.compare(modifier, RequestContext.get().getCurrUserId()) != 0) continue;
            if (checknum == null || checknum.compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u624b\u5de5\u586b\u5199\u7684\u201c\u5b9e\u76d8\u6570\u91cf\u201d \u8303\u56f4\uff0c\u5e94\u5927\u4e8e\u7b49\u4e8e0\uff0c \u8bf7\u68c0\u67e5\u3002", (String)"WipCostCheckPlugin_7", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                return;
            }
            String key = entry.getLong("manuorg.id") + "@" + entry.getLong("costcenter.id") + "@" + entry.getLong("costobject.id");
            needSaveDataMap.put(key, new WipCostCheckSave(finAdjustQty, checknum, modifier, opTime));
        }
        if (needSaveDataMap.size() < 1) {
            String tipStr = this.getTipStr(tipsBuilder);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u4fdd\u5b58\u7684\u7528\u6237\u4fee\u6539\u6570\u636e\u3002%s", (String)"WipCostCheckPlugin_8", (String)"macc-aca-formplugin", (Object[])new Object[0]), tipStr));
            return;
        }
        QFilter orgQf = new QFilter("org", "=", (Object)Long.parseLong(org));
        QFilter periodQf = new QFilter("period", "=", (Object)Long.parseLong(period));
        QFilter costaccountQf = new QFilter("costaccount", "=", (Object)Long.parseLong(costaccount));
        QFilter manuorgfQf = StringUtils.isEmpty((Object)manuorgf) ? null : new QFilter("manuorg", "=", (Object)Long.parseLong(manuorgf));
        Object costcenterQf = null;
        if (!CadEmptyUtils.isEmpty(costcenterfIds)) {
            costaccountQf = new QFilter("costcenter", "in", costcenterfIds);
        }
        DynamicObject[] aca_wipcostchecksaves = BusinessDataServiceHelper.load((String)"aca_wipcostchecksave", (String)"org,manuorg,costcenter,costaccount,period,costobject,checknum,finadjustqty,modifier,modifytime", (QFilter[])new QFilter[]{orgQf, costaccountQf, periodQf, costcenterQf, manuorgfQf}, (String)"modifytime");
        Map<String, DynamicObject> costObjectIdMap = Arrays.stream(aca_wipcostchecksaves).collect(Collectors.toMap(o -> o.getLong("manuorg.id") + "@" + o.getLong("costcenter.id") + "@" + o.getLong("costobject.id"), o -> o, (o1, o2) -> o2));
        ArrayList<DynamicObject> saveDataList = new ArrayList<DynamicObject>(costObjectIdMap.size());
        for (Map.Entry entry : needSaveDataMap.entrySet()) {
            String keyStr = (String)entry.getKey();
            WipCostCheckSave wipCostCheckSave = (WipCostCheckSave)entry.getValue();
            DynamicObject updateData = costObjectIdMap.get(keyStr);
            if (updateData != null) {
                if (wipCostCheckSave.getCheckQty().compareTo(updateData.getBigDecimal("checknum")) == 0 && wipCostCheckSave.getFinAdjustQty().compareTo(updateData.getBigDecimal("finadjustqty")) == 0) continue;
                updateData.set("finadjustqty", (Object)wipCostCheckSave.getFinAdjustQty());
                updateData.set("checknum", (Object)wipCostCheckSave.getCheckQty());
                updateData.set("modifier", (Object)wipCostCheckSave.getOperatorId());
                updateData.set("modifytime", (Object)wipCostCheckSave.getOperateTime());
                saveDataList.add(updateData);
                continue;
            }
            BigDecimal calCheckNum = (BigDecimal)checkNumMap.get(keyStr);
            if (calCheckNum != null && calCheckNum.compareTo(wipCostCheckSave.getCheckQty()) != 0) {
                String[] split = keyStr.split("@");
                updateData = BusinessDataServiceHelper.newDynamicObject((String)"aca_wipcostchecksave");
                updateData.set("org", (Object)Long.parseLong(org));
                updateData.set("costaccount", (Object)Long.parseLong(costaccount));
                updateData.set("period", (Object)Long.parseLong(period));
                updateData.set("manuorg", (Object)Long.valueOf(split[0]));
                updateData.set("costcenter", (Object)Long.valueOf(split[1]));
                updateData.set("costobject", (Object)Long.valueOf(split[2]));
                updateData.set("finadjustqty", (Object)wipCostCheckSave.getFinAdjustQty());
                updateData.set("checknum", (Object)wipCostCheckSave.getCheckQty());
                updateData.set("modifier", (Object)wipCostCheckSave.getOperatorId());
                updateData.set("modifytime", (Object)wipCostCheckSave.getOperateTime());
                saveDataList.add(updateData);
                continue;
            }
            tipsBuilder.append(i).append(',');
        }
        if (saveDataList.size() < 1) {
            String tipStr = this.getTipStr(tipsBuilder);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7528\u6237\u672a\u4fee\u6539\u6570\u636e\uff0c\u6ca1\u6709\u9700\u8981\u4fdd\u5b58\u7684\u7528\u6237\u6570\u636e\u3002%s", (String)"WipCostCheckPlugin_9", (String)"macc-aca-formplugin", (Object[])new Object[0]), tipStr));
            return;
        }
        SaveServiceHelper.save((DynamicObject[])saveDataList.toArray(new DynamicObject[0]));
        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u6210\u529f\u4fee\u6539\u6570\u636e %1$s \u6761\u3002%2$s", (String)"WipCostCheckPlugin_16", (String)"macc-aca-formplugin", (Object[])new Object[0]), saveDataList.size(), this.getTipStr(tipsBuilder)));
    }

    private String getTipStr(StringBuilder tipsBuilder) {
        if (tipsBuilder.length() > 0) {
            tipsBuilder.setLength(tipsBuilder.length() - 1);
            return String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\u6570\u636e\uff0c\u60a8\u5f55\u5165\u7684\u5b9e\u76d8\u6570\u91cf\u4e0e\u8ba1\u7b97\u4e00\u81f4\uff0c\u65e0\u9700\u624b\u5de5\u5f55\u5165\u3002", (String)"WipCostCheckPlugin_11", (String)"macc-aca-formplugin", (Object[])new Object[0]), tipsBuilder.toString());
        }
        return "";
    }

    private void changeValueBychecknum(BigDecimal newCheckNum, int rowIndex) {
        BigDecimal endproducting = (BigDecimal)this.getModel().getValue("endproducting", rowIndex);
        BigDecimal endproductchange = (BigDecimal)this.getModel().getValue("endproductchange", rowIndex);
        BigDecimal profitnum = newCheckNum.subtract(this.getBigDecimalValue(endproducting)).subtract(this.getBigDecimalValue(endproductchange));
        this.getModel().setValue("profitnum", (Object)profitnum, rowIndex);
        this.getModel().setValue("user", (Object)RequestContext.get().getCurrUserId(), rowIndex);
        this.getModel().setValue("optime", (Object)new Date(), rowIndex);
        this.getView().updateView("profitnum", rowIndex);
    }

    private TableValueSetter getTableValueSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("period", new Object[0]);
        vs.addField("manuorg", new Object[0]);
        vs.addField("costcenter", new Object[0]);
        vs.addField("costobject", new Object[0]);
        vs.addField("startnum", new Object[0]);
        vs.addField("startchangenum", new Object[0]);
        vs.addField("currentinput", new Object[0]);
        vs.addField("currentfinish", new Object[0]);
        vs.addField("finadjustqty", new Object[0]);
        vs.addField("fincheckqty", new Object[0]);
        vs.addField("endproductchange", new Object[0]);
        vs.addField("endproducting", new Object[0]);
        vs.addField("material", new Object[0]);
        vs.addField("auxpty", new Object[0]);
        vs.addField("user", new Object[0]);
        vs.addField("optime", new Object[0]);
        vs.addField("checknum", new Object[0]);
        vs.addField("profitnum", new Object[0]);
        return vs;
    }

    private String loadDataByCondition(Long orgId, Long manuorgfId, Long costaccountId, Set<Long> costcenterfId, Boolean isLoadUserData) {
        boolean enableMulFactory;
        if (CadEmptyUtils.isEmpty((Long)orgId)) {
            return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipCostCheckPlugin_12", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        }
        if (CadEmptyUtils.isEmpty((Long)costaccountId)) {
            return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"WipCostCheckPlugin_13", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        }
        DynamicObject sysCtrlPeriod = this.getSysCtrlPeriod(orgId, costaccountId);
        if (sysCtrlPeriod == null) {
            return ResManager.loadKDString((String)"\u901a\u8fc7\u6838\u7b97\u7ec4\u7ec7\u548c\u6210\u672c\u8d26\u7c3f,\u5728\u201c\u542f\u7528\u6807\u51c6\u6838\u7b97\u201d\u4e2d\u672a\u627e\u5230\u5f53\u524d\u671f\u95f4,\u8bf7\u7ef4\u62a4\u542f\u7528\u6807\u51c6\u6838\u7b97\u6570\u636e\u3002", (String)"WipCostCheckPlugin_14", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        }
        Date begindate = sysCtrlPeriod.getDate("begindate");
        Date enddate = sysCtrlPeriod.getDate("enddate");
        if (begindate == null || enddate == null) {
            return ResManager.loadKDString((String)"\u901a\u8fc7\u6838\u7b97\u7ec4\u7ec7\u548c\u6210\u672c\u8d26\u7c3f,\u5728\u201c\u542f\u7528\u6807\u51c6\u6838\u7b97\u201d\u4e2d\u7684\u5f53\u524d\u671f\u95f4\u672a\u7ef4\u62a4\u5f00\u59cb\u65e5\u671f\u548c\u7ed3\u675f\u65e5\u671f,\u8bf7\u7ef4\u62a4\u4f1a\u8ba1\u671f\u95f4\u6570\u636e\u3002", (String)"WipCostCheckPlugin_15", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        }
        DataSet fullDataSet = new WipCostCheckService().loadDataByCondition(orgId, manuorgfId, costaccountId, costcenterfId, sysCtrlPeriod).orderBy(new String[]{"manuorg", "costcenter", "costobject"});
        Map<Object, Object> userDataMap = null;
        userDataMap = isLoadUserData != false ? this.getUserDataByHang(orgId, manuorgfId, costaccountId, costcenterfId, sysCtrlPeriod) : new HashMap();
        StringBuilder keyBuilder = new StringBuilder();
        this.getModel().deleteEntryData("entryentity");
        TableValueSetter vs = this.getTableValueSetter();
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        this.getModel().beginInit();
        while (fullDataSet.hasNext()) {
            BigDecimal checknum;
            keyBuilder.setLength(0);
            Row row = fullDataSet.next();
            BigDecimal startnum = this.getBigDecimalValue(row.getBigDecimal("startnum"));
            BigDecimal endproductchange = this.getBigDecimalValue(row.getBigDecimal("endproductchange"));
            BigDecimal currentinput = this.getBigDecimalValue(row.getBigDecimal("currentinput"));
            BigDecimal currentfinish = this.getBigDecimalValue(row.getBigDecimal("currentfinish"));
            BigDecimal startchangenum = this.getBigDecimalValue(row.getBigDecimal("startchangenum"));
            Long manuorg = row.getLong("manuorg");
            Long costcenter = row.getLong("costcenter");
            Long costobject = row.getLong("costobject");
            String key = keyBuilder.append(manuorg).append("@").append(costcenter).append("@").append(costobject).toString();
            WipCostCheckSave userData = (WipCostCheckSave)userDataMap.get(key);
            if (CadEmptyUtils.isEmpty((BigDecimal)startnum) && CadEmptyUtils.isEmpty((BigDecimal)endproductchange) && CadEmptyUtils.isEmpty((BigDecimal)currentinput) && CadEmptyUtils.isEmpty((BigDecimal)currentfinish) && CadEmptyUtils.isEmpty((BigDecimal)startchangenum) && userData == null) continue;
            Object[] container = new Object[vs.getFields().size()];
            int index = 0;
            container[index++] = sysCtrlPeriod.getLong("currentperiod");
            container[index++] = manuorg;
            container[index++] = costcenter;
            container[index++] = costobject;
            container[index++] = startnum;
            container[index++] = startchangenum;
            container[index++] = currentinput;
            container[index++] = currentfinish;
            BigDecimal finAdjustQty = BigDecimal.ZERO;
            BigDecimal finCheckQty = currentfinish;
            if (userData != null) {
                finAdjustQty = userData.getFinAdjustQty();
                finCheckQty = currentfinish.add(finAdjustQty);
            }
            container[index++] = finAdjustQty;
            container[index++] = finCheckQty;
            container[index++] = endproductchange;
            BigDecimal endproducting = startnum.add(startchangenum).add(currentinput).subtract(finCheckQty);
            container[index++] = endproducting;
            container[index++] = row.getLong("material");
            container[index++] = row.getLong("auxpty");
            if (userData == null) {
                checknum = endproducting;
                container[index++] = null;
                container[index++] = null;
            } else {
                checknum = userData.getCheckQty();
                container[index++] = userData.getOperatorId();
                container[index++] = userData.getOperateTime();
            }
            container[index++] = checknum;
            container[index++] = checknum.subtract(endproducting).subtract(endproductchange);
            keyBuilder.setLength(0);
            vs.addRow(container);
            if (vs.getCount() < 1000) continue;
            model.batchCreateNewEntryRow("entryentity", vs);
            vs = this.getTableValueSetter();
        }
        if (vs.getCount() > 0) {
            model.batchCreateNewEntryRow("entryentity", vs);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        this.getView().getPageCache().put("org", String.valueOf(orgId));
        this.getView().getPageCache().put("costaccount", String.valueOf(costaccountId));
        this.getView().getPageCache().put("period", String.valueOf(sysCtrlPeriod.getLong("currentperiod")));
        this.getView().getPageCache().put("manuorgf", CadEmptyUtils.isEmpty((Long)manuorgfId) ? "" : String.valueOf(manuorgfId));
        this.getView().getPageCache().put("costcenterf", SerializationUtils.toJsonString(costcenterfId));
        if (!isLoadUserData.booleanValue()) {
            QFilter orgQf = new QFilter("org", "=", (Object)orgId);
            QFilter periodQf = new QFilter("period", "=", (Object)sysCtrlPeriod.getLong("currentperiod"));
            QFilter costaccountQf = new QFilter("costaccount", "=", (Object)costaccountId);
            QFilter manuorgQf = CadEmptyUtils.isEmpty((Long)manuorgfId) ? null : new QFilter("manuorg", "=", (Object)manuorgfId);
            QFilter costcenterQf = CadEmptyUtils.isEmpty(costcenterfId) ? null : new QFilter("costcenter", "in", costcenterfId);
            DeleteServiceHelper.delete((String)"aca_wipcostchecksave", (QFilter[])new QFilter[]{orgQf, costaccountQf, manuorgQf, costcenterQf, periodQf});
        }
        if (!(enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId))) {
            this.getModel().setValue("manuorgf", null);
        }
        this.getView().setVisible(Boolean.valueOf(enableMulFactory), new String[]{"manuorgf", "manuorg", "manuorgname"});
        this.getView().updateView("entryentity");
        return "Y";
    }

    private Map<String, WipCostCheckSave> getUserDataByHang(Long orgId, Long manuorgfId, Long costaccountId, Set<Long> costcenterfId, DynamicObject period) {
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter periodQf = new QFilter("period", "=", (Object)period.getLong("currentperiod"));
        QFilter costaccountQf = new QFilter("costaccount", "=", (Object)costaccountId);
        QFilter manuorgQf = CadEmptyUtils.isEmpty((Long)manuorgfId) ? null : new QFilter("manuorg", "=", (Object)manuorgfId);
        QFilter costcenterQf = CadEmptyUtils.isEmpty(costcenterfId) ? null : new QFilter("costcenter", "in", costcenterfId);
        DataSet rows = QueryServiceHelper.queryDataSet((String)"getUserDataByHang", (String)"aca_wipcostchecksave", (String)"manuorg,costcenter,costobject,finadjustqty,checknum,modifier,modifytime", (QFilter[])new QFilter[]{orgQf, costaccountQf, costcenterQf, manuorgQf, periodQf}, (String)"modifytime");
        HashMap<String, WipCostCheckSave> userDataMap = new HashMap<String, WipCostCheckSave>(8);
        StringBuilder keyBuilder = new StringBuilder();
        while (rows.hasNext()) {
            Row row = rows.next();
            Long manuorg = row.getLong("manuorg");
            Long costcenter = row.getLong("costcenter");
            Long costobject = row.getLong("costobject");
            BigDecimal finAdjustQty = row.getBigDecimal("finadjustqty");
            BigDecimal checknum = row.getBigDecimal("checknum");
            Long modifier = row.getLong("modifier");
            Date modifytime = row.getDate("modifytime");
            String key = keyBuilder.append(manuorg).append("@").append(costcenter).append("@").append(costobject).toString();
            WipCostCheckSave wipCostCheckSave = new WipCostCheckSave(finAdjustQty, checknum, modifier, modifytime);
            userDataMap.put(key, wipCostCheckSave);
            keyBuilder.setLength(0);
        }
        return userDataMap;
    }

    private BigDecimal getBigDecimalValue(BigDecimal startnum) {
        return CadEmptyUtils.isEmpty((BigDecimal)startnum) ? BigDecimal.ZERO : startnum;
    }

    private DynamicObject getSysCtrlPeriod(Long orgId, Long costaccountId) {
        QFilter periodfilter = new QFilter("org", "=", (Object)orgId);
        periodfilter.and(new QFilter("entry.costaccount", "=", (Object)costaccountId));
        DynamicObjectCollection cal_sysctrlentity = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id,entry.currentperiod.id currentperiod,entry.currentperiod.begindate as begindate,entry.currentperiod.enddate as enddate", (QFilter[])periodfilter.toArray());
        if (cal_sysctrlentity.size() > 0) {
            return (DynamicObject)cal_sysctrlentity.get(0);
        }
        return null;
    }

    private Long getDynamicObjectValueId(String fileName) {
        DynamicObject orgData = (DynamicObject)this.getModel().getValue(fileName);
        return orgData == null ? 0L : orgData.getLong("id");
    }

    private void changeManuorgStatus(Boolean refreshEntry) {
        Object org = this.getModel().getValue("org");
        if (!ObjectUtils.isEmpty((Object)org)) {
            DynamicObject orgData = (DynamicObject)org;
            boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)((Long)orgData.getPkValue()));
            if (!enableMulFactory) {
                this.getModel().setValue("manuorgf", null);
            }
            if (refreshEntry.booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(enableMulFactory), new String[]{"manuorgf", "manuorg", "manuorgname"});
            } else {
                this.getView().setVisible(Boolean.valueOf(enableMulFactory), new String[]{"manuorgf"});
            }
        } else {
            if (refreshEntry.booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorgf", "manuorg", "manuorgname"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorgf"});
            }
            this.getModel().setValue("manuorgf", null);
        }
    }

    private Long getCostAccountByAccoutOrg() {
        QFilter appNumQF;
        QFilter[] filters;
        DynamicObjectCollection result;
        Object org = this.getModel().getValue("org");
        if (org == null) {
            return 0L;
        }
        Long accountOrgId = ((DynamicObject)org).getLong("id");
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name,entryentity.costaccount.ismainaccount ismainaccount";
        QFilter orgFilter = new QFilter("org", "=", (Object)accountOrgId);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (kd.bos.util.StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId())) {
            appId = "aca";
        }
        if ((result = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])(filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable, appNumQF = new QFilter("appnum", "=", (Object)appId)}), null)) == null || result.size() == 0) {
            return null;
        }
        if (result.size() == 1) {
            DynamicObject costaccount = (DynamicObject)result.get(0);
            return costaccount.getLong("id");
        }
        for (DynamicObject res : result) {
            if (!res.getBoolean("ismainaccount")) continue;
            return res.getLong("id");
        }
        return null;
    }

    private void showImportstart() {
        FormShowParameter paramGroups = new FormShowParameter();
        paramGroups.getOpenStyle().setShowType(ShowType.Modal);
        paramGroups.setFormId("bos_importstart");
        HashMap<String, String> customParam = new HashMap<String, String>();
        customParam.put("BillFormId", "aca_wipcostchecksave");
        customParam.put("ListName", ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u76d8\u70b9\u5f55\u5165\u5217\u8868", (String)"WipCostCheckPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        customParam.put("ImportPlugin", "kd.macc.aca.opplugin.wipcostcheck.WipCostCheckImportPlugin");
        customParam.put("ServiceAppId", "aca");
        paramGroups.setCustomParams(customParam);
        paramGroups.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importstart"));
        this.getView().showForm(paramGroups);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        switch (e.getActionId()) {
            case "importstart": {
                Long orgId = this.getDynamicObjectValueId("org");
                Long manuorgfId = this.getDynamicObjectValueId("manuorgf");
                Long costaccountId = this.getDynamicObjectValueId("costaccount");
                Set<Long> costcenterfId = this.getDynamicObjectCollectionValueId("costcenterf");
                this.loadDataByCondition(orgId, manuorgfId, costaccountId, costcenterfId, true);
                this.changeManuorgStatus(true);
            }
        }
    }
}

