/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.business.invocation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.business.invocation.AutoExecInvocationChain;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLog;
import kd.macc.cad.common.dto.SchemeLogDetail;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class AcaAutoExecShemeEntrance {
    public static Map<String, LocaleString> getBussinessAndOperKeyNameMap() {
        HashMap<String, LocaleString> businessAndOperKeyNameMap = new HashMap<String, LocaleString>(32, 0.75f);
        businessAndOperKeyNameMap.put("cad_costobject", new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61", (String)"AcaAutoExecShemeEntrance_0", (String)"macc-aca-business", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("sca_resourceuse", new LocaleString(ResManager.loadKDString((String)"\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6", (String)"AcaAutoExecShemeEntrance_1", (String)"macc-aca-business", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("cad_plannedoutputbill", new LocaleString(ResManager.loadKDString((String)"\u8ba1\u5212\u751f\u4ea7\u6570\u91cf\u5f52\u96c6", (String)"AcaAutoExecShemeEntrance_2", (String)"macc-aca-business", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("cad_factnedoutputbill", new LocaleString(ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u6570\u91cf\u5f52\u96c6", (String)"AcaAutoExecShemeEntrance_3", (String)"macc-aca-business", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("aca_matusecollect", new LocaleString(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5f52\u96c6", (String)"AcaAutoExecShemeEntrance_4", (String)"macc-aca-business", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("aca_mfgfeebill", new LocaleString(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5f52\u96c6", (String)"AcaAutoExecShemeEntrance_5", (String)"macc-aca-business", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("aca_matalloc", new LocaleString(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d", (String)"AcaAutoExecShemeEntrance_6", (String)"macc-aca-business", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("aca_mfgfeealloccc", new LocaleString(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5206\u914d\uff08\u6210\u672c\u4e2d\u5fc3\u95f4\uff09", (String)"AcaAutoExecShemeEntrance_7", (String)"macc-aca-business", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("aca_mfgfeeallocco", new LocaleString(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5206\u914d\uff08\u6210\u672c\u4e2d\u5fc3\uff09", (String)"AcaAutoExecShemeEntrance_8", (String)"macc-aca-business", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("COSTBOM", new LocaleString(ResManager.loadKDString((String)"\u540c\u6b65\u5236\u9020BOM", (String)"AcaAutoExecShemeEntrance_9", (String)"macc-aca-business", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("ROUTER", new LocaleString(ResManager.loadKDString((String)"\u540c\u6b65\u5236\u9020\u5de5\u827a\u8def\u7ebf", (String)"AcaAutoExecShemeEntrance_10", (String)"macc-aca-business", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("SYSIMPORT", new LocaleString(ResManager.loadKDString((String)"\u4ece\u5185\u90e8\u7cfb\u7edf\u5f15\u5165", (String)"AcaAutoExecShemeEntrance_11", (String)"macc-aca-business", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("ALLOC", new LocaleString(ResManager.loadKDString((String)"\u5206\u914d", (String)"AcaAutoExecShemeEntrance_12", (String)"macc-aca-business", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("ODERIMPORT", new LocaleString(ResManager.loadKDString((String)"\u4ece\u751f\u4ea7\u5de5\u5355\u5f15\u5165", (String)"AcaAutoExecShemeEntrance_13", (String)"macc-aca-business", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("PROREPORT", new LocaleString(ResManager.loadKDString((String)"\u4ece\u5de5\u5e8f\u6c47\u62a5\u5f15\u5165", (String)"AcaAutoExecShemeEntrance_14", (String)"macc-aca-business", (Object[])new Object[0])));
        businessAndOperKeyNameMap.put("IMPORT", new LocaleString(ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"AcaAutoExecShemeEntrance_15", (String)"macc-aca-business", (Object[])new Object[0])));
        return businessAndOperKeyNameMap;
    }

    public static void executeSchemeById(Object schemeId, Object appId) {
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"sca_autoexecsheme");
        if (scheme != null) {
            AutoExecSchemeDTO autoExecSchemeDTO = new AutoExecSchemeDTO();
            AcaAutoExecShemeEntrance.buildAutoExecSchemeDTO(scheme, autoExecSchemeDTO, appId);
            autoExecSchemeDTO.getSchemeLog().setStarttime(new Date());
            AutoExecInvocationChain invocationChain = new AutoExecInvocationChain(autoExecSchemeDTO);
            invocationChain.exec();
            autoExecSchemeDTO.getSchemeLog().setEndtime(new Date());
            autoExecSchemeDTO.getSchemeLog().setSchemeId(Long.valueOf(scheme.getLong("id")));
            AcaAutoExecShemeEntrance.writeSchemeLog(autoExecSchemeDTO);
        }
    }

    public static List<Long> getTargetList(List<Long[]> sourceList, int index) {
        ArrayList<Long> targetList = new ArrayList<Long>(sourceList.size());
        for (Long[] source : sourceList) {
            targetList.add(source[index]);
        }
        return targetList;
    }

    public static Map<Long, List<Object>> getOrgCostCenterMap(List<Long> orgList) {
        HashMap<Long, List<Object>> resultMap = new HashMap<Long, List<Object>>(16);
        for (Long org : orgList) {
            List<Object> costCenters = AcaAutoExecShemeEntrance.getCostCenterByOrg(org);
            resultMap.put(org, costCenters);
        }
        return resultMap;
    }

    public static Map<Long, List<Object>> getOrgAndSysImportCostCostCenterMap(List<Long> acctOrgIds, String appNum, String filterStr, String importType) {
        HashMap<Long, List<Object>> resultMap = new HashMap<Long, List<Object>>(16);
        QFilter orgFilter = new QFilter("accountorg", "in", acctOrgIds);
        QFilter appFilter = new QFilter("appnum", "=", (Object)appNum);
        QFilter tabFilter = new QFilter("tab", "=", (Object)"costaccumultabpage");
        DynamicObjectCollection params = QueryServiceHelper.query((String)"cad_sysparam", (String)("accountorg,costcenter," + filterStr), (QFilter[])new QFilter[]{orgFilter, appFilter, tabFilter});
        HashMap<Long, List> resultByNotCover = new HashMap<Long, List>(16);
        for (DynamicObject param : params) {
            Long accountorg = param.getLong("accountorg");
            Long costcenter = param.getLong("costcenter");
            String type = param.getString(filterStr);
            if (!importType.equals(type) && !CadEmptyUtils.isEmpty((Long)costcenter)) {
                resultByNotCover.computeIfAbsent(accountorg, k -> new ArrayList()).add(costcenter);
            }
            if (importType.equals(type) && !CadEmptyUtils.isEmpty((Long)costcenter)) {
                resultMap.computeIfAbsent(accountorg, k -> new ArrayList()).add(costcenter);
                continue;
            }
            if (!importType.equals(type) || !CadEmptyUtils.isEmpty((Long)costcenter)) continue;
            resultMap.computeIfAbsent(accountorg, k -> new ArrayList()).addAll(AcaAutoExecShemeEntrance.getCostCenterByOrg(accountorg));
        }
        for (Map.Entry res : resultMap.entrySet()) {
            List notCovers = (List)resultByNotCover.get(res.getKey());
            List values = (List)res.getValue();
            if (notCovers == null || CadEmptyUtils.isEmpty((List)notCovers)) continue;
            Iterator it = values.iterator();
            while (it.hasNext()) {
                Object aValue = it.next();
                if (!notCovers.contains(aValue)) continue;
                it.remove();
            }
            resultMap.put((Long)res.getKey(), values);
        }
        return resultMap;
    }

    private static List<Object> getCostCenterByOrg(Long orgId) {
        QFilter orgFilter = new QFilter("accountorg", "=", (Object)orgId);
        QFilter orgdutyFilter = new QFilter("orgduty", "=", (Object)4L);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"bos_costcenter", (QFilter[])new QFilter[]{orgFilter, orgdutyFilter}, null, (int)9999);
        return ids;
    }

    public static Map<Long, List<Long>> getOrgCostAccountMap(List<Long> orgList, List<Long> costAccountList, String appNum) {
        HashMap<Long, List<Long>> orgCostAccountMap = new HashMap<Long, List<Long>>(16);
        for (int i = 0; i < orgList.size(); ++i) {
            Long orgId = orgList.get(i);
            Long costAccount = costAccountList.get(i);
            if (costAccount == null || costAccount == 0L) {
                DynamicObjectCollection costAccounts = StartCostHelper.getCostAccounts((Long)orgId, (Boolean)Boolean.TRUE, (String)appNum);
                List ids = costAccounts.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                orgCostAccountMap.put(orgId, ids);
                continue;
            }
            orgCostAccountMap.put(orgId, Collections.singletonList(costAccount));
        }
        return orgCostAccountMap;
    }

    private static void writeSchemeLog(AutoExecSchemeDTO autoExecSchemeDTO) {
        SchemeLog schemeLog = autoExecSchemeDTO.getSchemeLog();
        DynamicObject dObj = BusinessDataServiceHelper.newDynamicObject((String)"sca_schemelog");
        dObj.set("scheme", (Object)schemeLog.getSchemeId());
        dObj.set("starttime", (Object)schemeLog.getStarttime());
        dObj.set("endtime", (Object)schemeLog.getEndtime());
        dObj.set("executeresult", (Object)schemeLog.getExecuteResult());
        dObj.set("appnum", (Object)autoExecSchemeDTO.getAppnum());
        DynamicObjectCollection entryentity = dObj.getDynamicObjectCollection("entryentity");
        List schemeLogDetail = schemeLog.getSchemeLogDetail();
        for (SchemeLogDetail logDetail : schemeLogDetail) {
            DynamicObject entry = entryentity.addNew();
            entry.set("businessname", (Object)logDetail.getBusinessname());
            entry.set("opername", (Object)logDetail.getOpername());
            entry.set("detail", (Object)logDetail.getDetail());
            entry.set("sourcesys", (Object)0L);
            entry.set("sourceentity", (Object)0L);
            entry.set("sourcebillno", (Object)"");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObj});
    }

    public static void buildSchemeLogDetail(AutoExecSchemeDTO autoExecSchemeDTO, String executeResult, String entityName, String operKey, String detail) {
        if (executeResult != null) {
            autoExecSchemeDTO.getSchemeLog().setExecuteResult(executeResult);
        }
        List schemeLogDetailList = autoExecSchemeDTO.getSchemeLog().getSchemeLogDetail();
        Map<String, LocaleString> bussinessAndOperKeyNameMap = AcaAutoExecShemeEntrance.getBussinessAndOperKeyNameMap();
        SchemeLogDetail schemeLogDetail = new SchemeLogDetail();
        schemeLogDetail.setBusinessname(bussinessAndOperKeyNameMap.get(entityName).toString());
        schemeLogDetail.setOpername(bussinessAndOperKeyNameMap.get(operKey).toString());
        schemeLogDetail.setDetail(detail);
        schemeLogDetailList.add(schemeLogDetail);
    }

    public static void buildSchemeLogDetail(AutoExecSchemeDTO autoExecSchemeDTO, String executeResult, String entityName, String operKey, String detail, List<SchemeLogSubDetail> schemeLogSubDetail) {
        if (executeResult != null) {
            autoExecSchemeDTO.getSchemeLog().setExecuteResult(executeResult);
        }
        List schemeLogDetailList = autoExecSchemeDTO.getSchemeLog().getSchemeLogDetail();
        Map<String, LocaleString> bussinessAndOperKeyNameMap = AcaAutoExecShemeEntrance.getBussinessAndOperKeyNameMap();
        SchemeLogDetail schemeLogDetail = new SchemeLogDetail();
        schemeLogDetail.setBusinessname(bussinessAndOperKeyNameMap.get(entityName).toString());
        schemeLogDetail.setOpername(bussinessAndOperKeyNameMap.get(operKey).toString());
        schemeLogDetail.setDetail(detail);
        schemeLogDetail.setSchemeLogSubDetail(schemeLogSubDetail);
        schemeLogDetailList.add(schemeLogDetail);
    }

    public static String getMsgFromExecuteResult(ExecuteResult executeResult) {
        Map info = executeResult.isSuccess() ? executeResult.getSuccessInfo() : executeResult.getFalseInfo();
        Map.Entry msgMap = info.entrySet().iterator().next();
        return (String)msgMap.getValue();
    }

    public static String getNameById(String entityName, Long id) {
        DynamicObject query = QueryServiceHelper.queryOne((String)entityName, (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        return query == null ? "" : query.getString("name");
    }

    private static void buildAutoExecSchemeDTO(DynamicObject scheme, AutoExecSchemeDTO autoExecSchemeDTO, Object appId) {
        autoExecSchemeDTO.setAppnum(appId == null ? "" : appId.toString());
        autoExecSchemeDTO.setExecutor(Long.valueOf(scheme.getLong("executor.id")));
        DynamicObjectCollection operationentry = scheme.getDynamicObjectCollection("entryentity");
        ArrayList<String[]> entityAndOperKeyList = new ArrayList<String[]>(operationentry.size());
        for (DynamicObject operInfo : operationentry) {
            String[] entityAndOperKeyArr = new String[]{operInfo.getString("businesstype"), operInfo.getString("autoexecoper.number")};
            entityAndOperKeyList.add(entityAndOperKeyArr);
        }
        autoExecSchemeDTO.setEntityAndOperKeyList(entityAndOperKeyList);
        DynamicObjectCollection orgentry = scheme.getDynamicObjectCollection("orgentry");
        ArrayList<Long[]> orgCostAccountUserList = new ArrayList<Long[]>(orgentry.size());
        for (DynamicObject orgentryInfo : orgentry) {
            Long[] orgCostAccountUserArr = new Long[]{orgentryInfo.getLong("org.id"), orgentryInfo.getLong("costaccount.id"), orgentryInfo.getLong("user.id")};
            orgCostAccountUserList.add(orgCostAccountUserArr);
        }
        autoExecSchemeDTO.setOrgCostAccountUserList(orgCostAccountUserList);
    }

    public static Long getReceiverByOrg(AutoExecSchemeDTO autoExecSchemeDTO, Long orgId) {
        List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
        for (Long[] orgCostAccountUser : orgCostAccountUserList) {
            Long userId;
            if (Long.compare(orgCostAccountUser[0], orgId) != 0 || (userId = orgCostAccountUser[2]) == 0L) continue;
            return userId;
        }
        return null;
    }
}

