/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.business.invocation.closeaccount;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.common.closeaccount.AcaCloseAccountParam;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class AcaCloseAccountBiz {
    private List<AcaCloseAccountParam> acaCloseAccountParams;

    public AcaCloseAccountBiz(List<AcaCloseAccountParam> closeAccountParams) {
        this.acaCloseAccountParams = closeAccountParams;
    }

    public Map<String, String> doCloseAccount() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < this.acaCloseAccountParams.size(); ++i) {
            AcaCloseAccountParam param = this.acaCloseAccountParams.get(i);
            DynamicObjectCollection col = this.checkCloseIsDone(param);
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)col) && param.getClosePeriod().longValue() == ((DynamicObject)col.get(0)).getLong("closeperiod")) {
                String key = this.buildMapKeyString(param);
                String errorMsg = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u201c%1$s\u201d\u548c\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u4e0b\u7684\u201c\u5f53\u524d\u671f\u95f4\u201d\u5df2\u5173\u8d26\u3002", (String)"AcaCloseAccountBiz_3", (String)"macc-aca-business", (Object[])new Object[0]), param.getManuOrgName(), param.getCostAccountName());
                map.put(key, errorMsg);
                continue;
            }
            DynamicObjectCollection col2 = this.checkCalResultBillIsExist(param);
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)col2)) {
                String key = this.buildMapKeyString(param);
                String errorMsg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u548c\u751f\u4ea7\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\u672a\u8fdb\u884c\u6210\u672c\u8ba1\u7b97\u3002", (String)"AcaCloseAccountBiz_4", (String)"macc-aca-business", (Object[])new Object[0]), param.getCalOrgName(), param.getManuOrgName());
                map.put(key, errorMsg);
                continue;
            }
            this.closeAccount(param, col);
        }
        return map;
    }

    public Map<String, String> undoCloseAccount() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < this.acaCloseAccountParams.size(); ++i) {
            AcaCloseAccountParam param = this.acaCloseAccountParams.get(i);
            List<Object> pkIdList = this.checkDataIsExist(param);
            if (CadEmptyUtils.isEmpty(pkIdList)) {
                String key = this.buildMapKeyString(param);
                String errorMsg = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u201c%1$s\u201d\u548c\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u5f53\u524d\u671f\u95f4\u672a\u5173\u8d26\u3002", (String)"AcaCloseAccountBiz_5", (String)"macc-aca-business", (Object[])new Object[0]), param.getManuOrgName(), param.getCostAccountName());
                map.put(key, errorMsg);
                continue;
            }
            this.unCloseAccount(pkIdList);
        }
        return map;
    }

    private void closeAccount(AcaCloseAccountParam param, DynamicObjectCollection col) {
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)col)) {
            DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"aca_closeaccounttable");
            dyn.set("calorg", (Object)param.getCalOrg());
            dyn.set("manuorg", (Object)param.getManuOrg());
            dyn.set("costaccount", (Object)param.getCostAccount());
            dyn.set("closeperiod", (Object)param.getClosePeriod());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
        } else {
            DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)col.get(0)).getLong("id"), (String)"aca_closeaccounttable");
            dyn.set("closeperiod", (Object)param.getClosePeriod());
            SaveServiceHelper.update((DynamicObject)dyn);
        }
    }

    private void unCloseAccount(List<Object> list) {
        DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"aca_closeaccounttable"), (Object[])list.toArray());
    }

    private DynamicObjectCollection checkCalResultBillIsExist(AcaCloseAccountParam param) {
        QFilter qFilter = new QFilter("org", "=", (Object)param.getCalOrg());
        qFilter.and(new QFilter("costobject.manuorg", "=", (Object)param.getManuOrg()));
        qFilter.and(new QFilter("costaccount", "=", (Object)param.getCostAccount()));
        qFilter.and(new QFilter("period", "=", (Object)param.getClosePeriod()));
        return QueryServiceHelper.query((String)"aca_calcresult", (String)"org.name orgname,costobject.manuorg.name manuorgname", (QFilter[])qFilter.toArray());
    }

    private DynamicObjectCollection checkCloseIsDone(AcaCloseAccountParam param) {
        QFilter qFilter = this.buildQueryDataQFilter(param);
        return QueryServiceHelper.query((String)"aca_closeaccounttable", (String)"id,manuorg.name manuorgname,costaccount.name costaccountname,closeperiod", (QFilter[])qFilter.toArray());
    }

    private QFilter buildQueryDataQFilter(AcaCloseAccountParam param) {
        QFilter qFilter = new QFilter("calorg", "=", (Object)param.getCalOrg());
        qFilter.and(new QFilter("manuorg", "=", (Object)param.getManuOrg()));
        qFilter.and(new QFilter("costaccount", "=", (Object)param.getCostAccount()));
        return qFilter;
    }

    private String buildMapKeyString(AcaCloseAccountParam param) {
        String calOrg = String.valueOf(param.getCalOrg());
        String manuOrg = String.valueOf(param.getManuOrg());
        String costAccount = String.valueOf(param.getCostAccount());
        return calOrg + "&" + manuOrg + "&" + costAccount;
    }

    private List<Object> checkDataIsExist(AcaCloseAccountParam param) {
        QFilter qFilter = new QFilter("calorg", "=", (Object)param.getCalOrg());
        qFilter.and(new QFilter("manuorg", "=", (Object)param.getManuOrg()));
        qFilter.and(new QFilter("costaccount", "=", (Object)param.getCostAccount()));
        return QueryServiceHelper.queryPrimaryKeys((String)"aca_closeaccounttable", (QFilter[])qFilter.toArray(), null, (int)-1);
    }
}

