/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.business.invocation.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.business.invocation.AcaAutoExecShemeEntrance;
import kd.macc.aca.business.invocation.Executor;
import kd.macc.aca.business.invocation.executor.CostObjectOperExecutor;
import kd.macc.aca.common.enums.EntityOperEnum;
import kd.macc.aca.common.enums.SchemeExecuteResultEnum;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class FactnedOutputOperExecutor
implements Executor {
    private static final Log logger = LogFactory.getLog(CostObjectOperExecutor.class);
    private String operKey;

    public FactnedOutputOperExecutor(String operKey) {
        this.operKey = operKey;
    }

    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (EntityOperEnum.OPER_SYSIMPORT.getValue().equals(this.operKey)) {
            int sum = 0;
            List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
            if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
                AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "cad_factnedoutputbill", this.operKey, FAIL);
                return false;
            }
            boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)autoExecSchemeDTO.getExecutor(), (String)autoExecSchemeDTO.getAppnum(), (String)"cad_factnedoutputbill", (String)"47156aff000000ac");
            if (!hasPerm) {
                AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "cad_factnedoutputbill", this.operKey, NO_PERM);
                return false;
            }
            ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
            List<Long> orgList = AcaAutoExecShemeEntrance.getTargetList(orgCostAccountUserList, 0);
            Map<Long, List<Object>> orgAndSysImportCostCostCenterMap = AcaAutoExecShemeEntrance.getOrgAndSysImportCostCostCenterMap(orgList, autoExecSchemeDTO.getAppnum(), "completetype", "OBJECTRULE");
            for (Map.Entry<Long, List<Object>> entry : orgAndSysImportCostCostCenterMap.entrySet()) {
                if (CollectionUtils.isEmpty((Collection)entry.getValue())) continue;
                for (Object costcenter : entry.getValue()) {
                    logger.info("\u81ea\u52a8\u6267\u884c-\u5b8c\u5de5\u5165\u5e93\u6570\u91cf\u5f52\u96c6\u8986\u76d6\u5f15\u5165-\u6210\u672c\u4e2d\u5fc3\uff1a" + costcenter);
                    try {
                        Map<String, String> stringMap = this.doInvokeBizService(entry, costcenter, autoExecSchemeDTO);
                        String successQty = stringMap.get("successQty");
                        if (CadEmptyUtils.isEmpty((String)successQty) || Integer.parseInt(successQty) <= 0) continue;
                        sum += Integer.parseInt(successQty);
                        schemeLogSubDetail.add(new SchemeLogSubDetail(Long.valueOf(Long.parseLong(entry.getKey().toString())), Long.valueOf(Long.parseLong(costcenter.toString())), Long.valueOf(0L), Integer.parseInt(successQty)));
                    }
                    catch (Exception e) {
                        String detail = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u4ece\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\u5931\u8d25\u3002", (String)"FactnedOutputOperExecutor_0", (String)"macc-aca-business", (Object[])new Object[0]), AcaAutoExecShemeEntrance.getNameById("bos_org", Long.parseLong(entry.getKey().toString())));
                        AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, null, "cad_factnedoutputbill", this.operKey, detail);
                        logger.error((Throwable)e);
                    }
                }
            }
            AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), "cad_factnedoutputbill", this.operKey, String.format(SUCCESSIMPORTER, sum), schemeLogSubDetail);
        }
        return true;
    }

    private Map<String, String> doInvokeBizService(Map.Entry<Long, List<Object>> entry, Object costcenter, AutoExecSchemeDTO autoExecSchemeDTO) {
        Map stringMap = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"factnedOutPutService", (String)"importCompletion", (Object[])new Object[]{null, null, Long.parseLong(entry.getKey().toString()), Collections.singletonList(Long.parseLong(costcenter.toString())), null, autoExecSchemeDTO.getAppnum(), null});
        return stringMap;
    }
}

