/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.business.invocation.executor;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.algox.alloc.AcaMatAllocHelper;
import kd.macc.aca.algox.alloc.output.AllocResult;
import kd.macc.aca.algox.enums.ScaAllocEnum;
import kd.macc.aca.business.invocation.AcaAutoExecShemeEntrance;
import kd.macc.aca.business.invocation.Executor;
import kd.macc.aca.business.invocation.executor.CostObjectOperExecutor;
import kd.macc.aca.common.enums.EntityOperEnum;
import kd.macc.aca.common.enums.SchemeExecuteResultEnum;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;

public class MatAllocOperExecutor
implements Executor {
    private static final Log logger = LogFactory.getLog(CostObjectOperExecutor.class);
    private String operKey;

    public MatAllocOperExecutor(String operKey) {
        this.operKey = operKey;
    }

    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
        if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
            AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "aca_matalloc", this.operKey, FAIL);
            return false;
        }
        List<Long> orgList = AcaAutoExecShemeEntrance.getTargetList(orgCostAccountUserList, 0);
        List<Long> costAccountList = AcaAutoExecShemeEntrance.getTargetList(orgCostAccountUserList, 1);
        Map<Long, List<Long>> orgCostAccountMap = AcaAutoExecShemeEntrance.getOrgCostAccountMap(orgList, costAccountList, autoExecSchemeDTO.getAppnum());
        for (Map.Entry<Long, List<Long>> orgCostAccount : orgCostAccountMap.entrySet()) {
            String detail;
            List<Long> costAccounts = orgCostAccount.getValue();
            if (CollectionUtils.isEmpty(costAccounts)) continue;
            if (EntityOperEnum.OPER_IMPORT.getValue().equals(this.operKey)) {
                try {
                    boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)autoExecSchemeDTO.getExecutor(), (String)autoExecSchemeDTO.getAppnum(), (String)"aca_matalloc", (String)"47156aff000000ac");
                    if (!hasPerm) {
                        AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "aca_matalloc", this.operKey, NO_PERM);
                        return false;
                    }
                    AcaMatAllocHelper.importAllocData(costAccounts);
                    detail = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u5bfc\u5165\u6570\u636e\u6210\u529f\u3002", (String)"MatAllocOperExecutor_0", (String)"macc-aca-business", (Object[])new Object[0]), AcaAutoExecShemeEntrance.getNameById("bos_org", orgCostAccount.getKey()));
                    AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, null, "aca_matalloc", this.operKey, detail);
                }
                catch (Exception e) {
                    detail = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u5bfc\u5165\u6570\u636e\u5931\u8d25\u3002", (String)"MatAllocOperExecutor_1", (String)"macc-aca-business", (Object[])new Object[0]), AcaAutoExecShemeEntrance.getNameById("bos_org", orgCostAccount.getKey()));
                    AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, null, "aca_matalloc", this.operKey, detail);
                    logger.error((Throwable)e);
                }
                continue;
            }
            if (!EntityOperEnum.OPER_ALLOC.getValue().equals(this.operKey)) continue;
            try {
                boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)autoExecSchemeDTO.getExecutor(), (String)autoExecSchemeDTO.getAppnum(), (String)"aca_matalloc", (String)"80513208000000ac");
                if (!hasPerm) {
                    AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "aca_matalloc", this.operKey, NO_PERM);
                    return false;
                }
                Set<Long> ids = this.getToAllocIds(orgCostAccount.getKey(), costAccounts);
                AllocResult allocResult = AcaMatAllocHelper.doAlloc(ids);
                if (allocResult.getReasonMap().size() <= 0) continue;
                String result = (String)allocResult.getReasonMap().entrySet().iterator().next().getValue();
                String detail2 = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%1$s\u3011\u5206\u914d\u8be6\u60c5\uff1a%2$s", (String)"MatAllocOperExecutor_4", (String)"macc-aca-business", (Object[])new Object[0]), AcaAutoExecShemeEntrance.getNameById("bos_org", orgCostAccount.getKey()), result);
                AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, null, "aca_matalloc", this.operKey, detail2);
            }
            catch (Exception e) {
                detail = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u5206\u914d\u5931\u8d25\u3002", (String)"MatAllocOperExecutor_3", (String)"macc-aca-business", (Object[])new Object[0]), AcaAutoExecShemeEntrance.getNameById("bos_org", orgCostAccount.getKey()));
                AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, null, "aca_matalloc", this.operKey, detail);
                logger.error((Throwable)e);
            }
        }
        AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), "aca_matalloc", this.operKey, SUCCESS);
        return true;
    }

    private Set<Long> getToAllocIds(Long orgId, List<Long> costAccounts) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        orgFilter.and("costaccount", "in", costAccounts);
        orgFilter.and(new QFilter("allocstatus", "!=", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue()));
        orgFilter.and(new QFilter("costobject", "<=", (Object)0L));
        orgFilter.and(new QFilter("alloctype", "=", (Object)ScaAllocEnum.ALLOCTYP_AUTO.getValue()));
        orgFilter.and(new QFilter("costdriver", ">", (Object)0L));
        Set<Long> ids = QueryServiceHelper.query((String)"aca_matalloc", (String)"id", (QFilter[])new QFilter[]{orgFilter}).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        return ids;
    }
}

