/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.business.invocation.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.business.invocation.AcaAutoExecShemeEntrance;
import kd.macc.aca.business.invocation.Executor;
import kd.macc.aca.business.invocation.executor.CostObjectOperExecutor;
import kd.macc.aca.common.enums.EntityOperEnum;
import kd.macc.aca.common.enums.SchemeExecuteResultEnum;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;

public class MatUseCollectOperExecutor
implements Executor {
    private static final Log logger = LogFactory.getLog(CostObjectOperExecutor.class);
    private String operKey;
    private String entityName;

    public MatUseCollectOperExecutor(String entityName, String operKey) {
        this.entityName = entityName;
        this.operKey = operKey;
    }

    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (EntityOperEnum.OPER_SYSIMPORT.getValue().equals(this.operKey)) {
            int sum = 0;
            ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
            List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
            if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
                AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), this.entityName, this.operKey, FAIL);
                return false;
            }
            boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)autoExecSchemeDTO.getExecutor(), (String)autoExecSchemeDTO.getAppnum(), (String)this.entityName, (String)"47156aff000000ac");
            if (!hasPerm) {
                AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), this.entityName, this.operKey, NO_PERM);
                return false;
            }
            List<Long> orgList = AcaAutoExecShemeEntrance.getTargetList(orgCostAccountUserList, 0);
            Map<Long, List<Object>> orgAndSysImportCostCenterMap = AcaAutoExecShemeEntrance.getOrgAndSysImportCostCostCenterMap(orgList, autoExecSchemeDTO.getAppnum(), "matcollectway", "INNERSYSIMPORT");
            for (Map.Entry<Long, List<Object>> orgAndCc : orgAndSysImportCostCenterMap.entrySet()) {
                if (CollectionUtils.isEmpty((Collection)orgAndCc.getValue())) continue;
                for (Object costCenter : orgAndCc.getValue()) {
                    logger.info("\u81ea\u52a8\u6267\u884c-\u6750\u6599\u8017\u7528\u5f52\u96c6\u8986\u76d6\u5f15\u5165-\u6210\u672c\u4e2d\u5fc3\uff1a" + costCenter);
                    try {
                        ArrayList<Long> costCenters = new ArrayList<Long>(1);
                        costCenters.add((Long)costCenter);
                        Map<String, String> resultInfo = this.doInvokeBizService(orgAndCc, costCenters, autoExecSchemeDTO);
                        if (resultInfo == null || Long.parseLong(resultInfo.get("successQty")) <= 0L) continue;
                        sum += Integer.parseInt(resultInfo.get("successQty"));
                        schemeLogSubDetail.add(new SchemeLogSubDetail(orgAndCc.getKey(), Long.valueOf(costCenter == null ? "0" : costCenter.toString()), Long.valueOf(0L), Integer.parseInt(resultInfo.get("successQty"))));
                    }
                    catch (Exception e) {
                        logger.error("\u81ea\u52a8\u6267\u884c-\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u8986\u76d6\u5f15\u5165(\u5165\u53e3)\uff1a" + e);
                    }
                }
            }
            AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), this.entityName, this.operKey, String.format(SUCCESSIMPORTER, sum), schemeLogSubDetail);
        }
        return true;
    }

    private Map<String, String> doInvokeBizService(Map.Entry<Long, List<Object>> orgAndCc, List<Long> costCenters, AutoExecSchemeDTO autoExecSchemeDTO) {
        Map resultInfo = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"matUseService", (String)"importMatUse", (Object[])new Object[]{null, null, orgAndCc.getKey(), costCenters, null, autoExecSchemeDTO.getAppnum(), this.entityName, null});
        return resultInfo;
    }
}

