/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.business.invocation.executor;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.algox.enums.ScaAllocEnum;
import kd.macc.aca.business.invocation.AcaAutoExecShemeEntrance;
import kd.macc.aca.business.invocation.Executor;
import kd.macc.aca.business.invocation.executor.CostObjectOperExecutor;
import kd.macc.aca.common.enums.EntityOperEnum;
import kd.macc.aca.common.enums.SchemeExecuteResultEnum;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;

public class MfgFeeAllocCCExecutor
implements Executor {
    private static final Log logger = LogFactory.getLog(CostObjectOperExecutor.class);
    private String operKey;

    public MfgFeeAllocCCExecutor(String operKey) {
        this.operKey = operKey;
    }

    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (EntityOperEnum.OPER_ALLOC.getValue().equals(this.operKey)) {
            List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
            if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
                AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "aca_mfgfeealloccc", this.operKey, FAIL);
                return false;
            }
            boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)autoExecSchemeDTO.getExecutor(), (String)autoExecSchemeDTO.getAppnum(), (String)"aca_mfgfeealloccc", (String)"80513208000000ac");
            if (!hasPerm) {
                AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "aca_mfgfeealloccc", this.operKey, NO_PERM);
                return false;
            }
            List<Long> orgList = AcaAutoExecShemeEntrance.getTargetList(orgCostAccountUserList, 0);
            List<Long> costAccountList = AcaAutoExecShemeEntrance.getTargetList(orgCostAccountUserList, 1);
            Map<Long, List<Long>> orgCostAccountMap = AcaAutoExecShemeEntrance.getOrgCostAccountMap(orgList, costAccountList, autoExecSchemeDTO.getAppnum());
            for (Map.Entry<Long, List<Long>> orgCostAccount : orgCostAccountMap.entrySet()) {
                List<Long> costAccounts = orgCostAccount.getValue();
                if (CollectionUtils.isEmpty(costAccounts)) continue;
                for (Long costAccount : costAccounts) {
                    String orgName = AcaAutoExecShemeEntrance.getNameById("bos_org", orgCostAccount.getKey());
                    String costCountName = AcaAutoExecShemeEntrance.getNameById("cal_bd_costaccount", costAccount);
                    try {
                        String detail;
                        List<Object> ids = this.getToAllocIds(orgCostAccount.getKey(), costAccount);
                        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"donothing", (String)"aca_mfgfeealloccc", (Object[])ids.toArray(), (OperateOption)OperateOption.create());
                        if (operationResult.getSuccessPkIds().size() > 0) {
                            detail = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u3001\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u6210\u529f\u5206\u914d%3$s\u6761\u6570\u636e\u3002", (String)"MfgFeeAllocCCExecutor_2", (String)"macc-aca-business", (Object[])new Object[0]), orgName, costCountName, operationResult.getSuccessPkIds().size());
                            AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, null, "aca_mfgfeealloccc", this.operKey, detail);
                            continue;
                        }
                        detail = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u3001\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u81ea\u52a8\u5206\u914d\u5931\u8d25\u3002", (String)"MfgFeeAllocCCExecutor_3", (String)"macc-aca-business", (Object[])new Object[0]), orgName, costCountName);
                        AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, null, "aca_mfgfeealloccc", this.operKey, detail);
                    }
                    catch (Exception e) {
                        String detail = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u3001\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u81ea\u52a8\u5206\u914d\u5931\u8d25\u3002", (String)"MfgFeeAllocCCExecutor_3", (String)"macc-aca-business", (Object[])new Object[0]), orgName, costCountName);
                        AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, null, "aca_mfgfeealloccc", this.operKey, detail);
                        logger.error((Throwable)e);
                    }
                }
            }
        }
        AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), "aca_mfgfeealloccc", this.operKey, SUCCESS);
        return true;
    }

    private List<Object> getToAllocIds(Long orgId, Long cosAccount) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        orgFilter.and(new QFilter("costaccount", "=", (Object)cosAccount));
        orgFilter.and(new QFilter("allocstatus", "!=", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue()));
        orgFilter.and(new QFilter("usetype", "!=", (Object)ScaAllocEnum.USETYPE_DRIECT.getValue()));
        orgFilter.and(new QFilter("alloctype", "!=", (Object)ScaAllocEnum.ALLOCTYPE_MANUAL.getValue()));
        List<Object> ids = QueryServiceHelper.query((String)"aca_mfgfeealloccc", (String)"id", (QFilter[])new QFilter[]{orgFilter}).stream().map(e -> e.get("id")).collect(Collectors.toList());
        return ids;
    }
}

