/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.business.invocation.executor;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.business.invocation.AcaAutoExecShemeEntrance;
import kd.macc.aca.business.invocation.Executor;
import kd.macc.aca.business.invocation.executor.CostObjectOperExecutor;
import kd.macc.aca.common.enums.EntityOperEnum;
import kd.macc.aca.common.enums.SchemeExecuteResultEnum;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;

public class PlannedOutputOperExecutor
implements Executor {
    private static final Log logger = LogFactory.getLog(CostObjectOperExecutor.class);
    private String operKey;

    public PlannedOutputOperExecutor(String operKey) {
        this.operKey = operKey;
    }

    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (EntityOperEnum.OPER_ODERIMPORT.getValue().equals(this.operKey)) {
            List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
            if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
                AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "cad_plannedoutputbill", this.operKey, FAIL);
                return false;
            }
            boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)autoExecSchemeDTO.getExecutor(), (String)autoExecSchemeDTO.getAppnum(), (String)"cad_plannedoutputbill", (String)"47156aff000000ac");
            if (!hasPerm) {
                AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "cad_plannedoutputbill", this.operKey, NO_PERM);
                return false;
            }
            List<Long> orgList = AcaAutoExecShemeEntrance.getTargetList(orgCostAccountUserList, 0);
            Map<Long, List<Object>> orgCostCenterMap = AcaAutoExecShemeEntrance.getOrgCostCenterMap(orgList);
            for (Map.Entry<Long, List<Object>> orgCostCenter : orgCostCenterMap.entrySet()) {
                List<Object> costCenters = orgCostCenter.getValue();
                if (CollectionUtils.isEmpty(costCenters)) continue;
                for (Object costCenterId : costCenters) {
                    try {
                        Map<String, String> resultInfo = this.doInvokeBizService(orgCostCenter, costCenterId, autoExecSchemeDTO);
                        if (resultInfo.size() <= 0) continue;
                        String detail = resultInfo.entrySet().iterator().next().getValue();
                        AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, null, "cad_plannedoutputbill", this.operKey, detail);
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                    }
                }
            }
        }
        AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), "cad_plannedoutputbill", this.operKey, SUCCESS);
        return true;
    }

    private Map<String, String> doInvokeBizService(Map.Entry<Long, List<Object>> orgCostCenter, Object costCenterId, AutoExecSchemeDTO autoExecSchemeDTO) {
        Map resultInfo = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"plannedOutputService", (String)"importPlannedOut", (Object[])new Object[]{null, orgCostCenter.getKey(), Collections.singletonList(Long.parseLong(costCenterId.toString())), null, null, autoExecSchemeDTO.getAppnum(), null});
        return resultInfo;
    }
}

