/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.business.invocation.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.business.invocation.AcaAutoExecShemeEntrance;
import kd.macc.aca.business.invocation.Executor;
import kd.macc.aca.business.invocation.executor.CostObjectOperExecutor;
import kd.macc.aca.common.enums.EntityOperEnum;
import kd.macc.aca.common.enums.SchemeExecuteResultEnum;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;

public class ResourceUseOperExecutor
implements Executor {
    private static final Log logger = LogFactory.getLog(CostObjectOperExecutor.class);
    private String operKey;

    public ResourceUseOperExecutor(String operKey) {
        this.operKey = operKey;
    }

    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (EntityOperEnum.OPER_PROREPORT.getValue().equals(this.operKey)) {
            int sum = 0;
            ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
            List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
            if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
                AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "sca_resourceuse", this.operKey, FAIL, schemeLogSubDetail);
                return false;
            }
            boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)autoExecSchemeDTO.getExecutor(), (String)autoExecSchemeDTO.getAppnum(), (String)"sca_resourceuse", (String)"47156aff000000ac");
            if (!hasPerm) {
                AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "sca_resourceuse", this.operKey, NO_PERM, schemeLogSubDetail);
                return false;
            }
            List<Long> orgList = AcaAutoExecShemeEntrance.getTargetList(orgCostAccountUserList, 0);
            Map<Long, List<Object>> orgAndSysImportCostCostCenterMap = AcaAutoExecShemeEntrance.getOrgAndSysImportCostCostCenterMap(orgList, autoExecSchemeDTO.getAppnum(), "resourceusetype", "OBJECTRULE");
            for (Map.Entry<Long, List<Object>> entry : orgAndSysImportCostCostCenterMap.entrySet()) {
                if (CollectionUtils.isEmpty((Collection)entry.getValue())) continue;
                for (Object costcenter : entry.getValue()) {
                    logger.info("\u81ea\u52a8\u6267\u884c-\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u8986\u76d6\u5f15\u5165-\u6210\u672c\u4e2d\u5fc3\uff1a" + costcenter);
                    try {
                        Map<String, String> resultInfo = this.doInvokeBizService(entry, costcenter, autoExecSchemeDTO);
                        if (resultInfo == null) continue;
                        int successQty = Integer.parseInt(resultInfo.get("successQty"));
                        sum += successQty;
                        schemeLogSubDetail.add(new SchemeLogSubDetail(entry.getKey(), Long.valueOf(costcenter == null ? "0" : costcenter.toString()), Long.valueOf(0L), successQty));
                    }
                    catch (Exception e) {
                        logger.error("\u81ea\u52a8\u6267\u884c-\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u8986\u76d6\u5f15\u5165(\u5165\u53e3)\uff1a" + e);
                        logger.error((Throwable)e);
                    }
                }
            }
            AcaAutoExecShemeEntrance.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), "sca_resourceuse", this.operKey, String.format(SUCCESSIMPORTER, sum), schemeLogSubDetail);
        }
        return true;
    }

    private Map<String, String> doInvokeBizService(Map.Entry<Long, List<Object>> entry, Object costcenter, AutoExecSchemeDTO autoExecSchemeDTO) {
        Map resultInfo = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"resourceUseService", (String)"importResourceUse", (Object[])new Object[]{null, null, entry.getKey(), Collections.singletonList((Long)costcenter), null, autoExecSchemeDTO.getAppnum(), null});
        return resultInfo;
    }
}

