/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.business.wipadjust;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.utils.AcaAlgoxCurrencyHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.common.constants.WipAdjustConstants;
import kd.macc.aca.common.constants.WipAdjustSubItem;
import kd.macc.aca.common.helper.WipAdjustHelper;
import kd.macc.cad.common.helper.CalcKeycolHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class WipAdjustBillService {
    private static final Log logger = LogFactory.getLog(WipAdjustBillService.class);

    public Map<String, String> pushWipAdjustBill(Set<Long> orgIds, List<Long> ids) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        QFilter filter = new QFilter("id", "in", ids);
        String selectProps = "id,billno,billstatus,org,costcenter,costaccount,bookdate,period,currency,costobject,matauxpty,material,unit,entryentity,entryentity.seq,entryentity.element,entryentity.subelement,entryentity.adjustamt,entryentity.outsourcetype,entryentity.subadjustid,entryentity.subadjustbillno";
        DynamicObject[] sourceBills = BusinessDataServiceHelper.load((String)"aca_wipadjustbill", (String)selectProps, (QFilter[])new QFilter[]{filter});
        HashMap<Long, Long> costObjAndSourceBillMap = new HashMap<Long, Long>(16);
        HashMap<String, Map<String, Object>> costObjAndRecordMap = new HashMap<String, Map<String, Object>>();
        this.getCostRecordInfo(costObjAndSourceBillMap, costObjAndRecordMap, sourceBills, orgIds);
        Set<Map<String, Object>> params = this.getCostAdjustParam(sourceBills, costObjAndSourceBillMap, costObjAndRecordMap);
        if (params.size() > 0) {
            try (TXHandle h = TX.required();){
                Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalStandardCostDiffBillService", (String)"buildCostAdjustBill", (Object[])new Object[]{params});
                if (result == null) {
                    map.put("fail", ResManager.loadKDString((String)"\u5bf9\u63a5\u5b58\u8d27\u6838\u7b97\u7cfb\u7edf\u5931\u8d25\u3002", (String)"WipAdjustBillService_0", (String)"macc-aca-business", (Object[])new Object[0]));
                    logger.error("\u5bf9\u63a5\u5b58\u8d27\u6838\u7b97\u7cfb\u7edf\u5931\u8d25\uff0c\u8fd4\u56denull");
                    HashMap<String, String> hashMap = map;
                    return hashMap;
                }
                logger.info("\u5bf9\u63a5\u5b58\u8d27\u7cfb\u7edf\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a" + SerializationUtils.toJsonString((Object)result));
                HashSet<DynamicObject> failFinishDiffs = new HashSet<DynamicObject>();
                HashSet<DynamicObject> failEntryRows = new HashSet<DynamicObject>();
                String diffType = "B";
                Map adjustInfo = new HashMap(16);
                for (DynamicObject sourceBill : sourceBills) {
                    String sourcebill = sourceBill.getString("id");
                    DynamicObjectCollection entryentity = sourceBill.getDynamicObjectCollection("entryentity");
                    for (DynamicObject wipEntry : entryentity) {
                        BigDecimal adjustamt;
                        BigDecimal bigDecimal = adjustamt = wipEntry.get("adjustamt") == null ? BigDecimal.ZERO : (BigDecimal)wipEntry.get("adjustamt");
                        if (adjustamt.compareTo(BigDecimal.ZERO) == 0) continue;
                        String createType = this.getCreateType(wipEntry.getString("outsourcetype"));
                        String key_billid = sourcebill + "_" + diffType + "_" + createType;
                        adjustInfo = (Map)result.get(key_billid);
                        if (adjustInfo == null) {
                            failFinishDiffs.add(sourceBill);
                            failEntryRows.add(wipEntry);
                            continue;
                        }
                        wipEntry.set("subadjustid", adjustInfo.get("id"));
                        wipEntry.set("subadjustbillno", adjustInfo.get("billno"));
                    }
                }
                String msg = ResManager.loadKDString((String)"\u4e0b\u63a8\u6210\u529f!", (String)"WipAdjustBillService_1", (String)"macc-aca-business", (Object[])new Object[0]);
                if (!failFinishDiffs.isEmpty()) {
                    logger.info(msg);
                    msg = String.format(ResManager.loadKDString((String)"\u5bf9\u63a5\u5b58\u8d27\u6838\u7b97\u7cfb\u7edf\u7ed3\u675f\u3002%1$s\u5f20\u5355\u636e\u5171%2$s\u884c\u5206\u5f55\u6ca1\u6709\u6536\u5230\u8fd4\u56de\u7684\u6210\u672c\u8c03\u6574\u5355\u5185\u7801\u3002", (String)"WipAdjustBillService_4", (String)"macc-aca-business", (Object[])new Object[0]), failFinishDiffs.size(), failEntryRows);
                }
                map.put("success", msg);
                SaveServiceHelper.update((DynamicObject[])sourceBills);
            }
        }
        return map;
    }

    public Map<String, String> pushWipSubItemAdjustBill(Set<Long> orgIds, List<Long> ids) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        QFilter filter = new QFilter("id", "in", ids);
        String selectProps = "id,billno,billstatus,org,costcenter,costaccount,bookdate,period,currency,costobject,matauxpty,material,unit,subitementry,subitementry.seq,subitementry.sitemelement,subitementry.sitemsubelement,subitementry.sitemadjamt,subitementry.sitemoutsourcetype,subitementry.sitemadjustid,subitementry.sitemadjustbillno";
        DynamicObject[] sourceBills = BusinessDataServiceHelper.load((String)"aca_wipadjustbill", (String)selectProps, (QFilter[])new QFilter[]{filter});
        HashMap<Long, Long> costObjAndSourceBillMap = new HashMap<Long, Long>(16);
        HashMap<String, Map<String, Object>> costObjAndRecordMap = new HashMap<String, Map<String, Object>>(16);
        this.getCostRecordInfo(costObjAndSourceBillMap, costObjAndRecordMap, sourceBills, orgIds);
        Set<Map<String, Object>> params = this.getCostAdjustParamSub(sourceBills, costObjAndSourceBillMap, costObjAndRecordMap);
        if (params.size() > 0) {
            try (TXHandle h = TX.required();){
                Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalStandardCostDiffBillService", (String)"buildCostAdjustBill", (Object[])new Object[]{params});
                if (result == null) {
                    map.put("fail", ResManager.loadKDString((String)"\u5bf9\u63a5\u5b58\u8d27\u6838\u7b97\u7cfb\u7edf\u5931\u8d25\u3002", (String)"WipAdjustBillService_0", (String)"macc-aca-business", (Object[])new Object[0]));
                    logger.error("\u5bf9\u63a5\u5b58\u8d27\u6838\u7b97\u7cfb\u7edf\u5931\u8d25\uff0c\u8fd4\u56denull");
                    HashMap<String, String> hashMap = map;
                    return hashMap;
                }
                logger.info("\u5bf9\u63a5\u5b58\u8d27\u7cfb\u7edf\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a" + SerializationUtils.toJsonString((Object)result));
                HashSet<DynamicObject> failFinishDiffs = new HashSet<DynamicObject>();
                HashSet<DynamicObject> failEntryRows = new HashSet<DynamicObject>();
                String diffType = "B";
                Map adjustInfo = new HashMap(16);
                for (DynamicObject sourceBill : sourceBills) {
                    String sourcebill = sourceBill.getString("id");
                    DynamicObjectCollection entryentity = sourceBill.getDynamicObjectCollection("subitementry");
                    for (DynamicObject wipEntry : entryentity) {
                        BigDecimal adjustamt;
                        BigDecimal bigDecimal = adjustamt = wipEntry.get("sitemadjamt") == null ? BigDecimal.ZERO : (BigDecimal)wipEntry.get("sitemadjamt");
                        if (adjustamt.compareTo(BigDecimal.ZERO) == 0) continue;
                        String createType = this.getCreateType(wipEntry.getString("sitemoutsourcetype"));
                        String keyBillid = sourcebill + "_" + diffType + "_" + createType;
                        adjustInfo = (Map)result.get(keyBillid);
                        if (adjustInfo == null) {
                            failFinishDiffs.add(sourceBill);
                            failEntryRows.add(wipEntry);
                            continue;
                        }
                        wipEntry.set("sitemadjustid", adjustInfo.get("id"));
                        wipEntry.set("sitemadjustbillno", adjustInfo.get("billno"));
                    }
                }
                String msg = ResManager.loadKDString((String)"\u4e0b\u63a8\u6210\u529f!", (String)"WipAdjustBillService_1", (String)"macc-aca-business", (Object[])new Object[0]);
                if (!failFinishDiffs.isEmpty()) {
                    logger.info(msg);
                    msg = String.format(ResManager.loadKDString((String)"\u5bf9\u63a5\u5b58\u8d27\u6838\u7b97\u7cfb\u7edf\u7ed3\u675f\u3002%1$s\u5f20\u5355\u636e\u5171%2$s\u884c\u5206\u5f55\u6ca1\u6709\u6536\u5230\u8fd4\u56de\u7684\u6210\u672c\u8c03\u6574\u5355\u5185\u7801\u3002", (String)"WipAdjustBillService_4", (String)"macc-aca-business", (Object[])new Object[0]), failFinishDiffs.size(), failEntryRows);
                }
                map.put("success", msg);
                SaveServiceHelper.update((DynamicObject[])sourceBills);
            }
        }
        return map;
    }

    private void getCostRecordInfo(Map<Long, Long> costObjAndSourceBillMap, Map<String, Map<String, Object>> costObjAndRecordMap, DynamicObject[] sourceBills, Set<Long> orgIds) {
        HashSet<Long> costObjectIds = new HashSet<Long>(16);
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<Long> costCenterIds = new HashSet<Long>(16);
        HashSet<Object> costAccountIds = new HashSet<Object>(16);
        HashMap<Object, Long> costAccountAndPeriod = new HashMap<Object, Long>(16);
        for (DynamicObject sourceBill : sourceBills) {
            Long costAccountId = sourceBill.getLong("costaccount.id");
            Long l = sourceBill.getLong("period.id");
            costObjectIds.add(sourceBill.getLong("costobject.id"));
            periodIds.add(l);
            costCenterIds.add(sourceBill.getLong("costcenter.id"));
            costAccountIds.add(costAccountId);
            costAccountAndPeriod.putIfAbsent(costAccountId, l);
        }
        QFilter pfilter = new QFilter("id", "in", periodIds);
        DynamicObjectCollection periodObjs = QueryServiceHelper.query((String)"bd_period", (String)"id, begindate, enddate", (QFilter[])new QFilter[]{pfilter});
        HashMap periodMap = new HashMap(16);
        periodObjs.forEach(e -> periodMap.putIfAbsent(e.getLong("id"), e));
        QFilter qfFacAll = null;
        for (Long l : costAccountIds) {
            Long periodId = (Long)costAccountAndPeriod.get(l);
            QFilter qfFac = new QFilter("org", "in", orgIds);
            qfFac.and(new QFilter("costcenter", "in", costCenterIds));
            DynamicObject periodTemp = (DynamicObject)periodMap.get(periodId);
            if (periodTemp == null) continue;
            qfFac.and("bookdate", "<=", (Object)periodTemp.getDate("enddate"));
            qfFac.and(new QFilter("entryentity.costobject", "in", costObjectIds));
            qfFac.and(new QFilter("appnum", "=", (Object)"aca"));
            if (qfFacAll == null) {
                qfFacAll = qfFac;
                continue;
            }
            qfFacAll.or(qfFac);
        }
        String selectFields = "org,bookdate,auditdate,nsrcauditdate,costcenter,entryentity.costobject AS costobject,entryentity.qty AS qty,warehouse,location,wareinorg,sourcebill,sourcebillentry,batch as lot,entryentity.costobject.srcbillnumber AS scrbillnum,entryentity.costobject.srcbillrow AS srcbillrow";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.aca.business.wipadjust.WipAdjustBillService.pushWipAdjustBill_1", (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])new QFilter[]{qfFacAll}, null).orderBy(new String[]{"bookdate desc", "nsrcauditdate desc", "qty desc"});
        HashSet<Long> bizbillIds = new HashSet<Long>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long costObjectid = row.getLong("costobject");
            Long sourcebillentry = row.getLong("sourcebillentry");
            if (costObjAndSourceBillMap.containsKey(costObjectid)) continue;
            bizbillIds.add(sourcebillentry);
            costObjAndSourceBillMap.putIfAbsent(costObjectid, sourcebillentry);
        }
        String fields = "id,entry.id entryid,billno,entry.seq entryseq,calorg, storageorgunit, bookdate, costaccount, entry.warehouse AS warehouse, entry.location AS location, entry.assist AS assist,entry.lot AS lot,entry.configuredcode AS configuredcode,entry.tracknumber AS tracknumber, entry.invtype AS invtype, entry.invstatus AS invstatus,entry.ownertype AS ownertype, entry.owner AS owner, entry.project AS project,entry.bizbillentryid AS bizbillentryid";
        QFilter qfRecord = new QFilter("calorg", "in", orgIds);
        qfRecord.and(new QFilter("entry.bizbillentryid", "in", bizbillIds));
        DataSet costRecord = QueryServiceHelper.queryDataSet((String)"kd.macc.aca.common.helper.WipAdjustHelper.pushCalStandardCostDiffBill_2", (String)"cal_costrecord_subentity", (String)fields, (QFilter[])new QFilter[]{qfRecord}, null).orderBy(new String[]{"bookdate desc"});
        String dateKey = "";
        while (costRecord.hasNext()) {
            Row row = costRecord.next();
            Long bizBillentryId = row.getLong("bizbillentryid");
            Long costAccountId = row.getLong("costaccount");
            dateKey = String.format("%s@%s", costAccountId, bizBillentryId);
            HashMap<String, Object> srcInfo = new HashMap<String, Object>(16);
            srcInfo.put("storageorgunit", row.get("storageorgunit"));
            srcInfo.put("warehouse", row.get("warehouse"));
            srcInfo.put("location", row.get("location"));
            srcInfo.put("invtype", row.get("invtype"));
            srcInfo.put("invstatus", row.get("invstatus"));
            srcInfo.put("ownertype", row.get("ownertype"));
            srcInfo.put("owner", row.get("owner"));
            srcInfo.put("project", row.get("project"));
            srcInfo.put("configuredcode", row.get("configuredcode"));
            srcInfo.put("tracknumber", row.get("tracknumber"));
            srcInfo.put("lot", row.get("lot"));
            srcInfo.put("assist", row.get("assist"));
            srcInfo.put("invbillnum", row.get("billno"));
            srcInfo.put("inventryseq", row.get("entryseq"));
            srcInfo.put("invbillentryid", row.get("entryid"));
            srcInfo.put("invbillid", row.get("id"));
            srcInfo.put("invbizentityobject", "cal_costrecord_subentity");
            costObjAndRecordMap.putIfAbsent(dateKey, srcInfo);
        }
    }

    private void loadIvnBillNos(Map<Long, Map<String, Object>> invbillInfo) {
        HashSet<Long> srcEntryIds = new HashSet<Long>();
        for (Map.Entry<Long, Map<String, Object>> entry : invbillInfo.entrySet()) {
            Long entryId = (Long)entry.getValue().get("invbillentryid");
            if (entryId == null) continue;
            srcEntryIds.add(entryId);
        }
        this.setInvInfo(srcEntryIds, invbillInfo);
    }

    private void setInvInfo(Set<Long> srcEntryIds, Map<Long, Map<String, Object>> invbillInfo) {
        HashMap<Long, String> billNos = new HashMap<Long, String>(16);
        HashMap<Long, Integer> entrySeqs = new HashMap<Long, Integer>(16);
        HashMap<String, String> invBizObjects = new HashMap<String, String>(16);
        QFilter idQf = new QFilter("billentry.id", "in", srcEntryIds);
        DataSet dataSetOmc = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".setInvInfo"), (String)"im_mdc_omcmplinbill", (String)"id, billno, billentry.id entryid, billentry.seq seq,'im_mdc_omcmplinbill' invbizentityobject", (QFilter[])new QFilter[]{idQf}, null);
        DataSet dataSetMft = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".setInvInfo"), (String)"im_mdc_mftmanuinbill", (String)"id, billno, billentry.id entryid, billentry.seq seq,'im_mdc_mftmanuinbill' invbizentityobject", (QFilter[])new QFilter[]{idQf}, null);
        DataSet dataSetInv = dataSetOmc.union(dataSetMft.select(dataSetOmc.getRowMeta().getFieldNames()));
        while (dataSetInv.hasNext()) {
            Row row = dataSetInv.next();
            Long billId = row.getLong("id");
            Long entryId = row.getLong("entryid");
            String billNo = row.getString("billno");
            Integer seq = row.getInteger("seq");
            String invbizentityobject = row.getString("invbizentityobject");
            String invbizentityobjectKey = String.format("%s@%s", billId, entryId);
            billNos.put(billId, billNo);
            entrySeqs.put(entryId, seq);
            invBizObjects.put(invbizentityobjectKey, invbizentityobject);
        }
        for (Map.Entry<Long, Map<String, Object>> entry : invbillInfo.entrySet()) {
            Long billId = (Long)entry.getValue().get("invbillid");
            Long entryId = (Long)entry.getValue().get("invbillentryid");
            String invbizentityobjectKey = String.format("%s@%s", billId, entryId);
            entry.getValue().put("invbillnum", billNos.get(billId));
            entry.getValue().put("inventryseq", entrySeqs.get(entryId));
            entry.getValue().put("invbizentityobject", invBizObjects.get(invbizentityobjectKey));
        }
    }

    public void toCalcResult(List<Long> idList) {
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)"aca_wipadjustbill");
        DynamicObject[] res = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)billType);
        ArrayList<DynamicObject> calcResultUpdateList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> calcResultAddList = new ArrayList<DynamicObject>();
        Map<String, DynamicObject> calcResultMap = this.getCalcResultMapInfo(res);
        for (DynamicObject bizBill : res) {
            this.setCalcResultInfo(bizBill, calcResultUpdateList, calcResultAddList, calcResultMap);
        }
        if (res.length > 0 && "END".equals(res[0].getString("adjusttype"))) {
            for (DynamicObject dyn : calcResultAddList) {
                this.dealSumComplete(dyn);
            }
            for (DynamicObject dyn : calcResultUpdateList) {
                this.dealSumComplete(dyn);
            }
        }
        if (!CadEmptyUtils.isEmpty(calcResultUpdateList)) {
            SaveServiceHelper.save((DynamicObject[])calcResultUpdateList.toArray(new DynamicObject[0]));
        }
        if (!CadEmptyUtils.isEmpty(calcResultAddList)) {
            SaveServiceHelper.save((DynamicObject[])calcResultAddList.toArray(new DynamicObject[0]));
        }
    }

    private void dealSumComplete(DynamicObject dyn) {
        DynamicObjectCollection calcResultEntryEntitys = dyn.getDynamicObjectCollection("entryentity");
        Long currencyId = dyn.getLong("currency.id");
        for (DynamicObject calcResultEntryEntity : calcResultEntryEntitys) {
            this.setSubtractCol(calcResultEntryEntity, "endadjqty", "sumcomqty", null);
            this.setSubtractCol(calcResultEntryEntity, "endadjamt", "sumcomamount", null);
            this.setSubtractCol(calcResultEntryEntity, "endadjqty", "yearsumcomqty", null);
            this.setSubtractCol(calcResultEntryEntity, "endadjamt", "yearsumcomamount", null);
        }
        this.recalSumComplete(calcResultEntryEntitys, currencyId);
    }

    private void recalSumComplete(DynamicObjectCollection calcResultEntryEntitys, Long currencyId) {
        HashMap currencyPrecMap = Maps.newHashMapWithExpectedSize((int)16);
        if (currencyId != null && !currencyPrecMap.containsKey(currencyId)) {
            DynamicObject dyo = AcaAlgoxCurrencyHelper.getCurrency((Long)currencyId);
            if (dyo != null) {
                currencyPrecMap.put(currencyId, dyo.getInt("priceprecision"));
            } else {
                currencyPrecMap.put(currencyId, 0);
            }
        }
        int priceprecision = 0;
        if (currencyId != null && currencyPrecMap.containsKey(currencyId)) {
            priceprecision = (Integer)currencyPrecMap.get(currencyId);
        }
        BigDecimal proSumQty = BigDecimal.ZERO;
        BigDecimal proYearSumQty = BigDecimal.ZERO;
        for (DynamicObject calcResultEntryEntity : calcResultEntryEntitys) {
            if (!"finalResult".equals(calcResultEntryEntity.get("type"))) continue;
            proSumQty = BigDecimalUtil.getOrZero((Object)calcResultEntryEntity.getBigDecimal("sumcomqty"));
            proYearSumQty = BigDecimalUtil.getOrZero((Object)calcResultEntryEntity.getBigDecimal("yearsumcomqty"));
        }
        for (DynamicObject calcResultEntryEntity : calcResultEntryEntitys) {
            BigDecimal sumcomqty = BigDecimalUtil.getOrZero((Object)calcResultEntryEntity.getBigDecimal("sumcomqty"));
            BigDecimal yearsumcomqty = BigDecimalUtil.getOrZero((Object)calcResultEntryEntity.getBigDecimal("yearsumcomqty"));
            calcResultEntryEntity.set("sumcomunitcost", (Object)(sumcomqty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : BigDecimalUtil.getOrZero((Object)calcResultEntryEntity.getBigDecimal("sumcomamount")).divide(sumcomqty, priceprecision, 4)));
            calcResultEntryEntity.set("yearsumcomunitcost", (Object)(yearsumcomqty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : BigDecimalUtil.getOrZero((Object)calcResultEntryEntity.getBigDecimal("yearsumcomamount")).divide(yearsumcomqty, priceprecision, 4)));
            if ("finalResult".equals(calcResultEntryEntity.get("type"))) continue;
            calcResultEntryEntity.set("sumcomuse", (Object)(proSumQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : BigDecimalUtil.getOrZero((Object)calcResultEntryEntity.getBigDecimal("sumcomqty")).divide(proSumQty, 10, 4)));
            calcResultEntryEntity.set("yearsumcomuse", (Object)(proYearSumQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : BigDecimalUtil.getOrZero((Object)calcResultEntryEntity.getBigDecimal("yearsumcomqty")).divide(proYearSumQty, 10, 4)));
        }
    }

    private void setSubtractCol(DynamicObject dyn, String sourceCol, String targetCol, BigDecimal srcVal) {
        BigDecimal sourceVal;
        BigDecimal targetVal = BigDecimalUtil.getOrZero((Object)dyn.getBigDecimal(targetCol));
        BigDecimal subtractVal = targetVal.subtract(sourceVal = srcVal == null ? BigDecimalUtil.getOrZero((Object)dyn.getBigDecimal(sourceCol)) : srcVal);
        if (BigDecimalUtil.isOutOfRange((BigDecimal)subtractVal)) {
            subtractVal = BigDecimal.ZERO;
        }
        dyn.set(targetCol, (Object)subtractVal);
    }

    private void setAddCol(DynamicObject dyn, String sourceCol, String targetCol) {
        BigDecimal targetVal = BigDecimalUtil.getOrZero((Object)dyn.getBigDecimal(targetCol));
        BigDecimal sourceVal = BigDecimalUtil.getOrZero((Object)dyn.getBigDecimal(sourceCol));
        dyn.set(targetCol, (Object)targetVal.add(sourceVal));
    }

    public Set<Long> unauditCostAdjustBill(List<ExtendedDataEntity> dataEntities) {
        HashSet<Long> srcFailWipIds = new HashSet<Long>(16);
        HashSet<Long> adjustBillIdSet = new HashSet<Long>(16);
        HashMap<Long, Long> wipAdjustMap = new HashMap<Long, Long>(16);
        for (ExtendedDataEntity data : dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            Iterator iterator = entryEntity.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                Long adjustBill = entry.getLong("subadjustid");
                if (adjustBill == 0L) continue;
                adjustBillIdSet.add(adjustBill);
                wipAdjustMap.put(adjustBill, bill.getLong("id"));
            }
            DynamicObjectCollection subitementry = bill.getDynamicObjectCollection("subitementry");
            for (DynamicObject entry : subitementry) {
                Long adjustBill = entry.getLong("sitemadjustid");
                if (adjustBill == 0L) continue;
                adjustBillIdSet.add(adjustBill);
                wipAdjustMap.put(adjustBill, bill.getLong("id"));
            }
        }
        DynamicObjectCollection ajustBills = WipAdjustHelper.getCostAdjustBills(adjustBillIdSet);
        if (ajustBills.size() > 0) {
            HashSet<Long> allCostAdjustIds = new HashSet<Long>();
            HashSet<Long> costAdjustIds = new HashSet<Long>(16);
            for (DynamicObject obj : ajustBills) {
                Long costAdjustId = obj.getLong("id");
                allCostAdjustIds.add(costAdjustId);
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)obj.getString("billstatus"))) continue;
                costAdjustIds.add(costAdjustId);
            }
            if (costAdjustIds.isEmpty()) {
                if (!allCostAdjustIds.isEmpty()) {
                    logger.info(String.format("\u627e\u5230\u4e86\u5173\u8054\u7684%s\u5f20\u6210\u672c\u8c03\u6574\u5355\uff0c\u5747\u4e0d\u662f\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u65e0\u9700\u53cd\u5ba1\u6838\u3002", allCostAdjustIds.size()));
                }
                return srcFailWipIds;
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("unwriteoff", "true");
            OperationResult unauditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_costadjust_subentity", (Object[])costAdjustIds.toArray(), (OperateOption)option);
            logger.info(String.format("\u53cd\u5ba1\u6838\u6210\u672c\u8c03\u6574\u5355%s\u5f20\uff0c\u6210\u529f%s\u5f20", costAdjustIds.size(), unauditResult.getSuccessPkIds().size()));
            QFilter adjustidQF = new QFilter("id", "in", allCostAdjustIds);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".unAuditCostAdjustBill"), (String)"cal_costadjust_subentity", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{adjustidQF}, null);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    if (!StringUtils.equals((CharSequence)"C", (CharSequence)row.getString("billstatus"))) continue;
                    Long costAdjustId = row.getLong("id");
                    srcFailWipIds.add((Long)wipAdjustMap.get(costAdjustId));
                }
            }
        }
        return srcFailWipIds;
    }

    public Set<Long> deleteCostAudit(DynamicObject[] dataEntities) {
        HashSet<Long> failWipIds = new HashSet<Long>(16);
        HashSet<Long> costAdjustIds = new HashSet<Long>();
        HashMap<Long, Long> adjustIdAndWipId = new HashMap<Long, Long>(16);
        for (DynamicObject bill : dataEntities) {
            Object entry2;
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            for (Object entry2 : entryEntity) {
                Long adjustBill = entry2.getLong("subadjustid");
                if (adjustBill == null || Long.compare(0L, adjustBill) == 0) continue;
                costAdjustIds.add(adjustBill);
                adjustIdAndWipId.put(adjustBill, bill.getLong("id"));
            }
            DynamicObjectCollection subitementry = bill.getDynamicObjectCollection("subitementry");
            entry2 = subitementry.iterator();
            while (entry2.hasNext()) {
                DynamicObject entry3 = (DynamicObject)entry2.next();
                Long adjustBill = entry3.getLong("sitemadjustid");
                if (adjustBill == null || Long.compare(0L, adjustBill) == 0) continue;
                costAdjustIds.add(adjustBill);
                adjustIdAndWipId.put(adjustBill, bill.getLong("id"));
            }
        }
        if (costAdjustIds.isEmpty()) {
            logger.info("\u6ca1\u6709\u627e\u5230\u9700\u8981\u540c\u6b65\u5220\u9664\u7684\u6210\u672c\u8c03\u6574\u5355");
            return failWipIds;
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity"), (Object[])costAdjustIds.toArray());
        int failAdjustCount = 0;
        QFilter adjustidQF = new QFilter("id", "in", costAdjustIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".deleteCostAudit"), (String)"cal_costadjust_subentity", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{adjustidQF}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long costAdjustId = row.getLong("id");
                Long wipId = (Long)adjustIdAndWipId.get(costAdjustId);
                failWipIds.add(wipId);
                ++failAdjustCount;
            }
        }
        logger.info(String.format("\u6210\u529f\u5220\u9664\u6210\u672c\u8c03\u6574\u5355%s\u5f20\uff0c\u5931\u8d25%s\u5f20", costAdjustIds.size() - failAdjustCount, failAdjustCount));
        return failWipIds;
    }

    public void updateCalcResultBill(DynamicObject[] dataEntities, String adjustType) {
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> costCenterIds = new HashSet<Long>(16);
        HashSet<Long> costobjectIds = new HashSet<Long>(16);
        HashSet<String> keySet = new HashSet<String>(16);
        for (DynamicObject bizBill : dataEntities) {
            Long orgId = bizBill.getLong("org.id");
            Long costAccountId = bizBill.getLong("costaccount.id");
            Long periodId = bizBill.getLong("period.id");
            Long costobjectId = bizBill.getLong("costobject.id");
            Long costCenterId = bizBill.getLong("costcenter.id");
            costAccountIds.add(costAccountId);
            periodIds.add(periodId);
            orgIds.add(orgId);
            costCenterIds.add(costCenterId);
            costobjectIds.add(costobjectId);
            keySet.add(this.getKeyStr(bizBill));
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("period", "in", periodIds), new QFilter("costaccount", "in", costAccountIds), new QFilter("costobject", "in", costobjectIds), new QFilter("costcenter", "in", costCenterIds)};
        String selectFields = "id,org,costcenter,costaccount,period,costobject,currency,entryentity,entryentity.endadjqty,entryentity.endadjamt,entryentity.startadjqty,entryentity.startadjamt,entryentity.type,entryentity.sumcomqty,entryentity.sumcomuse,entryentity.sumcomunitcost,entryentity.sumcomamount,entryentity.yearsumcomqty,entryentity.yearsumcomuse,entryentity.yearsumcomunitcost,entryentity.yearsumcomamount,subdetail.selement,subdetail.ssubelement,subdetail.spdstartadjamt,subdetail.spdendadjamt,subdetail.spdsumcomamt,subdetail.spdyearcomamt";
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"aca_calcresult", (String)selectFields, (QFilter[])filters);
        ArrayList<DynamicObject> calcResultList = new ArrayList<DynamicObject>(bills.length);
        for (DynamicObject dy : bills) {
            String keyStr;
            if (dy == null || !keySet.contains(keyStr = this.getKeyStr(dy))) continue;
            calcResultList.add(dy);
        }
        if (!CadEmptyUtils.isEmpty(calcResultList)) {
            for (DynamicObject calcResult : calcResultList) {
                DynamicObjectCollection entryEntity = calcResult.getDynamicObjectCollection("entryentity");
                for (DynamicObject obj : entryEntity) {
                    DynamicObjectCollection subdetail = obj.getDynamicObjectCollection("subdetail");
                    if ("END".equalsIgnoreCase(adjustType)) {
                        this.setAddCol(obj, "endadjqty", "sumcomqty");
                        this.setAddCol(obj, "endadjamt", "sumcomamount");
                        this.setAddCol(obj, "endadjqty", "yearsumcomqty");
                        this.setAddCol(obj, "endadjamt", "yearsumcomamount");
                        obj.set("endadjqty", null);
                        obj.set("endadjamt", null);
                        if (subdetail.isEmpty()) continue;
                        for (DynamicObject dyn : subdetail) {
                            this.setAddCol(dyn, "spdendadjamt", "spdsumcomamt");
                            this.setAddCol(dyn, "spdendadjamt", "spdyearcomamt");
                            dyn.set("spdendadjamt", null);
                        }
                        continue;
                    }
                    obj.set("startadjqty", null);
                    obj.set("startadjamt", null);
                    for (DynamicObject dyn : subdetail) {
                        dyn.set("spdstartadjamt", null);
                    }
                }
                if (!"END".equalsIgnoreCase(adjustType)) continue;
                Long currencyId = calcResult.getLong("currency.id");
                this.recalSumComplete(entryEntity, currencyId);
            }
            SaveServiceHelper.update((DynamicObject[])calcResultList.toArray(new DynamicObject[0]));
        }
    }

    public void updateWipAdjustInfo(DynamicObject[] dataEntities) {
        for (DynamicObject wipBill : dataEntities) {
            DynamicObjectCollection entryEntity = wipBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                entry.set("subadjustid", null);
                entry.set("subadjustbillno", (Object)"");
            }
            DynamicObjectCollection subitementry = wipBill.getDynamicObjectCollection("subitementry");
            for (DynamicObject entry : subitementry) {
                entry.set("sitemadjustid", null);
                entry.set("sitemadjustbillno", (Object)"");
            }
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }

    private Set<Map<String, Object>> getCostAdjustParam(DynamicObject[] sourceBills, Map<Long, Long> costObjAndSourceBillMap, Map<String, Map<String, Object>> costObjAndRecordMap) {
        HashSet<Map<String, Object>> params = new HashSet<Map<String, Object>>(16);
        HashMap keycolMap = new HashMap(10);
        for (DynamicObject sourceBill : sourceBills) {
            Long orgId = sourceBill.getLong("org.id");
            Long costObjectId = sourceBill.getLong("costobject.id");
            long costCenterId = sourceBill.getLong("costcenter.id");
            DynamicObject costAccount = sourceBill.getDynamicObject("costaccount");
            Long costaccountId = costAccount.getLong("id");
            Long bizBillentryId = costObjAndSourceBillMap.get(costObjectId);
            String dataKey = String.format("%s@%s", costaccountId, bizBillentryId);
            Map<String, Object> recordMap = costObjAndRecordMap.get(dataKey);
            Map keycolFieldMap = (Map)keycolMap.get(costaccountId);
            if (keycolFieldMap == null) {
                keycolFieldMap = CalcKeycolHelper.getWipAdjustKeyColFieldMap((Long)orgId, (Long)costaccountId, (boolean)false);
                keycolFieldMap.remove("configuredcode");
                keycolFieldMap.remove("tracknumber");
                keycolFieldMap.remove("project");
                keycolFieldMap.remove("lot");
            }
            DynamicObjectCollection entryentity = sourceBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                BigDecimal adjustamt;
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                BigDecimal bigDecimal = adjustamt = entry.get("adjustamt") == null ? BigDecimal.ZERO : entry.getBigDecimal("adjustamt").negate();
                if (adjustamt.compareTo(BigDecimal.ZERO) == 0) continue;
                param.put("calorg", orgId);
                param.put("ecostcenter", costCenterId);
                param.put("costaccount", costaccountId);
                Object bookdate = sourceBill.get("bookdate");
                param.put("bizdate", bookdate);
                param.put("bookdate", bookdate);
                param.put("billstatus", "C");
                param.put("biztype", "A");
                param.put("billtype", WipAdjustConstants.BILLTYPE);
                param.put("currency", sourceBill.get("currency.id"));
                param.put("period", sourceBill.get("period.id"));
                String createType = this.getCreateType(entry.getString("outsourcetype"));
                param.put("createtype", createType);
                param.put("difftype", "B");
                param.put("remark", ResManager.loadKDString((String)"\u6765\u6e90\u4e8e\u5728\u4ea7\u54c1\u6210\u672c\u8c03\u6574\u5355\u4e0b\u63a8\u751f\u6210", (String)"WipAdjustBillService_3", (String)"macc-aca-business", (Object[])new Object[0]));
                param.put("material", sourceBill.get("material.id"));
                param.put("mversion", sourceBill.get("costobject.bomversion.id"));
                param.put("assist", sourceBill.get("matauxpty.id"));
                param.put("baseunit", sourceBill.get("unit.id"));
                param.put("ownertype", "bos_org");
                param.put("owner", orgId);
                if (recordMap != null) {
                    param.put("configuredcode", recordMap.get("configuredcode"));
                    param.put("tracknumber", recordMap.get("tracknumber"));
                    param.put("storageorgunit", recordMap.get("storageorgunit"));
                    param.put("warehouse", recordMap.get("warehouse"));
                    param.put("location", recordMap.get("location"));
                    param.put("invtype", recordMap.get("invtype"));
                    param.put("invstatus", recordMap.get("invstatus"));
                    param.put("ownertype", recordMap.get("ownertype"));
                    param.put("owner", recordMap.get("owner"));
                    param.put("project", recordMap.get("project"));
                    param.put("assist", recordMap.get("assist"));
                    param.put("lot", recordMap.get("lot"));
                    this.setExtFields(keycolFieldMap, param, sourceBill);
                    if (recordMap.containsKey("invbillnum")) {
                        param.put("invbillnum", recordMap.get("invbillnum"));
                        param.put("inventryseq", recordMap.get("inventryseq"));
                        param.put("invbillentryid", recordMap.get("invbillentryid"));
                        param.put("invbillid", recordMap.get("invbillid"));
                        param.put("invbizentityobject", recordMap.get("invbizentityobject"));
                    }
                }
                param.put("srcbillnum", sourceBill.get("billno"));
                param.put("srcentryseq", entry.getLong("seq"));
                param.put("srcbillid", sourceBill.get("id"));
                param.put("srcbillentryid", entry.getLong("id"));
                param.put("srcbizentityobject", "aca_wipadjustbill");
                param.put("costelement", entry.get("element.id"));
                param.put("costsubelement", entry.get("subelement.id"));
                param.put("sub_material", sourceBill.get("material.id"));
                param.put("sub_adjustamt", adjustamt);
                param.put("adjustamt", adjustamt);
                param.put("srcsys", "B");
                params.add(param);
            }
        }
        return params;
    }

    private Set<Map<String, Object>> getCostAdjustParamSub(DynamicObject[] sourceBills, Map<Long, Long> costObjAndSourceBillMap, Map<String, Map<String, Object>> costObjAndRecordMap) {
        HashSet<Map<String, Object>> params = new HashSet<Map<String, Object>>(16);
        HashMap keycolMap = new HashMap(10);
        for (DynamicObject sourceBill : sourceBills) {
            Long orgId = sourceBill.getLong("org.id");
            Long costObjectId = sourceBill.getLong("costobject.id");
            long costCenterId = sourceBill.getLong("costcenter.id");
            DynamicObject costAccount = sourceBill.getDynamicObject("costaccount");
            Long costaccountId = costAccount.getLong("id");
            Long bizBillentryId = costObjAndSourceBillMap.get(costObjectId);
            String dataKey = String.format("%s@%s", costaccountId, bizBillentryId);
            Map<String, Object> recordMap = costObjAndRecordMap.get(dataKey);
            Map keycolFieldMap = (Map)keycolMap.get(costaccountId);
            if (keycolFieldMap == null) {
                keycolFieldMap = CalcKeycolHelper.getWipAdjustKeyColFieldMap((Long)orgId, (Long)costaccountId, (boolean)false);
                keycolFieldMap.remove("configuredcode");
                keycolFieldMap.remove("tracknumber");
                keycolFieldMap.remove("project");
                keycolFieldMap.remove("lot");
            }
            DynamicObjectCollection entryentity = sourceBill.getDynamicObjectCollection("subitementry");
            for (DynamicObject entry : entryentity) {
                BigDecimal adjustamt;
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                BigDecimal bigDecimal = adjustamt = entry.get("sitemadjamt") == null ? BigDecimal.ZERO : entry.getBigDecimal("sitemadjamt").negate();
                if (adjustamt.compareTo(BigDecimal.ZERO) == 0) continue;
                param.put("calorg", orgId);
                param.put("ecostcenter", costCenterId);
                param.put("costaccount", costaccountId);
                Object bookdate = sourceBill.get("bookdate");
                param.put("bizdate", bookdate);
                param.put("bookdate", bookdate);
                param.put("billstatus", "C");
                param.put("biztype", "A");
                param.put("billtype", WipAdjustConstants.BILLTYPE);
                param.put("currency", sourceBill.get("currency.id"));
                param.put("period", sourceBill.get("period.id"));
                String createType = this.getCreateType(entry.getString("sitemoutsourcetype"));
                param.put("createtype", createType);
                param.put("difftype", "B");
                param.put("remark", ResManager.loadKDString((String)"\u6765\u6e90\u4e8e\u5728\u4ea7\u54c1\u6210\u672c\u8c03\u6574\u5355\u4e0b\u63a8\u751f\u6210", (String)"WipAdjustBillService_3", (String)"macc-aca-business", (Object[])new Object[0]));
                param.put("material", sourceBill.get("material.id"));
                param.put("mversion", sourceBill.get("costobject.bomversion.id"));
                param.put("assist", sourceBill.get("matauxpty.id"));
                param.put("baseunit", sourceBill.get("unit.id"));
                param.put("ownertype", "bos_org");
                param.put("owner", orgId);
                if (recordMap != null) {
                    param.put("configuredcode", recordMap.get("configuredcode"));
                    param.put("tracknumber", recordMap.get("tracknumber"));
                    param.put("storageorgunit", recordMap.get("storageorgunit"));
                    param.put("warehouse", recordMap.get("warehouse"));
                    param.put("location", recordMap.get("location"));
                    param.put("invtype", recordMap.get("invtype"));
                    param.put("invstatus", recordMap.get("invstatus"));
                    param.put("ownertype", recordMap.get("ownertype"));
                    param.put("owner", recordMap.get("owner"));
                    param.put("project", recordMap.get("project"));
                    param.put("assist", recordMap.get("assist"));
                    param.put("lot", recordMap.get("lot"));
                    this.setExtFields(keycolFieldMap, param, sourceBill);
                    if (recordMap.containsKey("invbillnum")) {
                        param.put("invbillnum", recordMap.get("invbillnum"));
                        param.put("inventryseq", recordMap.get("inventryseq"));
                        param.put("invbillentryid", recordMap.get("invbillentryid"));
                        param.put("invbillid", recordMap.get("invbillid"));
                        param.put("invbizentityobject", recordMap.get("invbizentityobject"));
                    }
                }
                param.put("srcbillnum", sourceBill.get("billno"));
                param.put("srcentryseq", entry.getLong("seq"));
                param.put("srcbillid", sourceBill.get("id"));
                param.put("srcbillentryid", entry.getLong("id"));
                param.put("srcbizentityobject", "aca_wipadjustbill");
                param.put("costelement", entry.get("sitemelement.id"));
                param.put("costsubelement", entry.get("sitemsubelement.id"));
                param.put("sub_material", sourceBill.get("material.id"));
                param.put("sub_adjustamt", adjustamt);
                param.put("adjustamt", adjustamt);
                param.put("srcsys", "B");
                params.add(param);
            }
        }
        return params;
    }

    private void setExtFields(Map<String, Tuple2<String, IDataEntityProperty>> keycolFieldMap, Map<String, Object> param, DynamicObject sourceBill) {
        try {
            for (Map.Entry<String, Tuple2<String, IDataEntityProperty>> keyEntry : keycolFieldMap.entrySet()) {
                if (keyEntry.getValue().t2 instanceof BasedataProp) {
                    param.put(keyEntry.getKey(), sourceBill.get("costobject." + (String)keyEntry.getValue().t1 + ".id"));
                    continue;
                }
                if ("productnum".equals(keyEntry.getKey())) {
                    param.put(keyEntry.getKey(), sourceBill.get("costobject.producenum"));
                    continue;
                }
                param.put(keyEntry.getKey(), sourceBill.get("costobject." + (String)keyEntry.getValue().t1));
            }
        }
        catch (Exception ex) {
            logger.error("\u83b7\u53d6\u6210\u672c\u5bf9\u8c61\u7684\u6269\u5c55\u5b57\u6bb5\u62a5\u9519", (Throwable)ex);
        }
    }

    private String getCreateType(String outsourcetype) {
        String createType;
        if (StringUtils.isNotBlank((CharSequence)outsourcetype)) {
            switch (createType = outsourcetype) {
                case "A": {
                    createType = "WW-A1";
                    break;
                }
                case "B": {
                    createType = "WW-A2";
                    break;
                }
                case "C": {
                    createType = "WW-A3";
                    break;
                }
                case "D": {
                    createType = "WW-A4";
                }
            }
        } else {
            createType = "D1";
        }
        return createType;
    }

    private Map<String, DynamicObject> getCalcResultMapInfo(DynamicObject[] res) {
        DynamicObject[] bills;
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> costCenterIds = new HashSet<Long>(16);
        HashSet<Long> costobjectIds = new HashSet<Long>(16);
        for (DynamicObject bizBill : res) {
            Long orgId = bizBill.getLong("org.id");
            Long costAccountId = bizBill.getLong("costaccount.id");
            Long periodId = bizBill.getLong("period.id");
            Long costobjectId = bizBill.getLong("costobject.id");
            Long costCenterId = bizBill.getLong("costcenter.id");
            costAccountIds.add(costAccountId);
            periodIds.add(periodId);
            orgIds.add(orgId);
            costCenterIds.add(costCenterId);
            costobjectIds.add(costobjectId);
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("period", "in", periodIds), new QFilter("costaccount", "in", costAccountIds), new QFilter("costobject", "in", costobjectIds), new QFilter("costcenter", "in", costCenterIds)};
        String selectFields = "id,billno,org,costobject,costaccount,period,costcenter,bizdate,currency,billstatus,  entryentity,entryentity.type,entryentity.relacostobject,entryentity.relaproducttype,entryentity.material,entryentity.auxpty,entryentity.outsourcetype,entryentity.matversion,entryentity.calckeycol,entryentity.feetype,entryentity.submaterial,entryentity.submatversion,entryentity.subauxpty,entryentity.element,entryentity.subelement,entryentity.endadjqty,entryentity.endadjamt,entryentity.startadjqty,entryentity.startadjamt,entryentity.sumcomqty,entryentity.sumcomuse,entryentity.sumcomunitcost,entryentity.sumcomamount,entryentity.yearsumcomqty,entryentity.yearsumcomuse,entryentity.yearsumcomunitcost,entryentity.yearsumcomamount,subdetail.selement,subdetail.ssubelement,subdetail.spdstartadjamt,subdetail.spdendadjamt,subdetail.spdsumcomamt,subdetail.spdyearcomamt";
        for (DynamicObject dy : bills = BusinessDataServiceHelper.load((String)"aca_calcresult", (String)selectFields, (QFilter[])filters)) {
            if (dy == null) continue;
            String keyStr = this.getKeyStr(dy);
            map.putIfAbsent(keyStr, dy);
        }
        return map;
    }

    private String getKeyStr(DynamicObject dy) {
        Long orgId = dy.getLong("org.id");
        Long costAccountId = dy.getLong("costaccount.id");
        Long periodId = dy.getLong("period.id");
        Long costobjectId = dy.getLong("costobject.id");
        Long costCenterId = dy.getLong("costcenter.id");
        return String.format("%s@%s@%s@%s@%s", orgId, costAccountId, costCenterId, periodId, costobjectId);
    }

    private String getBizEntryKeyStr(DynamicObject bizEntry, DynamicObject subBizEntry) {
        Long subelement = bizEntry.getLong("subelement.id");
        Long submaterial = 0L;
        Long submatversion = 0L;
        Long subauxpty = 0L;
        Long calckeycol = 0L;
        if (subBizEntry != null) {
            submaterial = subBizEntry.getLong("submaterial.id");
            submatversion = subBizEntry.getLong("version.id");
            subauxpty = subBizEntry.getLong("auxpty.id");
            calckeycol = subBizEntry.getLong("calckeycol.id");
        }
        return String.format("%s@%s@%s@%s@%s", subelement, submaterial, submatversion, subauxpty, calckeycol);
    }

    private String getCalcEntryKeyStr(DynamicObject calcResultEntryEntity) {
        Long subelement = calcResultEntryEntity.getLong("subelement.id");
        Long submaterial = calcResultEntryEntity.getLong("submaterial.id");
        Long submatversion = calcResultEntryEntity.getLong("submatversion.id");
        Long subauxpty = calcResultEntryEntity.getLong("subauxpty.id");
        Long calckeycol = calcResultEntryEntity.getLong("calckeycol.id");
        return String.format("%s@%s@%s@%s@%s", subelement, submaterial, submatversion, subauxpty, calckeycol);
    }

    private void setCalcResultInfo(DynamicObject bizBill, List<DynamicObject> calcResultUpdateList, List<DynamicObject> calcResultAddList, Map<String, DynamicObject> calcResultMap) {
        String adjustType = bizBill.getString("adjusttype");
        String keyStr = this.getKeyStr(bizBill);
        DynamicObject calcResult = calcResultMap.get(keyStr);
        BigDecimal tatolAmt = BigDecimal.ZERO;
        BigDecimal adjustamt = BigDecimal.ZERO;
        if (calcResult == null) {
            calcResult = BusinessDataServiceHelper.newDynamicObject((String)"aca_calcresult");
            this.setCalcResultHeadler(calcResult, bizBill);
            DynamicObject costObj = bizBill.getDynamicObject("costobject");
            DynamicObjectCollection entryEntity = calcResult.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection bizEntrys = bizBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject bizEntry : bizEntrys) {
                adjustamt = bizEntry.getBigDecimal("adjustamt");
                DynamicObject subElement = (DynamicObject)bizEntry.get("subelement");
                DynamicObjectCollection subBizEntrys = bizEntry.getDynamicObjectCollection("subentryentity");
                if (!WipAdjustConstants.MAT_SUBELE_TYPES.contains(subElement.getString("type")) || subBizEntrys.isEmpty()) {
                    DynamicObject detailRow = entryEntity.addNew();
                    this.setDetailRow(detailRow, adjustType, null, bizEntry, bizBill.getLong("costobject.id"));
                    this.setAdjInfo(detailRow, adjustType, adjustamt);
                    this.setMaterialInfo(detailRow, costObj);
                } else {
                    for (DynamicObject subBizEntry : subBizEntrys) {
                        DynamicObject detailRow = entryEntity.addNew();
                        this.setDetailRow(detailRow, adjustType, subBizEntry, bizEntry, bizBill.getLong("costobject.id"));
                        this.setSubItemRow(detailRow, adjustType, subBizEntry);
                        this.setMaterialInfo(detailRow, costObj);
                    }
                }
                tatolAmt = tatolAmt.add(adjustamt);
            }
            DynamicObject finalResultEntry = entryEntity.addNew();
            finalResultEntry.set("type", (Object)"finalResult");
            finalResultEntry.set("relacostobject", bizBill.get("costobject.id"));
            finalResultEntry.set("relaproducttype", (Object)"C");
            this.setFinalResultAdjInfo(finalResultEntry, bizBill, adjustType, tatolAmt);
            calcResultAddList.add(calcResult);
        } else {
            DynamicObject costObj = bizBill.getDynamicObject("costobject");
            DynamicObjectCollection calcResultEntryEntitys = calcResult.getDynamicObjectCollection("entryentity");
            for (DynamicObject dyn : calcResultEntryEntitys) {
                this.setAdjInfo(dyn, null, adjustType);
            }
            HashMap<String, DynamicObject> calcEntryDetailMap = new HashMap<String, DynamicObject>();
            DynamicObject finalResultEntry = new DynamicObject();
            for (DynamicObject calcResultEntryEntity : calcResultEntryEntitys) {
                if (!"C".equals(calcResultEntryEntity.get("relaproducttype"))) continue;
                if (!"finalResult".equals(calcResultEntryEntity.get("type"))) {
                    calcEntryDetailMap.putIfAbsent(this.getCalcEntryKeyStr(calcResultEntryEntity), calcResultEntryEntity);
                    continue;
                }
                finalResultEntry = calcResultEntryEntity;
            }
            if (finalResultEntry == null) {
                logger.info("\u8ba1\u7b97\u7ed3\u679c\u5355\u672a\u6709\u6700\u7ec8\u7ed3\u679c\u5206\u5f55\u884c");
                finalResultEntry = calcResultEntryEntitys.addNew();
                finalResultEntry.set("type", (Object)"finalResult");
                finalResultEntry.set("relacostobject", bizBill.get("costobject.id"));
                finalResultEntry.set("relaproducttype", (Object)"C");
            }
            DynamicObjectCollection bizEntrys = bizBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject bizEntry : bizEntrys) {
                adjustamt = bizEntry.getBigDecimal("adjustamt");
                tatolAmt = tatolAmt.add(adjustamt);
                DynamicObject subElement = (DynamicObject)bizEntry.get("subelement");
                DynamicObjectCollection subBizEntrys = bizEntry.getDynamicObjectCollection("subentryentity");
                if (!WipAdjustConstants.MAT_SUBELE_TYPES.contains(subElement.getString("type")) || subBizEntrys.isEmpty()) {
                    String bizEntryKeyStr = this.getBizEntryKeyStr(bizEntry, null);
                    DynamicObject calcResultEntry = (DynamicObject)calcEntryDetailMap.get(bizEntryKeyStr);
                    if (calcResultEntry != null) {
                        this.setAdjInfo(calcResultEntry, adjustType, adjustamt);
                        continue;
                    }
                    DynamicObject detailRow = calcResultEntryEntitys.addNew();
                    calcEntryDetailMap.putIfAbsent(bizEntryKeyStr, detailRow);
                    this.setDetailRow(detailRow, adjustType, null, bizEntry, bizBill.getLong("costobject.id"));
                    this.setAdjInfo(detailRow, adjustType, adjustamt);
                    this.setMaterialInfo(detailRow, costObj);
                    continue;
                }
                for (DynamicObject subBizEntry : subBizEntrys) {
                    String bizEntryKeyStr = this.getBizEntryKeyStr(bizEntry, subBizEntry);
                    DynamicObject calcResultEntry = (DynamicObject)calcEntryDetailMap.get(bizEntryKeyStr);
                    if (calcResultEntry != null) {
                        this.setAdjInfo(calcResultEntry, subBizEntry, adjustType);
                        this.setSubItemRow(calcResultEntry, adjustType, subBizEntry);
                        continue;
                    }
                    DynamicObject detailRow = calcResultEntryEntitys.addNew();
                    calcEntryDetailMap.putIfAbsent(bizEntryKeyStr, detailRow);
                    this.setDetailRow(detailRow, adjustType, subBizEntry, bizEntry, bizBill.getLong("costobject.id"));
                    this.setMaterialInfo(detailRow, costObj);
                    this.setSubItemRow(detailRow, adjustType, subBizEntry);
                }
            }
            this.setFinalResultAdjInfo(finalResultEntry, bizBill, adjustType, tatolAmt);
            calcResultUpdateList.add(calcResult);
        }
    }

    private void setFinalResultAdjInfo(DynamicObject finalResultEntry, DynamicObject bizBill, String adjustType, BigDecimal tatolAmt) {
        if ("END".equals(adjustType)) {
            finalResultEntry.set("endadjqty", bizBill.get("adjustqty"));
            finalResultEntry.set("endadjamt", (Object)tatolAmt);
        } else {
            finalResultEntry.set("startadjqty", bizBill.get("adjustqty"));
            finalResultEntry.set("startadjamt", (Object)tatolAmt);
        }
    }

    private void setCalcResultHeadler(DynamicObject calcResult, DynamicObject bizBill) {
        calcResult.set("billno", (Object)ID.genStringId());
        calcResult.set("org", bizBill.get("org.id"));
        calcResult.set("costobject", bizBill.get("costobject.id"));
        calcResult.set("costaccount", bizBill.get("costaccount.id"));
        calcResult.set("costcenter", bizBill.get("costcenter.id"));
        calcResult.set("period", bizBill.get("period.id"));
        calcResult.set("bizdate", bizBill.get("bookdate"));
        calcResult.set("currency", bizBill.get("currency.id"));
        calcResult.set("billstatus", (Object)"C");
    }

    private void setDetailRow(DynamicObject detailRow, String adjustType, DynamicObject subBizEntry, DynamicObject bizEntry, Long costobjectId) {
        detailRow.set("type", (Object)"detail");
        detailRow.set("relacostobject", (Object)costobjectId);
        detailRow.set("element", bizEntry.get("element"));
        detailRow.set("subelement", bizEntry.get("subelement"));
        detailRow.set("outsourcetype", bizEntry.get("outsourcetype"));
        detailRow.set("relaproducttype", (Object)"C");
        detailRow.set("feetype", (Object)"mfgFee");
        if (subBizEntry == null) {
            return;
        }
        detailRow.set("feetype", (Object)"materialFee");
        detailRow.set("submaterial", subBizEntry.get("submaterial.id"));
        detailRow.set("submatversion", subBizEntry.get("version.id"));
        detailRow.set("subauxpty", subBizEntry.get("auxpty.id"));
        detailRow.set("calckeycol", subBizEntry.get("calckeycol.id"));
        this.setAdjInfo(detailRow, subBizEntry, adjustType);
    }

    private void setSubItemRow(DynamicObject detailRow, String adjustType, DynamicObject subBizEntry) {
        HashMap subitemMap = Maps.newHashMapWithExpectedSize((int)10);
        String json = subBizEntry.getString("subitemjson_tag");
        if (!StringUtils.isEmpty((CharSequence)json)) {
            DynamicObjectCollection dynCols = detailRow.getDynamicObjectCollection("subdetail");
            for (DynamicObject dyn : dynCols) {
                Long ssubelement = dyn.getLong("ssubelement.id");
                if (CadEmptyUtils.isEmpty((Long)ssubelement)) continue;
                subitemMap.put(ssubelement, dyn);
            }
            List subItems = JSON.parseArray((String)json, WipAdjustSubItem.class);
            for (WipAdjustSubItem subItem : subItems) {
                DynamicObject dyn = (DynamicObject)subitemMap.get(subItem.getSsubelement());
                if (dyn == null) {
                    dyn = dynCols.addNew();
                    dyn.set("selement", (Object)subItem.getSelement());
                    dyn.set("ssubelement", (Object)subItem.getSsubelement());
                }
                BigDecimal adjAmt = BigDecimalUtil.getOrZero((Object)subItem.getSadjustamt());
                if ("END".equals(adjustType)) {
                    dyn.set("spdendadjamt", (Object)BigDecimalUtil.getOrZero((Object)dyn.getBigDecimal("spdendadjamt")).add(adjAmt));
                    this.setSubtractCol(dyn, "spdendadjamt", "spdsumcomamt", adjAmt);
                    this.setSubtractCol(dyn, "spdendadjamt", "spdyearcomamt", adjAmt);
                    continue;
                }
                dyn.set("spdstartadjamt", (Object)BigDecimalUtil.getOrZero((Object)dyn.getBigDecimal("spdstartadjamt")).add(adjAmt));
            }
        }
    }

    private void setAdjInfo(DynamicObject detailRow, DynamicObject subBizEntry, String adjustType) {
        if (subBizEntry == null) {
            if ("END".equals(adjustType)) {
                detailRow.set("endadjqty", (Object)BigDecimal.ZERO);
                detailRow.set("endadjamt", (Object)BigDecimal.ZERO);
            } else {
                detailRow.set("startadjqty", (Object)BigDecimal.ZERO);
                detailRow.set("startadjamt", (Object)BigDecimal.ZERO);
            }
            DynamicObjectCollection dynCols = detailRow.getDynamicObjectCollection("subdetail");
            for (DynamicObject dyn : dynCols) {
                if ("END".equals(adjustType)) {
                    dyn.set("spdendadjamt", (Object)BigDecimal.ZERO);
                    continue;
                }
                dyn.set("spdstartadjamt", (Object)BigDecimal.ZERO);
            }
            return;
        }
        if ("END".equals(adjustType)) {
            detailRow.set("endadjqty", (Object)BigDecimalUtil.getOrZero((Object)detailRow.getBigDecimal("endadjqty")).add(BigDecimalUtil.getOrZero((Object)subBizEntry.get("submatadjqty"))));
            detailRow.set("endadjamt", (Object)BigDecimalUtil.getOrZero((Object)detailRow.getBigDecimal("endadjamt")).add(BigDecimalUtil.getOrZero((Object)subBizEntry.get("submatadjamt"))));
        } else {
            detailRow.set("startadjqty", (Object)BigDecimalUtil.getOrZero((Object)detailRow.getBigDecimal("startadjqty")).add(BigDecimalUtil.getOrZero((Object)subBizEntry.get("submatadjqty"))));
            detailRow.set("startadjamt", (Object)BigDecimalUtil.getOrZero((Object)detailRow.getBigDecimal("startadjamt")).add(BigDecimalUtil.getOrZero((Object)subBizEntry.get("submatadjamt"))));
        }
    }

    private void setAdjInfo(DynamicObject detailRow, String adjustType, BigDecimal adjustamt) {
        if (adjustamt == null) {
            adjustamt = BigDecimal.ZERO;
        }
        if ("END".equals(adjustType)) {
            detailRow.set("endadjamt", (Object)BigDecimalUtil.getOrZero((Object)detailRow.getBigDecimal("endadjamt")).add(adjustamt));
        } else {
            detailRow.set("startadjamt", (Object)BigDecimalUtil.getOrZero((Object)detailRow.getBigDecimal("startadjamt")).add(adjustamt));
        }
    }

    private void setMaterialInfo(DynamicObject detailRow, DynamicObject costObj) {
        if (costObj == null) {
            return;
        }
        detailRow.set("material", (Object)costObj.getDynamicObject("material"));
        detailRow.set("auxpty", (Object)costObj.getDynamicObject("auxpty"));
        detailRow.set("matversion", (Object)costObj.getDynamicObject("bomversion"));
    }
}

