/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.business.wipcostcheck;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.aca.algox.enums.TerminalWipMatEnum;
import kd.macc.aca.algox.utils.AcaCalcRangeHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class TerminalWipMatCheckService {
    private static final Log logger = LogFactory.getLog(TerminalWipMatCheckService.class);
    private static final String alGoKey = "TerminalWipMatCheckService";
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String[] entryFileName = new String[]{"material", "matversion", "auxpty", "unit", "qty", "costmaterial", "costauxpty", "lot"};

    public String importDataByHand(Long orgId, Long costaccountId, Date currPeriodEndDate, Long costcenterId, boolean deleteData) {
        StringBuilder tips;
        TerminalWipMatEnum checkType;
        block38: {
            QFilter costCenterQf;
            if (CadEmptyUtils.isEmpty((Long)orgId) || CadEmptyUtils.isEmpty((Long)costaccountId) || currPeriodEndDate == null) {
                return ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u6216\u6210\u672c\u8d26\u7c3f\u6216\u6210\u672c\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TerminalWipMatCheckService_0", (String)"macc-aca-business", (Object[])new Object[0]);
            }
            if (CadEmptyUtils.isEmpty((Long)costcenterId)) {
                QFilter filter = new QFilter("accountorg", "=", (Object)orgId);
                QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                QFilter orgdutyFilter = new QFilter("orgduty", "=", (Object)4L);
                List costCenterList = QueryServiceHelper.queryPrimaryKeys((String)"bos_costcenter", (QFilter[])new QFilter[]{filter, enableFilter, orgdutyFilter}, null, (int)-1);
                if (CadEmptyUtils.isEmpty((List)costCenterList)) {
                    return ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u672a\u627e\u5230\u53ef\u7528\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TerminalWipMatCheckService_1", (String)"macc-aca-business", (Object[])new Object[0]);
                }
                String tip = this.checkCenter(orgId, costCenterList);
                if (!StringUtils.isEmpty((CharSequence)tip)) {
                    return tip;
                }
                costCenterQf = new QFilter("costcenter", "in", (Object)costCenterList);
            } else {
                ArrayList<Object> costCenterList = new ArrayList<Object>();
                costCenterList.add(costcenterId);
                String tip = this.checkCenter(orgId, costCenterList);
                if (!StringUtils.isEmpty((CharSequence)tip)) {
                    return tip;
                }
                costCenterQf = new QFilter("costcenter", "=", (Object)costcenterId);
            }
            QFilter orgQf = new QFilter("org", "=", (Object)orgId);
            QFilter bizTypeQf = new QFilter("biztype", "=", (Object)"RO");
            List roCostObjectIds = QueryServiceHelper.queryPrimaryKeys((String)"cad_costobject", (QFilter[])new QFilter[]{orgQf, costCenterQf, bizTypeQf}, null, (int)-1);
            Long currPeriod = CalcRptHelper.getCurrPeriod((Long)orgId, (Long)costaccountId);
            Set calcCurPeriodCostobjectRange = AcaCalcRangeHelper.getCalResultAndPlanCostObject((Long)orgId, (Long)costaccountId, (Long)currPeriod, (Long)0L);
            roCostObjectIds.retainAll(calcCurPeriodCostobjectRange);
            if (CadEmptyUtils.isEmpty((List)roCostObjectIds)) {
                return ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u672a\u627e\u5230\u6210\u672c\u8ba1\u7b97\u65b9\u6cd5=\u5de5\u5355\u6cd5\u4e14\u6709\u671f\u521d\u6216\u672c\u671f\u6295\u5165\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u4e0d\u80fd\u6267\u884c\u201c\u5f15\u5165\u7ec4\u4ef6\u6e05\u5355\u201d\u3002", (String)"TerminalWipMatCheckService_2", (String)"macc-aca-business", (Object[])new Object[0]);
            }
            DataSet costObjectRows = QueryServiceHelper.queryDataSet((String)alGoKey, (String)"cad_costobject", (String)"id,probill,isoutsource,costcenter,material.masterid as costmaterial,auxpty as costauxpty", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)roCostObjectIds)}, null);
            HashMap<Long, Long> proEntryToCostObjIdMap = new HashMap<Long, Long>(32);
            HashSet<Long> proBillIds = new HashSet<Long>(16);
            HashSet<Long> outProBillIds = new HashSet<Long>(16);
            DataSet costObjectRowsCopy = costObjectRows.copy();
            while (costObjectRowsCopy.hasNext()) {
                Row costObjectRow = costObjectRowsCopy.next();
                Long probill = costObjectRow.getLong("probill");
                Long costObjId = costObjectRow.getLong("id");
                if (costObjectRow.getBoolean("isoutsource").booleanValue()) {
                    outProBillIds.add(probill);
                } else {
                    proBillIds.add(probill);
                }
                proEntryToCostObjIdMap.put(probill, costObjId);
            }
            DataSet mftOrderRows = QueryServiceHelper.queryDataSet((String)alGoKey, (String)"pom_mftstock", (String)this.getQueryFileName(), (QFilter[])new QFilter[]{new QFilter("orderentryid", "in", proBillIds)}, null);
            DataSet omMftOrderRows = QueryServiceHelper.queryDataSet((String)alGoKey, (String)"om_mftstock", (String)this.getQueryFileName(), (QFilter[])new QFilter[]{new QFilter("orderentryid", "in", outProBillIds)}, null);
            mftOrderRows = mftOrderRows.union(omMftOrderRows);
            HashSet<Long> matIdSet = new HashSet<Long>();
            DataSet mftOrderRowsCopy = mftOrderRows.copy();
            while (mftOrderRowsCopy.hasNext()) {
                Row next = mftOrderRowsCopy.next();
                Long material = next.getLong("material");
                matIdSet.add(material);
            }
            DataSet bomVersionDs = this.getBomVersionDs(matIdSet);
            mftOrderRows = mftOrderRows.leftJoin(bomVersionDs).on("material", "enableVersionMat").select(new String[]{"orderentryid", "unit", "material", "lot", "qty", "auxpty", "case when enableVersionMat>0  then matversion else 0L end matversion"}).finish().groupBy(new String[]{"orderentryid", "unit", "material", "matversion", "lot", "auxpty"}).sum("qty").finish();
            checkType = this.getCheckType(orgId);
            DataSet terWipMatCheckDataSet = mftOrderRows.leftJoin(costObjectRows).on("orderentryid", "probill").select(mftOrderRows.getRowMeta().getFieldNames(), costObjectRows.getRowMeta().getFieldNames()).finish().filter("qty!=0").orderBy(new String[]{"costcenter"});
            Long preCostCenter = 0L;
            ArrayList<DynamicObject> saveDataList = new ArrayList<DynamicObject>();
            DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency AS currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costaccountId)});
            Long currency = result.getLong("currency");
            DynamicObject terWipMatCheckDy = null;
            int maxNum = 1000;
            int num = 0;
            int entrySeq = 0;
            long currUserId = RequestContext.get().getCurrUserId();
            String billstatus = "C";
            if (TerminalWipMatEnum.CHECKTYPE_AMOUNT == checkType) {
                billstatus = "A";
            }
            Date date = new Date();
            while (terWipMatCheckDataSet.hasNext()) {
                Row terWipMatCheck = terWipMatCheckDataSet.next();
                Long costCenterId = terWipMatCheck.getLong("costcenter");
                Long probillId = terWipMatCheck.getLong("probill");
                BigDecimal qty = terWipMatCheck.getBigDecimal("qty");
                Long material = terWipMatCheck.getLong("material");
                if (CadEmptyUtils.isEmpty((Long)material) || CadEmptyUtils.isEmpty((BigDecimal)qty) || BigDecimal.ZERO.compareTo(qty) == 0) continue;
                if (preCostCenter.compareTo(costCenterId) != 0 || num >= maxNum || terWipMatCheckDy == null) {
                    preCostCenter = costCenterId;
                    num = 0;
                    entrySeq = 0;
                    terWipMatCheckDy = BusinessDataServiceHelper.newDynamicObject((String)"aca_terminalwipmatcheck");
                    try {
                        String number = CodeRuleServiceHelper.getNumber((String)"aca_terminalwipmatcheck", (DynamicObject)terWipMatCheckDy, (String)String.valueOf(orgId));
                        terWipMatCheckDy.set("billno", (Object)number);
                    }
                    catch (Exception e) {
                        logger.error("\u5355\u636e\u7f16\u53f7\u83b7\u53d6\u5931\u8d25,\u8bf7\u68c0\u67e5\u662f\u5426\u542f\u7528\u7f16\u53f7\u89c4\u5219\u3002", (Throwable)e);
                        return ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u542f\u7528\u7f16\u53f7\u89c4\u5219\u3002", (String)"TerminalWipMatCheckService_3", (String)"macc-aca-business", (Object[])new Object[0]);
                    }
                    terWipMatCheckDy.set("org", (Object)orgId);
                    terWipMatCheckDy.set("costcenter", (Object)costCenterId);
                    terWipMatCheckDy.set("costaccount", (Object)costaccountId);
                    terWipMatCheckDy.set("currency", (Object)currency);
                    terWipMatCheckDy.set("bookdate", (Object)currPeriodEndDate);
                    terWipMatCheckDy.set("period", (Object)currPeriod);
                    terWipMatCheckDy.set("billstatus", (Object)billstatus);
                    terWipMatCheckDy.set("creator", (Object)currUserId);
                    terWipMatCheckDy.set("createtime", (Object)date);
                    terWipMatCheckDy.set("modifier", (Object)currUserId);
                    terWipMatCheckDy.set("modifytime", (Object)date);
                    if ("C".equals(billstatus)) {
                        terWipMatCheckDy.set("auditor", (Object)currUserId);
                        terWipMatCheckDy.set("auditdate", (Object)date);
                    }
                    saveDataList.add(terWipMatCheckDy);
                }
                ++num;
                DynamicObjectCollection entryentity = terWipMatCheckDy.getDynamicObjectCollection("entryentity");
                Long costObjectId = (Long)proEntryToCostObjIdMap.get(probillId);
                if (CadEmptyUtils.isEmpty((Long)costObjectId)) {
                    logger.error("\u5de5\u5355\u5206\u5f55id{}\uff0c\u6ca1\u6709\u5bf9\u5e94\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61", (Object)probillId);
                    continue;
                }
                DynamicObject entry = entryentity.addNew();
                long entryId = this.getLongId("t_aca_wipmatcheck_entry");
                entry.set("id", (Object)entryId);
                entry.set("seq", (Object)(++entrySeq));
                entry.set("costobject", (Object)costObjectId);
                entry.set("source", (Object)"syscal");
                entry.set("allocstatus", (Object)"0");
                for (String fileName : entryFileName) {
                    entry.set(fileName, terWipMatCheck.get(fileName));
                }
            }
            int delete = 0;
            tips = new StringBuilder();
            try (TXHandle handle = TX.requiresNew();){
                try {
                    String deleteStr;
                    if (deleteData) {
                        QFilter costaccountQf = new QFilter("costaccount", "=", (Object)costaccountId);
                        QFilter currPeriodQf = new QFilter("period", "=", (Object)currPeriod);
                        QFilter[] qFilters = new QFilter[]{orgQf, costaccountQf, costCenterQf, currPeriodQf};
                        DeleteServiceHelper.delete((String)"aca_terminalwipmatallco", (QFilter[])new QFilter[]{orgQf, costaccountQf, currPeriodQf});
                        delete = DeleteServiceHelper.delete((String)"aca_terminalwipmatcheck", (QFilter[])qFilters);
                    }
                    String string = deleteStr = delete < 1 ? "" : String.format(ResManager.loadKDString((String)"\u5220\u9664%s\u6761\u6570\u636e", (String)"TerminalWipMatCheckService_4", (String)"macc-aca-business", (Object[])new Object[0]), delete);
                    if (saveDataList.size() > 0) {
                        OperationResult resultOp = OperationServiceHelper.executeOperate((String)"save", (String)"aca_terminalwipmatcheck", (DynamicObject[])saveDataList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                        int size = resultOp.getSuccessPkIds().size();
                        if (size > 0) {
                            String info = String.format(ResManager.loadKDString((String)"\u5f15\u5165\u6210\u529f %s \u6761\u6570\u636e\u3002", (String)"TerminalWipMatCheckService_5", (String)"macc-aca-business", (Object[])new Object[0]), size);
                            tips.append(info);
                        }
                        if (!resultOp.isSuccess()) {
                            String message = ((OperateErrorInfo)((ValidateResult)resultOp.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage();
                            String info = String.format(ResManager.loadKDString((String)"\u5931\u8d25%s\u6761\u6570\u636e\u3002", (String)"TerminalWipMatCheckService_6", (String)"macc-aca-business", (Object[])new Object[0]), saveDataList.size() - size);
                            tips.append(info);
                            tips.append(message);
                        }
                        tips.append(deleteStr);
                        break block38;
                    }
                    tips.append(deleteStr);
                }
                catch (Exception e) {
                    handle.markRollback();
                    logger.error("{}\u5f15\u5165\u5931\u8d25 {}", (Object)alGoKey, (Object)e);
                    tips.append(e.getMessage());
                }
            }
        }
        if (tips.length() < 1) {
            return String.format(ResManager.loadKDString((String)"\u76d8\u70b9\u65b9\u5f0f\u4e3a%s\uff0c\u6ca1\u6709\u7b26\u5408\u5f15\u5165\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"TerminalWipMatCheckService_7", (String)"macc-aca-business", (Object[])new Object[0]), checkType.getName());
        }
        String opType = ResManager.loadKDString((String)"\u5f15\u5165\u7ec4\u4ef6\u6e05\u5355", (String)"TerminalWipMatCheckService_8", (String)"macc-aca-business", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)tips.toString(), (String)"aca_terminalwipmatcheck", (String)"aca");
        return tips.toString();
    }

    private Long getLongId(String entityName) {
        return DB.genLongId((String)entityName);
    }

    private String checkCenter(Long orgId, List<Object> costCenterList) {
        if (CadEmptyUtils.isEmpty(costCenterList)) {
            return null;
        }
        costCenterList.add(0L);
        QFilter orgQf = new QFilter("accountorg", "=", (Object)orgId);
        QFilter costcenterQf = new QFilter("costcenter", "in", costCenterList);
        DataSet rows = QueryServiceHelper.queryDataSet((String)"checkCenter", (String)"cad_costobjectrule", (String)"costcenter,costcenter.name as name,biztype", (QFilter[])new QFilter[]{orgQf, costcenterQf}, null);
        HashSet<Long> idSet = new HashSet<Long>();
        Boolean flag = false;
        StringBuilder keyBuilder = new StringBuilder(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u6210\u672c\u4e2d\u5fc3\u201c", (String)"TerminalWipMatCheckService_9", (String)"macc-aca-business", (Object[])new Object[0]));
        while (rows.hasNext()) {
            Row row = rows.next();
            String biztype = row.getString("biztype");
            Long costcenter = row.getLong("costcenter");
            if (!"RO".equals(biztype)) {
                if (CadEmptyUtils.isEmpty((Long)costcenter) || idSet.contains(costcenter)) continue;
                keyBuilder.append(row.getString("name")).append('\uff0c');
                idSet.add(costcenter);
                continue;
            }
            if (CadEmptyUtils.isEmpty((Long)costcenter)) {
                flag = true;
                continue;
            }
            return null;
        }
        if (flag.booleanValue()) {
            costCenterList.removeAll(idSet);
            if (costCenterList.size() > 1) {
                return null;
            }
        }
        if (CadEmptyUtils.isEmpty(idSet)) {
            return ResManager.loadKDString((String)"\u6240\u6709\u6210\u672c\u4e2d\u5fc3\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u4e2d\u7684\u6210\u672c\u8ba1\u7b97\u65b9\u6cd5\u2260\u5de5\u5355\u6cd5\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TerminalWipMatCheckService_10", (String)"macc-aca-business", (Object[])new Object[0]);
        }
        keyBuilder.setLength(keyBuilder.length() - 1);
        return keyBuilder.append(ResManager.loadKDString((String)"\u201d\u7684\u6210\u672c\u8ba1\u7b97\u65b9\u6cd5\u2260\u5de5\u5355\u6cd5\uff0c\u4e0d\u80fd\u6267\u884c\u201c\u5f15\u5165\u7ec4\u4ef6\u6e05\u5355\u201d\u3002", (String)"TerminalWipMatCheckService_11", (String)"macc-aca-business", (Object[])new Object[0])).toString();
    }

    private TerminalWipMatEnum getCheckType(Long orgId) {
        TerminalWipMatEnum fileName = TerminalWipMatEnum.CHECKTYPE_QTY;
        DynamicObject loadData = BusinessDataServiceHelper.loadSingle((String)"aca_checksetting", (String)"checktype", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        if (!CadEmptyUtils.isEmpty((DynamicObject)loadData)) {
            String checktype = loadData.getString("checktype");
            fileName = TerminalWipMatEnum.CHECKTYPE_AMOUNT.getValue().equals(checktype) ? TerminalWipMatEnum.CHECKTYPE_AMOUNT : TerminalWipMatEnum.CHECKTYPE_QTY;
        }
        return fileName;
    }

    private String getQueryFileName() {
        return "orderentryid,baseunitid as unit,stockentry.materielmasterid as material,stockentry.bomreversion as matversion,stockentry.lot as lot,stockentry.wipqty as qty,stockentry.childauxpropertyid as auxpty";
    }

    private DataSet getAffectPriceDs(Set<Long> materialIdSet) {
        QFilter filter = new QFilter("id", "in", materialIdSet);
        filter.and("isuseauxpty", "=", (Object)Boolean.TRUE);
        filter.and("auxptyentry.isaffectprice", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.queryDataSet((String)"getAffectPriceDsmat", (String)"bd_material", (String)"id as effectpricemat", (QFilter[])new QFilter[]{filter}, null).distinct();
    }

    private DataSet getBomVersionDs(HashSet<Long> matIdSet) {
        QFilter filter = new QFilter("id", "in", matIdSet);
        filter.and("isenablematerialversion", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.queryDataSet((String)"getBomVersionDs", (String)"bd_material", (String)"id as enableVersionMat", (QFilter[])new QFilter[]{filter}, null).distinct();
    }
}

