/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.basedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.macc.aca.common.helper.AcaCostAccountHelper;
import kd.macc.aca.opplugin.AcaCommonOp;
import kd.macc.aca.opplugin.basedata.ProductExtraPriceOpValidator;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class ProductExtraPriceOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("costaccount");
        fieldKeys.add("material");
        fieldKeys.add("matversion");
        fieldKeys.add("auxpty");
        fieldKeys.add("subelement");
        fieldKeys.add("price");
        fieldKeys.add("startperiod");
        fieldKeys.add("manuorg");
        fieldKeys.add("costcenter");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ProductExtraPriceOpValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            boolean isUseAuxpty;
            DynamicObject matVersion;
            String dataSrc = dataEntity.getString("datasrc");
            if (StringUtils.isBlank((CharSequence)dataSrc)) {
                dataEntity.set("datasrc", (Object)"manual");
            }
            StringBuilder stringBuilder = new StringBuilder(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b", (String)"ProductExtraPriceOpPlugin_0", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
            Long orgId = dataEntity.getDynamicObject("org").getLong("id");
            qFilters.add(new QFilter("org.id", "=", (Object)orgId));
            DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
            stringBuilder.append(String.format(ResManager.loadKDString((String)" \u6210\u672c\u8d26\u7c3f\uff1a\u3010%s\u3011", (String)"ProductExtraPriceOpPlugin_11", (String)"macc-aca-opplugin", (Object[])new Object[0]), costAccount.getString("name")));
            Long costAccountId = costAccount.getLong("id");
            qFilters.add(new QFilter("costaccount.id", "=", (Object)costAccountId));
            DynamicObject manuorg = dataEntity.getDynamicObject("manuorg");
            if (manuorg == null) {
                qFilters.add(new QFilter("manuorg", "=", (Object)0L));
            } else {
                qFilters.add(new QFilter("manuorg", "=", manuorg.getPkValue()));
                stringBuilder.append(String.format(ResManager.loadKDString((String)" \u751f\u4ea7\u7ec4\u7ec7\uff1a\u3010%s\u3011", (String)"ProductExtraPriceOpPlugin_12", (String)"macc-aca-opplugin", (Object[])new Object[0]), manuorg.getString("name")));
            }
            DynamicObject costcenter = dataEntity.getDynamicObject("costcenter");
            if (costcenter == null) {
                qFilters.add(new QFilter("costcenter", "=", (Object)0L));
            } else {
                qFilters.add(new QFilter("costcenter", "=", costcenter.getPkValue()));
                stringBuilder.append(String.format(ResManager.loadKDString((String)" \u6210\u672c\u4e2d\u5fc3\uff1a\u3010%s\u3011", (String)"ProductExtraPriceOpPlugin_13", (String)"macc-aca-opplugin", (Object[])new Object[0]), costcenter.getString("name")));
            }
            Object pkValue = dataEntity.getPkValue();
            if (pkValue != null) {
                qFilters.add(new QFilter("id", "!=", pkValue));
            }
            DynamicObject material = dataEntity.getDynamicObject("material");
            Long materialId = material.getLong("id");
            stringBuilder.append(String.format(ResManager.loadKDString((String)" \u7269\u6599\uff1a\u3010%1$s/%2$s\u3011", (String)"ProductExtraPriceOpPlugin_14", (String)"macc-aca-opplugin", (Object[])new Object[0]), material.getString("number"), material.getString("name")));
            qFilters.add(new QFilter("material.id", "=", (Object)materialId));
            boolean enableVersion = material.getBoolean("isenablematerialversion");
            if (enableVersion && (matVersion = dataEntity.getDynamicObject("matversion")) != null) {
                Long matVersionId = matVersion.getLong("id");
                stringBuilder.append(String.format(ResManager.loadKDString((String)" \u7269\u6599\u7248\u672c\uff1a\u3010%1$s/%2$s\u3011", (String)"ProductExtraPriceOpPlugin_15", (String)"macc-aca-opplugin", (Object[])new Object[0]), matVersion.getString("number"), matVersion.getString("name")));
                qFilters.add(new QFilter("matversion.id", "=", (Object)matVersionId));
            }
            if (isUseAuxpty = material.getBoolean("isuseauxpty")) {
                boolean isaffectprice = false;
                DynamicObjectCollection auxptyentry = material.getDynamicObjectCollection("auxptyentry");
                for (DynamicObject aux : auxptyentry) {
                    if (!aux.getBoolean("isaffectprice")) continue;
                    isaffectprice = true;
                    break;
                }
                if (isaffectprice) {
                    DynamicObject auxpty = dataEntity.getDynamicObject("auxpty");
                    Set<Long> auxptyIdSet = material.getDynamicObjectCollection("auxptyentry").stream().map(dynamicObject -> dynamicObject.getLong("auxpty.id")).collect(Collectors.toSet());
                    Long auxptyId = auxpty.getLong("id");
                    stringBuilder.append(String.format(ResManager.loadKDString((String)" \u8f85\u52a9\u5c5e\u6027\u3010%s\u3011", (String)"ProductExtraPriceOpPlugin_16", (String)"macc-aca-opplugin", (Object[])new Object[0]), AcaCommonOp.getAuptyInfo(auxptyIdSet, (String)auxpty.get(1))));
                    qFilters.add(new QFilter("auxpty.id", "=", (Object)auxptyId));
                }
            }
            Date beginDate = AcaCostAccountHelper.getCurrentPeriodStartDateByCostAccountId((long)costAccountId);
            QFilter startDate = new QFilter("startdate", "<=", (Object)beginDate);
            QFilter endDate = new QFilter("enddate", ">=", (Object)beginDate);
            qFilters.add(startDate);
            qFilters.add(endDate);
            DynamicObject[] collection = BusinessDataServiceHelper.load((String)"aca_proextraprice", (String)"id,startperiod,endperiod,startdate,enddate", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"startdate desc", (int)1);
            Long currentPeriodId = AcaCostAccountHelper.getCurrentPeriodByCostAccountId((String)String.valueOf(costAccountId));
            long dataPeriodId = dataEntity.getLong("startperiod".concat(".id"));
            if (currentPeriodId == null) {
                e.setCancelMessage(ResManager.loadKDString((String)"\u901a\u8fc7\u6838\u7b97\u7ec4\u7ec7\u672a\u83b7\u53d6\u5230\u5f53\u524d\u671f\u95f4\uff0c\u8bf7\u68c0\u67e5\u6838\u7b97\u7ec4\u7ec7\u671f\u95f4\u8bbe\u7f6e\u3002", (String)"ProductExtraPriceOpPlugin_7", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                e.setCancel(true);
                continue;
            }
            if (collection == null || collection.length == 0) {
                qFilters.remove(startDate);
                qFilters.remove(endDate);
                qFilters.add(new QFilter("startdate", ">=", (Object)beginDate));
                dataEntity.set("startperiod".concat("_id"), (Object)currentPeriodId);
                dataEntity.set("startdate", (Object)beginDate);
                DynamicObject[] biggerStartBills = BusinessDataServiceHelper.load((String)"aca_proextraprice", (String)"id,startperiod,endperiod,startdate,enddate", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"startdate asc", (int)1);
                if (biggerStartBills != null && biggerStartBills.length != 0) {
                    DynamicObject biggerBill = biggerStartBills[0];
                    dataEntity.set("endperiod".concat("_id"), (Object)biggerBill.getDynamicObject("startperiod").getLong("id"));
                    dataEntity.set("enddate", (Object)biggerBill.getDate("startdate"));
                    continue;
                }
                dataEntity.set("enddate", (Object)DateUtils.getMaxDate());
                continue;
            }
            DynamicObject existsData = collection[0];
            Long existsStartPeriodId = existsData.getDynamicObject("startperiod").getLong("id");
            if (existsStartPeriodId.equals(currentPeriodId)) {
                stringBuilder.append(String.format(ResManager.loadKDString((String)"\u5728\u201c%s\u201d\u751f\u6548\u671f\u95f4\u5185\u5df2\u7ecf\u8bbe\u7f6e\u4e86\u7269\u6599\u5b9a\u989d\u6210\u672c\u4ef7\u76ee\u8868\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"ProductExtraPriceOpPlugin_17", (String)"macc-aca-opplugin", (Object[])new Object[0]), existsData.getDynamicObject("startperiod").getString("name")));
                e.setCancelMessage(stringBuilder.toString());
                e.setCancel(true);
                continue;
            }
            Long oldId = existsData.getLong("id");
            if (!CadEmptyUtils.isEmpty((Long)oldId)) {
                this.updatePreBill(oldId, currentPeriodId, beginDate);
            }
            dataEntity.set("startperiod".concat("_id"), (Object)currentPeriodId);
            dataEntity.set("startdate", (Object)beginDate);
            dataEntity.set("enddate", (Object)DateUtils.getMaxDate());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        String operationKey = e.getOperationKey();
        for (DynamicObject productExtraPrice : dataEntities = e.getDataEntities()) {
            productExtraPrice.set("modifytime", null);
            productExtraPrice.set("modifier", null);
            productExtraPrice.set("createtime", (Object)new Date());
            productExtraPrice.set("endperiod", null);
            if (!operationKey.equals("copy")) continue;
            SaveServiceHelper.update((DynamicObject)productExtraPrice);
        }
    }

    private DynamicObject updatePreBill(Long oldId, Long periodId, Date endDate) {
        DynamicObject productExtraPrice = BusinessDataServiceHelper.loadSingle((Object)oldId, (String)"aca_proextraprice");
        DynamicObject endPeriod = productExtraPrice.getDynamicObject("endperiod");
        productExtraPrice.set("endperiod", (Object)periodId);
        productExtraPrice.set("modifytime", (Object)new Date());
        productExtraPrice.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        productExtraPrice.set("enddate", (Object)endDate);
        SaveServiceHelper.update((DynamicObject)productExtraPrice);
        return endPeriod;
    }
}

