/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.basedata;

import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.opplugin.AcaCommonOp;

public class ProductExtraPriceUniqeValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        StringBuilder tipBuilder = new StringBuilder();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            boolean isUseAuxpty;
            DynamicObject dataEntityDy = dataEntity.getDataEntity();
            DynamicObject org = dataEntityDy.getDynamicObject("org");
            DynamicObject costaccount = dataEntityDy.getDynamicObject("costaccount");
            if (org == null || costaccount == null) continue;
            qFilters.add(new QFilter("org", "=", org.getPkValue()));
            qFilters.add(new QFilter("costaccount", "=", costaccount.getPkValue()));
            tipBuilder.append(org.getString("name")).append("+");
            tipBuilder.append(costaccount.getString("name")).append("+");
            DynamicObject manuorg = dataEntityDy.getDynamicObject("manuorg");
            if (manuorg == null) {
                qFilters.add(new QFilter("manuorg", "=", (Object)0L));
            } else {
                qFilters.add(new QFilter("manuorg", "=", manuorg.getPkValue()));
                tipBuilder.append(manuorg.getString("name")).append("+");
            }
            DynamicObject costcenter = dataEntityDy.getDynamicObject("costcenter");
            if (costcenter == null) {
                qFilters.add(new QFilter("costcenter", "=", (Object)0L));
            } else {
                qFilters.add(new QFilter("costcenter", "=", costcenter.getPkValue()));
                tipBuilder.append(costcenter.getString("name")).append("+");
            }
            DynamicObject material = dataEntityDy.getDynamicObject("material");
            if (material == null) continue;
            qFilters.add(new QFilter("material", "=", material.getPkValue()));
            tipBuilder.append(material.getString("name"));
            Long materialId = material.getLong("id");
            qFilters.add(new QFilter("material.id", "=", (Object)materialId));
            boolean enableVersion = material.getBoolean("isenablematerialversion");
            if (enableVersion) {
                DynamicObject matVersion = dataEntityDy.getDynamicObject("matversion");
                Long matVersionId = matVersion.getLong("id");
                tipBuilder.append("+").append(matVersion.getString("name"));
                qFilters.add(new QFilter("matversion.id", "=", (Object)matVersionId));
            }
            if (isUseAuxpty = material.getBoolean("isuseauxpty")) {
                Boolean isaffectprice = false;
                DynamicObjectCollection auxptyentry = material.getDynamicObjectCollection("auxptyentry");
                for (DynamicObject aux : auxptyentry) {
                    if (!aux.getBoolean("isaffectprice")) continue;
                    isaffectprice = true;
                    break;
                }
                if (isaffectprice.booleanValue()) {
                    DynamicObject auxpty = dataEntityDy.getDynamicObject("auxpty");
                    Set<Long> auxptyIdSet = material.getDynamicObjectCollection("auxptyentry").stream().map(dynamicObject -> dynamicObject.getLong("auxpty.id")).collect(Collectors.toSet());
                    Long auxptyId = auxpty.getLong("id");
                    tipBuilder.append("+").append(AcaCommonOp.getAuptyInfo(auxptyIdSet, (String)auxpty.get(1)));
                    qFilters.add(new QFilter("auxpty.id", "=", (Object)auxptyId));
                }
            }
            qFilters.add(new QFilter("id", "!=", dataEntityDy.getPkValue()));
            boolean exists = QueryServiceHelper.exists((String)"aca_proextraprice", (QFilter[])qFilters.toArray(new QFilter[0]));
            if (exists) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u5df2\u7ecf\u5b58\u5728\u201c%s\u201d\u7ec4\u5408\u7684\u6570\u636e\u3002", (String)"ProductExtraPriceUniqeValidator_0", (String)"macc-aca-opplugin", (Object[])new Object[0]), tipBuilder.toString()));
            }
            tipBuilder.setLength(0);
        }
    }
}

