/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.cal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.macc.cad.common.constants.DutyIdConstants;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CalcKeycolHelper;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class EwipEnterSaveOpValidator
extends AbstractValidator {
    private static final String MATTYPE = "001";
    private static final String MATCOST = "002";

    public void validate() {
        ExtendedDataEntity[] datas = this.dataEntities;
        HashMap<String, Set> costaccountKeyColMap = new HashMap<String, Set>(10);
        for (int i = 0; i < datas.length; ++i) {
            ExtendedDataEntity dataEntity = datas[i];
            Long orgId = dataEntity.getDataEntity().getLong("org.id");
            Long costaccountId = dataEntity.getDataEntity().getLong("costaccount.id");
            String key = String.format("%s@%s", orgId, costaccountId);
            Set calcKeys = (Set)costaccountKeyColMap.get(key);
            if (calcKeys == null) {
                calcKeys = CalcKeycolHelper.getCostaccountKeyCols((Long)orgId, (Long)costaccountId, (String)"aca");
                costaccountKeyColMap.put(key, calcKeys);
            }
            this.relateData(dataEntity);
            this.validateSave(dataEntity, CadEmptyUtils.isEmpty((Set)calcKeys));
        }
    }

    private void relateData(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection entryEntity;
        DynamicObject item = dataEntity.getDataEntity();
        String source = item.getString("source");
        String billStatus = item.getString("billstatus");
        if ("import".equals(source) && !"C".equals(billStatus) && CollectionUtils.isNotEmpty((Collection)(entryEntity = item.getDynamicObjectCollection("entryentity")))) {
            Map<Long, DynamicObject> subElementSubEntryMap = entryEntity.stream().filter(dynamicObject -> "subentry".equals(dynamicObject.getString("importtype"))).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("subelement".concat(".id")), dynamicObject -> dynamicObject));
            if (!subElementSubEntryMap.isEmpty()) {
                for (DynamicObject entry : entryEntity) {
                    if (entry == null) continue;
                    long subElementId = entry.getLong("subelement".concat(".id"));
                    entry.set("element".concat("_id"), (Object)ElementRelationHelper.getElement((long)subElementId));
                    if (!subElementSubEntryMap.containsKey(subElementId) || "subentry".equals(entry.getString("importtype"))) continue;
                    DynamicObject entryEntityVal = subElementSubEntryMap.get(subElementId);
                    entry.set("subentryentity", entryEntityVal.get("subentryentity"));
                }
            }
            if (!subElementSubEntryMap.isEmpty()) {
                Iterator iterator = entryEntity.iterator();
                while (iterator.hasNext()) {
                    DynamicObject entry;
                    entry = (DynamicObject)iterator.next();
                    if (entry == null) {
                        iterator.remove();
                        continue;
                    }
                    if (!"subentry".equals(entry.getString("importtype"))) continue;
                    iterator.remove();
                }
            }
        }
    }

    private void validateSave(ExtendedDataEntity dataEntity, boolean checkRepeat) {
        DynamicObject item = dataEntity.getDataEntity();
        String operateKey = this.getOperateKey();
        if ("submit".equals(operateKey)) {
            this.checkBillHead(dataEntity, item);
            this.checkBillBody(dataEntity, item);
            DynamicObjectCollection costInfoList = item.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < costInfoList.size(); ++i) {
                DynamicObjectCollection matInfoList;
                DynamicObject costInfo = (DynamicObject)costInfoList.get(i);
                String subElementType = costInfo.getString("subelement".concat(".type"));
                String subElementName = costInfo.getString("subelement".concat(".name"));
                if (MATTYPE.equals(subElementType) || MATCOST.equals(subElementType)) {
                    matInfoList = costInfo.getDynamicObjectCollection("subentryentity");
                    if (CollectionUtils.isEmpty((Collection)matInfoList)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u9700\u5f55\u5165\u5b50\u7269\u6599\u4fe1\u606f\u3002", (String)"EwipEnterSaveOpValidator_0", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName));
                    }
                    BigDecimal amountTotal = BigDecimal.ZERO;
                    HashMap matRepeatMap = Maps.newHashMapWithExpectedSize((int)16);
                    for (int j = 0; j < matInfoList.size(); ++j) {
                        DynamicObject matInfo = (DynamicObject)matInfoList.get(j);
                        this.validateMat(dataEntity, matInfo, i, j, subElementName, matRepeatMap, checkRepeat);
                        BigDecimal matAmount = matInfo.getBigDecimal("subamount");
                        amountTotal = amountTotal.add(matAmount);
                    }
                    BigDecimal amount = costInfo.getBigDecimal("amount");
                    if (amountTotal.compareTo(amount) == 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u91d1\u989d\u4e0d\u7b49\u4e8e\u5bf9\u5e94\u7684\u5b50\u7269\u6599\u4fe1\u606f\u91d1\u989d\u5408\u8ba1\u3002", (String)"EwipEnterSaveOpValidator_2", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName));
                    continue;
                }
                matInfoList = costInfo.getDynamicObjectCollection("subentryentity");
                if (CollectionUtils.isEmpty((Collection)matInfoList)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u975e\u7269\u6599\u548c\u7269\u6599\u8d39\u7528\u7c7b\u578b\uff0c\u4e0d\u9700\u5f55\u5165\u5b50\u7269\u6599\u4fe1\u606f\u4fe1\u606f\u3002", (String)"EwipEnterSaveOpValidator_3", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName));
            }
        }
    }

    private void checkBillBody(ExtendedDataEntity dataEntity, DynamicObject item) {
        this.validateOutsourceType(dataEntity, item);
    }

    private void validateOutsourceType(ExtendedDataEntity dataEntity, DynamicObject item) {
        DynamicObject costobjectDyn = item.getDynamicObject("costobject");
        if (costobjectDyn == null) {
            return;
        }
        boolean isOutsource = costobjectDyn.getBoolean("isoutsource");
        DynamicObjectCollection dynCols = item.getDynamicObjectCollection("entryentity");
        if (!dynCols.isEmpty()) {
            int i = 1;
            HashSet subelementKeys = Sets.newHashSetWithExpectedSize((int)10);
            for (DynamicObject dyn : dynCols) {
                String outsourcetype = dyn.getString("outsourcetype");
                Long subElementId = dyn.getLong("subelement.id");
                if (!isOutsource && !StringUtils.isBlank((String)outsourcetype)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u5bf9\u8c61\u975e\u59d4\u5916\u65f6\uff0c\u6210\u672c\u4fe1\u606f\u7b2c%s\u884c\uff0c\u59d4\u5916\u6210\u672c\u7c7b\u578b\u4e0d\u9700\u8981\u586b\u503c\u3002", (String)"EwipEnterSaveOpValidator_4", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i)));
                } else if (isOutsource && StringUtils.isBlank((String)outsourcetype)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u5bf9\u8c61\u662f\u59d4\u5916\u5de5\u5355\u65f6\uff0c\u6210\u672c\u4fe1\u606f\u7b2c%s\u884c\uff0c\u59d4\u5916\u6210\u672c\u7c7b\u578b\u5fc5\u5f55\u3002", (String)"EwipEnterSaveOpValidator_5", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i)));
                }
                if (!subelementKeys.add(String.format("%s@%s", subElementId, outsourcetype))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%s\u884c\uff0c\u4e0d\u6ee1\u8db3\u6210\u672c\u5b50\u8981\u7d20\u4e0e\u59d4\u5916\u6210\u672c\u7c7b\u578b\u7ec4\u5408\u552f\u4e00\u3002", (String)"EwipEnterSaveOpValidator_6", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i)));
                }
                ++i;
            }
        }
    }

    private void validateMatTypeElementAmount(ExtendedDataEntity dataEntity, DynamicObject item) {
        DynamicObjectCollection entryEntity = item.getDynamicObjectCollection("entryentity");
        ArrayList<Integer> invalidateRowSeqList = new ArrayList<Integer>(10);
        for (DynamicObject row : entryEntity) {
            String elementType = row.getString("element.type");
            BigDecimal amount = row.getBigDecimal("amount");
            if (!MATTYPE.equals(elementType) || amount != null && amount.compareTo(BigDecimal.ZERO) != 0) continue;
            invalidateRowSeqList.add(row.getInt("seq"));
        }
        if (!CadEmptyUtils.isEmpty(invalidateRowSeqList)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002\u8bf7\u586b\u5199\u6210\u672c\u4fe1\u606f\u7b2c%s\u884c\u91d1\u989d\u4fe1\u606f\u3002", (String)"EwipEnterSaveOpValidator_7", (String)"macc-aca-opplugin", (Object[])new Object[0]), StringUtils.join(invalidateRowSeqList, (String)","));
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }

    private void validateExistMatTypeElement(ExtendedDataEntity dataEntity, DynamicObject item) {
        DynamicObjectCollection entryEntity = item.getDynamicObjectCollection("entryentity");
        boolean hasMatTypeElement = false;
        for (DynamicObject row : entryEntity) {
            String type;
            DynamicObject subElement;
            DynamicObject element;
            if (MATTYPE.equals(row.getString("element.type"))) {
                hasMatTypeElement = true;
                break;
            }
            if (row.get("element") != null || (element = ElementRelationHelper.getElement((DynamicObject)(subElement = row.getDynamicObject("subelement")))) == null || !MATTYPE.equals(type = element.getString("type"))) continue;
            hasMatTypeElement = true;
            break;
        }
        if (!hasMatTypeElement) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002\u6210\u672c\u4fe1\u606f\u5fc5\u987b\u7ef4\u62a4\u7269\u6599\u8981\u7d20\u76f8\u5173\u4fe1\u606f\u3002", (String)"EwipEnterSaveOpValidator_8", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkBillHead(ExtendedDataEntity dataEntity, DynamicObject item) {
        this.checkOrgManuOrg(dataEntity, item);
        this.checkOrgCostAccount(dataEntity, item);
        this.checkOrgCostCenter(dataEntity, item);
        this.checkOrgCostObject(dataEntity, item);
    }

    private void checkOrgManuOrg(ExtendedDataEntity dataEntity, DynamicObject item) {
        DynamicObject org = item.getDynamicObject("org");
        if (org == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EwipEnterSaveOpValidator_9", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        } else if (OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"))) {
            DynamicObject manuOrg = item.getDynamicObject("manuorg");
            if (manuOrg == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u5f00\u542f\u591a\u5de5\u5382\uff0c\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EwipEnterSaveOpValidator_10", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            } else {
                Long manuOrgId = manuOrg.getLong("id");
                List manuOrgIds = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)"aca_wipcostinit", (String)"aca");
                if (!manuOrgIds.contains(manuOrgId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u7b97\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"EwipEnterSaveOpValidator_11", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void checkOrgCostObject(ExtendedDataEntity dataEntity, DynamicObject item) {
        DynamicObject costObject = item.getDynamicObject("costobject");
        if (costObject == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EwipEnterSaveOpValidator_12", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        } else {
            DynamicObject costCenter;
            DynamicObject org = item.getDynamicObject("org");
            if (org != null && costObject.getDynamicObject("org").getLong("id") != org.getLong("id")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e0e\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"EwipEnterSaveOpValidator_13", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            }
            if ((costCenter = item.getDynamicObject("costcenter")) != null && costObject.getDynamicObject("costcenter").getLong("id") != costCenter.getLong("id")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e0e\u6210\u672c\u4e2d\u5fc3\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"EwipEnterSaveOpValidator_14", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkOrgCostCenter(ExtendedDataEntity dataEntity, DynamicObject item) {
        DynamicObject costCenter = item.getDynamicObject("costcenter");
        if (costCenter == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EwipEnterSaveOpValidator_15", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        } else {
            DynamicObject accountOrg;
            long orgDuty = costCenter.getLong("orgduty.id");
            if (orgDuty != DutyIdConstants.BASIC_PRODUCT_ID) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u7c7b\u578b\u4e0d\u4e3a\u7b80\u5355\u751f\u4ea7\u3002", (String)"EwipEnterSaveOpValidator_16", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            }
            if ((accountOrg = costCenter.getDynamicObject("accountorg")) == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u4e0e\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"EwipEnterSaveOpValidator_17", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            } else {
                DynamicObject org = item.getDynamicObject("org");
                if (org != null && accountOrg.getLong("id") != org.getLong("id")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u4e0e\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"EwipEnterSaveOpValidator_17", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void checkOrgCostAccount(ExtendedDataEntity dataEntity, DynamicObject item) {
        DynamicObject costAccount = item.getDynamicObject("costaccount");
        if (costAccount == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EwipEnterSaveOpValidator_18", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        } else {
            DynamicObject calOrg = costAccount.getDynamicObject("calorg");
            if (calOrg != null) {
                DynamicObject org = item.getDynamicObject("org");
                if (org != null && calOrg.getLong("id") != org.getLong("id")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0e\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"EwipEnterSaveOpValidator_19", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                }
            } else {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0e\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"EwipEnterSaveOpValidator_19", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void validateMat(ExtendedDataEntity dataEntity, DynamicObject matInfo, int i, int j, String subElementName, Map<String, Integer> matRepeatMap, boolean checkRepeat) {
        DynamicObject material = matInfo.getDynamicObject("submateriel");
        StringBuilder stringBuilder = new StringBuilder();
        if (material == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u5bf9\u5e94\u7684\u5b50\u7269\u6599\u4fe1\u606f\u7b2c%3$s\u884c\u5b50\u9879\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EwipEnterSaveOpValidator_20", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName, String.valueOf(j + 1)));
        } else {
            DynamicObject matVersion;
            stringBuilder.append(material.getLong("id"));
            if (BomRouterHelper.isEnableMatversion((DynamicObject)material) && (matVersion = matInfo.getDynamicObject("submatversion")) != null) {
                stringBuilder.append(matVersion.getLong("id"));
            }
            if (BomRouterHelper.isEnableAuxprop((DynamicObject)material)) {
                DynamicObject auxpty = matInfo.getDynamicObject("subauxpty");
                if (auxpty == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u5bf9\u5e94\u7684\u5b50\u7269\u6599\u4fe1\u606f\u7b2c%3$s\u884c\u5b50\u9879\u7269\u6599\u5f00\u542f\u4e86\u8f85\u52a9\u5c5e\u6027\u4e14\u8f85\u52a9\u5c5e\u6027\u5f71\u54cd\u6210\u672c\uff0c\u5b50\u9879\u7269\u6599\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EwipEnterSaveOpValidator_22", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName, String.valueOf(j + 1)));
                } else {
                    stringBuilder.append(auxpty.getLong("id"));
                }
            }
        }
        if (stringBuilder.length() > 0) {
            String matKey = stringBuilder.toString();
            if (matRepeatMap.containsKey(matKey) && checkRepeat) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u7b2c%1$s\u884c\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u5bf9\u5e94\u7684\u5b50\u7269\u6599\u4fe1\u606f\u7b2c%3$s\u884c\u6570\u636e\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"EwipEnterSaveOpValidator_23", (String)"macc-aca-opplugin", (Object[])new Object[0]), String.valueOf(i + 1), subElementName, String.valueOf(j + 1)));
            } else {
                matRepeatMap.put(matKey, j + 1);
            }
        }
    }
}

