/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.cal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class FinishCostTranFerCreateVoucherValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.dataEntities;
        HashSet checkSrcBillNos = Sets.newHashSetWithExpectedSize((int)10);
        Long costaccountId = 0L;
        HashMap costaccountPeriodMap = Maps.newHashMapWithExpectedSize((int)10);
        for (ExtendedDataEntity data : datas) {
            DynamicObject dataEntity = data.getDataEntity();
            String billno = dataEntity.getString("billno");
            DynamicObject org = dataEntity.getDynamicObject("org");
            DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
            DynamicObject period = dataEntity.getDynamicObject("period");
            if (period == null) continue;
            costaccountId = (Long)costaccount.getPkValue();
            Long currentperiod = (Long)costaccountPeriodMap.get(costaccountId);
            if (currentperiod == null) {
                QFilter qfOrg = new QFilter("org", "=", org.getPkValue());
                QFilter qfCostAccount = new QFilter("entry.costaccount", "=", costaccount.getPkValue());
                QFilter isInitFilter = new QFilter("entry.isenabled", "=", (Object)Character.valueOf('1'));
                DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, isInitFilter});
                currentperiod = res != null ? Long.valueOf(res.getLong("currentperiod")) : Long.valueOf(0L);
                costaccountPeriodMap.put(costaccountId, currentperiod);
            }
            if (CadEmptyUtils.isEmpty((Long)currentperiod) || currentperiod.compareTo((Long)period.getPkValue()) != 0) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u975e\u6210\u672c\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u80fd\u751f\u6210\u51ed\u8bc1\u3002", (String)"FinishCostTranFerCreateVoucherValidator_3", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                continue;
            }
            String vouchernum = dataEntity.getString("vouchernum");
            if (!CadEmptyUtils.isEmpty((String)vouchernum)) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\u3002", (String)"FinishCostTranFerCreateVoucherValidator_4", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                continue;
            }
            checkSrcBillNos.add(dataEntity.getString("billno"));
        }
        if (!checkSrcBillNos.isEmpty()) {
            QFilter filter = new QFilter("billno", "in", (Object)checkSrcBillNos);
            filter.and("isvoucher", "=", (Object)true);
            filter.and("costaccount", "=", (Object)costaccountId);
            DataSet ds = QueryServiceHelper.queryDataSet((String)"COSTRECORD_SUBENTITY", (String)"cal_costrecord_subentity", (String)"billno", (QFilter[])filter.toArray(), null);
            if (!ds.isEmpty()) {
                HashSet vBillNos = Sets.newHashSetWithExpectedSize((int)10);
                for (Row row : ds) {
                    vBillNos.add(row.getString("billno"));
                }
                for (ExtendedDataEntity data : datas) {
                    DynamicObject dataEntity = data.getDataEntity();
                    String billno = dataEntity.getString("billno");
                    if (!vBillNos.contains(billno)) continue;
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5bf9\u5e94\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\u3002", (String)"FinishCostTranFerCreateVoucherValidator_5", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                }
            }
        }
    }
}

