/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.cal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MatAllocateCreateVoucherValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.dataEntities;
        boolean syscCal = "1".equals(CadBgParamUtils.getCadBgParamForString((String)"matAllocVhSyncCal", (String)"1"));
        Set<Long> srcBillIdForEquCount = null;
        HashSet<Long> vohcherIds = new HashSet<Long>(10);
        srcBillIdForEquCount = syscCal ? this.getSrcBillIdForEquCount(vohcherIds) : new HashSet<Long>(10);
        HashMap<Long, Long> costaccountPeriodMap = new HashMap<Long, Long>(10);
        for (ExtendedDataEntity data : datas) {
            DynamicObject dyn;
            DynamicObject dataEntity = data.getDataEntity();
            String billno = dataEntity.getString("billno");
            long sourcebillid = dataEntity.getLong("sourcebillid");
            DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
            DynamicObject period = dataEntity.getDynamicObject("period");
            if (period == null) continue;
            Long costaccountId = costaccount.getLong("id");
            Long curPeriodId = (Long)costaccountPeriodMap.get(costaccountId);
            if (curPeriodId == null && (dyn = PeriodHelper.getCurrentPeriod((Long)costaccountId)) != null) {
                curPeriodId = dyn.getLong("id");
                costaccountPeriodMap.put(costaccountId, curPeriodId);
            }
            if (curPeriodId != null && curPeriodId.compareTo((Long)period.getPkValue()) != 0) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u975e\u6210\u672c\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u80fd\u751f\u6210\u51ed\u8bc1\u3002", (String)"MatAllocateCreateVoucherValidator_0", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                continue;
            }
            String allocstatus = dataEntity.getString("allocstatus");
            if (!"2".equals(allocstatus)) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u7684\u5206\u914d\u72b6\u6001\u4e0d\u662f\u5df2\u786e\u8ba4\u72b6\u6001\uff0c\u4e0d\u80fd\u751f\u6210\u51ed\u8bc1\u3002", (String)"MatAllocateCreateVoucherValidator_1", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                continue;
            }
            if (srcBillIdForEquCount.contains(sourcebillid)) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5bf9\u5e94\u6e90\u5355\u7684\u5206\u914d\u5355\u603b\u6570\u4e0e\u6e90\u5355\u5206\u5f55\u6570\u4e0d\u76f8\u7b49\uff0c\u4e0d\u80fd\u751f\u6210\u51ed\u8bc1\u3002", (String)"MatAllocateCreateVoucherValidator_2", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                continue;
            }
            String vouchernum = dataEntity.getString("vouchernum");
            if (!CadEmptyUtils.isEmpty((String)vouchernum)) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\u3002", (String)"MatAllocateCreateVoucherValidator_3", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
                continue;
            }
            if (!vohcherIds.contains(sourcebillid)) continue;
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5bf9\u5e94\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\u3002", (String)"MatAllocateCreateVoucherValidator_4", (String)"macc-aca-opplugin", (Object[])new Object[0]), billno));
        }
    }

    private Set<Long> getSrcBillIdForEquCount(Set<Long> voucherIds) {
        ExtendedDataEntity[] datas = this.dataEntities;
        HashSet<Long> srcBillIds = new HashSet<Long>(10);
        ArrayList<Object[]> objectList = new ArrayList<Object[]>(10);
        HashSet<Long> costAccountIds = new HashSet<Long>(2);
        for (ExtendedDataEntity data : datas) {
            DynamicObject dataEntity = data.getDataEntity();
            long sourcebillid = dataEntity.getLong("sourcebillid");
            if (!CadEmptyUtils.isEmpty((Long)sourcebillid)) {
                srcBillIds.add(sourcebillid);
            }
            Object[] object = new Object[]{sourcebillid, 1};
            objectList.add(object);
            costAccountIds.add(dataEntity.getLong("costaccount.id"));
        }
        DataSet srcbillDataSet = Algo.create((String)"macc-aca-opplugin").createDataSet(objectList.iterator(), this.getSourceRowMeta());
        objectList.clear();
        srcbillDataSet = srcbillDataSet.groupBy(new String[]{"sourcebillid"}).sum("sourcebillentrycount").finish();
        QFilter filter = new QFilter("bizbillid", "in", srcBillIds);
        filter.and("costaccount", "in", costAccountIds);
        DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)"getSrcBillEntryCount", (String)"cal_costrecord_subentity", (String)"bizbillid,isfivoucher,entry.id as entryid,1 as entrycount", (QFilter[])new QFilter[]{filter}, null);
        DataSet costRecordDataSetCopy = costRecordDataSet.copy().filter("isfivoucher=true").select("bizbillid").distinct();
        for (Row row : costRecordDataSetCopy) {
            voucherIds.add(row.getLong("bizbillid"));
        }
        costRecordDataSet = costRecordDataSet.groupBy(new String[]{"bizbillid"}).sum("entrycount").finish();
        DataSet dataSet = srcbillDataSet.join(costRecordDataSet, JoinType.INNER).on("sourcebillid", "bizbillid").select(srcbillDataSet.getRowMeta().getFieldNames(), new String[]{"entrycount"}).finish();
        dataSet = dataSet.filter("sourcebillentrycount != entrycount");
        srcBillIds.clear();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long sourcebillid = row.getLong("sourcebillid");
            if (CadEmptyUtils.isEmpty((Long)sourcebillid)) continue;
            srcBillIds.add(sourcebillid);
        }
        return srcBillIds;
    }

    private RowMeta getSourceRowMeta() {
        ArrayList<Field> field = new ArrayList<Field>(10);
        field.add(new Field("sourcebillid", (DataType)DataType.LongType));
        field.add(new Field("sourcebillentrycount", (DataType)DataType.IntegerType));
        return new RowMeta(field.toArray(new Field[0]));
    }
}

