/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.equivalent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class EquivalentSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas;
        for (ExtendedDataEntity data : datas = this.dataEntities) {
            boolean aca_equivalent;
            QFilter isenabledQf;
            DynamicObject dataEntity = data.getDataEntity();
            DynamicObject org = dataEntity.getDynamicObject("org");
            DynamicObject manuorg = dataEntity.getDynamicObject("manuorg");
            DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
            DynamicObject period = dataEntity.getDynamicObject("period");
            ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
            QFilter idQf = new QFilter("id", "!=", dataEntity.getPkValue());
            if (org == null || costaccount == null || period == null) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7 \u6216 \u6210\u672c\u8d26\u7c3f \u6216 \u671f\u95f4 \u672a\u586b\u5199\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EquivalentSaveValidator_4", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                continue;
            }
            QFilter qfOrg = new QFilter("org", "=", org.getPkValue());
            QFilter qfCostAccount = new QFilter("entry.costaccount", "=", costaccount.getPkValue());
            QFilter isInitFilter = new QFilter("entry.isenabled", "=", (Object)Character.valueOf('1'));
            DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, isInitFilter});
            Long currentperiod = null;
            if (res != null) {
                currentperiod = res.getLong("currentperiod");
            }
            if (currentperiod == null || currentperiod.compareTo((Long)period.getPkValue()) != 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u6838\u7b97\u671f\u95f4\u4e0d\u662f\u5f53\u524d\u6210\u672c\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EquivalentSaveValidator_5", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                continue;
            }
            qfCostAccount = new QFilter("entryentity.costaccount", "=", costaccount.getPkValue());
            boolean sca_startstdcost = QueryServiceHelper.exists((String)"sca_startstdcost", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, isInitFilter = new QFilter("entryentity.isinit", "=", (Object)true), isenabledQf = new QFilter("entryentity.isenabled", "=", (Object)true)});
            if (!sca_startstdcost) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u3001\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u7684\u542f\u7528\u5b9e\u9645\u6210\u672c\u6838\u7b97\u8bbe\u7f6e\u9519\u8bef\u3002", (String)"EquivalentSaveValidator_17", (String)"macc-aca-opplugin", (Object[])new Object[0]), org.getString("name"), costaccount.getString("name")));
                continue;
            }
            boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)((Long)costaccount.getPkValue()));
            if (enableMulFactory) {
                if (manuorg == null) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u6838\u7b97\u7ec4\u7ec7\u5f00\u542f\u591a\u5de5\u5382\uff0c\u751f\u4ea7\u7ec4\u7ec7\u5fc5\u5f55\u3002", (String)"EquivalentSaveValidator_18", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                    continue;
                }
                List manuOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)((Long)org.getPkValue()), (String)"aca_equivalent", (String)"aca");
                if (manuOrg.isEmpty()) {
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8be5\u7528\u6237\u6ca1\u6709 %s \u751f\u4ea7\u7ec4\u7ec7\u7684\u6743\u9650\u3002", (String)"EquivalentSaveValidator_8", (String)"macc-aca-opplugin", (Object[])new Object[0]), manuorg.getString("name")));
                    continue;
                }
                if (!manuOrg.contains((Long)manuorg.getPkValue())) {
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8be5\u7528\u6237\u6ca1\u6709 %s \u751f\u4ea7\u7ec4\u7ec7\u7684\u6743\u9650 \u6216\u8005 \u8be5\u751f\u4ea7\u7ec4\u7ec7\u4e0e\u6838\u7b97\u7ec4\u7ec7\u95f4\u7684\u59d4\u6258\u5173\u7cfb\u4e0d\u6b63\u786e\u3002", (String)"EquivalentSaveValidator_9", (String)"macc-aca-opplugin", (Object[])new Object[0]), manuorg.getString("name")));
                    continue;
                }
            }
            QFilter orgQf = new QFilter("org", "=", org.getPkValue());
            QFilter costaccountQf = new QFilter("costaccount", "=", costaccount.getPkValue());
            QFilter periodQf = new QFilter("period", "=", period.getPkValue());
            qfilters.add(idQf);
            qfilters.add(orgQf);
            qfilters.add(costaccountQf);
            qfilters.add(periodQf);
            String flag = "";
            if (manuorg != null) {
                QFilter manuorgQf = new QFilter("manuorg", "=", manuorg.getPkValue());
                qfilters.add(manuorgQf);
                flag = ResManager.loadKDString((String)"-\u751f\u4ea7\u7ec4\u7ec7", (String)"EquivalentSaveValidator_22", (String)"macc-aca-opplugin", (Object[])new Object[0]);
            }
            if (aca_equivalent = QueryServiceHelper.exists((String)"aca_equivalent", (QFilter[])qfilters.toArray(new QFilter[0]))) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u5b58\u5728\u6838\u7b97\u7ec4\u7ec7+\u6210\u672c\u8d26\u7c3f+\u6838\u7b97\u671f\u95f4%s\u76f8\u540c\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EquivalentSaveValidator_11", (String)"macc-aca-opplugin", (Object[])new Object[0]), flag));
                continue;
            }
            DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
            String tips = this.checkCostcenter(entryentity, org.getLong("id"));
            if (tips != null) {
                this.addErrorMessage(data, tips);
                continue;
            }
            String errorMsg = this.checkEntryRepeat(entryentity);
            if (CadEmptyUtils.isEmpty((String)errorMsg)) continue;
            this.addErrorMessage(data, errorMsg);
        }
    }

    private String checkEntryRepeat(DynamicObjectCollection entryEntity) {
        String errorMsg = "";
        HashMap<String, Integer> keys = new HashMap<String, Integer>(entryEntity.size());
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            Long costCenterId = entry.getLong("costcenter.id");
            Long costObjectId = entry.getLong("costobject.id");
            String key = String.valueOf(costCenterId).concat(String.valueOf(costObjectId));
            if (keys.containsKey(key)) {
                Integer existRow = (Integer)keys.get(key);
                errorMsg = errorMsg.concat(String.format(ResManager.loadKDString((String)"\u7efc\u5408\u7ea6\u5f53\u7cfb\u6570\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u5b58\u5728\u76f8\u540c\u7ec4\u5408\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EquivalentSaveValidator_20", (String)"macc-aca-opplugin", (Object[])new Object[0]), existRow + 1, i + 1));
                continue;
            }
            keys.put(key, i);
        }
        return errorMsg;
    }

    private String checkCostcenter(DynamicObjectCollection entryentity, Long id) {
        HashMap<Long, Character> idMap = new HashMap<Long, Character>(entryentity.size() * 2);
        for (DynamicObject dynamicObject : entryentity) {
            Long aLong;
            DynamicObject costcenter = dynamicObject.getDynamicObject("costcenter");
            DynamicObject costobject = dynamicObject.getDynamicObject("costobject");
            if (costcenter == null || costobject == null || costobject == null || costcenter == null) continue;
            Long costobjectId = costobject.getLong("id");
            Long costcenterId = costobject.getLong("costcenter.id");
            if (costcenterId == null || costcenterId.compareTo((Long)(costcenter != null ? costcenter.getPkValue() : Long.valueOf(-1L))) != 0) {
                return this.getTips(0);
            }
            Long l = aLong = costcenter != null ? Long.valueOf(costcenter.getLong("orgduty.id")) : null;
            if (aLong == null || Long.compare(aLong, 4L) != 0) {
                return this.getTips(1);
            }
            Long accOrgId = costcenter.getLong("accountorg.id");
            if (accOrgId.compareTo(id) != 0) {
                return this.getTips(2);
            }
            if (idMap.get(costobjectId) == null) {
                idMap.put(costobjectId, Character.valueOf('Y'));
                continue;
            }
            return this.getTips(3);
        }
        return null;
    }

    private String getTips(int indexTips) {
        String tips = "";
        switch (indexTips) {
            case 0: {
                tips = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u6210\u672c\u4e2d\u5fc3\u4e0e\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e4b\u95f4\u7684\u5173\u7cfb\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EquivalentSaveValidator_13", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                break;
            }
            case 1: {
                tips = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u4e0d\u662f\u57fa\u672c\u751f\u4ea7\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EquivalentSaveValidator_14", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                break;
            }
            case 2: {
                tips = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u6838\u7b97\u7ec4\u7ec7\u4e0e\u6210\u672c\u4e2d\u5fc3\u7684\u5bf9\u5e94\u5173\u7cfb\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EquivalentSaveValidator_15", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                break;
            }
            case 3: {
                tips = ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u6838\u7b97\u7ec4\u7ec7+\u751f\u4ea7\u7ec4\u7ec7+\u6210\u672c\u8d26\u7c3f+\u6838\u7b97\u671f\u95f4\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e0d\u5141\u8bb8\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EquivalentSaveValidator_16", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                break;
            }
        }
        return tips;
    }
}

