/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.feealloc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.aca.algox.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MatAllocateDelOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("allocstatus");
        fieldKeys.add("vouchernum");
        fieldKeys.add("costaccount");
        fieldKeys.add("period");
        fieldKeys.add("appnum");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                HashMap costaccountPeriodMap = Maps.newHashMapWithExpectedSize((int)10);
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                HashMap<Long, ExtendedDataEntity> voucherCheckMap = new HashMap<Long, ExtendedDataEntity>(dataEntities.length);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    this.isCurPeriod(dataEntity, costaccountPeriodMap);
                    this.checkAllocStatus(dataEntity);
                    long id = dataEntity.getDataEntity().getLong("id");
                    if (CadEmptyUtils.isEmpty((Long)id)) continue;
                    voucherCheckMap.put(id, dataEntity);
                }
                this.checkVourcher(voucherCheckMap);
            }

            private void isCurPeriod(ExtendedDataEntity dataEntity, Map<Long, Long> costaccountPeriodMap) {
                DynamicObject dyn;
                DynamicObject item = dataEntity.getDataEntity();
                DynamicObject costaccount = item.getDynamicObject("costaccount");
                DynamicObject period = item.getDynamicObject("period");
                Long costaccountId = costaccount.getLong("id");
                Long curPeriodId = costaccountPeriodMap.get(costaccountId);
                if (curPeriodId == null && (dyn = PeriodHelper.getCurrentPeriod((Long)costaccount.getLong("id"))) != null) {
                    curPeriodId = dyn.getLong("id");
                    costaccountPeriodMap.put(costaccountId, curPeriodId);
                }
                if (curPeriodId != null && period.getLong("id") != curPeriodId.longValue()) {
                    String tip = ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002\u4e0d\u5141\u8bb8\u5bf9\u4ee5\u524d\u671f\u95f4\u7684\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MatAllocateDelOpPlugin_0", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)tip, (String)"MatAllocateDelOpPlugin_1", (String)"MatAllocateDelOpPlugin_1", (Object[])new Object[0]));
                }
            }

            private void checkVourcher(Map<Long, ExtendedDataEntity> dataEntityMap) {
                Set<Long> ids;
                Collection<ExtendedDataEntity> dataEntities = dataEntityMap.values();
                ArrayList<Long> removeIds = new ArrayList<Long>();
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject matAlloc = dataEntity.getDataEntity();
                    String voucherNum = matAlloc.getString("vouchernum");
                    if (StringUtils.isEmpty((CharSequence)voucherNum)) continue;
                    long id = matAlloc.getLong("id");
                    if (!CadEmptyUtils.isEmpty((Long)id)) {
                        removeIds.add(id);
                    }
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u3002\u5f53\u524d\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u5df2\u751f\u6210\u4e86\u51ed\u8bc1\u3002", (String)"MatAllocateDelOpPlugin_2", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                }
                if (!removeIds.isEmpty()) {
                    for (Long id : removeIds) {
                        dataEntityMap.remove(id);
                    }
                }
                if (!CadEmptyUtils.isEmpty(ids = dataEntityMap.keySet())) {
                    ArrayList<Long> idList = new ArrayList<Long>(ids);
                    List partitions = Lists.partition(idList, (int)20000);
                    for (List partition : partitions) {
                        QFilter[] qf = new QFilter[]{new QFilter("sourcebill", "in", (Object)partition)};
                        DataSet vouchers = QueryServiceHelper.queryDataSet((String)"MatAllocDelOp-checkVoucher", (String)"gl_voucher", (String)"sourcebill", (QFilter[])qf, null);
                        for (Row voucher : vouchers) {
                            Long id = voucher.getLong("sourcebill");
                            if (CadEmptyUtils.isEmpty((Long)id)) continue;
                            this.addErrorMessage(dataEntityMap.get(id), ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u3002\u5f53\u524d\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u5df2\u751f\u6210\u4e86\u51ed\u8bc1\u3002", (String)"MatAllocateDelOpPlugin_2", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                        }
                    }
                }
            }

            private void checkAllocStatus(ExtendedDataEntity dataEntity) {
                String allocStatus = dataEntity.getDataEntity().getString("allocstatus");
                if (ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue().equals(allocStatus)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u3002\u5f53\u524d\u6750\u6599\u8017\u7528\u8bb0\u5f55\u5df2\u7ecf\u786e\u8ba4\u5206\u914d\u7ed3\u679c\u3002", (String)"MatAllocateDelOpPlugin_3", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                }
            }
        });
        super.onAddValidators(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        ArrayList<Object> ids = new ArrayList<Object>(16);
        for (DynamicObject dyn : e.getDataEntities()) {
            if (!"eca".equals(dyn.getString("appnum"))) continue;
            ids.add(dyn.getPkValue());
        }
        if (ids.isEmpty()) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("srcbillid", "in", ids), new QFilter("billtype", "=", (Object)"aca_matalloc"), new QFilter("vouchernum", "=", (Object)" ")};
        DeleteServiceHelper.delete((String)"eca_costcarrybill", (QFilter[])filters);
    }
}

