/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.init;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.common.helper.AcaCostAccountHelper;
import kd.macc.cad.common.constants.DutyIdConstants;
import kd.macc.cad.common.helper.MatHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class WipCostInitImportEntryOp
extends BatchImportPlugin {
    private Log log = LogFactory.getLog(WipCostInitImportEntryOp.class);
    private static final String MATTYPE = "001";
    private static final String MATCOST = "002";
    private static final String IMPORT_PROP = "importprop";
    private DynamicObject org;
    private DynamicObject costAccount;
    private DynamicObject costCenter;
    private DynamicObject costObject;
    private List<DynamicObject> costObjectList = Lists.newArrayList();
    private static final String NUMBER = "number";

    private void clearCache() {
        this.org = null;
        this.costCenter = null;
        this.costObject = null;
        this.costObjectList.clear();
    }

    protected boolean isForceBatch() {
        return super.isForceBatch();
    }

    protected int getBatchImportSize() {
        return 5000;
    }

    public String getDefaultImportType() {
        return "new";
    }

    public List<String> getDefaultLockUIs() {
        ArrayList<String> lockKeys = new ArrayList<String>();
        lockKeys.add("flexpanelap6");
        return lockKeys;
    }

    protected void beforeSave(List<ImportBillData> billDatas, ImportLogger logger) {
        super.beforeSave(billDatas, logger);
        HashMap<Long, Long> subelementMap = new HashMap<Long, Long>(10);
        DataSet dySubElementDs = QueryServiceHelper.queryDataSet((String)"elementRelation", (String)"cad_elementdetail", (String)"element,subelement", null, null);
        for (Row row : dySubElementDs) {
            subelementMap.put(row.getLong("subelement"), row.getLong("element"));
        }
        Iterator<ImportBillData> iterator = billDatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData billData = iterator.next();
            if (billData.getData().get((Object)"org") != null) {
                if (!this.validateData(billData, logger, subelementMap)) {
                    iterator.remove();
                    logger.setFailed(logger.getFailed() + 1);
                }
                this.clearCache();
                continue;
            }
            logger.log(Integer.valueOf(-1), ResManager.loadKDString((String)"\u5f15\u5165\u6a21\u677f\u9519\u8bef", (String)"WipCostInitImportEntryOp_0", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean validateData(ImportBillData billData, ImportLogger logger, Map<Long, Long> subelementMap) {
        boolean checkFlag = true;
        int index = billData.getStartIndex();
        JSONObject rowData = billData.getData();
        rowData.put("source", (Object)"import");
        try {
            if (!this.checkOrg(index, rowData, logger)) {
                return false;
            }
            if (!this.checkManuOrg(index, rowData, logger)) {
                checkFlag = false;
            }
            if (!this.checkOrgCostAccount(index, rowData, logger)) {
                checkFlag = false;
            }
            if (!this.checkOrgCostCenter(index, rowData, logger)) {
                checkFlag = false;
            }
            if (!this.checkOrgCostObject(index, rowData, logger)) {
                checkFlag = false;
            }
            if (!this.checkInitQty(index, rowData, logger)) {
                checkFlag = false;
            }
            if (!this.checkQtyAmt(index, rowData, logger)) {
                checkFlag = false;
            }
            if (!this.checkEntryMatProp(index, rowData, logger, subelementMap)) {
                checkFlag = false;
            }
            if (!this.checkUnique(index, rowData, logger)) {
                checkFlag = false;
            }
        }
        catch (Exception e) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u6570\u636e\u89e3\u6790\u5f02\u5e38\u3002", (String)"WipCostInitImportEntryOp_1", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            this.log.error("\u5f15\u5165\u5931\u8d25\u3002\u6570\u636e\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            checkFlag = false;
        }
        return checkFlag;
    }

    private boolean checkQtyAmt(int index, JSONObject rowData, ImportLogger logger) {
        BigDecimal yearInputQty = rowData.getBigDecimal("yearinputqty");
        BigDecimal yearFinishQty = rowData.getBigDecimal("yearfinishqty");
        boolean inputQty = !CadEmptyUtils.isEmpty((BigDecimal)yearInputQty);
        boolean finishQty = !CadEmptyUtils.isEmpty((BigDecimal)yearFinishQty);
        boolean entryInputAmt = false;
        boolean entryFinishAmt = false;
        JSONArray entryEntity = rowData.getJSONArray("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            JSONObject jsonObject = entryEntity.getJSONObject(i);
            if (jsonObject == null) continue;
            if (!CadEmptyUtils.isEmpty((BigDecimal)jsonObject.getBigDecimal("yearinputamt"))) {
                entryInputAmt = true;
            }
            if (CadEmptyUtils.isEmpty((BigDecimal)jsonObject.getBigDecimal("yearfinishamt"))) continue;
            entryFinishAmt = true;
        }
        if (inputQty != entryInputAmt) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u672c\u5e74\u7d2f\u8ba1\u6295\u5165\u6570\u91cf\u3001\u91d1\u989d\u9700\u540c\u65f6\u5f55\u5165\u6216\u4e0d\u5f55\u3002", (String)"WipCostInitImportEntryOp_2", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (finishQty != entryFinishAmt) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u672c\u5e74\u7d2f\u8ba1\u5b8c\u5de5\u6570\u91cf\u3001\u91d1\u989d\u9700\u540c\u65f6\u5f55\u5165\u6216\u4e0d\u5f55\u3002", (String)"WipCostInitImportEntryOp_3", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkManuOrg(int index, JSONObject rowData, ImportLogger logger) {
        long orgId = this.org.getLong("id");
        if (OrgHelper.isOrgEnableMultiFactory((Long)orgId) && rowData.get((Object)"manuorg") == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u5f00\u542f\u591a\u5de5\u5382\uff0c\u8bf7\u5f55\u5165\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"WipCostInitImportEntryOp_49", (String)"macc-aca-opplugin", (Object[])new Object[0]), this.org.getString(NUMBER)));
            return false;
        }
        return true;
    }

    private boolean checkUnique(int index, JSONObject rowData, ImportLogger logger) {
        long orgId = this.org.getLong("id");
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        if (OrgHelper.isOrgEnableMultiFactory((Long)orgId)) {
            Map manuOrgMap = (Map)rowData.get((Object)"manuorg");
            String manuOrgNum = manuOrgMap.get(NUMBER).toString();
            qFilter.and("manuorg.number", "=", (Object)manuOrgNum);
        }
        qFilter.and("costaccount", "=", (Object)this.costAccount.getLong("id"));
        qFilter.and("costcenter", "=", (Object)this.costCenter.getLong("id"));
        qFilter.and("costobject", "=", (Object)this.costObject.getLong("id"));
        boolean exists = QueryServiceHelper.exists((String)"aca_wipcostinit", (QFilter[])new QFilter[]{qFilter});
        if (exists) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u7684\u201c\u6838\u7b97\u7ec4\u7ec7+\u751f\u4ea7\u7ec4\u7ec7+\u6210\u672c\u8d26\u7c3f+\u6210\u672c\u4e2d\u5fc3+\u6210\u672c\u6838\u7b97\u201d\u5bf9\u8c61\u7ec4\u5408\u3002", (String)"WipCostInitImportEntryOp_5", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkInitQty(int index, JSONObject rowData, ImportLogger logger) {
        BigDecimal initQty = rowData.getBigDecimal("initqty");
        if (initQty == null || initQty.compareTo(BigDecimal.ZERO) == 0) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u671f\u521d\u5728\u4ea7\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u62160\u3002", (String)"WipCostInitImportEntryOp_6", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkEntryMatProp(int index, JSONObject rowData, ImportLogger logger, Map<Long, Long> subelementMap) {
        JSONArray entryEntity = rowData.getJSONArray("entryentity");
        if (entryEntity == null || entryEntity.size() == 0) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6210\u672c\u4fe1\u606f\u201d\u3002", (String)"WipCostInitImportEntryOp_7", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<String> existsSubElement = new ArrayList<String>(10);
        boolean existsMatProp = false;
        for (int i = 0; i < entryEntity.size(); ++i) {
            BigDecimal amount;
            JSONObject jsonObject = entryEntity.getJSONObject(i);
            Map subElementMap = (Map)jsonObject.get((Object)"subelement");
            String subElementNum = (String)subElementMap.get(NUMBER);
            QFilter subElementNumFilter = new QFilter(NUMBER, "=", (Object)subElementNum);
            DynamicObject subElement = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_subelement", (String)"id,type", (QFilter[])new QFilter[]{subElementNumFilter});
            if (subElement == null) {
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7269\u6599\u5b50\u8981\u7d20\u201c%s\u201d\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7269\u6599\u5b50\u8981\u7d20\u3002", (String)"WipCostInitImportEntryOp_50", (String)"macc-aca-opplugin", (Object[])new Object[0]), subElementNum));
                return false;
            }
            String type = subElement.getString("type");
            if (!StringUtils.isEmpty((CharSequence)type) && (MATTYPE.equals(type) || MATCOST.equals(type))) {
                existsMatProp = true;
            }
            if (existsSubElement.contains(subElementNum)) {
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u7269\u6599\u5b50\u8981\u7d20\u201c%s\u201d\u3002", (String)"WipCostInitImportEntryOp_51", (String)"macc-aca-opplugin", (Object[])new Object[0]), subElementNum));
                return false;
            }
            existsSubElement.add(subElementNum);
            long subElementId = subElement.getLong("id");
            if (subelementMap.containsKey(subElementId)) {
                jsonObject.put("element_id", (Object)subelementMap.get(subElementId));
            }
            if ((amount = jsonObject.getBigDecimal("amount")) == null || amount.compareTo(BigDecimal.ZERO) == 0) {
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7269\u6599\u5b50\u8981\u7d20\u201c%s\u201d\u672a\u7ef4\u62a4\u91d1\u989d\u3002", (String)"WipCostInitImportEntryOp_52", (String)"macc-aca-opplugin", (Object[])new Object[0]), subElementNum));
                return false;
            }
            jsonObject.put("importtype", (Object)"entry");
        }
        if (!existsMatProp) {
            // empty if block
        }
        return true;
    }

    private boolean checkOrgCostObject(int index, JSONObject rowData, ImportLogger logger) {
        if (rowData.get((Object)"costobject") == null) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7f16\u7801\u201d\u3002", (String)"WipCostInitImportEntryOp_11", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        Map costObjectMap = (Map)rowData.get((Object)"costobject");
        String costObjectNum = costObjectMap.get("billno").toString();
        DynamicObject costObject = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_costobject", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)costObjectNum)});
        if (costObject == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%s\u201d\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\u3002", (String)"WipCostInitImportEntryOp_53", (String)"macc-aca-opplugin", (Object[])new Object[0]), costObjectNum));
            return false;
        }
        if (this.costObjectList.contains(costObject)) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"WipCostInitImportEntryOp_54", (String)"macc-aca-opplugin", (Object[])new Object[0]), costObjectNum));
            return false;
        }
        this.costObject = costObject;
        if (this.org != null && costObject.getDynamicObject("org").getLong("id") != this.org.getLong("id")) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7f16\u7801\u3010%1$s\u3011\u4e0e\u6838\u7b97\u7ec4\u7ec7\u7f16\u53f7\u3010%2$s\u3011\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb", (String)"WipCostInitImportEntryOp_59", (String)"macc-aca-opplugin", (Object[])new Object[0]), costObjectNum, this.org.getString(NUMBER)));
            return false;
        }
        if (this.costCenter != null && costObject.getDynamicObject("costcenter").getLong("id") != this.costCenter.getLong("id")) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7f16\u7801\u3010%1$s\u3011\u4e0e\u6210\u672c\u4e2d\u5fc3\u7f16\u53f7\u3010%2$s\u3011\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb", (String)"WipCostInitImportEntryOp_60", (String)"macc-aca-opplugin", (Object[])new Object[0]), costObjectNum, this.costCenter.getString(NUMBER)));
            return false;
        }
        DynamicObject material = costObject.getDynamicObject("material");
        Map matBaseUnit = MatHelper.getMatBaseUnit(Collections.singleton((Long)material.getPkValue()));
        if (matBaseUnit != null && matBaseUnit.size() > 0) {
            rowData.put("baseunit".concat("_id"), matBaseUnit.get(material.getLong("id")));
        }
        rowData.put("auxpty_id", (Object)costObject.getLong("auxpty.id"));
        rowData.put("assignedproduct".concat("_id"), (Object)material.getLong("id"));
        return true;
    }

    private boolean checkOrgCostCenter(int index, JSONObject rowData, ImportLogger logger) {
        if (rowData.get((Object)"costcenter") == null) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u201d\u3002", (String)"WipCostInitImportEntryOp_12", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        Map costCenterMap = (Map)rowData.get((Object)"costcenter");
        String costCenterNumber = costCenterMap.get(NUMBER).toString();
        DynamicObject costCenter = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_costcenter", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)costCenterNumber)});
        if (costCenter == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%s\u201d\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\u3002", (String)"WipCostInitImportEntryOp_57", (String)"macc-aca-opplugin", (Object[])new Object[0]), costCenterNumber));
            return false;
        }
        this.costCenter = costCenter;
        long orgDuty = costCenter.getLong("orgduty.id");
        if (orgDuty != DutyIdConstants.BASIC_PRODUCT_ID) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u7c7b\u578b\u4e0d\u4e3a\u201c\u7b80\u5355\u751f\u4ea7\u201d\u3002", (String)"WipCostInitImportEntryOp_14", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject accountOrg = costCenter.getDynamicObject("accountorg");
        if (accountOrg == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u4e0e\u6838\u7b97\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"WipCostInitImportEntryOp_58", (String)"macc-aca-opplugin", (Object[])new Object[0]), costCenterNumber, this.org.getString(NUMBER)));
            return false;
        }
        if (this.org != null && accountOrg.getLong("id") != this.org.getLong("id")) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u4e0e\u6838\u7b97\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"WipCostInitImportEntryOp_58", (String)"macc-aca-opplugin", (Object[])new Object[0]), costCenterNumber, this.org.getString(NUMBER)));
            return false;
        }
        return true;
    }

    private boolean checkOrgCostAccount(int index, JSONObject rowData, ImportLogger logger) {
        Long count;
        if (rowData.get((Object)"costaccount") == null) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6210\u672c\u8d26\u7c3f\u7f16\u7801\u201d\u3002", (String)"WipCostInitImportEntryOp_15", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        Map costAccountMap = (Map)rowData.get((Object)"costaccount");
        String costAccountNumber = costAccountMap.get(NUMBER).toString();
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (String)"id,calpolicy.currency", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)costAccountNumber)});
        if (costAccount == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%s\u201d\u4e0b\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\u3002", (String)"WipCostInitImportEntryOp_44", (String)"macc-aca-opplugin", (Object[])new Object[0]), costAccountNumber));
            return false;
        }
        this.costAccount = costAccount;
        Long costAccountId = costAccount.getLong("id");
        DynamicObjectCollection costAccountCollection = AcaCostAccountHelper.getUnInitCostAccountCollection((String)String.valueOf(this.org.getLong("id")));
        if (costAccountCollection == null || costAccountCollection.size() == 0) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u672a\u627e\u5230\u6210\u672c\u8d26\u7c3f\u3002", (String)"WipCostInitImportEntryOp_45", (String)"macc-aca-opplugin", (Object[])new Object[0]), this.org.getString(NUMBER)));
            return false;
        }
        if (costAccountCollection != null && !(count = Long.valueOf(costAccountCollection.stream().filter(dynamicObject -> costAccountId.equals(dynamicObject.getLong("id"))).count())).equals(1L)) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u7f16\u53f7:\u3010%1$s\u3011\u4e0e\u6210\u672c\u8d26\u7c3f\u7f16\u7801:\u3010%2$s\u3011\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb", (String)"WipCostInitImportEntryOp_61", (String)"macc-aca-opplugin", (Object[])new Object[0]), this.org.getString(NUMBER), costAccountNumber));
            return false;
        }
        JSONObject currencyJson = new JSONObject();
        currencyJson.put("id", (Object)costAccount.getLong("calpolicy.currency.id"));
        rowData.put("currency", (Object)currencyJson);
        return true;
    }

    private boolean checkOrg(int index, JSONObject rowData, ImportLogger logger) {
        if (rowData.get((Object)"org") == null) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6838\u7b97\u7ec4\u7ec7\u7f16\u7801\u201d\u3002", (String)"WipCostInitImportEntryOp_18", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        Map orgMap = (Map)rowData.get((Object)"org");
        String orgNumber = orgMap.get(NUMBER).toString();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,fisaccounting", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)orgNumber)});
        if (org == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\u3002", (String)"WipCostInitImportEntryOp_47", (String)"macc-aca-opplugin", (Object[])new Object[0]), orgNumber));
            return false;
        }
        this.org = org;
        Long orgId = org.getLong("id");
        List acctOrgs = OrgHelper.getHasPermAccountOrgIds((String)"aca_wipcostinit", (String)"aca");
        if (CadEmptyUtils.isEmpty((List)acctOrgs)) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u6237\u6ca1\u6709\u6838\u7b97\u7ec4\u7ec7\u6743\u9650\u3002", (String)"WipCostInitImportEntryOp_19", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (!acctOrgs.contains(orgId)) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u6237\u6ca1\u6709\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u7684\u6743\u9650\u3002", (String)"WipCostInitImportEntryOp_48", (String)"macc-aca-opplugin", (Object[])new Object[0]), orgNumber));
            return false;
        }
        return true;
    }
}

