/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.realtime;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.DateUtils;

public class MfgFeeRateEffectOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("org");
        fieldKeys.add("costaccount");
        fieldKeys.add("costcenter");
        fieldKeys.add("effectdate");
        fieldKeys.add("expdate");
        fieldKeys.add("effectstatus");
        fieldKeys.add("calctype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity entity : dataEntities = this.getDataEntities()) {
                    DynamicObject dataEntity = entity.getDataEntity();
                    Date effectDate = dataEntity.getDate("effectdate");
                    if (effectDate == null) {
                        effectDate = DateUtils.getDefaultEffectDate();
                    }
                    Date expDate = DateUtils.getDeFaultExpDate();
                    String effectStatus = "E";
                    DynamicObject accountOrg = (DynamicObject)dataEntity.get("org");
                    DynamicObject costAccount = (DynamicObject)dataEntity.get("costaccount");
                    if (accountOrg == null || costAccount == null) {
                        return;
                    }
                    String status = dataEntity.getString("effectstatus");
                    if (!"A".equals(status)) {
                        this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u751f\u6548\u5931\u8d25\uff0c\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u201c\u672a\u751f\u6548\u201d\u3002", (String)"MfgFeeRateEffectOpPlugin_0", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (MfgFeeRateEffectOpPlugin.this.isEnableEffectByOrg(accountOrg.getLong("id"))) {
                        DynamicObject maxExpDateBill = MfgFeeRateEffectOpPlugin.this.getMaxExpDateBill(dataEntity);
                        if (maxExpDateBill != null) {
                            Date nowDate;
                            effectDate = nowDate = new Date();
                            maxExpDateBill.set("expdate", (Object)nowDate);
                            maxExpDateBill.set("effectstatus", (Object)"F");
                            SaveServiceHelper.update((DynamicObject)maxExpDateBill);
                        }
                    } else if (MfgFeeRateEffectOpPlugin.this.existsEffectData(dataEntity)) {
                        DynamicObject costCenter = dataEntity.getDynamicObject("costcenter");
                        StringBuilder sbTip = new StringBuilder();
                        sbTip.append(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u4e0e\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u7ec4\u5408\u6570\u636e", (String)"MfgFeeRateEffectOpPlugin_1", (String)"macc-aca-opplugin", (Object[])new Object[0]), accountOrg.getString("name"), costAccount.getString("name")));
                        if (costCenter != null) {
                            sbTip.append(String.format(ResManager.loadKDString((String)"+\u3010%s\u3011\u6210\u672c\u4e2d\u5fc3", (String)"MfgFeeRateEffectOpPlugin_2", (String)"macc-aca-opplugin", (Object[])new Object[0]), costCenter.getString("name")));
                        }
                        String calcType = dataEntity.getString("calctype");
                        String calcTypeName = "";
                        if ("F".equals(calcType)) {
                            calcTypeName = ResManager.loadKDString((String)"\u6309\u4ea7\u91cf\u8ba1\u7b97", (String)"MfgFeeRateEffectOpPlugin_3", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                        } else if ("R".equals(calcType)) {
                            calcTypeName = ResManager.loadKDString((String)"\u6309\u8d44\u6e90\u5de5\u65f6\u8ba1\u7b97", (String)"MfgFeeRateEffectOpPlugin_4", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                        }
                        sbTip.append(String.format(ResManager.loadKDString((String)"+\u4e0b\u3010%s\u3011\u7684\u751f\u6548\u6570\u636e\uff0c\u5f53\u524d\u5355\u636e\u4e0d\u80fd\u751f\u6548", (String)"MfgFeeRateEffectOpPlugin_5", (String)"macc-aca-opplugin", (Object[])new Object[0]), calcTypeName));
                        this.addFatalErrorMessage(entity, sbTip.toString());
                        continue;
                    }
                    dataEntity.set("effectdate", (Object)effectDate);
                    dataEntity.set("expdate", (Object)expDate);
                    dataEntity.set("effectstatus", (Object)effectStatus);
                    SaveServiceHelper.update((DynamicObject)dataEntity);
                }
            }
        });
    }

    private DynamicObject getMaxExpDateBill(DynamicObject dataEntity) {
        QFilter[] qFilter = this.getQFilter(dataEntity);
        DynamicObject[] sourceDataArr = BusinessDataServiceHelper.load((String)"aca_mfgplanfeerate", (String)"id,effectdate,expdate,effectstatus", (QFilter[])qFilter);
        DynamicObject maxExpDateBill = null;
        for (DynamicObject source : sourceDataArr) {
            Date expDate = source.getDate("expdate");
            if (expDate == null) continue;
            if (maxExpDateBill == null) {
                maxExpDateBill = source;
                continue;
            }
            Date maxExpDate = maxExpDateBill.getDate("expdate");
            if (expDate.compareTo(maxExpDate) <= 0) continue;
            maxExpDateBill = source;
        }
        return maxExpDateBill;
    }

    private boolean existsEffectData(DynamicObject dataEntity) {
        QFilter[] filters = this.getQFilter(dataEntity);
        if (filters == null) {
            return false;
        }
        return QueryServiceHelper.exists((String)"aca_mfgplanfeerate", (QFilter[])filters);
    }

    private QFilter[] getQFilter(DynamicObject dataEntity) {
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        DynamicObject costCenter = dataEntity.getDynamicObject("costcenter");
        if (org == null || costAccount == null) {
            return null;
        }
        String calcType = dataEntity.getString("calctype");
        QFilter[] filters = new QFilter[]{new QFilter("id", "!=", dataEntity.getPkValue()), new QFilter("org", "=", org.getPkValue()), new QFilter("costaccount", "=", costAccount.getPkValue()), new QFilter("costcenter", "=", costCenter == null ? Long.valueOf(0L) : costCenter.getPkValue()), new QFilter("calctype", "=", (Object)calcType), new QFilter("effectstatus", "=", (Object)"E")};
        return filters;
    }

    private boolean isEnableEffectByOrg(Long orgId) {
        return SysParamHelper.getEnableEffectByOrg((Long)orgId, (String)"aca", (String)"aca_mfgplanfeerate");
    }
}

