/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.wipadjust;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.common.helper.AcaCostAccountHelper;
import kd.macc.cad.common.constants.DutyIdConstants;
import kd.macc.cad.common.helper.MatHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class WipAdjustBillImportEntryOp
extends BatchImportPlugin {
    private Log log = LogFactory.getLog(WipAdjustBillImportEntryOp.class);
    private DynamicObject org;
    private DynamicObject costCenter;
    private Set<DynamicObject> costObjectSet = new HashSet<DynamicObject>();
    private static final String NUMBER = "number";

    private void clearCache() {
        this.org = null;
        this.costCenter = null;
        this.costObjectSet.clear();
    }

    protected boolean isForceBatch() {
        return super.isForceBatch();
    }

    protected int getBatchImportSize() {
        return 5000;
    }

    public String getDefaultImportType() {
        return "new";
    }

    public List<String> getDefaultLockUIs() {
        ArrayList<String> lockKeys = new ArrayList<String>();
        lockKeys.add("flexpanelap6");
        return lockKeys;
    }

    protected void beforeSave(List<ImportBillData> billDatas, ImportLogger logger) {
        super.beforeSave(billDatas, logger);
        Iterator<ImportBillData> iterator = billDatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData billData = iterator.next();
            if (billData.getData().get((Object)"org") != null) {
                if (!this.validateData(billData, logger)) {
                    iterator.remove();
                    logger.setFailed(logger.getFailed() + 1);
                }
                this.clearCache();
                continue;
            }
            logger.log(Integer.valueOf(-1), ResManager.loadKDString((String)"\u5f15\u5165\u6a21\u677f\u9519\u8bef", (String)"WipAdjustBillImportEntryOp_0", (String)"macc-aca-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean validateData(ImportBillData billData, ImportLogger logger) {
        boolean checkFlag = true;
        int index = billData.getStartIndex();
        JSONObject rowData = billData.getData();
        rowData.put("source", (Object)"import");
        try {
            if (!this.checkOrg(index, rowData, logger)) {
                return false;
            }
            if (!this.checkManuOrg(index, rowData, logger)) {
                checkFlag = false;
            }
            if (!this.checkOrgCostAccount(index, rowData, logger)) {
                checkFlag = false;
            }
            if (!this.checkOrgCostCenter(index, rowData, logger)) {
                checkFlag = false;
            }
            if (!this.checkOrgCostObject(index, rowData, logger)) {
                checkFlag = false;
            }
            if (!this.checkEntryMatProp(index, rowData, logger)) {
                checkFlag = false;
            }
        }
        catch (Exception e) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u6570\u636e\u89e3\u6790\u5f02\u5e38\u3002", (String)"WipAdjustBillImportEntryOp_1", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            this.log.error("\u5f15\u5165\u5931\u8d25\u3002\u6570\u636e\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            checkFlag = false;
        }
        return checkFlag;
    }

    private boolean checkEntryMatProp(int index, JSONObject rowData, ImportLogger logger) {
        JSONArray entryEntity = rowData.getJSONArray("entryentity");
        if (entryEntity == null || entryEntity.size() == 0) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6210\u672c\u4fe1\u606f\u201d\u3002", (String)"WipAdjustBillImportEntryOp_2", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<String> existsSubElement = new ArrayList<String>(16);
        for (int i = 0; i < entryEntity.size(); ++i) {
            JSONObject jsonObject = entryEntity.getJSONObject(i);
            Map subElementMap = (Map)jsonObject.get((Object)"subelement");
            String subElementNum = (String)subElementMap.get(NUMBER);
            QFilter subElementNumFilter = new QFilter(NUMBER, "=", (Object)subElementNum);
            DynamicObject subElement = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_subelement", (String)"id,type", (QFilter[])new QFilter[]{subElementNumFilter});
            if (subElement == null) {
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6839\u636e\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801\u3010%s\u3011\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u5b50\u8981\u7d20", (String)"WipAdjustBillImportEntryOp_54", (String)"macc-aca-opplugin", (Object[])new Object[0]), subElementNum));
                return false;
            }
            if (existsSubElement.contains(subElementNum)) {
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801\u3010%s\u3011", (String)"WipAdjustBillImportEntryOp_55", (String)"macc-aca-opplugin", (Object[])new Object[0]), subElementNum));
                return false;
            }
            existsSubElement.add(subElementNum);
            long subElementId = subElement.getLong("id");
            QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
            DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
            entryEntity.getJSONObject(i).put("element_id", (Object)dySubElement.getLong("element"));
        }
        return true;
    }

    private boolean checkOrgCostObject(int index, JSONObject rowData, ImportLogger logger) {
        if (rowData.get((Object)"costobject") == null) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7f16\u7801\u201d\u3002", (String)"WipAdjustBillImportEntryOp_6", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        Map costObjectMap = (Map)rowData.get((Object)"costobject");
        String costObjectNum = costObjectMap.get("billno").toString();
        DynamicObject costObject = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_costobject", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)costObjectNum)});
        if (costObject == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%s\u201d\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\u3002", (String)"WipAdjustBillImportEntryOp_41", (String)"macc-aca-opplugin", (Object[])new Object[0]), costObjectNum));
            return false;
        }
        if (this.costObjectSet.contains(costObject)) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"WipAdjustBillImportEntryOp_42", (String)"macc-aca-opplugin", (Object[])new Object[0]), costObjectNum));
            return false;
        }
        if (this.org != null && costObject.getDynamicObject("org").getLong("id") != this.org.getLong("id")) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7f16\u7801\u3010%1$s\u3011\u4e0e\u6838\u7b97\u7ec4\u7ec7\u7f16\u53f7\u3010%2$s\u3011\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb", (String)"WipAdjustBillImportEntryOp_56", (String)"macc-aca-opplugin", (Object[])new Object[0]), costObjectNum, this.org.getString(NUMBER)));
            return false;
        }
        if (this.costCenter != null && costObject.getDynamicObject("costcenter").getLong("id") != this.costCenter.getLong("id")) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7f16\u7801\u3010%1$s\u3011\u4e0e\u6210\u672c\u4e2d\u5fc3\u7f16\u53f7\u3010%2$s\u3011\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb", (String)"WipAdjustBillImportEntryOp_57", (String)"macc-aca-opplugin", (Object[])new Object[0]), costObjectNum, this.costCenter.getString(NUMBER)));
            return false;
        }
        if (!"C".equals(costObject.getString("producttype"))) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7f16\u53f7\u3010%1$s\u3011\u4ea7\u54c1\u7c7b\u578b\u4e3a\u8054\u526f\u4ea7\u54c1\u65f6\uff0c\u4e0d\u652f\u6301\u5f15\u5165", (String)"WipAdjustBillImportEntryOp_53", (String)"macc-aca-opplugin", (Object[])new Object[0]), costObjectNum));
            return false;
        }
        DynamicObject material = costObject.getDynamicObject("material");
        Map matBaseUnit = MatHelper.getMatBaseUnit(Collections.singleton((Long)material.getPkValue()));
        if (matBaseUnit != null && matBaseUnit.size() > 0) {
            rowData.put("unit_id", matBaseUnit.get(material.getLong("id")));
        }
        rowData.put("matauxpty_id", (Object)costObject.getLong("auxpty.id"));
        rowData.put("material".concat("_id"), (Object)material.getLong("id"));
        return true;
    }

    private boolean checkOrgCostCenter(int index, JSONObject rowData, ImportLogger logger) {
        if (rowData.get((Object)"costcenter") == null) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u201d\u3002", (String)"WipAdjustBillImportEntryOp_8", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        Map costCenterMap = (Map)rowData.get((Object)"costcenter");
        String costCenterNumber = costCenterMap.get(NUMBER).toString();
        DynamicObject costCenter = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_costcenter", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)costCenterNumber)});
        if (costCenter == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%s\u201d\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\u3002", (String)"WipAdjustBillImportEntryOp_45", (String)"macc-aca-opplugin", (Object[])new Object[0]), costCenterNumber));
            return false;
        }
        this.costCenter = costCenter;
        long orgDuty = costCenter.getLong("orgduty.id");
        if (orgDuty != DutyIdConstants.BASIC_PRODUCT_ID) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u7c7b\u578b\u4e0d\u4e3a\u201c\u7b80\u5355\u751f\u4ea7\u201d\u3002", (String)"WipAdjustBillImportEntryOp_10", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject accountOrg = costCenter.getDynamicObject("accountorg");
        if (accountOrg == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u4e0e\u6838\u7b97\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"WipAdjustBillImportEntryOp_46", (String)"macc-aca-opplugin", (Object[])new Object[0]), costCenterNumber, this.org.getString(NUMBER)));
            return false;
        }
        if (this.org != null && accountOrg.getLong("id") != this.org.getLong("id")) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u4e0e\u6838\u7b97\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"WipAdjustBillImportEntryOp_46", (String)"macc-aca-opplugin", (Object[])new Object[0]), costCenterNumber, this.org.getString(NUMBER)));
            return false;
        }
        return true;
    }

    private boolean checkOrgCostAccount(int index, JSONObject rowData, ImportLogger logger) {
        Long count;
        if (rowData.get((Object)"costaccount") == null) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6210\u672c\u8d26\u7c3f\u7f16\u7801\u201d\u3002", (String)"WipAdjustBillImportEntryOp_11", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        Map costAccountMap = (Map)rowData.get((Object)"costaccount");
        String costAccountNumber = costAccountMap.get(NUMBER).toString();
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (String)"id,calpolicy.currency", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)costAccountNumber)});
        if (costAccount == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%s\u201d\u4e0b\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\u3002", (String)"WipAdjustBillImportEntryOp_47", (String)"macc-aca-opplugin", (Object[])new Object[0]), costAccountNumber));
            return false;
        }
        Long costAccountId = costAccount.getLong("id");
        DynamicObjectCollection costAccountCollection = AcaCostAccountHelper.getEndInitCostAccountCollection((Long)this.org.getLong("id"));
        if (costAccountCollection == null || costAccountCollection.size() == 0) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u672a\u627e\u5230\u6210\u672c\u8d26\u7c3f\u3002", (String)"WipAdjustBillImportEntryOp_48", (String)"macc-aca-opplugin", (Object[])new Object[0]), this.org.getString(NUMBER)));
            return false;
        }
        if (costAccountCollection != null && !(count = Long.valueOf(costAccountCollection.stream().filter(dynamicObject -> costAccountId.equals(dynamicObject.getLong("id"))).count())).equals(1L)) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u7f16\u53f7:\u3010%1$s\u3011\u4e0e\u6210\u672c\u8d26\u7c3f\u7f16\u7801:\u3010%2$s\u3011\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb", (String)"WipAdjustBillImportEntryOp_58", (String)"macc-aca-opplugin", (Object[])new Object[0]), this.org.getString(NUMBER), costAccountNumber));
            return false;
        }
        JSONObject currencyJson = new JSONObject();
        currencyJson.put("id", (Object)costAccount.getLong("calpolicy.currency.id"));
        rowData.put("currency", (Object)currencyJson);
        JSONObject periodJson = new JSONObject();
        DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        periodJson.put("id", (Object)curPeriod.getLong("id"));
        rowData.put("period", (Object)periodJson);
        Date date = PeriodHelper.getCurrentPeriodenddate((Long)costAccountId);
        rowData.put("bookdate", (Object)date);
        rowData.put("bizdate", (Object)date);
        return true;
    }

    private boolean checkManuOrg(int index, JSONObject rowData, ImportLogger logger) {
        long orgId = this.org.getLong("id");
        if (OrgHelper.isOrgEnableMultiFactory((Long)orgId) && rowData.get((Object)"manuorg") == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u5f00\u542f\u591a\u5de5\u5382\uff0c\u8bf7\u5f55\u5165\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"WipAdjustBillImportEntryOp_50", (String)"macc-aca-opplugin", (Object[])new Object[0]), this.org.getString(NUMBER)));
            return false;
        }
        return true;
    }

    private boolean checkOrg(int index, JSONObject rowData, ImportLogger logger) {
        if (rowData.get((Object)"org") == null) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6838\u7b97\u7ec4\u7ec7\u7f16\u7801\u201d\u3002", (String)"WipAdjustBillImportEntryOp_15", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        Map orgMap = (Map)rowData.get((Object)"org");
        String orgNumber = orgMap.get(NUMBER).toString();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,fisaccounting", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)orgNumber)});
        if (org == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\u3002", (String)"WipAdjustBillImportEntryOp_51", (String)"macc-aca-opplugin", (Object[])new Object[0]), orgNumber));
            return false;
        }
        this.org = org;
        Long orgId = org.getLong("id");
        List acctOrgs = OrgHelper.getHasPermAccountOrgIds((String)"aca_wipadjustbill", (String)"aca");
        if (CadEmptyUtils.isEmpty((List)acctOrgs)) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u6237\u6ca1\u6709\u6838\u7b97\u7ec4\u7ec7\u6743\u9650\u3002", (String)"WipAdjustBillImportEntryOp_16", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (!acctOrgs.contains(orgId)) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u6237\u6ca1\u6709\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u7684\u6743\u9650\u3002", (String)"WipAdjustBillImportEntryOp_52", (String)"macc-aca-opplugin", (Object[])new Object[0]), orgNumber));
            return false;
        }
        return true;
    }
}

