/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.wipadjust;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.aca.common.constants.WipAdjustConstants;
import kd.macc.aca.common.helper.WipAdjustHelper;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CalcKeycolHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class WipAdjustBillImportSubEntryOp
extends BatchImportPlugin {
    private static final String NUMBER = "number";

    protected boolean isForceBatch() {
        return super.isForceBatch();
    }

    protected int getBatchImportSize() {
        return 5000;
    }

    public List<String> getDefaultLockUIs() {
        ArrayList<String> lockKeys = new ArrayList<String>();
        lockKeys.add("keyfields");
        lockKeys.add("flexpanelap6");
        return lockKeys;
    }

    public String getDefaultImportType() {
        return "override";
    }

    public String getDefaultKeyFields() {
        return "id";
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)"WipAdjustBillImportSubEntryOp_25", (String)"macc-aca-opplugin", (Object[])new Object[0])), "id"));
        return items;
    }

    protected void beforeSave(List<ImportBillData> billDatas, ImportLogger logger) {
        super.beforeSave(billDatas, logger);
        this.validateSubEntry(billDatas, logger);
    }

    private void validateSubEntry(List<ImportBillData> billDatas, ImportLogger logger) {
        Iterator<ImportBillData> billIterator = billDatas.iterator();
        while (billIterator.hasNext()) {
            ImportBillData billData = billIterator.next();
            JSONObject data = billData.getData();
            int index = billData.getStartIndex();
            if (!this.subCheckHead(index, data, logger)) {
                billIterator.remove();
                logger.setFailed(logger.getFailed() + 1);
                continue;
            }
            if (this.subCheckSubEntry(index, data, logger)) continue;
            billIterator.remove();
            logger.setFailed(logger.getFailed() + 1);
        }
        this.validateSubData(billDatas, logger);
    }

    private void validateSubData(List<ImportBillData> billDatas, ImportLogger logger) {
        ArrayList idAndsubEleNum = Lists.newArrayList();
        Map<Long, List<ImportBillData>> billNoSubEntryMap = billDatas.stream().collect(Collectors.groupingBy(importBillData -> Long.valueOf(importBillData.getData().get("id").toString())));
        if (billNoSubEntryMap != null && billNoSubEntryMap.size() > 0) {
            Set<Long> ids = billNoSubEntryMap.keySet();
            QFilter qFilter = new QFilter("id", "in", ids);
            qFilter.and("billstatus", "=", (Object)"A");
            DynamicObject[] wipCostInitArray = BusinessDataServiceHelper.load((String)"aca_wipadjustbill", (String)"id,org,costaccount,entryentity.subelement,entryentity.adjustamt", (QFilter[])new QFilter[]{qFilter});
            HashMap<String, Set> costaccountKeyColMap = new HashMap<String, Set>(10);
            if (wipCostInitArray != null && wipCostInitArray.length > 0) {
                Map<Long, DynamicObject> storedNoSubMap = Arrays.stream(wipCostInitArray).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject));
                for (Map.Entry<Long, List<ImportBillData>> billNoSubEntry : billNoSubEntryMap.entrySet()) {
                    Long id = billNoSubEntry.getKey();
                    String idStr = id.toString();
                    List<ImportBillData> subEntryDatas = billNoSubEntry.getValue();
                    Iterator<ImportBillData> iterator = subEntryDatas.iterator();
                    while (iterator.hasNext()) {
                        Long costaccountId;
                        ImportBillData subEntryData = iterator.next();
                        int index = subEntryData.getStartIndex();
                        JSONObject data = subEntryData.getData();
                        if (!storedNoSubMap.containsKey(id)) {
                            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5185\u7801\u201c%s\u201d\u672a\u627e\u5230\u5339\u914d\u6570\u636e\u3002", (String)"WipAdjustBillImportSubEntryOp_40", (String)"macc-aca-opplugin", (Object[])new Object[0]), idStr));
                            iterator.remove();
                            logger.setFailed(logger.getFailed() + 1);
                            continue;
                        }
                        DynamicObject wipAdjust = storedNoSubMap.get(id);
                        JSONArray jsonArray = data.getJSONArray("entryentity");
                        for (Object o : jsonArray) {
                            JSONObject entryObj = (JSONObject)o;
                            Map subElementMap = (Map)entryObj.get((Object)"subelement");
                            if (subElementMap == null || subElementMap.size() <= 0) continue;
                            String subEleNum = subElementMap.get(NUMBER).toString();
                            if (idAndsubEleNum.contains(idStr.concat("@").concat(subEleNum))) {
                                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5185\u7801\u3010%1$s\u3011\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801\u3010%2$s\u3011\u5df2\u91cd\u590d", (String)"WipAdjustBillImportSubEntryOp_43", (String)"macc-aca-opplugin", (Object[])new Object[0]), idStr, subEleNum));
                                iterator.remove();
                                logger.setFailed(logger.getFailed() + 1);
                                continue;
                            }
                            idAndsubEleNum.add(idStr.concat("@").concat(subEleNum));
                        }
                        if (wipAdjust == null) continue;
                        Long orgId = wipAdjust.getLong("org.id");
                        String key = String.format("%s@%s", orgId, costaccountId = Long.valueOf(wipAdjust.getLong("costaccount.id")));
                        Set calcKeys = (Set)costaccountKeyColMap.get(key);
                        if (calcKeys == null) {
                            calcKeys = CalcKeycolHelper.getCostaccountKeyCols((Long)orgId, (Long)costaccountId, (String)"aca");
                            costaccountKeyColMap.put(key, calcKeys);
                        }
                        if (this.checkEntryEntity(index, wipAdjust, data, logger, CadEmptyUtils.isEmpty((Set)calcKeys))) continue;
                        billDatas.remove(subEntryData);
                        logger.setFailed(logger.getFailed() + 1);
                    }
                }
            } else {
                logger.log(Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5185\u7801\u201c%s\u201d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u5355\u636e\u3002", (String)"WipAdjustBillImportSubEntryOp_42", (String)"macc-aca-opplugin", (Object[])new Object[0]), StringUtils.join(ids, (String)",")));
                logger.setFailed(logger.getFailed() + billDatas.size());
                billDatas.clear();
            }
        }
    }

    private boolean subCheckSubEntry(int index, JSONObject data, ImportLogger logger) {
        boolean checkFlag = true;
        JSONArray entryData = data.getJSONArray("entryentity");
        boolean subEntryFlag = false;
        for (Object entryObj : entryData) {
            JSONObject entryObject;
            JSONArray subEntry;
            if (entryObj == null || (subEntry = (entryObject = (JSONObject)entryObj).getJSONArray("subentryentity")) == null || subEntry.size() <= 0) continue;
            subEntryFlag = true;
            Map subElementMap = (Map)entryObject.get((Object)"subelement");
            String subElementNum = (String)subElementMap.get(NUMBER);
            QFilter subElementNumFilter = new QFilter(NUMBER, "=", (Object)subElementNum);
            DynamicObject subElement = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_subelement", (String)"id,type", (QFilter[])new QFilter[]{subElementNumFilter});
            if (subElement == null) {
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6839\u636e\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801\u3010%s\u3011\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u5b50\u8981\u7d20", (String)"WipAdjustBillImportSubEntryOp_44", (String)"macc-aca-opplugin", (Object[])new Object[0]), subElementNum));
                checkFlag = false;
                return checkFlag;
            }
            if (!WipAdjustConstants.MAT_SUBELE_TYPES.contains(subElement.getString("type"))) {
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6839\u636e\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801\u3010%s\u3011\u627e\u5230\u7684\u6210\u672c\u5b50\u8981\u7d20\u4e0d\u662f\u7269\u6599\u6216\u8005\u7269\u6599\u8d39\u7528\u5c5e\u6027\uff0c\u4e0d\u9700\u8981\u5bfc\u5165\u5b50\u7269\u6599\u4fe1\u606f", (String)"WipAdjustBillImportSubEntryOp_45", (String)"macc-aca-opplugin", (Object[])new Object[0]), subElementNum));
                checkFlag = false;
                return checkFlag;
            }
            Iterator iterator = subEntry.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object != null) {
                    JSONObject subEntryRow = (JSONObject)object;
                    if (subEntryRow.get((Object)"submaterial") == null) {
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u5b50\u9879\u7269\u6599\u7f16\u7801\u201d\u3002", (String)"WipAdjustBillImportSubEntryOp_46", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                        checkFlag = false;
                        continue;
                    }
                    subEntryRow.put("subsubelement_id", subElement.get("id"));
                    Map subMaterialMap = (Map)subEntryRow.get((Object)"submaterial");
                    String matNum = subMaterialMap.get(NUMBER).toString();
                    if (!StringUtils.isNotBlank((CharSequence)matNum)) continue;
                    QFilter qFilter = new QFilter(NUMBER, "=", (Object)matNum);
                    DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (QFilter[])new QFilter[]{qFilter});
                    if (material == null) {
                        logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5b50\u9879\u7269\u6599\u7f16\u7801\u3010%s\u3011\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e", (String)"WipAdjustBillImportSubEntryOp_47", (String)"macc-aca-opplugin", (Object[])new Object[0]), matNum));
                        checkFlag = false;
                        return checkFlag;
                    }
                    if (BomRouterHelper.isEnableAuxprop((DynamicObject)material) && subEntryRow.get((Object)"auxpty") == null) {
                        logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5b50\u9879\u7269\u6599\u7f16\u7801\u3010%s\u3011\u5f00\u542f\u4e86\u8f85\u52a9\u5c5e\u6027\u4e14\u8f85\u52a9\u5c5e\u6027\u5f71\u54cd\u6210\u672c\uff0c\u8bf7\u5f55\u5165\u5b50\u9879\u7269\u6599\u8f85\u52a9\u5c5e\u6027", (String)"WipAdjustBillImportSubEntryOp_48", (String)"macc-aca-opplugin", (Object[])new Object[0]), matNum));
                        checkFlag = false;
                    }
                    subEntryRow.put("baseunit".concat("_id"), material.get("baseunit.id"));
                    BigDecimal submatadjqty = WipAdjustHelper.getOrZero((Object)subEntryRow.getBigDecimal("submatadjqty"));
                    BigDecimal submatadjamt = WipAdjustHelper.getOrZero((Object)subEntryRow.getBigDecimal("submatadjamt"));
                    if (submatadjqty.compareTo(BigDecimal.ZERO) != 0 || submatadjamt.compareTo(BigDecimal.ZERO) != 0) continue;
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5b50\u9879\u7269\u6599\u7f16\u7801\u3010%s\u3011\u8c03\u6574\u6570\u91cf\u548c\u5b50\u9879\u7269\u6599\u8c03\u6574\u91d1\u989d\u90fd\u4e3a0\u6216\u7a7a\uff0c\u5219\u8fd9\u6761\u6570\u636e\u4e0d\u5f15\u5165", (String)"WipAdjustBillImportSubEntryOp_49", (String)"macc-aca-opplugin", (Object[])new Object[0]), matNum));
                    checkFlag = false;
                    return checkFlag;
                }
                iterator.remove();
            }
        }
        if (!subEntryFlag) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u5b50\u9879\u7269\u6599\u4fe1\u606f\u201d\u3002", (String)"WipAdjustBillImportSubEntryOp_6", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            checkFlag = false;
        }
        return checkFlag;
    }

    private boolean subCheckHead(int index, JSONObject data, ImportLogger logger) {
        JSONArray entryEntity;
        boolean checkFlag = true;
        data.put("source", (Object)"subImport");
        if (data.get((Object)"id") == null) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5185\u7801\u672a\u586b\u5165", (String)"WipAdjustBillImportSubEntryOp_7", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            checkFlag = false;
        }
        if ((entryEntity = data.getJSONArray("entryentity")) == null || entryEntity.size() == 0) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6210\u672c\u4fe1\u606f\u201d\u3002", (String)"WipAdjustBillImportSubEntryOp_8", (String)"macc-aca-opplugin", (Object[])new Object[0]));
            checkFlag = false;
        }
        if (entryEntity != null && entryEntity.size() != 0) {
            Iterator iterator = entryEntity.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (o != null) {
                    JSONObject entryRow = (JSONObject)o;
                    if (entryRow.get((Object)"subelement") != null) continue;
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801\u672a\u586b\u5165", (String)"WipAdjustBillImportSubEntryOp_50", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                    checkFlag = false;
                    continue;
                }
                iterator.remove();
            }
        }
        return checkFlag;
    }

    private boolean checkEntryEntity(int index, DynamicObject wipAdjust, JSONObject data, ImportLogger logger, boolean checkRepeat) {
        boolean checkFlag = true;
        DynamicObjectCollection entryEntity = wipAdjust.getDynamicObjectCollection("entryentity");
        ArrayList subEleMats = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            JSONArray jsonArray = data.getJSONArray("entryentity");
            Map<String, JSONObject> subEleJsonObjMap = jsonArray.stream().collect(Collectors.toMap(o -> {
                JSONObject entryObject = (JSONObject)o;
                Map subElementMap = (Map)entryObject.get((Object)"subelement");
                return subElementMap.get(NUMBER).toString();
            }, o -> (JSONObject)o));
            for (DynamicObject costInfo : entryEntity) {
                String subElementNum;
                DynamicObject subElement = costInfo.getDynamicObject("subelement");
                if (subElement == null || !subEleJsonObjMap.containsKey(subElementNum = subElement.getString(NUMBER))) continue;
                JSONObject entryObject = subEleJsonObjMap.get(subElementNum);
                entryObject.put("importtype", (Object)"subentry");
                JSONArray subEntryArray = entryObject.getJSONArray("subentryentity");
                boolean amtCheckFlag = true;
                for (Object matInfoObj : subEntryArray) {
                    if (matInfoObj == null) continue;
                    JSONObject matInfo = (JSONObject)matInfoObj;
                    Map matMap = (Map)matInfo.get((Object)"submaterial");
                    String matNum = matMap.get(NUMBER).toString();
                    if (subEleMats.contains(subElementNum.concat("@").concat(matNum)) && checkRepeat) {
                        logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801\u3010%1$s\u3011\u5b58\u5728\u76f8\u540c\u5b50\u9879\u7269\u6599\u7f16\u7801\u3010%2$s\u3011", (String)"WipAdjustBillImportSubEntryOp_51", (String)"macc-aca-opplugin", (Object[])new Object[0]), subElementNum, matNum));
                        checkFlag = false;
                    }
                    subEleMats.add(subElementNum.concat("@").concat(matNum));
                    BigDecimal submatadjamt = WipAdjustHelper.getOrZero((Object)matInfo.getBigDecimal("submatadjamt"));
                    BigDecimal submatadjqty = WipAdjustHelper.getOrZero((Object)matInfo.getBigDecimal("submatadjqty"));
                    if (submatadjamt.compareTo(BigDecimal.ZERO) != 0 || submatadjqty.compareTo(BigDecimal.ZERO) != 0) continue;
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801\u3010%1$s\u3011\u5b50\u7269\u6599\u7269\u6599\u7f16\u7801\u3010%2$s\u3011\u5b50\u9879\u7269\u6599\u8c03\u6574\u6570\u91cf\u548c\u5b50\u9879\u7269\u6599\u8c03\u6574\u91d1\u989d\u90fd\u4e3a0\u6216\u7a7a", (String)"WipAdjustBillImportSubEntryOp_52", (String)"macc-aca-opplugin", (Object[])new Object[0]), subElementNum, matNum));
                    checkFlag = false;
                }
                if (amtCheckFlag) continue;
                logger.setFailed(logger.getFailed() + 1);
                checkFlag = false;
            }
        }
        return checkFlag;
    }
}

