/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.wipadjust;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.CostaccountHelper;
import kd.macc.aca.common.constants.WipAdjustConstants;
import kd.macc.aca.common.constants.WipAdjustSubItem;
import kd.macc.aca.common.helper.WipAdjustHelper;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CalcKeycolHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class WipAdjustBillSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("adjusttype");
        fieldKeys.add("org");
        fieldKeys.add("manuorg");
        fieldKeys.add("costcenter");
        fieldKeys.add("costaccount");
        fieldKeys.add("period");
        fieldKeys.add("bookdate");
        fieldKeys.add("costobject");
        fieldKeys.add("wipqty");
        fieldKeys.add("adjustqty");
        fieldKeys.add("source");
        fieldKeys.add("billstatus");
        fieldKeys.add("entryentity");
        fieldKeys.add("entryentity.element");
        fieldKeys.add("entryentity.subelement");
        fieldKeys.add("entryentity.outsourcetype");
        fieldKeys.add("entryentity.wipamt");
        fieldKeys.add("entryentity.adjustamt");
        fieldKeys.add("entryentity.afteradjustamt");
        fieldKeys.add("entryentity.importtype");
        fieldKeys.add("entryentity.datatype");
        fieldKeys.add("subentryentity");
        fieldKeys.add("subentryentity.submaterial");
        fieldKeys.add("subentryentity.version");
        fieldKeys.add("subentryentity.auxpty");
        fieldKeys.add("subentryentity.calckeycol");
        fieldKeys.add("subentryentity.modelnum");
        fieldKeys.add("subentryentity.submatqty");
        fieldKeys.add("subentryentity.submatadjqty");
        fieldKeys.add("subentryentity.submatamt");
        fieldKeys.add("subentryentity.submatadjamt");
        fieldKeys.add("subentryentity.subdatatype");
        fieldKeys.add("subentryentity.subitemjson");
        fieldKeys.add("subentryentity.subitemjson_tag");
        fieldKeys.add("subitementry");
        fieldKeys.add("subitementry.sitemelement");
        fieldKeys.add("subitementry.sitemsubelement");
        fieldKeys.add("subitementry.sitemoutsourcetype");
        fieldKeys.add("subitementry.sitemwipamt");
        fieldKeys.add("subitementry.sitemadjamt");
        fieldKeys.add("subitementry.sitemafteradjamt");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap costaccountMap = Maps.newHashMapWithExpectedSize((int)10);
        if (e.getOperationKey().equalsIgnoreCase("submit")) {
            for (DynamicObject dyn : dataEntities) {
                Boolean isViewSubItem;
                Long costaccountId = dyn.getLong("costaccount.id");
                if (!costaccountMap.containsKey(costaccountId)) {
                    isViewSubItem = CostaccountHelper.getCostElementByCostAccount((long)costaccountId);
                    costaccountMap.put(costaccountId, isViewSubItem);
                }
                if (!(isViewSubItem = (Boolean)costaccountMap.get(costaccountId)).booleanValue()) continue;
                this.updateSubItemEntry(dyn);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (!e.getOperationKey().equalsIgnoreCase("submit")) {
            return;
        }
        DynamicObject[] dyns = e.getDataEntities();
        HashMap<String, List> costaccountIdMap = new HashMap<String, List>(10);
        HashMap<String, Set> costaccountKeyColMap = new HashMap<String, Set>(10);
        for (DynamicObject dyn : dyns) {
            Long costaccountId;
            Long orgId = dyn.getLong("org.id");
            String key = String.format("%s@%s", orgId, costaccountId = Long.valueOf(dyn.getLong("costaccount.id")));
            Set calcKeys = (Set)costaccountKeyColMap.get(key);
            if (calcKeys == null) {
                calcKeys = CalcKeycolHelper.getCostaccountKeyCols((Long)orgId, (Long)costaccountId, (String)"aca");
                costaccountKeyColMap.put(key, calcKeys);
            }
            if (CadEmptyUtils.isEmpty((Set)calcKeys)) continue;
            DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject subDyn : entryentity) {
                DynamicObjectCollection detailDyns = subDyn.getDynamicObjectCollection("subentryentity");
                if (detailDyns == null || detailDyns.isEmpty()) continue;
                boolean isAdd = false;
                for (DynamicObject detailDyn : detailDyns) {
                    if ("sysImport".equals(detailDyn.getString("subdatatype"))) continue;
                    isAdd = true;
                    break;
                }
                if (!isAdd) continue;
                costaccountIdMap.computeIfAbsent(key, t -> new ArrayList(10)).add(dyn.getLong("id"));
            }
        }
        if (!costaccountIdMap.isEmpty()) {
            for (Map.Entry entry : costaccountIdMap.entrySet()) {
                String[] arr = ((String)entry.getKey()).split("@");
                Long orgId = Long.valueOf(arr[0]);
                Long costaccountId = Long.valueOf(arr[1]);
                CalcKeycolHelper.wipAdjustGenKeycol((Long)orgId, (Long)costaccountId, (List)((List)entry.getValue()), (Set)((Set)costaccountKeyColMap.get(entry.getKey())));
            }
        }
    }

    private void updateSubItemEntry(DynamicObject dyn) {
        HashMap elementAdjItemMap = Maps.newHashMapWithExpectedSize((int)10);
        DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            Long elementId = entry.getLong("element.id");
            Long subElementId = entry.getLong("subelement.id");
            String outsourcetype = entry.getString("outsourcetype");
            DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
            if (subentryentity != null && !subentryentity.isEmpty()) {
                for (DynamicObject subentry : subentryentity) {
                    String json = subentry.getString("subitemjson_tag");
                    List subItems = null;
                    if (!StringUtils.isEmpty((String)json)) {
                        subItems = JSON.parseArray((String)json, WipAdjustSubItem.class);
                    }
                    if (CadEmptyUtils.isEmpty(subItems)) {
                        String key = String.format("%s@%s@%s", elementId, subElementId, outsourcetype);
                        BigDecimal wipAmt = BigDecimalUtil.getOrZero((Object)subentry.getBigDecimal("submatamt"));
                        BigDecimal adjAmt = BigDecimalUtil.getOrZero((Object)subentry.getBigDecimal("submatadjamt"));
                        this.addAdjAmt(key, wipAmt, adjAmt, elementAdjItemMap);
                        continue;
                    }
                    for (WipAdjustSubItem subitem : subItems) {
                        String key = String.format("%s@%s@%s", subitem.getSelement(), subitem.getSsubelement(), outsourcetype);
                        this.addAdjAmt(key, subitem.getSwipamt(), subitem.getSadjustamt(), elementAdjItemMap);
                    }
                }
                continue;
            }
            String key = String.format("%s@%s@%s", elementId, subElementId, outsourcetype);
            BigDecimal wipAmt = BigDecimalUtil.getOrZero((Object)entry.getBigDecimal("wipamt"));
            BigDecimal adjAmt = BigDecimalUtil.getOrZero((Object)entry.getBigDecimal("adjustamt"));
            this.addAdjAmt(key, wipAmt, adjAmt, elementAdjItemMap);
        }
        DynamicObjectCollection subitementry = dyn.getDynamicObjectCollection("subitementry");
        if (!subitementry.isEmpty()) {
            subitementry.clear();
        }
        for (Map.Entry entry : elementAdjItemMap.entrySet()) {
            String[] keys = ((String)entry.getKey()).split("@");
            DynamicObject subitem = subitementry.addNew();
            subitem.set("sitemelement_id", (Object)Long.valueOf(keys[0]));
            subitem.set("sitemsubelement_id", (Object)Long.valueOf(keys[1]));
            subitem.set("sitemoutsourcetype", (Object)(keys.length < 3 ? "" : keys[2]));
            subitem.set("sitemwipamt", (Object)((BigDecimal[])entry.getValue())[0]);
            subitem.set("sitemadjamt", (Object)((BigDecimal[])entry.getValue())[1]);
            subitem.set("sitemafteradjamt", (Object)((BigDecimal[])entry.getValue())[0].add(((BigDecimal[])entry.getValue())[1]));
        }
    }

    private void addAdjAmt(String key, BigDecimal wipAmt, BigDecimal adjAmt, Map<String, BigDecimal[]> elementAdjItemMap) {
        BigDecimal[] arr = null;
        arr = elementAdjItemMap.containsKey(key) ? elementAdjItemMap.get(key) : new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
        arr[0] = arr[0].add(wipAmt);
        arr[1] = arr[1].add(adjAmt);
        elementAdjItemMap.put(key, arr);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                HashMap<String, Set> costaccountKeyColMap = new HashMap<String, Set>(10);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject item = dataEntity.getDataEntity();
                    this.relateData(dataEntity);
                    Long orgId = item.getLong("org.id");
                    Long costaccountId = item.getLong("costaccount.id");
                    String key = String.format("%s@%s", orgId, costaccountId);
                    Set calcKeys = (Set)costaccountKeyColMap.get(key);
                    if (calcKeys == null) {
                        calcKeys = CalcKeycolHelper.getCostaccountKeyCols((Long)orgId, (Long)costaccountId, (String)"aca");
                        costaccountKeyColMap.put(key, calcKeys);
                    }
                    this.cherckData(dataEntity, CadEmptyUtils.isEmpty((Set)calcKeys));
                }
            }

            private void cherckData(ExtendedDataEntity dataEntity, boolean checkRepeat) {
                DynamicObject bill = dataEntity.getDataEntity();
                String operationMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"WipAdjustBillSaveOpPlugin_25", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                if (this.getOperateKey().equalsIgnoreCase("submit")) {
                    operationMsg = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002", (String)"WipAdjustBillSaveOpPlugin_27", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                }
                String source = dataEntity.getDataEntity().getString("source");
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
                HashSet<String> subelementSet = new HashSet<String>(16);
                DynamicObject costobjectDyn = bill.getDynamicObject("costobject");
                boolean isOutsource = costobjectDyn == null ? false : costobjectDyn.getBoolean("isoutsource");
                for (DynamicObject entry : entries) {
                    String subElementOutType;
                    DynamicObject subelement = (DynamicObject)entry.get("subelement");
                    String subelementName = "";
                    Long subelementId = 0L;
                    if (subelement == null) {
                        subelementId = entry.getLong("subelement_id");
                    } else {
                        subelementId = subelement.getLong("id");
                        subelementName = subelement.getString("name");
                    }
                    if (CadEmptyUtils.isEmpty((Long)subelementId)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6210\u672c\u4fe1\u606f\u4e2d\u6210\u672c\u5b50\u8981\u7d20\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WipAdjustBillSaveOpPlugin_2", (String)"macc-aca-opplugin", (Object[])new Object[0]), operationMsg));
                        continue;
                    }
                    String outSourceType = entry.getString("outsourcetype");
                    if (outSourceType == null) {
                        outSourceType = "";
                    }
                    if (!isOutsource && !StringUtils.isBlank((String)outSourceType)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6210\u672c\u5bf9\u8c61\u975e\u59d4\u5916\u65f6\uff0c\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\uff0c\u59d4\u5916\u6210\u672c\u7c7b\u578b\u4e0d\u9700\u8981\u586b\u503c\u3002", (String)"WipAdjustBillSaveOpPlugin_21", (String)"macc-aca-opplugin", (Object[])new Object[0]), operationMsg, subelementName));
                    }
                    if (subelementSet.contains(subElementOutType = String.format("%s@%s", subelementId, outSourceType))) {
                        String tipMsg = StringUtils.isBlank((String)outSourceType) ? String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6210\u672c\u4fe1\u606f\u4e2d\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u91cd\u590d\u3002", (String)"WipAdjustBillSaveOpPlugin_14", (String)"macc-aca-opplugin", (Object[])new Object[0]), operationMsg, subelementName) : String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6210\u672c\u4fe1\u606f\u4e2d\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u548c\u59d4\u5916\u6210\u672c\u7c7b\u578b\u201c%3$s\u201d\u91cd\u590d\u3002", (String)"WipAdjustBillSaveOpPlugin_15", (String)"macc-aca-opplugin", (Object[])new Object[0]), operationMsg, subelementName, WipAdjustBillSaveOpPlugin.this.getOutSourceType(outSourceType));
                        this.addErrorMessage(dataEntity, tipMsg);
                        continue;
                    }
                    subelementSet.add(subElementOutType);
                }
                if (!"import".equals(source)) {
                    BigDecimal qty = bill.getBigDecimal("adjustqty");
                    Boolean isNoHaiQtyAndAmt = Boolean.TRUE;
                    for (DynamicObject entry : entries) {
                        DynamicObject subelement = (DynamicObject)entry.get("subelement");
                        BigDecimal adjustAmt = entry.getBigDecimal("adjustamt");
                        if (isNoHaiQtyAndAmt.booleanValue()) {
                            isNoHaiQtyAndAmt = adjustAmt.compareTo(BigDecimal.ZERO) == 0;
                        }
                        if (!WipAdjustConstants.MAT_SUBELE_TYPES.contains(subelement.getString("type"))) continue;
                        DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("subentryentity");
                        BigDecimal tatolAmt = BigDecimal.ZERO;
                        HashSet<String> submaterialSet = new HashSet<String>(16);
                        Iterator iterator = subEntrys.iterator();
                        while (iterator.hasNext()) {
                            DynamicObject subEntry = (DynamicObject)iterator.next();
                            String subDataType = subEntry.getString("subdatatype");
                            DynamicObject submaterial = (DynamicObject)subEntry.get("submaterial");
                            BigDecimal subMatAdjQty = subEntry.getBigDecimal("submatadjqty");
                            BigDecimal subMatAdjAmt = subEntry.getBigDecimal("submatadjamt");
                            Boolean subMatAdjQtyCherck = subMatAdjQty.compareTo(BigDecimal.ZERO) == 0 && subMatAdjAmt.compareTo(BigDecimal.ZERO) == 0;
                            if (!"sysImport".equals(subDataType) && submaterial == null && subMatAdjQtyCherck.booleanValue()) {
                                iterator.remove();
                                continue;
                            }
                            Long submaterialId = 0L;
                            Long versionId = 0L;
                            Long auxptyId = 0L;
                            String submaterialNumber = "";
                            if (submaterial != null) {
                                String submaterialSetKey;
                                submaterialNumber = submaterial.getString("number");
                                submaterialId = submaterial.getLong("id");
                                versionId = subEntry.get("version") == null ? 0L : ((DynamicObject)subEntry.get("version")).getLong("id");
                                auxptyId = subEntry.get("auxpty") == null ? 0L : ((DynamicObject)subEntry.get("auxpty")).getLong("id");
                                if (BomRouterHelper.isEnableAuxprop((DynamicObject)submaterial) && auxptyId == 0L) {
                                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u6210\u672c\u4fe1\u606f\u6210\u672c\u5b50\u8981\u7d20\u3010%2$s\u3011\u4e0b\uff0c\u5b50\u9879\u7269\u6599\u4fe1\u606f\u4e2d\u5b50\u9879\u7269\u6599\u7f16\u7801\u3010%3$s\u3011\u5f00\u542f\u4e86\u8f85\u52a9\u5c5e\u6027\u4e14\u8f85\u52a9\u5c5e\u6027\u5f71\u54cd\u6210\u672c\uff0c\u8bf7\u5f55\u5165\u5b50\u9879\u7269\u6599\u8f85\u52a9\u5c5e\u6027\uff01", (String)"WipAdjustBillSaveOpPlugin_28", (String)"macc-aca-opplugin", (Object[])new Object[0]), operationMsg, subelement.getString("name"), submaterialNumber));
                                }
                                if (submaterialSet.contains(submaterialSetKey = String.format("%s@%s@%s", submaterialId, versionId, auxptyId)) && checkRepeat) {
                                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u6210\u672c\u4fe1\u606f\u6210\u672c\u5b50\u8981\u7d20\u3010%2$s\u3011\u4e0b\uff0c\u5b50\u9879\u7269\u6599\u4fe1\u606f\u4e2d\u5b50\u9879\u7269\u6599\u7f16\u7801\u3010%3$s\u3011\u91cd\u590d\uff01", (String)"WipAdjustBillSaveOpPlugin_29", (String)"macc-aca-opplugin", (Object[])new Object[0]), operationMsg, subelement.getString("name"), submaterialNumber));
                                } else {
                                    submaterialSet.add(submaterialSetKey);
                                }
                                Long costaccountId = bill.getLong("costaccount.id");
                                boolean isViewSubItem = CostaccountHelper.getCostElementByCostAccount((long)costaccountId);
                                if (this.getOperateKey().equalsIgnoreCase("submit") && isViewSubItem) {
                                    String subjson = subEntry.getString("subitemjson_tag");
                                    if (!StringUtils.isEmpty((String)subjson)) {
                                        List subitems = JSON.parseArray((String)subjson, WipAdjustSubItem.class);
                                        BigDecimal subItemAdjAmt = BigDecimal.ZERO;
                                        for (WipAdjustSubItem subitem : subitems) {
                                            subItemAdjAmt = subItemAdjAmt.add(BigDecimalUtil.getOrZero((Object)subitem.getSadjustamt()));
                                            if (!CadEmptyUtils.isEmpty((Long)subitem.getSsubelement())) continue;
                                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u6210\u672c\u4fe1\u606f\u6210\u672c\u5b50\u8981\u7d20\u3010%2$s\u3011\u4e0b\uff0c\u5b50\u9879\u7269\u6599\u4fe1\u606f\u4e2d\u5b50\u9879\u7269\u6599\u7f16\u7801\u3010%3$s\u3011\u7684\u5206\u9879\u8c03\u6574\u5b58\u5728\u5b50\u8981\u7d20\u4e3a\u7a7a\u7684\u6570\u636e\uff01", (String)"WipAdjustBillSaveOpPlugin_30", (String)"macc-aca-opplugin", (Object[])new Object[0]), operationMsg, subelement.getString("name"), submaterialNumber));
                                        }
                                        if (subItemAdjAmt.compareTo(subMatAdjAmt) != 0) {
                                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u6210\u672c\u4fe1\u606f\u6210\u672c\u5b50\u8981\u7d20\u3010%2$s\u3011\u4e0b\uff0c\u5b50\u9879\u7269\u6599\u4fe1\u606f\u4e2d\u5b50\u9879\u7269\u6599\u7f16\u7801\u3010%3$s\u3011\u7684\u8c03\u6574\u91d1\u989d\u2260\u5176\u5206\u9879\u8c03\u6574\u91d1\u989d\u4e4b\u548c\uff01", (String)"WipAdjustBillSaveOpPlugin_31", (String)"macc-aca-opplugin", (Object[])new Object[0]), operationMsg, subelement.getString("name"), submaterialNumber));
                                        }
                                    } else {
                                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d26\u7c3f\u542f\u7528\u5206\u9879\u65f6\uff0c%1$s\u6210\u672c\u4fe1\u606f\u6210\u672c\u5b50\u8981\u7d20\u3010%2$s\u3011\u4e0b\uff0c\u5b50\u9879\u7269\u6599\u4fe1\u606f\u4e2d\u5b50\u9879\u7269\u6599\u7f16\u7801\u3010%3$s\u3011\u7684\u5206\u9879\u8c03\u6574\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\uff01", (String)"WipAdjustBillSaveOpPlugin_32", (String)"macc-aca-opplugin", (Object[])new Object[0]), operationMsg, subelement.getString("name"), submaterialNumber));
                                    }
                                }
                            }
                            if (isNoHaiQtyAndAmt.booleanValue()) {
                                isNoHaiQtyAndAmt = subMatAdjQtyCherck;
                            }
                            tatolAmt = tatolAmt.add(subMatAdjAmt);
                        }
                        if (!this.getOperateKey().equalsIgnoreCase("submit") || tatolAmt.compareTo(adjustAmt) == 0) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u7684\u8c03\u6574\u91d1\u989d\u4e0d\u7b49\u4e8e\u5176\u5b50\u9879\u7269\u6599\u8c03\u6574\u91d1\u989d\u4e4b\u548c\u3002", (String)"WipAdjustBillSaveOpPlugin_19", (String)"macc-aca-opplugin", (Object[])new Object[0]), operationMsg, subelement.getString("name")));
                    }
                    if (this.getOperateKey().equalsIgnoreCase("submit") && qty.compareTo(BigDecimal.ZERO) == 0 && isNoHaiQtyAndAmt.booleanValue()) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u8c03\u6574\u6570\u91cf\u3001\u8c03\u6574\u91d1\u989d\u3001\u5b50\u9879\u7269\u6599\u8c03\u6574\u6570\u91cf\u3001\u5b50\u9879\u7269\u6599\u8c03\u6574\u91d1\u989d\u5fc5\u987b\u8981\u6709\u4e00\u4e2a\u6709\u503c\uff0c\u4e0d\u80fd\u5168\u4e3a\u7a7a\u3002", (String)"WipAdjustBillSaveOpPlugin_9", (String)"macc-aca-opplugin", (Object[])new Object[0]), operationMsg));
                    }
                }
            }

            private void relateData(ExtendedDataEntity dataEntity) {
                DynamicObjectCollection entryEntity;
                DynamicObject item = dataEntity.getDataEntity();
                String source = item.getString("source");
                String billStatus = item.getString("billstatus");
                if ("import".equals(source) && !"C".equals(billStatus)) {
                    this.relaCalcResultInfo(item);
                }
                if ("subImport".equals(source) && !"C".equals(billStatus) && CollectionUtils.isNotEmpty((Collection)(entryEntity = item.getDynamicObjectCollection("entryentity")))) {
                    for (DynamicObject entry : entryEntity) {
                        long subElementId = entry.getLong("subelement.id");
                        long elementId = entry.getLong("element.id");
                        if (CadEmptyUtils.isEmpty((Long)elementId)) {
                            QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
                            DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
                            entry.set("element_id", (Object)dySubElement.getLong("element"));
                        }
                        DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
                        for (DynamicObject dyn : subentryentity) {
                            String subitemJson = dyn.getString("subitemjson_tag");
                            if (StringUtils.isEmpty((String)subitemJson)) continue;
                            List subitems = JSON.parseArray((String)subitemJson, WipAdjustSubItem.class);
                            WipAdjustHelper.calcAdjustSubItemAmt((List)subitems, (BigDecimal)dyn.getBigDecimal("submatadjamt"), (int)this.getCurrencyPrecision(item));
                            dyn.set("subitemjson_tag", (Object)JSON.toJSONString((Object)subitems));
                        }
                    }
                }
            }

            private int getCurrencyPrecision(DynamicObject item) {
                DynamicObject currency = item.getDynamicObject("currency");
                if (currency == null) {
                    return 2;
                }
                return currency.getInt("amtprecision");
            }

            private void relaCalcResultInfo(DynamicObject item) {
                Long costobjectId = item.getLong("costobject.id");
                Long costaccountId = item.getLong("costaccount.id");
                Long orgId = item.getLong("org.id");
                String adjustType = item.getString("adjusttype");
                Map keycolFieldMap = CalcKeycolHelper.getWipAdjustKeyColFieldMap((Long)orgId, (Long)costaccountId, (boolean)false);
                Map map = WipAdjustHelper.getCostObjectRelInfo((long)costobjectId, (DynamicObject)item, (String)adjustType, (boolean)CostaccountHelper.getCostElementByCostAccount((long)costaccountId));
                if (map.isEmpty()) {
                    return;
                }
                boolean isEnd = "END".equalsIgnoreCase(adjustType);
                BigDecimal pdendqty = WipAdjustHelper.getOrZero(map.get("pdendqty"));
                BigDecimal endadjqty = WipAdjustHelper.getOrZero(map.get("endadjqty"));
                item.set("wipqty", (Object)(isEnd ? pdendqty : pdendqty.add(endadjqty)));
                if (map.get("detailInfo") != null) {
                    String keyStr;
                    List detailList = (List)map.get("detailInfo");
                    Map subMapInfo = (Map)map.get("subMap");
                    DynamicObjectCollection entryEntity = item.getDynamicObjectCollection("entryentity");
                    HashMap subelementMap = Maps.newHashMapWithExpectedSize((int)10);
                    for (DynamicObject dyn : entryEntity) {
                        keyStr = String.format("%s@%s", dyn.getLong("subelement.id"), dyn.getString("outsourcetype") == null ? "" : dyn.getString("outsourcetype"));
                        subelementMap.put(keyStr, dyn);
                    }
                    for (Map detailMap : detailList) {
                        keyStr = String.format("%s@%s", detailMap.get("subelement"), detailMap.get("outsourcetype"));
                        DynamicObject entry = null;
                        if (subelementMap.containsKey(keyStr)) {
                            entry = (DynamicObject)subelementMap.get(keyStr);
                        } else {
                            entry = entryEntity.addNew();
                            entry.set("element_id", detailMap.get("element"));
                            entry.set("subelement_id", detailMap.get("subelement"));
                        }
                        BigDecimal pdendamount = WipAdjustHelper.getOrZero(detailMap.get("pdendamount"));
                        BigDecimal endadjamt = WipAdjustHelper.getOrZero(detailMap.get("endadjamt"));
                        BigDecimal wipamt = isEnd ? pdendamount : pdendamount.add(endadjamt);
                        entry.set("wipamt", (Object)wipamt);
                        entry.set("datatype", (Object)"sysImport");
                        entry.set("outsourcetype", detailMap.get("outsourcetype"));
                        List subList = (List)subMapInfo.get(keyStr);
                        if (subList == null) continue;
                        DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("subentryentity");
                        for (Map subMap : subList) {
                            DynamicObject subEntry = subEntrys.addNew();
                            subEntry.set("submaterial_id", subMap.get("submaterial"));
                            subEntry.set("version_id", subMap.get("submatversion"));
                            subEntry.set("auxpty_id", subMap.get("subauxpty"));
                            subEntry.set("calckeycol_id", subMap.get("calckeycol"));
                            for (Map.Entry keyEntry : keycolFieldMap.entrySet()) {
                                if (((Tuple2)keyEntry.getValue()).t2 instanceof BasedataProp) {
                                    subEntry.set((String)((Tuple2)keyEntry.getValue()).t1 + "_id", subMap.get(keyEntry.getKey()));
                                    continue;
                                }
                                subEntry.set((String)((Tuple2)keyEntry.getValue()).t1, subMap.get(keyEntry.getKey()));
                            }
                            BigDecimal subPdendqty = WipAdjustHelper.getOrZero(subMap.get("pdendqty"));
                            BigDecimal subEndadjqty = WipAdjustHelper.getOrZero(subMap.get("endadjqty"));
                            BigDecimal submatqty = isEnd ? subPdendqty : subPdendqty.add(subEndadjqty);
                            subEntry.set("submatqty", (Object)submatqty);
                            subEntry.set("aftersubmatadjqty", (Object)submatqty);
                            subEntry.set("subsubelement_id", subMap.get("subelement"));
                            BigDecimal subPdendamount = WipAdjustHelper.getOrZero(subMap.get("pdendamount"));
                            BigDecimal subEndadjamt = WipAdjustHelper.getOrZero(subMap.get("endadjamt"));
                            BigDecimal submatamt = isEnd ? subPdendamount : subPdendamount.add(subEndadjamt);
                            subEntry.set("submatamt", (Object)submatamt);
                            subEntry.set("aftersubmatadjamt", (Object)submatamt);
                            subEntry.set("baseunit_id", subMap.get("baseunit"));
                            subEntry.set("subdatatype", (Object)"sysImport");
                            subEntry.set("subitemjson_tag", subMap.get("subitemjson"));
                        }
                    }
                    for (DynamicObject entryObj : entryEntity) {
                        DynamicObjectCollection subentryentity;
                        BigDecimal adjamt = entryObj.getBigDecimal("adjustamt");
                        if (adjamt == null || adjamt.compareTo(BigDecimal.ZERO) == 0 || CadEmptyUtils.isEmpty((DynamicObjectCollection)(subentryentity = entryObj.getDynamicObjectCollection("subentryentity")))) continue;
                        BigDecimal totalAmt = BigDecimal.ZERO;
                        DynamicObject maxDyn = null;
                        for (DynamicObject dyn : subentryentity) {
                            BigDecimal subinamt = BigDecimalUtil.getOrZero((Object)dyn.getBigDecimal("submatamt"));
                            totalAmt = totalAmt.add(subinamt);
                            if (maxDyn != null && subinamt.compareTo(BigDecimalUtil.getOrZero((Object)maxDyn.getBigDecimal("submatamt"))) <= 0) continue;
                            maxDyn = dyn;
                        }
                        HashMap dynRadioMap = Maps.newHashMapWithExpectedSize((int)10);
                        if (totalAmt.compareTo(BigDecimal.ZERO) == 0) {
                            BigDecimal radio = adjamt.divide(new BigDecimal(subentryentity.size()), 10, RoundingMode.HALF_UP);
                            for (DynamicObject dyn : subentryentity) {
                                dynRadioMap.put(dyn, radio);
                            }
                        } else {
                            for (DynamicObject dyn : subentryentity) {
                                BigDecimal subadjamt = BigDecimalUtil.getOrZero((Object)dyn.getBigDecimal("submatamt"));
                                dynRadioMap.put(dyn, subadjamt.divide(totalAmt, 10, RoundingMode.HALF_UP));
                            }
                        }
                        BigDecimal diffAmt = adjamt;
                        for (DynamicObject dyn : subentryentity) {
                            BigDecimal radio = (BigDecimal)dynRadioMap.get(dyn);
                            if (radio == null) continue;
                            BigDecimal subAdjAmt = adjamt.multiply(radio).setScale(this.getCurrencyPrecision(item), RoundingMode.HALF_UP);
                            dyn.set("submatadjamt", (Object)subAdjAmt);
                            diffAmt = diffAmt.subtract(subAdjAmt);
                        }
                        if (diffAmt.compareTo(BigDecimal.ZERO) != 0 && maxDyn != null) {
                            maxDyn.set("submatadjamt", (Object)maxDyn.getBigDecimal("submatadjamt").add(diffAmt));
                        }
                        for (DynamicObject dyn : subentryentity) {
                            String subitemJson = dyn.getString("subitemjson_tag");
                            if (StringUtils.isEmpty((String)subitemJson)) continue;
                            List subitems = JSON.parseArray((String)subitemJson, WipAdjustSubItem.class);
                            WipAdjustHelper.calcAdjustSubItemAmt((List)subitems, (BigDecimal)dyn.getBigDecimal("submatadjamt"), (int)this.getCurrencyPrecision(item));
                            dyn.set("subitemjson_tag", (Object)JSON.toJSONString((Object)subitems));
                        }
                    }
                }
            }
        });
    }

    private String getOutSourceType(String outSourceType) {
        String type = "";
        switch (outSourceType) {
            case "A": {
                type = ResManager.loadKDString((String)"\u59d4\u5916\u52a0\u5de5\u8d39", (String)"WipAdjustBillSaveOpPlugin_10", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                break;
            }
            case "B": {
                type = ResManager.loadKDString((String)"\u59d4\u5916\u8d39\u7528", (String)"WipAdjustBillSaveOpPlugin_11", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                break;
            }
            case "C": {
                type = ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528", (String)"WipAdjustBillSaveOpPlugin_12", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                break;
            }
            case "D": {
                type = ResManager.loadKDString((String)"\u7269\u6599", (String)"WipAdjustBillSaveOpPlugin_13", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                break;
            }
        }
        return type;
    }
}

