/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.wipcostcheck;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.aca.algox.enums.TerminalWipMatEnum;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class TerminalWipMatCheckImportOp
extends BatchImportPlugin {
    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Map option = this.ctx.getOption();
        String orgNumber = null;
        String costaccountNumber = null;
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        List allOrg = OrgUnitServiceHelper.getAllOrg((String)"10");
        if (option != null) {
            Iterator<ImportBillData> iterator = billdatas.iterator();
            while (iterator.hasNext()) {
                JSONObject costaccount;
                ImportBillData billdata = iterator.next();
                JSONObject data = billdata.getData();
                JSONObject org = data.getJSONObject("org");
                if (org == null || (costaccount = data.getJSONObject("costaccount")) == null) continue;
                String excelOrgNum = org.getString("number");
                if (StringUtils.isEmpty((CharSequence)excelOrgNum)) {
                    logger.log(Integer.valueOf(billdata.getStartIndex()), String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6838\u7b97\u7ec4\u7ec7\u7f16\u53f7\u3002", (String)"TerminalWipMatCheckImportOp_0", (String)"macc-aca-opplugin", (Object[])new Object[0]), new Object[0])).fail();
                    iterator.remove();
                    continue;
                }
                if (orgNumber == null) {
                    orgNumber = excelOrgNum;
                } else if (!orgNumber.equals(excelOrgNum)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u7684\u6838\u7b97\u7ec4\u7ec7\u4e0d\u662f\u540c\u4e00\u4e2a\uff0c\u65e0\u6cd5\u8fdb\u884c\u5f15\u5165\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TerminalWipMatCheckImportOp_1", (String)"macc-aca-opplugin", (Object[])new Object[0]));
                }
                boolean checkResult = this.checkOrgPermt(allOrg, orgNumber);
                if (checkResult) {
                    logger.log(Integer.valueOf(billdata.getStartIndex()), String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6838\u7b97\u7ec4\u7ec7\u7f16\u53f7%s\u7684\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TerminalWipMatCheckImportOp_2", (String)"macc-aca-opplugin", (Object[])new Object[0]), orgNumber)).fail();
                    iterator.remove();
                    continue;
                }
                String costaccNumberExcl = costaccount.getString("number");
                if (StringUtils.isEmpty((CharSequence)costaccNumberExcl)) {
                    logger.log(Integer.valueOf(billdata.getStartIndex()), String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u8d26\u7c3f\u7f16\u7801\u3002", (String)"TerminalWipMatCheckImportOp_6", (String)"macc-aca-opplugin", (Object[])new Object[0]), new Object[0])).fail();
                    iterator.remove();
                    continue;
                }
                if (costaccountNumber == null || !costaccountNumber.equals(costaccNumberExcl)) {
                    costaccountNumber = costaccNumberExcl;
                    DynamicObject currPeriodEndDate = this.getCurrPeriodEndDate(orgNumber, costaccountNumber);
                    if (currPeriodEndDate == null) {
                        logger.log(Integer.valueOf(billdata.getStartIndex()), String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7f16\u7801%s\uff0c\u7684\u5f53\u524d\u671f\u95f4\u672a\u7ef4\u62a4\u3002", (String)"TerminalWipMatCheckImportOp_7", (String)"macc-aca-opplugin", (Object[])new Object[0]), costaccountNumber)).fail();
                        iterator.remove();
                        continue;
                    }
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("importprop", (Object)"id");
                    jsonObject.put("id", (Object)currPeriodEndDate.getLong("currentperiod"));
                    data.put("period", (Object)jsonObject);
                    data.put("bookdate", currPeriodEndDate.get("enddate"));
                    JSONObject userJsonObject = new JSONObject();
                    userJsonObject.put("importprop", (Object)"id");
                    userJsonObject.put("id", (Object)currUserId);
                    data.put("creator", (Object)userJsonObject);
                    data.put("modifier", (Object)userJsonObject);
                    String billstatus = data.getString("billstatus");
                    if ("C".equals(billstatus)) {
                        data.put("auditor", (Object)userJsonObject);
                        data.put("auditdate", (Object)date);
                    }
                    data.put("createtime", (Object)date);
                    data.put("modifytime", (Object)date);
                    DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency AS currency", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)costaccountNumber)});
                    if (result == null) {
                        logger.log(Integer.valueOf(billdata.getStartIndex()), String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7f16\u7801%s\uff0c\u672a\u7ef4\u62a4\u672c\u4f4d\u5e01\u3002", (String)"TerminalWipMatCheckImportOp_8", (String)"macc-aca-opplugin", (Object[])new Object[0]), costaccountNumber)).fail();
                        iterator.remove();
                        continue;
                    }
                    JSONObject currencyJsonObject = new JSONObject();
                    currencyJsonObject.put("importprop", (Object)"id");
                    currencyJsonObject.put("id", (Object)result.getLong("currency"));
                    data.put("currency", (Object)currencyJsonObject);
                }
                JSONArray entryentity = data.getJSONArray("entryentity");
                for (int i = 0; i < entryentity.size(); ++i) {
                    JSONObject jsonObject = entryentity.getJSONObject(i);
                    jsonObject.put("source", (Object)TerminalWipMatEnum.SOURCE_IMPORT.getValue());
                }
            }
        }
    }

    private boolean checkOrgPermt(List<Long> permOrgIds, String number) {
        List objects = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)}, null, (int)1);
        return CadEmptyUtils.isEmpty((List)objects) || !CadEmptyUtils.isEmpty(permOrgIds) && !permOrgIds.contains((Long)objects.get(0));
    }

    private DynamicObject getCurrPeriodEndDate(String orgNumber, String costAccountNumber) {
        QFilter qfOrg = new QFilter("org.number", "=", (Object)orgNumber);
        QFilter qfCostAccount = new QFilter("entry.costaccount.number", "=", (Object)costAccountNumber);
        QFilter isInitFilter = new QFilter("entry.isenabled", "=", (Object)Character.valueOf('1'));
        return QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod as currentperiod,entry.currentperiod.enddate enddate", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, isInitFilter});
    }
}

