/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.wipcostcheck;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.common.helper.WipCostCheckHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class TerminalWipMatCheckQtyPluginValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(TerminalWipMatCheckQtyPluginValidator.class);

    public void validate() {
        HashMap matToQtyMap = null;
        HashSet acctIdSet = new HashSet();
        int j = 0;
        String checkType = "qty";
        StringBuilder matNameBuilder = new StringBuilder("\u3010");
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            HashMap matQtyMap;
            DynamicObject data = dataEntity.getDataEntity();
            String operateKey = this.validateContext.getOperateKey();
            String billstatus = data.getString("billstatus");
            if ("save".equals(operateKey) && "A".equals(billstatus)) {
                return;
            }
            Long orgId = this.getDyFileNameId(data, "org");
            if (j == 0) {
                DynamicObject checksetting = BusinessDataServiceHelper.loadSingle((String)"aca_checksetting", (String)"checktype,checkcal", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
                if (checksetting != null) {
                    checkType = checksetting.getString("checktype");
                }
                ++j;
            }
            Long costaccountId = this.getDyFileNameId(data, "costaccount");
            Long costCenterId = this.getDyFileNameId(data, "costcenter");
            DynamicObjectCollection entryentity = data.getDynamicObjectCollection("entryentity");
            if (!(matToQtyMap != null && acctIdSet.contains(costaccountId) || (matQtyMap = WipCostCheckHelper.loadWipMatCheckQtyMap((Long)orgId, (Long)0L, (Long)costaccountId, null, (String)checkType)) == null)) {
                if (matToQtyMap == null) {
                    matToQtyMap = matQtyMap;
                } else {
                    matToQtyMap.putAll(matQtyMap);
                }
            }
            checkType = "amount".equals(checkType) ? "amount" : "qty";
            HashMap<String, Tuple> checkQtyMap = new HashMap<String, Tuple>();
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(i);
                BigDecimal qty = dynamicObject.getBigDecimal(checkType);
                if (CadEmptyUtils.isEmpty((BigDecimal)qty)) continue;
                Long materialId = this.getDyFileNameId(dynamicObject, "material");
                Long matVersionId = this.getDyFileNameId(dynamicObject, "matversion");
                Long auxptyId = this.getDyFileNameId(dynamicObject, "auxpty");
                String qtyKey = costCenterId + "@" + materialId + "@" + matVersionId + "@" + auxptyId;
                Tuple tuple = (Tuple)checkQtyMap.get(qtyKey);
                if (tuple != null) {
                    qty = ((BigDecimal)tuple.item1).add(qty);
                }
                checkQtyMap.put(qtyKey, new Tuple((Object)qty, (Object)materialId));
            }
            for (Map.Entry entry : checkQtyMap.entrySet()) {
                String qtyKey = (String)entry.getKey();
                BigDecimal maxQty = null;
                if (matToQtyMap != null) {
                    maxQty = (BigDecimal)matToQtyMap.get(qtyKey);
                }
                if (CadEmptyUtils.isEmpty(maxQty)) {
                    maxQty = BigDecimal.ZERO;
                }
                if (((BigDecimal)((Tuple)entry.getValue()).item1).compareTo(maxQty) <= 0) continue;
                logger.info("\u5728\u4ea7\u54c1\u76d8\u70b9\u6570\u91cf>\u5728\u4ea7\u6570\u91cf\uff1a{},{},{}", new Object[]{qtyKey, ((Tuple)entry.getValue()).item1, matToQtyMap == null ? "null" : matToQtyMap.get(qtyKey)});
                String materialIdName = this.getMaterialIdName((Long)((Tuple)entry.getValue()).item2);
                matNameBuilder.append(materialIdName).append("\uff0c");
            }
            int length = matNameBuilder.length();
            if (length <= 1) continue;
            matNameBuilder.setLength(length - 1);
            matNameBuilder.append('\u3011');
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6750\u6599\u201c%s\u201d\u7684\u201c\u671f\u521d+\u672c\u671f\u6295\u5165\u201d\u7684\u6570\u636e\u5c0f\u4e8e\u5728\u4ea7\u6750\u6599\u76d8\u70b9\u6570\u636e\u3002", (String)"TerminalWipMatCheckQtyPluginValidator_0", (String)"macc-aca-opplugin", (Object[])new Object[0]), matNameBuilder.toString()));
            matNameBuilder.setLength(1);
        }
    }

    private String getMaterialIdName(Long materialId) {
        if (CadEmptyUtils.isEmpty((Long)materialId)) {
            return "";
        }
        DataSet rows = QueryServiceHelper.queryDataSet((String)"getMaterialIdName", (String)"bd_material", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)materialId)}, null);
        while (rows.hasNext()) {
            String name = rows.next().getString("name");
            if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
            return name;
        }
        return String.valueOf(materialId);
    }

    private Long getDyFileNameId(DynamicObject data, String fileName) {
        Object value = data.get(fileName);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).getLong("id");
        }
        return 0L;
    }
}

