/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.wipcostcheck;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.enums.TerminalWipMatEnum;
import kd.macc.aca.opplugin.wipcostcheck.TerminalWipMatCheckQtyPluginValidator;
import kd.macc.aca.opplugin.wipcostcheck.TerminalWipMatCheckSubmitPluginValidator;
import kd.macc.cad.common.helper.EntityPropertyHelper;

public class TerminalWipMatCheckSubmitPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(EntityPropertyHelper.getPropertys((String)"aca_terminalwipmatcheck"));
        fieldKeys.addAll(EntityPropertyHelper.getEntryPropertys((String)"aca_terminalwipmatcheck", (String)"entryentity"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new TerminalWipMatCheckSubmitPluginValidator());
        e.addValidator((AbstractValidator)new TerminalWipMatCheckQtyPluginValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        HashMap<Long, String> orgToCheckType = new HashMap<Long, String>();
        ArrayList<DynamicObject> allocList = new ArrayList<DynamicObject>();
        int entrySeq = 0;
        for (DynamicObject dataEntity : dataEntities) {
            long orgId = dataEntity.getLong("org.id");
            entrySeq = 0;
            DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                DynamicObject costobject = entry.getDynamicObject("costobject");
                ++entrySeq;
                if (costobject != null) {
                    entry.set("costmaterial", costobject.get("material"));
                    entry.set("costauxpty", costobject.get("auxpty"));
                    if (!"audit".equals(operationKey)) continue;
                    String checkType = (String)orgToCheckType.get(orgId);
                    if (checkType == null) {
                        DynamicObject checkTypeDy = BusinessDataServiceHelper.loadSingle((String)"aca_checksetting", (String)"checktype", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
                        checkType = checkTypeDy == null ? TerminalWipMatEnum.CHECKTYPE_QTY.getValue() : checkTypeDy.getString("checktype");
                        orgToCheckType.put(orgId, checkType);
                    }
                    entry.set("allocstatus", (Object)"1");
                    DynamicObject allocDy = BusinessDataServiceHelper.newDynamicObject((String)"aca_terminalwipmatallco");
                    allocDy.set("entryid", entry.getPkValue());
                    allocDy.set("srcbillnumber", dataEntity.get("billno"));
                    allocDy.set("srcbillrow", (Object)entrySeq);
                    allocDy.set("org", dataEntity.get("org"));
                    allocDy.set("costaccount", dataEntity.get("costaccount"));
                    allocDy.set("period", dataEntity.get("period"));
                    allocDy.set("costcenter", dataEntity.get("costcenter"));
                    allocDy.set("currency", dataEntity.get("currency"));
                    this.setSavDataValue(allocDy, entry, checkType);
                    allocList.add(allocDy);
                    continue;
                }
                entry.set("costmaterial", null);
                entry.set("costauxpty", null);
            }
        }
        if (allocList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])allocList.toArray(new DynamicObject[0]));
        }
    }

    private void setSavDataValue(DynamicObject saveData, DynamicObject row, String checkType) {
        saveData.set("material", row.get("material"));
        saveData.set("matversion", row.get("matversion"));
        saveData.set("auxpty", row.get("auxpty"));
        saveData.set("costobject", row.get("costobject"));
        saveData.set("source", row.get("source"));
        saveData.set("qty", row.get("qty"));
        saveData.set("amount", row.get("amount"));
        saveData.set("unit", row.get("unit"));
        saveData.set("modifytime", (Object)new Date());
        saveData.set("modifier", (Object)RequestContext.get().getCurrUserId());
        String fileName = TerminalWipMatEnum.CHECKTYPE_AMOUNT.getValue().equals(checkType) ? "amount" : "qty";
        saveData.set("calqty", row.get(fileName));
        saveData.set("checktype", (Object)checkType);
    }
}

