/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.opplugin.wipcostcheck;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.enums.TerminalWipMatEnum;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class TerminalWipMatCheckSubmitPluginValidator
extends AbstractValidator {
    public void validate() {
        HashMap<String, HashMap<String, Integer>> keyHashMap = new HashMap<String, HashMap<String, Integer>>();
        StringBuilder keyBuilder = new StringBuilder();
        HashMap<Long, String> fileNameByOrg = new HashMap<Long, String>();
        String operateKey = this.getOperateKey();
        String operateName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"TerminalWipMatCheckSubmitPluginValidator_0", (String)"macc-aca-opplugin", (Object[])new Object[0]);
        if ("submit".equals(operateKey)) {
            operateName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"TerminalWipMatCheckSubmitPluginValidator_1", (String)"macc-aca-opplugin", (Object[])new Object[0]);
        } else if ("audit".equals(operateKey)) {
            operateName = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"TerminalWipMatCheckSubmitPluginValidator_2", (String)"macc-aca-opplugin", (Object[])new Object[0]);
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject costcenter;
            keyBuilder.setLength(0);
            DynamicObject data = dataEntity.getDataEntity();
            Long orgId = data.getLong("org.id");
            if (CadEmptyUtils.isEmpty((Long)orgId)) continue;
            String checkFileName = (String)fileNameByOrg.get(orgId);
            if (StringUtils.isEmpty((Object)checkFileName)) {
                checkFileName = this.getCheckFileName(orgId);
                fileNameByOrg.put(orgId, checkFileName);
            }
            if ((costcenter = data.getDynamicObject("costcenter")) == null) continue;
            Long accountorgId = costcenter.getLong("accountorg.id");
            if (orgId.compareTo(accountorgId) != 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5931\u8d25\uff1a\u8be5\u6210\u672c\u4e2d\u5fc3\u4e0e\u6838\u7b97\u7ec4\u7ec7\u95f4\u7684\u5bf9\u5e94\u5173\u7cfb\u4e0d\u6b63\u786e\u3002", (String)"TerminalWipMatCheckSubmitPluginValidator_3", (String)"macc-aca-opplugin", (Object[])new Object[0]), operateName));
                continue;
            }
            keyBuilder.append(costcenter.getLong("id")).append("@");
            DynamicObject costaccount = data.getDynamicObject("costaccount");
            if (costaccount == null) continue;
            keyBuilder.append(costaccount.getLong("id")).append("@");
            DynamicObject period = data.getDynamicObject("period");
            if (period == null) continue;
            keyBuilder.append(period.getLong("id")).append("@");
            String key = keyBuilder.append(orgId).toString();
            HashSet<Long> costObjectIds = new HashSet<Long>();
            DynamicObjectCollection entryentity = data.getDynamicObjectCollection("entryentity");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryentity)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff1a\u76d8\u70b9\u4fe1\u606f\u4e3a\u7a7a\u8bf7\u68c0\u67e5\u3002", (String)"TerminalWipMatCheckSubmitPluginValidator_4", (String)"macc-aca-opplugin", (Object[])new Object[0]), operateName));
                continue;
            }
            for (int i = 0; i < entryentity.size(); ++i) {
                String tips;
                DynamicObject entry = (DynamicObject)entryentity.get(i);
                BigDecimal qtyOrAmount = entry.getBigDecimal(checkFileName);
                if (CadEmptyUtils.isEmpty((BigDecimal)qtyOrAmount)) {
                    tips = "amount".equals(checkFileName) ? ResManager.loadKDString((String)"\u91d1\u989d\uff0c\u91d1\u989d", (String)"TerminalWipMatCheckSubmitPluginValidator_5", (String)"macc-aca-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6570\u91cf\uff0c\u6570\u91cf", (String)"TerminalWipMatCheckSubmitPluginValidator_6", (String)"macc-aca-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff0c\u76d8\u70b9\u65b9\u5f0f\u4e3a%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TerminalWipMatCheckSubmitPluginValidator_15", (String)"macc-aca-opplugin", (Object[])new Object[0]), operateName, tips));
                    continue;
                }
                tips = this.checkMustMatVersionAndAuxpty(entry, i, data.getString("billno"), operateName);
                if (!CadEmptyUtils.isEmpty((String)tips)) {
                    this.addErrorMessage(dataEntity, tips);
                    continue;
                }
                DynamicObject costobject = entry.getDynamicObject("costobject");
                if (costobject != null) {
                    Long costcenterId;
                    Long accountorgId2 = costobject.getLong("org.id");
                    if (orgId.compareTo(accountorgId2) != 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5931\u8d25\uff1a\u8be5\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e0e\u6838\u7b97\u7ec4\u7ec7\u95f4\u7684\u5bf9\u5e94\u5173\u7cfb\u4e0d\u6b63\u786e\u3002", (String)"TerminalWipMatCheckSubmitPluginValidator_8", (String)"macc-aca-opplugin", (Object[])new Object[0]), operateName));
                        continue;
                    }
                    if (costcenter != null && Long.compare(costcenterId = Long.valueOf(costobject.getLong("costcenter.id")), costcenter.getLong("id")) != 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff1a\u8be5\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e0e\u6210\u672c\u4e2d\u5fc3\u7684\u5bf9\u5e94\u5173\u7cfb\u4e0d\u6b63\u786e\u3002", (String)"TerminalWipMatCheckSubmitPluginValidator_9", (String)"macc-aca-opplugin", (Object[])new Object[0]), operateName));
                        continue;
                    }
                }
                keyBuilder.setLength(0);
                keyBuilder.append(entry.getLong("material.id")).append("@").append(entry.getLong("matversion.id")).append("@").append(entry.getLong("auxpty.id")).append("@").append(entry.getLong("costobject.id"));
                costObjectIds.add(entry.getLong("costobject.id"));
                String keyValue = keyBuilder.toString();
                HashMap<String, Integer> entryMap = (HashMap<String, Integer>)keyHashMap.get(key);
                if (entryMap == null) {
                    entryMap = new HashMap<String, Integer>();
                }
                entryMap.put(keyValue, i + 1);
                keyHashMap.put(key, entryMap);
            }
            QFilter orgQf = new QFilter("org", "=", (Object)orgId);
            QFilter idQf = new QFilter("id", "!=", data.getPkValue());
            QFilter costaccountQf = new QFilter("costaccount", "=", (Object)costaccount.getLong("id"));
            QFilter costcenterQf = new QFilter("costcenter", "=", (Object)costcenter.getLong("id"));
            QFilter bookdateQf = new QFilter("period", "=", (Object)data.getLong("period.id"));
            QFilter costobjectQf = new QFilter("entryentity.costobject", "in", costObjectIds);
            QFilter billstatusQf = new QFilter("billstatus", "!=", (Object)"A");
            DataSet rows = QueryServiceHelper.queryDataSet((String)"", (String)"aca_terminalwipmatcheck", (String)"entryentity.material as material,entryentity.matversion as matversion,entryentity.auxpty as auxpty, entryentity.costobject as costobject", (QFilter[])new QFilter[]{idQf, orgQf, costcenterQf, costaccountQf, bookdateQf, costobjectQf, billstatusQf}, null);
            Map entryMap = (Map)keyHashMap.get(key);
            while (rows.hasNext()) {
                keyBuilder.setLength(0);
                Row row = rows.next();
                keyBuilder.append(row.getLong("material")).append("@").append(row.getLong("matversion")).append("@").append(row.getLong("auxpty")).append("@").append(row.getLong("costobject"));
            }
        }
    }

    private String getCheckFileName(Long orgId) {
        DynamicObject loadData = BusinessDataServiceHelper.loadSingle((String)"aca_checksetting", (String)"checktype", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        String fileName = "qty";
        if (!CadEmptyUtils.isEmpty((DynamicObject)loadData)) {
            String checktype = loadData.getString("checktype");
            fileName = TerminalWipMatEnum.CHECKTYPE_AMOUNT.getValue().equals(checktype) ? "amount" : "qty";
        }
        return fileName;
    }

    private String checkMustMatVersionAndAuxpty(DynamicObject entry, int i, String billno, String operateName) {
        DynamicObject materialData = entry.getDynamicObject("material");
        if (materialData == null) {
            return String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff0c\u7f16\u53f7\u4e3a %2$s \u7684\u6570\u636e\uff0c\u7b2c %3$s \u884c\uff0c \u8bf7\u586b\u5199\u6750\u6599\u7f16\u53f7\u3002", (String)"TerminalWipMatCheckSubmitPluginValidator_18", (String)"macc-aca-opplugin", (Object[])new Object[0]), operateName, billno, i + 1);
        }
        return null;
    }
}

