/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox;

import java.io.Serializable;
import java.util.Date;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.algox.calc.helper.TaskServiceHelper;

public class BizLogger
implements Serializable {
    private static final Log logger = LogFactory.getLog(BizLogger.class);
    private long startTime = System.currentTimeMillis();
    private long methodStartTime = System.currentTimeMillis();
    private long taskId = 0L;
    private Long costTypeId = 0L;

    public Long getCostTypeId() {
        return this.costTypeId;
    }

    public void setCostTypeId(Long costTypeId) {
        this.costTypeId = costTypeId;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public void writeDebug(String catalog, String desc) {
        this.write(9, catalog, desc);
    }

    public void writeInfo(String catalog, String desc) {
        this.write(3, catalog, desc);
    }

    public void writeInfoNew(String catalog, String desc, long startTime, long endTime) {
        this.writeNew(3, catalog, desc, startTime, endTime);
    }

    public void writeError(String catalog, Exception exp) {
        StringBuilder sb = new StringBuilder();
        if (exp instanceof KDBizException) {
            this.write(2, catalog, exp.getMessage());
            return;
        }
        sb.append(exp);
        int count = 0;
        for (StackTraceElement stackTraceElement : exp.getStackTrace()) {
            sb.append("\n").append(stackTraceElement.toString());
            if (++count > 30) break;
        }
        this.write(2, catalog, sb.toString());
    }

    private void writeNew(int errorType, String catalog, String desc, long startTime, long endTime) {
        long duration = endTime - startTime;
        this.write2db(errorType, startTime, duration, catalog, desc);
    }

    private void write(int errorType, String catalog, String desc) {
        long startTime = this.methodStartTime;
        this.methodStartTime = System.currentTimeMillis();
        long duration = System.currentTimeMillis() - startTime;
        this.write2db(errorType, startTime, duration, catalog, desc);
    }

    private void write2db(int errorType, long startTime, long duration, String catalog, String desc) {
        if (errorType != 9) {
            try {
                TaskServiceHelper.addTaskDetail(this.getCostTypeId(), this.getTaskId(), new Date(startTime), duration, errorType, catalog, desc);
            }
            catch (Exception exp) {
                logger.error("\u5199\u5165\u65e5\u5fd7\u9519\u8bef", (Throwable)exp);
            }
        }
        if (errorType == 2) {
            logger.error(String.format("%s\u8017\u65f6%sms:%s", catalog, duration, desc));
        } else {
            logger.info(String.format("%s\u8017\u65f6%sms:%s", catalog, duration, desc));
        }
    }

    public void finish(String catalog, String desc) {
        long duration = this.getTotalTime();
        TaskServiceHelper.addTaskDetail(this.getCostTypeId(), this.getTaskId(), new Date(this.startTime), duration, 3, catalog, desc);
        logger.error(String.format("%s\u8017\u65f6%sms:%s", catalog, duration, desc));
    }

    public long getTotalTime() {
        return System.currentTimeMillis() - this.startTime;
    }
}

