/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.Data;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.algox.Data.BOMExpandNode;
import kd.macc.cad.algox.Data.Material;
import kd.macc.cad.algox.calc.helper.AnalysisBOMStructHelper;
import kd.macc.cad.algox.calc.helper.BomRuleSettingStdCalcHelper;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.calc.pojo.ConfigBomInfo;
import kd.macc.cad.algox.calc.pojo.CostBOMDyo;
import kd.macc.cad.algox.function.BOMExpand;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CostTypeHelper;

public class BOMExpandDataSet
implements Serializable {
    private static final long serialVersionUID = -3323564916960422821L;
    private static final Log logger = LogFactory.getLog(BOMExpandDataSet.class);
    private List<BOMExpandNode> nodeList = new ArrayList<BOMExpandNode>();
    private Map<String, Material> bomMaterialMap = new HashMap<String, Material>();
    private List<Material> calculateMaterials = new ArrayList<Material>(10);
    private Map<String, List<CostBOMDyo>> costBomDyoForVirtualMatMap = new HashMap<String, List<CostBOMDyo>>(16);
    private StandCostCalcParam calcParam = null;
    private Map<Long, Set<Long>> partBomInTrees = new HashMap<Long, Set<Long>>();
    private Map<Long, BOMExpandNode> bomIdAndNodeMap = new HashMap<Long, BOMExpandNode>(16);
    private Map<Long, List<BOMExpandNode>> parentBomIdAndNodeMap = new HashMap<Long, List<BOMExpandNode>>(16);
    private Map<String, List<BOMExpandNode>> matKeycolAndNodeMap = new HashMap<String, List<BOMExpandNode>>(16);
    private Set<Long> alreadyExpandedNodeIds = Sets.newHashSet();
    private Set<Long> alreadyExpandedMatIds = Sets.newHashSet();
    private List<CostBOMDyo> costBOMDyoList = new ArrayList<CostBOMDyo>(10);
    private List<BOMExpandNode> roots = new ArrayList<BOMExpandNode>();
    private List<String> coByProductWithBom = new ArrayList<String>(10);

    public Map<Long, Set<Long>> getPartBomInTrees() {
        return this.partBomInTrees;
    }

    public void setPartBomInTrees(Map<Long, Set<Long>> partBomInTrees) {
        this.partBomInTrees = partBomInTrees;
    }

    public StandCostCalcParam getCalcParam() {
        return this.calcParam;
    }

    public void setCalcParam(StandCostCalcParam calcParam) {
        this.calcParam = calcParam;
    }

    public void addNode(BOMExpandNode node, boolean isExpandBom) {
        this.nodeList.add(node);
        if (isExpandBom) {
            this.getAlreadyExpandedNodeIds().add(node.getNodeId());
            this.getAlreadyExpandedMatIds().add(node.getMaterial().getMaterialId());
        }
    }

    public boolean contained(BOMExpandNode node) {
        return this.alreadyExpandedNodeIds.contains(node.getNodeId());
    }

    public boolean bomContainsMaterial(long materialId) {
        return this.alreadyExpandedMatIds.contains(materialId);
    }

    public Material addOrUpdateMaterialObject(Material material) {
        Material existedMaterial = this.bomMaterialMap.get(material.toString());
        if (existedMaterial == null) {
            this.bomMaterialMap.put(material.toString(), material);
            existedMaterial = material;
        }
        return existedMaterial;
    }

    public void prepareBomDataForStruct(StandCostCalcParam standCostCalcParam) {
        this.analysisBOMStruct(standCostCalcParam, Boolean.FALSE);
        this.buildNodeList();
        this.mergeSameMaterialUnderSameBomForStruct();
        this.updateSubItemRelateBOM();
        if (standCostCalcParam.isDebug()) {
            this.writeDebugLog();
        }
    }

    private Map<Long, Long> getBomIdByBomsetting(Long costTypeId) {
        QFilter filter = new QFilter("costtype.id", "=", (Object)costTypeId);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        QFilter calcFilter = new QFilter("matcalcprop", "!=", (Object)"B");
        DataSet bomSettings = QueryServiceHelper.queryDataSet((String)"getBomIdByBomsetting", (String)"cad_bomsetting", (String)"id,bom", (QFilter[])new QFilter[]{filter, calcFilter}, null);
        HashMap<Long, Long> bomSettingIdMap = new HashMap<Long, Long>(16);
        while (bomSettings.hasNext()) {
            Row row = bomSettings.next();
            Long bom = row.getLong("bom");
            if (CadEmptyUtils.isEmpty(bom)) continue;
            bomSettingIdMap.put(row.getLong("id"), bom);
        }
        return bomSettingIdMap;
    }

    private Set<String> getCalcKeycolsByBomSetting(List<String> keycols, List<Long> bomIds, int scopeType, Boolean isCalcCurLevel) {
        HashSet<String> calcKeycols = new HashSet<String>(100);
        if (scopeType == 0) {
            return calcKeycols;
        }
        HashSet<String> upLevelMatIds = new HashSet<String>(keycols);
        if (!isCalcCurLevel.booleanValue()) {
            this.getMostHightLevelMaterialBySpeciMat(upLevelMatIds, new HashSet<String>(upLevelMatIds), bomIds, 0);
            this.getCalcKeyCols(upLevelMatIds, calcKeycols, bomIds, 0);
            keycols.addAll(calcKeycols);
        } else {
            this.getCalcKeyCols(new HashSet<String>(keycols), calcKeycols, bomIds, 0);
        }
        return calcKeycols;
    }

    private Set<String> getByCoCalcKeycols(List<Long> bomIds, Set<String> calcKeycols, int scopeType) {
        QFilter bomFilter = new QFilter("id", "in", bomIds);
        bomFilter.and(new QFilter("iscoproduct", "=", (Object)"1"));
        if (scopeType == 1) {
            bomFilter.and(new QFilter("keycol", "in", calcKeycols));
        }
        DataSet bomDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.algox.function.bomexpand.bom", (String)"cad_costbom", (String)"copentry.copentrykeycol copentrykeycol", (QFilter[])new QFilter[]{bomFilter}, null);
        HashSet<String> byCoCalcKeycols = new HashSet<String>(10);
        while (bomDataSet.hasNext()) {
            Row row = bomDataSet.next();
            String copentryKeycol = row.getString("copentrykeycol");
            if (CadEmptyUtils.isEmpty(copentryKeycol)) continue;
            byCoCalcKeycols.add(copentryKeycol);
        }
        return byCoCalcKeycols;
    }

    public void prepareBOMData(StandCostCalcParam standCostCalcParam) {
        if (!standCostCalcParam.isTrackCalc().booleanValue() && !standCostCalcParam.isDefaultConfigCalc().booleanValue()) {
            if (standCostCalcParam.isStartBomRuleCalc().booleanValue()) {
                Map<Object, Object> matBomIdMap = new HashMap(16);
                DynamicObject bomRuleSettingObj = StdCalculateHelper.getBomRuleSettingObj(standCostCalcParam.getBomRuleSetting());
                logger.info("\u5377\u7b97-BOM\u5c55\u5f00\uff1a\u83b7\u53d6BOM\u89c4\u5219\u8bbe\u7f6eid\uff1a{}", (Object)(bomRuleSettingObj == null ? 0L : bomRuleSettingObj.getLong("id")));
                if (bomRuleSettingObj == null) {
                    return;
                }
                String srcBomEntity = bomRuleSettingObj.getString("srcbom");
                Set<Long> productOrgs = standCostCalcParam.getProductOrgs();
                logger.info("\u5377\u7b97-BOM\u5c55\u5f00\uff1a\u6839\u636e\u6838\u7b97\u6210\u672c\u7c7b\u578b\u5bf9\u5e94\u7684\u6838\u7b97\u7ec4\u7ec7\u627e\u5230\u7684\u5176\u59d4\u6258\u7684\u751f\u4ea7\u7ec4\u7ec7\uff1a{}", productOrgs);
                String bomPrio = bomRuleSettingObj.getString("bomprioritisation");
                if ("1".equals(bomPrio)) {
                    Map<String, Long> matProduceVersionBomIdMap = BomRuleSettingStdCalcHelper.getMatProduceVerBomIdMap(bomRuleSettingObj, productOrgs, standCostCalcParam.getCalcDate(), null);
                    matBomIdMap = BomRuleSettingStdCalcHelper.getMatBomIdMap(srcBomEntity, bomRuleSettingObj, productOrgs, matProduceVersionBomIdMap);
                } else if ("2".equals(bomPrio)) {
                    Map<String, Long> proMatBomIdMap = BomRuleSettingStdCalcHelper.getMatBomIdMap(srcBomEntity, bomRuleSettingObj, productOrgs, null);
                    matBomIdMap = BomRuleSettingStdCalcHelper.getMatProduceVerBomIdMap(bomRuleSettingObj, productOrgs, standCostCalcParam.getCalcDate(), proMatBomIdMap);
                } else {
                    matBomIdMap = "3".equals(bomPrio) ? BomRuleSettingStdCalcHelper.getMatProduceVerBomIdMap(bomRuleSettingObj, productOrgs, standCostCalcParam.getCalcDate(), null) : BomRuleSettingStdCalcHelper.getMatBomIdMap(srcBomEntity, bomRuleSettingObj, productOrgs, null);
                }
                logger.info("\u5377\u7b97-BOM\u5c55\u5f00\uff1a\u6839\u636eBOM\u89c4\u5219\u8bbe\u7f6e\u83b7\u53d6\u7b26\u5408\u6761\u4ef6\u7684BOM\u4e2a\u6570\uff1a{}", (Object)matBomIdMap.size());
                if (CadEmptyUtils.isEmpty(matBomIdMap)) {
                    return;
                }
                if (!CadEmptyUtils.isEmpty(standCostCalcParam.getKeycols())) {
                    matBomIdMap = BomRuleSettingStdCalcHelper.getMatBomIdMap(srcBomEntity, matBomIdMap, standCostCalcParam);
                }
                logger.info("\u5377\u7b97-BOM\u5c55\u5f00\uff1a\u53c2\u4e0e\u8ba1\u7b97\u7684BOMid\uff1a{}", matBomIdMap.values());
                HashSet<Long> materialIds = new HashSet<Long>(200);
                HashSet<Long> bomIds = new HashSet<Long>(200);
                for (Map.Entry<Object, Object> entry : matBomIdMap.entrySet()) {
                    String key = (String)entry.getKey();
                    String[] split = key.split("@");
                    materialIds.add(Long.parseLong(split[0]));
                    bomIds.add((Long)entry.getValue());
                }
                standCostCalcParam.setBomIdSet(bomIds);
                materialIds.addAll(this.getBomItemMaterials(srcBomEntity, standCostCalcParam.getBomIdSet()));
                DataSet matInfoDataSet = BomRuleSettingStdCalcHelper.getMatInfo(materialIds);
                DataSet matProduceInfoDataSet = BomRuleSettingStdCalcHelper.getMatProduceInfo(productOrgs, materialIds);
                boolean isJumpLevel = bomRuleSettingObj.getBoolean("isjumplevel");
                if (isJumpLevel) {
                    this.queryCalcVirtualMaterialInfoNew(srcBomEntity, matBomIdMap, standCostCalcParam);
                    this.structBomVirtualItems(srcBomEntity, matBomIdMap, matInfoDataSet.copy(), matProduceInfoDataSet.copy(), bomRuleSettingObj, standCostCalcParam);
                }
                this.structBom(srcBomEntity, matBomIdMap, matInfoDataSet.copy(), matProduceInfoDataSet.copy());
                this.structBomItems(srcBomEntity, matBomIdMap, bomRuleSettingObj, standCostCalcParam, matInfoDataSet, matProduceInfoDataSet);
                this.structCoByProduct(srcBomEntity, matBomIdMap, bomRuleSettingObj, standCostCalcParam);
            } else {
                Map<Long, Long> bomSettingIdMap = this.getBomIdByBomsetting(standCostCalcParam.getCostTypeId());
                ArrayList<Long> bomIds = new ArrayList<Long>(bomSettingIdMap.values());
                Set<String> calcKeycols = this.getCalcKeycolsByBomSetting(standCostCalcParam.getKeycols(), bomIds, standCostCalcParam.getScopetype(), standCostCalcParam.isCalcCurLevel());
                Set<String> byCoCalcKeycols = this.getByCoCalcKeycols(bomIds, calcKeycols, standCostCalcParam.getScopetype());
                calcKeycols.addAll(byCoCalcKeycols);
                HashMap<Long, Tuple<Boolean, Boolean>> bomInfoMap = new HashMap<Long, Tuple<Boolean, Boolean>>(16);
                this.queryBomParent(standCostCalcParam, calcKeycols, bomInfoMap, bomSettingIdMap.keySet());
                this.queryCalcVirtualMaterialInfo(standCostCalcParam, bomInfoMap.keySet());
                this.queryBomVirtualItems(standCostCalcParam, bomInfoMap, bomSettingIdMap.keySet());
                this.queryBomItems(standCostCalcParam, bomInfoMap, bomSettingIdMap.keySet());
                this.queryCoByProduct(standCostCalcParam, calcKeycols, bomInfoMap, bomSettingIdMap.keySet());
            }
        } else if (standCostCalcParam.isDefaultConfigCalc().booleanValue()) {
            this.analysisBOMStructExt(standCostCalcParam, Boolean.FALSE);
        } else {
            this.analysisBOMStruct(standCostCalcParam, Boolean.FALSE);
        }
        this.buildNodeList();
        if (!standCostCalcParam.isTrackCalc().booleanValue()) {
            this.mergeSameMaterialUnderSameBom();
        } else {
            this.mergeSameMaterialUnderSameBomForStruct();
        }
        this.updateSubItemRelateBOM();
        if (standCostCalcParam.isDebug()) {
            this.writeDebugLog();
        }
    }

    private Set<Long> getBomItemMaterials(String srcEntity, Set<Long> bomIdSet) {
        QFilter filter = new QFilter("id", "in", bomIdSet);
        String matFields = "entry.entrymaterial.masterid MaterialId";
        if ("pdm_mftbom".equals(srcEntity)) {
            matFields = "entry.entrymaterial.masterid.masterid MaterialId";
        }
        DynamicObjectCollection bomDyos = QueryServiceHelper.query((String)srcEntity, (String)matFields, (QFilter[])new QFilter[]{filter});
        HashSet<Long> materialIds = new HashSet<Long>(200);
        bomDyos.forEach(p -> materialIds.add(p.getLong("MaterialId")));
        return materialIds;
    }

    public void preparePriceData(StandCostCalcParam standCostCalcParam) {
        List<Long> purPriceObjIds = StdCalculateHelper.getPurPriceObjIds(standCostCalcParam.getCostTypeId(), standCostCalcParam.getHsCostTypeId(), standCostCalcParam.getCustomSuppliedMaterials(), standCostCalcParam.getPriceRuleScheme(), standCostCalcParam.getCalcDate(), standCostCalcParam.getPurMatCostInfoMap());
        List<Long> outPriceObjIds = StdCalculateHelper.getOutPriceObjIds(standCostCalcParam.getCostTypeId(), standCostCalcParam.getHsCostTypeId(), standCostCalcParam.getCustomSuppliedMaterials(), standCostCalcParam.getPriceRuleScheme(), standCostCalcParam.getCalcDate());
        standCostCalcParam.setPruPriceObjIds(purPriceObjIds);
        standCostCalcParam.setOutPriceObjIds(outPriceObjIds);
    }

    public void prepareRouteData(StandCostCalcParam standCostCalcParam) {
        HashSet<Long> processRouteIds = new HashSet(10);
        Set<String> calcRouteMaterials = this.getCalcRouteMaterials(standCostCalcParam.getConfigBomInfoList());
        Map<Object, DynamicObject> routerIdAndRouterObjMap = new HashMap<Object, DynamicObject>(16);
        if (!standCostCalcParam.isTrackCalc().booleanValue() && !standCostCalcParam.isDefaultConfigCalc().booleanValue()) {
            if (standCostCalcParam.isStartRouteRuleCalc().booleanValue()) {
                DynamicObject routeRuleSettingObj = StdCalculateHelper.getRouteRuleSettingObj(standCostCalcParam.getRouteRuleSetting());
                if (routeRuleSettingObj == null) {
                    return;
                }
                String srcEntity = routeRuleSettingObj.getString("srcroute");
                processRouteIds = BomRuleSettingStdCalcHelper.getProcessRouteNew(routeRuleSettingObj, srcEntity, standCostCalcParam.getBomIdSet(), calcRouteMaterials, standCostCalcParam.getCostTypeId(), standCostCalcParam.getCalcDate(), standCostCalcParam.getAppNum());
                String string = routeRuleSettingObj.getString("filter_tag");
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)string, FilterCondition.class);
                ArrayList<QFilter> arrayList = new ArrayList<QFilter>(10);
                if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
                    MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)srcEntity);
                    FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
                    filterBuilder.buildFilter();
                    arrayList.add(filterBuilder.getQFilter());
                }
                routerIdAndRouterObjMap = BomRuleSettingStdCalcHelper.getRouterIdAndRouterObjMap(processRouteIds, srcEntity, standCostCalcParam.getCalcDate(), arrayList);
            } else {
                processRouteIds = BomRuleSettingStdCalcHelper.getProcessRoutes(standCostCalcParam.getCostTypeId(), calcRouteMaterials);
                ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
                filterList.add(new QFilter("entryentity.processseqtype", "in", (Object)new String[]{"A", "B"}));
                routerIdAndRouterObjMap = BomRuleSettingStdCalcHelper.getRouterIdAndRouterObjMap(processRouteIds, "cad_router", standCostCalcParam.getCalcDate(), filterList);
            }
            standCostCalcParam.setRouterIdAndRouterObjMap(routerIdAndRouterObjMap);
        } else if (!CadEmptyUtils.isEmpty(standCostCalcParam.getConfigBomKeycolRouteMap())) {
            HashSet<Long> routerIds = new HashSet<Long>(10);
            for (Map.Entry entry : standCostCalcParam.getConfigBomKeycolRouteMap().entrySet()) {
                Long value = (Long)entry.getValue();
                routerIds.add(value);
            }
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
            filterList.add(new QFilter("entryentity.processseqtype", "in", (Object)new String[]{"A", "B"}));
            routerIdAndRouterObjMap = BomRuleSettingStdCalcHelper.getRouterIdAndRouterObjMap(routerIds, "pdm_route", standCostCalcParam.getCalcDate(), filterList);
            standCostCalcParam.setRouterIdAndRouterObjMap(routerIdAndRouterObjMap);
        }
        if (CadEmptyUtils.isEmpty(routerIdAndRouterObjMap)) {
            logger.info("\u6ca1\u6709\u9700\u8981\u8ba1\u7b97\u7684\u5de5\u827a\u8def\u7ebf");
            return;
        }
        Set<Long> resourceIds = BomRuleSettingStdCalcHelper.dealRoute(routerIdAndRouterObjMap, standCostCalcParam);
        HashSet<Long> costTypes = new HashSet<Long>(10);
        Map<Long, Long> map = standCostCalcParam.getProOrgCostTypeMap();
        for (Map.Entry entry : map.entrySet()) {
            Long costType = (Long)entry.getValue();
            if (CadEmptyUtils.isEmpty(costType)) continue;
            costTypes.add(costType);
        }
        logger.info("\u5377\u7b97-\u5de5\u827a\u8def\u7ebf\u5904\u7406\uff0c\u6d89\u53ca\u7684\u6a21\u62df\u6210\u672c\u7c7b\u578b\uff1a{}", (Object)SerializationUtils.toJsonString(costTypes));
        Map mnHsCostMapByMn = CostTypeHelper.getMnHsCostMapByMn(new ArrayList(costTypes));
        ArrayList<Long> arrayList = new ArrayList<Long>(10);
        ArrayList<Long> outResourcObjIds = new ArrayList<Long>(10);
        for (Long costType : costTypes) {
            arrayList.addAll(StdCalculateHelper.getInResourcObjIds(costType, standCostCalcParam.getPriceRuleScheme(), standCostCalcParam.getCalcDate(), resourceIds, mnHsCostMapByMn));
            outResourcObjIds.addAll(StdCalculateHelper.getOutResourcObjIds(costType, standCostCalcParam.getPriceRuleScheme(), standCostCalcParam.getCalcDate(), routerIdAndRouterObjMap.keySet(), mnHsCostMapByMn));
        }
        standCostCalcParam.setMnHsCostTypeMap(mnHsCostMapByMn);
        standCostCalcParam.setInSourceObjIds(arrayList);
        standCostCalcParam.setOutSourceObjIds(outResourcObjIds);
        standCostCalcParam.setCalcRouteMaterials(calcRouteMaterials);
        logger.info("\u5377\u7b97-\u81ea\u5236\u8d44\u6e90\u8d39\u7387\u4ef7\u76ee\u8868id\uff1a{}", (Object)SerializationUtils.toJsonString(arrayList));
        logger.info("\u5377\u7b97-\u5916\u534f\u8d44\u6e90\u8d39\u7387\u4ef7\u76ee\u8868id\uff1a{}", (Object)SerializationUtils.toJsonString(outResourcObjIds));
    }

    public void prepareRouteDataForStruct(StandCostCalcParam standCostCalcParam) {
        if (CadEmptyUtils.isEmpty(standCostCalcParam.getConfigBomKeycolRouteMap())) {
            logger.info("\u6ca1\u6709\u9700\u8981\u8ba1\u7b97\u7684\u5de5\u827a\u8def\u7ebf");
            return;
        }
        HashSet<Long> routerIds = new HashSet<Long>(10);
        for (Map.Entry<String, Long> entry : standCostCalcParam.getConfigBomKeycolRouteMap().entrySet()) {
            Long value = entry.getValue();
            routerIds.add(value);
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        filterList.add(new QFilter("entryentity.processseqtype", "in", (Object)new String[]{"A", "B"}));
        Map<Object, DynamicObject> routerIdAndRouterObjMap = BomRuleSettingStdCalcHelper.getRouterIdAndRouterObjMap(routerIds, "pdm_route", standCostCalcParam.getCalcDate(), filterList);
        if (CadEmptyUtils.isEmpty(routerIdAndRouterObjMap)) {
            logger.info("\u6ca1\u6709\u9700\u8981\u8ba1\u7b97\u7684\u5de5\u827a\u8def\u7ebf");
            return;
        }
        Set<Long> resourceIds = BomRuleSettingStdCalcHelper.dealRoute(routerIdAndRouterObjMap, standCostCalcParam);
        HashSet<Long> costTypes = new HashSet<Long>(10);
        Map<Long, Long> proOrgCostTypeMap = standCostCalcParam.getProOrgCostTypeMap();
        for (Map.Entry<Long, Long> entry : proOrgCostTypeMap.entrySet()) {
            Long costType = entry.getValue();
            if (CadEmptyUtils.isEmpty(costType)) continue;
            costTypes.add(costType);
        }
        logger.info("\u5377\u7b97-\u5de5\u827a\u8def\u7ebf\u5904\u7406\uff0c\u6d89\u53ca\u7684\u6a21\u62df\u6210\u672c\u7c7b\u578b\uff1a{}", (Object)SerializationUtils.toJsonString(costTypes));
        Map mnHsCostMapByMn = CostTypeHelper.getMnHsCostMapByMn(new ArrayList(costTypes));
        Set<String> calcRouteMaterials = this.getCalcRouteMaterials(standCostCalcParam.getConfigBomInfoList());
        ArrayList<Long> inResourcObjIds = new ArrayList<Long>(10);
        ArrayList<Long> outResourcObjIds = new ArrayList<Long>(10);
        for (Long costType : costTypes) {
            inResourcObjIds.addAll(StdCalculateHelper.getInResourcObjIds(costType, standCostCalcParam.getPriceRuleScheme(), standCostCalcParam.getCalcDate(), resourceIds, mnHsCostMapByMn));
            outResourcObjIds.addAll(StdCalculateHelper.getOutResourcObjIds(costType, standCostCalcParam.getPriceRuleScheme(), standCostCalcParam.getCalcDate(), routerIdAndRouterObjMap.keySet(), mnHsCostMapByMn));
        }
        standCostCalcParam.setMnHsCostTypeMap(mnHsCostMapByMn);
        standCostCalcParam.setRouterIdAndRouterObjMap(routerIdAndRouterObjMap);
        standCostCalcParam.setInSourceObjIds(inResourcObjIds);
        standCostCalcParam.setOutSourceObjIds(outResourcObjIds);
        standCostCalcParam.setCalcRouteMaterials(calcRouteMaterials);
        logger.info("\u5377\u7b97-\u81ea\u5236\u8d44\u6e90\u8d39\u7387\u4ef7\u76ee\u8868id\uff1a{}", (Object)SerializationUtils.toJsonString(inResourcObjIds));
        logger.info("\u5377\u7b97-\u5916\u534f\u8d44\u6e90\u8d39\u7387\u4ef7\u76ee\u8868id\uff1a{}", (Object)SerializationUtils.toJsonString(outResourcObjIds));
    }

    private Set<String> getCalcRouteMaterials(List<ConfigBomInfo> configBomInfoList) {
        HashSet<String> calcRouteMaterials = new HashSet<String>(16);
        if (CadEmptyUtils.isEmpty(configBomInfoList)) {
            return calcRouteMaterials;
        }
        for (ConfigBomInfo configBomInfo : configBomInfoList) {
            if (!configBomInfo.isProduce().booleanValue() && !configBomInfo.isOutSource().booleanValue() && (configBomInfo.getPid() != 0L || !configBomInfo.isVirtual().booleanValue())) continue;
            calcRouteMaterials.add(configBomInfo.getKeycol());
        }
        return calcRouteMaterials;
    }

    protected void analysisBOMStructExt(StandCostCalcParam calcParam, Boolean configJumpLevel) {
        Date start = TimeServiceHelper.now();
        logger.info("\u89e3\u6790\u5916\u90e8\u4f20\u5165\u7684BOM\u7ed3\u6784\u5f00\u59cb\u3002\u65f6\u95f4\uff1a" + start);
        HashSet<Long> materialIds = new HashSet<Long>(200);
        ArrayList<Long> configCodeIds = new ArrayList<Long>(10);
        Map<Long, DataSet> manuOrgConfigBomInfoDataSet = calcParam.getManuOrgConfigBomInfoDataSet();
        if (CadEmptyUtils.isEmpty(manuOrgConfigBomInfoDataSet)) {
            return;
        }
        DataSet configBomDataSet = null;
        for (Map.Entry<Long, DataSet> entry : manuOrgConfigBomInfoDataSet.entrySet()) {
            Long manuOrg = entry.getKey();
            DataSet subConfigBomDataSet = entry.getValue();
            if (subConfigBomDataSet.isEmpty()) {
                return;
            }
            DataSet copyDataSet = subConfigBomDataSet.copy();
            while (copyDataSet.hasNext()) {
                Row row = copyDataSet.next();
                Long materialId = row.getLong("MaterialId");
                if (CadEmptyUtils.isEmpty(materialId)) continue;
                materialIds.add(materialId);
            }
            DataSet configCodeInfoDataSet = this.queryConfigCodeInfo(configCodeIds);
            subConfigBomDataSet = subConfigBomDataSet.join(configCodeInfoDataSet, JoinType.LEFT).on("configuredcode", "id").select(subConfigBomDataSet.getRowMeta().getFieldNames(), new String[]{"configuredcodenumber"}).finish();
            DataSet matInfoDataSet = BomRuleSettingStdCalcHelper.getMatInfo(materialIds);
            DataSet matProduceInfoDataSet = BomRuleSettingStdCalcHelper.getMatProduceInfo(Collections.singleton(manuOrg), materialIds);
            subConfigBomDataSet = subConfigBomDataSet.join(matInfoDataSet, JoinType.LEFT).on("MaterialId", "material").select(subConfigBomDataSet.getRowMeta().getFieldNames(), new String[]{"number", "name", "enableproduct", "enableoutsource", "isuseauxpty", "isaffectprice", "isenablematerialversion"}).finish();
            subConfigBomDataSet = subConfigBomDataSet.join(matProduceInfoDataSet, JoinType.LEFT).on("MaterialId", "masterid").select(subConfigBomDataSet.getRowMeta().getFieldNames(), new String[]{"materialattr", "isoutsource"}).finish();
            configBomDataSet = configBomDataSet == null ? subConfigBomDataSet : configBomDataSet.union(subConfigBomDataSet);
            materialIds.clear();
            configCodeIds.clear();
        }
        if (configBomDataSet == null) {
            return;
        }
        if (configJumpLevel.booleanValue()) {
            DataSet jumpLevelDataSet = configBomDataSet.copy().filter("pid>0 and materialattr=='10020'");
            this.queryCalcVirtualMaterialInfoForStruct(calcParam, jumpLevelDataSet.copy());
            this.structVirtualMatDataSet(calcParam, configBomDataSet.copy());
        }
        DataSet mainMatDataSet = configBomDataSet.copy().filter("pid == 0 or materialattr!='10040'");
        this.structMainMatDataSet(mainMatDataSet);
        DataSet subMatDataSet = configBomDataSet.copy().filter("pid > 0");
        this.structSubMatDataSet(subMatDataSet);
        calcParam.getManuOrgConfigBomInfoDataSet().clear();
        Date end = TimeServiceHelper.now();
        logger.info("\u89e3\u6790\u5916\u90e8\u4f20\u5165\u7684BOM\u7ed3\u6784\u7ed3\u675f\u3002\u65f6\u95f4\uff1a" + end + "\uff1b\u8017\u65f6" + (start.getTime() - end.getTime()));
    }

    protected void analysisBOMStruct(StandCostCalcParam calcParam, Boolean configJumpLevel) {
        Date start = TimeServiceHelper.now();
        logger.info("\u89e3\u6790\u5916\u90e8\u4f20\u5165\u7684BOM\u7ed3\u6784\u5f00\u59cb\u3002\u65f6\u95f4\uff1a" + start);
        HashSet<Long> materialIds = new HashSet<Long>(200);
        HashSet<Long> productOrgs = new HashSet<Long>(10);
        ArrayList<Long> configCodeIds = new ArrayList<Long>(10);
        Map<Long, List<String>> manuOrgConfigBomInfoJsStrList = calcParam.getManuOrgConfigBomInfoJsStrList();
        if (CadEmptyUtils.isEmpty(manuOrgConfigBomInfoJsStrList)) {
            return;
        }
        DataSet configBomDataSet = null;
        for (Map.Entry<Long, List<String>> entry : manuOrgConfigBomInfoJsStrList.entrySet()) {
            Long manuOrg = entry.getKey();
            List<String> configBomInfoJsStrList = entry.getValue();
            for (String configBomInfoJsStr : configBomInfoJsStrList) {
                List<Object[]> objects = AnalysisBOMStructHelper.analysisBOMResult(calcParam, configBomInfoJsStr, materialIds, productOrgs, configCodeIds);
                DataSet subConfigBomDataSet = AnalysisBOMStructHelper.creatConfigBomDataSet(objects);
                DataSet configCodeInfoDataSet = this.queryConfigCodeInfo(configCodeIds);
                subConfigBomDataSet = subConfigBomDataSet.join(configCodeInfoDataSet, JoinType.LEFT).on("configuredcode", "id").select(subConfigBomDataSet.getRowMeta().getFieldNames(), new String[]{"configuredcodenumber"}).finish();
                DataSet matInfoDataSet = BomRuleSettingStdCalcHelper.getMatInfo(materialIds);
                DataSet matProduceInfoDataSet = BomRuleSettingStdCalcHelper.getMatProduceInfo(Collections.singleton(manuOrg), materialIds);
                subConfigBomDataSet = subConfigBomDataSet.join(matInfoDataSet, JoinType.LEFT).on("MaterialId", "material").select(subConfigBomDataSet.getRowMeta().getFieldNames(), new String[]{"number", "name", "enableproduct", "enableoutsource", "isuseauxpty", "isaffectprice", "isenablematerialversion"}).finish();
                subConfigBomDataSet = subConfigBomDataSet.join(matProduceInfoDataSet, JoinType.LEFT).on("MaterialId", "masterid").select(subConfigBomDataSet.getRowMeta().getFieldNames(), new String[]{"materialattr", "isoutsource"}).finish();
                configBomDataSet = configBomDataSet == null ? subConfigBomDataSet : configBomDataSet.union(subConfigBomDataSet);
                materialIds.clear();
                productOrgs.clear();
                configCodeIds.clear();
            }
        }
        if (configBomDataSet == null) {
            return;
        }
        if (configJumpLevel.booleanValue()) {
            DataSet jumpLevelDataSet = configBomDataSet.copy().filter("pid>0 and materialattr=='10020'");
            this.queryCalcVirtualMaterialInfoForStruct(calcParam, jumpLevelDataSet.copy());
            this.structVirtualMatDataSet(calcParam, configBomDataSet.copy());
        }
        DataSet mainMatDataSet = configBomDataSet.copy().filter("pid == 0 or materialattr!='10040'");
        this.structMainMatDataSet(mainMatDataSet);
        DataSet subMatDataSet = configBomDataSet.copy().filter("pid > 0");
        this.structSubMatDataSet(subMatDataSet);
        calcParam.getManuOrgConfigBomInfoJsStrList().clear();
        Date end = TimeServiceHelper.now();
        logger.info("\u89e3\u6790\u5916\u90e8\u4f20\u5165\u7684BOM\u7ed3\u6784\u7ed3\u675f\u3002\u65f6\u95f4\uff1a" + end + "\uff1b\u8017\u65f6" + (start.getTime() - end.getTime()));
    }

    private DataSet queryConfigCodeInfo(List<Long> configCodeIds) {
        QFilter filter = new QFilter("id", "in", configCodeIds);
        return QueryServiceHelper.queryDataSet((String)"queryConfigCodeInfo", (String)"bd_configuredcode", (String)"id,number configuredcodenumber", (QFilter[])new QFilter[]{filter}, null);
    }

    private void transferConfigBomInfo(StandCostCalcParam calcParam, Row row) {
        String materialAttr;
        if (row == null) {
            return;
        }
        ConfigBomInfo configBomInfo = new ConfigBomInfo();
        configBomInfo.setId(row.getLong("id"));
        configBomInfo.setPid(row.getLong("pid"));
        configBomInfo.setMaterial(row.getLong("MaterialId"));
        configBomInfo.setMatNumber(row.getString("number"));
        configBomInfo.setMatName(row.getString("name"));
        configBomInfo.setVersion(row.getLong("MaterialVer"));
        configBomInfo.setAuxpty(row.getLong("AuxPropId"));
        configBomInfo.setConfiguredCode(row.getLong("configuredcode"));
        configBomInfo.setConfiguredCodeNumber(row.getString("configuredcodenumber"));
        Boolean isUseAuxpty = row.getBoolean("isuseauxpty");
        if (isUseAuxpty != null) {
            configBomInfo.setUseAuxpty(isUseAuxpty);
        }
        configBomInfo.setAffectPrice(true);
        configBomInfo.setEnableMaterialVersion(row.getBoolean("isenablematerialversion"));
        if (calcParam.isTrackCalc().booleanValue() || calcParam.isDefaultConfigCalc().booleanValue()) {
            calcParam.getBomPidsForTrackCalc().add(configBomInfo.getPid());
        }
        if ("10030".equals(materialAttr = row.getString("materialattr")) || "A".equals(materialAttr)) {
            configBomInfo.setProduce(Boolean.TRUE);
            if (calcParam.isTrackCalc().booleanValue() || calcParam.isDefaultConfigCalc().booleanValue()) {
                configBomInfo.setPid(0L);
            }
        } else if ("10040".equals(materialAttr) || "B".equals(materialAttr)) {
            configBomInfo.setPurPrice(Boolean.TRUE);
        } else if ("10050".equals(materialAttr) || "C".equals(materialAttr)) {
            configBomInfo.setOutSource(Boolean.TRUE);
            if (calcParam.isTrackCalc().booleanValue() || calcParam.isDefaultConfigCalc().booleanValue()) {
                configBomInfo.setPid(0L);
            }
        } else if ("10020".equals(materialAttr)) {
            configBomInfo.setVirtual(Boolean.TRUE);
            if (calcParam.isTrackCalc().booleanValue() || calcParam.isDefaultConfigCalc().booleanValue()) {
                configBomInfo.setPid(0L);
            }
        } else {
            configBomInfo.setPurPrice(Boolean.TRUE);
        }
        HashMap<String, Long> values = new HashMap<String, Long>(5);
        values.put("material", configBomInfo.getMaterial());
        values.put("auxproperty", configBomInfo.getAuxpty());
        if (isUseAuxpty != null && isUseAuxpty.booleanValue()) {
            values.put("auxproperty", configBomInfo.getAuxpty());
        }
        values.put("configuredcode", configBomInfo.getConfiguredCode());
        Keycol calcKey = CalcKeyHelper.getCalcKey(values, new ArrayList(), (boolean)false);
        configBomInfo.setKeycol(calcKey.getKeycol());
        calcParam.getConfigBomInfoList().add(configBomInfo);
    }

    private void structVirtualMatDataSet(StandCostCalcParam calcParam, DataSet dataSet) {
        long calcDate = this.getCalcParam().getCalcDate().getTime();
        while (dataSet.hasNext()) {
            boolean isValid;
            Row row = dataSet.next();
            Long pid = row.getLong("pid");
            if (CadEmptyUtils.isEmpty(pid) || !calcParam.getVirtualMaterials().contains(String.valueOf(pid)) || !(isValid = row.getDate("entryvaliddate").getTime() <= calcDate && row.getDate("entryinvaliddate").getTime() >= calcDate)) continue;
            boolean isSupplierCustomerMat = "bd_supplier".equals(row.getString("ownertype")) || "bd_customer".equals(row.getString("ownertype"));
            CostBOMDyo costBomDyo = this.createCostBomDyo(row, true, false);
            costBomDyo.setId(row.getLong("id"));
            costBomDyo.setStdQty(BigDecimal.ZERO.compareTo(row.getBigDecimal("entryqty")) == 0 ? BigDecimal.ONE : row.getBigDecimal("entryqty"));
            if (isSupplierCustomerMat) {
                calcParam.getCustomSuppliedMaterials().add(costBomDyo.getKeycol());
            }
            if (!calcParam.getKeycols().contains(costBomDyo.getKeycol())) {
                calcParam.getKeycols().add(costBomDyo.getKeycol());
            }
            this.costBomDyoForVirtualMatMap.computeIfAbsent(String.valueOf(pid), p -> new ArrayList()).add(costBomDyo);
        }
    }

    private String getKeyCol(CostBOMDyo costBOMDyo) {
        HashMap<String, Long> values = new HashMap<String, Long>(5);
        values.put("material", costBOMDyo.getMaterial());
        Boolean isUseAuxpty = costBOMDyo.isUseAuxpty();
        if (isUseAuxpty != null && isUseAuxpty.booleanValue()) {
            values.put("auxproperty", costBOMDyo.getMatAuxpty());
        }
        values.put("configuredcode", costBOMDyo.getConfiguredcode());
        Keycol calcKey = CalcKeyHelper.getCalcKey(values, new ArrayList(), (boolean)true);
        return calcKey.getKeycol();
    }

    private void structSubMatDataSet(DataSet subMatDataSet) {
        if (subMatDataSet == null) {
            return;
        }
        int count = 0;
        long calcDate = this.calcParam.getCalcDate().getTime();
        while (subMatDataSet.hasNext()) {
            Row row = subMatDataSet.next();
            boolean isValid = row.getDate("entryvaliddate").getTime() <= calcDate && row.getDate("entryinvaliddate").getTime() >= calcDate;
            if (!isValid) continue;
            boolean isSupplierCustomerMat = "bd_supplier".equals(row.getString("ownertype")) || "bd_customer".equals(row.getString("ownertype"));
            Long pid = row.getLong("pid");
            Long id = row.getLong("id");
            Long bomId = row.getLong("bomId");
            if (this.calcParam.getVirtualMaterials().contains(String.valueOf(id))) {
                String key = pid + "@" + id;
                BigDecimal qty = this.calcParam.getVirtualMaterialQtyMap().getOrDefault(key, BigDecimal.ZERO);
                this.createCostBomDyoForVirtualStruct(String.valueOf(id), qty, bomId, this.calcParam.getVirtualMaterials(), count);
            } else {
                CostBOMDyo costBomDyo = this.createCostBomDyo(row, true, true);
                costBomDyo.setId(0L);
                costBomDyo.setRedundBomId(id);
                costBomDyo.setParentId(bomId);
                costBomDyo.setBomSettingId(0L);
                costBomDyo.setStdQty(row.getBigDecimal("entryqty"));
                if (isSupplierCustomerMat) {
                    this.calcParam.getCustomSuppliedMaterials().add(costBomDyo.getKeycol());
                }
                if (!this.calcParam.getKeycols().contains(costBomDyo.getKeycol())) {
                    this.calcParam.getKeycols().add(costBomDyo.getKeycol());
                }
            }
            this.transferConfigBomInfo(this.calcParam, row);
            ++count;
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u8ba2\u5355BOM\u5b50\u9879\u6570\u636e%s\u4e2a", (String)"BOMExpandDataSet_13", (String)"macc-cad-algox", (Object[])new Object[0]), count));
    }

    private void structMainMatDataSet(DataSet mainMatDataSet) {
        if (mainMatDataSet == null) {
            return;
        }
        int count = 0;
        while (mainMatDataSet.hasNext()) {
            Row row = mainMatDataSet.next();
            Long bomId = row.getLong("bomId");
            if (bomId == null) {
                logger.error(String.format("\u7269\u6599Id\uff1a%s\u5bf9\u5e94\u7684\u8ba2\u5355bom\u4e0d\u5b58\u5728\u3002", row.getLong("MaterialId")));
                continue;
            }
            CostBOMDyo costBomDyo = this.createCostBomDyo(row, false, true);
            costBomDyo.setId(row.getLong("id"));
            costBomDyo.setStdQty(BigDecimal.ZERO.compareTo(row.getBigDecimal("entryqty")) == 0 ? BigDecimal.ONE : row.getBigDecimal("entryqty"));
            if (!this.calcParam.getKeycols().contains(costBomDyo.getKeycol())) {
                this.calcParam.getKeycols().add(costBomDyo.getKeycol());
            }
            this.transferConfigBomInfo(this.calcParam, row);
            ++count;
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u8ba2\u5355BOM\u7236\u9879\u6570\u636e%s\u4e2a\u3002", (String)"BOMExpandDataSet_14", (String)"macc-cad-algox", (Object[])new Object[0]), count));
    }

    private void buildNodeList() {
        if (CadEmptyUtils.isEmpty(this.costBOMDyoList)) {
            return;
        }
        this.calcParam.getVirtualMaterials().clear();
        HashMap<String, String> matDimKeycolMap = new HashMap<String, String>(16);
        for (CostBOMDyo costBOMDyo : this.costBOMDyoList) {
            BOMExpandNode node = new BOMExpandNode();
            node.setNodeId(BOMExpandNode.genNodeId());
            node.setBomId(costBOMDyo.getId());
            node.setRedundBomId(costBOMDyo.getRedundBomId());
            node.setBomSettingID(costBOMDyo.getBomSettingId());
            Material material = this.toMaterial(costBOMDyo, matDimKeycolMap);
            node.setMaterial(material);
            node.setParentBomId(costBOMDyo.getParentId());
            node.setYieldrate(costBOMDyo.getYieldRate());
            node.setUnitId(costBOMDyo.getBaseUnit());
            node.setQtytype(costBOMDyo.getQtyType());
            node.setQtynumerator(costBOMDyo.getQtyNumerator());
            node.setQtydenominator(costBOMDyo.getQtyDenominator());
            node.setFixscrap(costBOMDyo.getFixScrap());
            node.setScraprate(costBOMDyo.getScrapRate());
            node.setStdQty(costBOMDyo.getStdQty());
            this.addNode(node, false);
            if (node.getParentBomId() == 0L) {
                this.calculateMaterials.add(material);
            }
            if (!"D".equals(material.getMaterialAttr())) continue;
            this.calcParam.getVirtualMaterials().add(material.getKeycol());
        }
        this.costBOMDyoList.clear();
        matDimKeycolMap.clear();
        this.write2Log(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u8ba1\u7b97\u7269\u6599%s\u4e2a\u3002", (String)"BOMExpandDataSet_10", (String)"macc-cad-algox", (Object[])new Object[0]), this.calculateMaterials.size()));
    }

    private void queryCoByProduct(StandCostCalcParam standCostCalcParam, Set<String> calcKeycols, Map<Long, Tuple<Boolean, Boolean>> bomInfoMap, Set<Long> bomSettingIds) {
        Row row;
        QFilter filter = new QFilter("id", "in", bomSettingIds);
        if (standCostCalcParam.getScopetype() == 1) {
            filter.and(new QFilter("keycol", "in", calcKeycols));
        }
        DataSet bomSetting = QueryServiceHelper.queryDataSet((String)"queryCoByProduct1", (String)"cad_bomsetting", (String)"keycol bskeycol,auxprop,ispurprices,considervalidperiod,bom", (QFilter[])new QFilter[]{filter}, null);
        QFilter bomFilter = new QFilter("id", "in", bomInfoMap.keySet());
        bomFilter.and(new QFilter("iscoproduct", "=", (Object)"1"));
        QFilter timeFilter = new QFilter("copentry.copentryvaliddate", "<=", (Object)standCostCalcParam.getCalcDate());
        timeFilter.and(new QFilter("copentry.copentryinvaliddate", ">=", (Object)standCostCalcParam.getCalcDate()));
        DataSet bomDataSet = QueryServiceHelper.queryDataSet((String)"queryCoByProduct2", (String)"cad_costbom", (String)"id,id bomId,keycol bkeycol,configuredcode,copentry.copentrytype copentrytype,copentry.copentrykeycol copentrykeycol,copentry.copentryqty copentryqty,copentry.copentryvaliddate copentryvaliddate,copentry.copentryinvaliddate copentryinvaliddate", (QFilter[])new QFilter[]{bomFilter, timeFilter}, null);
        DataSet dataSet = bomDataSet.copy().join(bomSetting, JoinType.LEFT).on("copentrykeycol", "bskeycol").select(bomDataSet.getRowMeta().getFieldNames(), bomSetting.getRowMeta().getFieldNames()).finish();
        DataSet coByProductWithBomDataSet = dataSet.copy().filter("bskeycol is not null");
        while (coByProductWithBomDataSet.hasNext()) {
            row = coByProductWithBomDataSet.next();
            Long bomId = row.getLong("bomId");
            if (CadEmptyUtils.isEmpty(bomId)) continue;
            Tuple<Boolean, Boolean> bomInfo = bomInfoMap.get(bomId);
            if (((Boolean)bomInfo.item2).booleanValue() && "10730".equals(row.getString("copentrytype"))) {
                standCostCalcParam.getMainAndCoByProductWithPurPriceMap().computeIfAbsent(row.getString("bkeycol"), p -> new HashMap()).put(row.getString("copentrykeycol"), row.getBigDecimal("copentryqty"));
                continue;
            }
            this.coByProductWithBom.add(row.getString("copentrykeycol"));
        }
        standCostCalcParam.setCoByProductWithBom(this.coByProductWithBom);
        while (bomDataSet.hasNext()) {
            row = bomDataSet.next();
            if (!this.coByProductWithBom.contains(row.getString("copentrykeycol"))) continue;
            standCostCalcParam.getMainAndCoByProductWithBomMap().computeIfAbsent(row.getString("bkeycol"), p -> new ArrayList()).add(row.getString("copentrykeycol"));
        }
        DataSet coByProductDataSet = dataSet.filter("bskeycol is null");
        while (coByProductDataSet.hasNext()) {
            Row row2 = coByProductDataSet.next();
            Long bomId = row2.getLong("bomId");
            if (CadEmptyUtils.isEmpty(bomId)) continue;
            Tuple<Boolean, Boolean> bomInfo = bomInfoMap.get(bomId);
            if (((Boolean)bomInfo.item2).booleanValue() && "10730".equals(row2.getString("copentrytype"))) {
                standCostCalcParam.getMainAndCoByProductWithPurPriceMap().computeIfAbsent(row2.getString("bkeycol"), p -> new HashMap()).put(row2.getString("copentrykeycol"), row2.getBigDecimal("copentryqty"));
                continue;
            }
            Map materialInfo = standCostCalcParam.getMainAndCoByProductWithOutBomMap().computeIfAbsent(row2.getString("bkeycol"), p -> new HashMap());
            BigDecimal newValue = materialInfo.computeIfAbsent(row2.getString("copentrykeycol"), v -> BigDecimal.ZERO).add(row2.getBigDecimal("copentryqty"));
            materialInfo.put(row2.getString("copentrykeycol"), newValue);
        }
    }

    private void structCoByProduct(String srcEntity, Map<String, Long> matBomIdMap, DynamicObject bomRuleSettingObj, StandCostCalcParam standCostCalcParam) {
        String matFields = "material.masterid material,copentry.copentrymaterial.masterid copentrymaterial";
        if ("pdm_mftbom".equals(srcEntity)) {
            matFields = "material.masterid.masterid material,copentry.copentrymaterial.masterid.masterid copentrymaterial";
        }
        QFilter bomFilter = new QFilter("id", "in", matBomIdMap.values());
        bomFilter.and(new QFilter("iscoproduct", "=", (Object)"1"));
        QFilter timeFilter = new QFilter("copentry.copentryvaliddate", "<=", (Object)standCostCalcParam.getCalcDate());
        timeFilter.and(new QFilter("copentry.copentryinvaliddate", ">=", (Object)standCostCalcParam.getCalcDate()));
        DataSet bomDataSet = QueryServiceHelper.queryDataSet((String)"structCoByProduct", (String)srcEntity, (String)("id,auxproperty,configuredcode,copentry.copentrytype copentrytype,copentry.copentryauxproperty copentryauxproperty,copentry.copentryqty copentryqty,copentry.copentryvaliddate copentryvaliddate,copentry.copentryinvaliddate copentryinvaliddate," + matFields), (QFilter[])new QFilter[]{bomFilter, timeFilter}, null);
        String byProductPriceRule = bomRuleSettingObj.getString("byproductpricerule");
        boolean isPurPrices = "1".equals(byProductPriceRule);
        while (bomDataSet.hasNext()) {
            Row row = bomDataSet.next();
            HashMap<String, Object> keycolMap = new HashMap<String, Object>(16);
            keycolMap.put("material", row.get("material"));
            keycolMap.put("auxproperty", row.getLong("auxproperty"));
            keycolMap.put("configuredcode", row.get("configuredcode"));
            String mainKeycol = CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true).getKeycol();
            HashMap<String, Object> coKeycolMap = new HashMap<String, Object>(16);
            coKeycolMap.put("material", row.get("copentrymaterial"));
            coKeycolMap.put("auxproperty", row.getLong("copentryauxproperty"));
            coKeycolMap.put("configuredcode", row.get("configuredcode"));
            String coKeycol = CalcKeyHelper.getCalcKey(coKeycolMap, new ArrayList(), (boolean)true).getKeycol();
            if (isPurPrices && "10730".equals(row.getString("copentrytype"))) {
                standCostCalcParam.getMainAndCoByProductWithPurPriceMap().computeIfAbsent(mainKeycol, p -> new HashMap()).put(coKeycol, row.getBigDecimal("copentryqty"));
                continue;
            }
            String key = row.getLong("copentrymaterial") + "@" + row.getLong("copentryauxproperty") + "@" + row.getLong("configuredcode");
            if (matBomIdMap.containsKey(key)) {
                this.coByProductWithBom.add(coKeycol);
                standCostCalcParam.getMainAndCoByProductWithBomMap().computeIfAbsent(mainKeycol, p -> new ArrayList()).add(coKeycol);
                continue;
            }
            Map materialInfo = standCostCalcParam.getMainAndCoByProductWithOutBomMap().computeIfAbsent(mainKeycol, p -> new HashMap());
            BigDecimal newValue = materialInfo.computeIfAbsent(coKeycol, v -> BigDecimal.ZERO).add(row.getBigDecimal("copentryqty"));
            materialInfo.put(coKeycol, newValue);
        }
        standCostCalcParam.setCoByProductWithBom(this.coByProductWithBom);
    }

    private void queryBomVirtualItems(StandCostCalcParam standCostCalcParam, Map<Long, Tuple<Boolean, Boolean>> bomInfoMap, Set<Long> bomSettingIds) {
        QFilter filter = new QFilter("id", "in", bomSettingIds);
        filter.and(new QFilter("keycol", "in", standCostCalcParam.getVirtualMaterials()));
        DataSet bomSettingDataSet = QueryServiceHelper.queryDataSet((String)"queryBomVirtualItems", (String)"cad_bomsetting", (String)"id,keycol,material,bom,considervalidperiod,matcalcprop materialattr,case when matcalcprop='C' then '1' else '0' end isoutsource", (QFilter[])new QFilter[]{filter}, null);
        if (bomSettingDataSet.isEmpty()) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", bomInfoMap.keySet());
        qFilter.and(new QFilter("keycol", "in", standCostCalcParam.getVirtualMaterials()));
        QFilter timeFilter = new QFilter("entry.entryvaliddate", "<=", (Object)standCostCalcParam.getCalcDate());
        timeFilter.and(new QFilter("entry.entryinvaliddate", ">=", (Object)standCostCalcParam.getCalcDate()));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.algox.function.bomexpand.buildVirtualMatConstruct", (String)"cad_costbom", (String)"id bomId,keycol mainkeycol,material mainmaterial,yieldrate yieldrate,entry.id bomEntryId,entry.entrymaterial.masterid MaterialId,entry.entrymaterial.enableproduct enableproduct,entry.entrymaterial.enableoutsource enableoutsource,entry.entrymaterial.isuseauxpty isuseauxpty,entry.entrymaterial.auxptyentry.isaffectprice isaffectprice,entry.entrymaterial.isenablematerialversion isenablematerialversion,entry.entryversion.id MaterialVer,entry.entryauxproperty.id AuxPropId,entry.entryunit.id unitId,entry.entryqtytype entryqtytype,entry.entryqtynumerator entryqtynumerator,entry.entryqtydenominator entryqtydenominator,entry.entryfixscrap entryfixscrap,entry.entryscraprate entryscraprate,entry.entryvaliddate,entry.entryinvaliddate,entry.entrykeycol keycol,entry.entryconfiguredcode configuredcode,entry.ownertype ownertype", (QFilter[])new QFilter[]{qFilter, timeFilter}, null);
        dataSet = dataSet.select("bomId,mainmaterial,mainkeycol,yieldrate,bomEntryId,keycol,MaterialId,enableproduct,enableoutsource,isuseauxpty,isaffectprice,isenablematerialversion,MaterialVer,AuxPropId,unitId,entryqtytype,entryqtynumerator,entryqtydenominator,entryfixscrap,entryscraprate,entry.entryvaliddate,entry.entryinvaliddate,configuredcode,ownertype,case when isaffectprice =" + Boolean.TRUE + " then 1L else 0L end affectprice");
        dataSet = dataSet.groupBy(new String[]{"bomId", "mainmaterial", "mainkeycol", "yieldrate", "bomEntryId", "keycol", "MaterialId", "enableproduct", "enableoutsource", "isuseauxpty", "isenablematerialversion", "MaterialVer", "AuxPropId", "unitId", "entryqtytype", "entryqtynumerator", "entryqtydenominator", "entryfixscrap", "entryscraprate", "entry.entryvaliddate", "entry.entryinvaliddate", "configuredcode", "ownertype"}).maxP("affectprice", "isaffectprice").finish();
        dataSet = dataSet.leftJoin(bomSettingDataSet).on("keycol", "keycol").select(dataSet.getRowMeta().getFieldNames(), new String[]{"id as bomSettingId", "materialattr", "isoutsource"}).finish();
        if (dataSet.isEmpty()) {
            return;
        }
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long bomId = row.getLong("bomId");
            if (CadEmptyUtils.isEmpty(bomId)) continue;
            boolean isSupplierCustomerMat = "bd_supplier".equals(row.getString("ownertype")) || "bd_customer".equals(row.getString("ownertype"));
            String mainkeycol = row.getString("mainkeycol");
            CostBOMDyo costBomDyo = this.createCostBomDyo(row, true, false);
            if (isSupplierCustomerMat) {
                standCostCalcParam.getCustomSuppliedMaterials().add(costBomDyo.getKeycol());
            }
            this.costBomDyoForVirtualMatMap.computeIfAbsent(mainkeycol, p -> new ArrayList()).add(costBomDyo);
        }
    }

    private void structBomVirtualItems(String srcEntity, Map<String, Long> matBomIdMap, DataSet matInfoDataSet, DataSet matProduceInfoDataSet, DynamicObject bomRuleSettingObj, StandCostCalcParam standCostCalcParam) {
        Set<String> virtualMaterials = standCostCalcParam.getVirtualMaterials();
        QFilter qFilter = new QFilter("id", "in", matBomIdMap.values());
        DataSet bomVirtualMatFilterByKeyCol = BomRuleSettingStdCalcHelper.getBomMatDataSetByKeyCol(virtualMaterials);
        String matFields = "manuorg,material.masterid mainmaterial,entry.entrymaterial.masterid MaterialId,entry.ownertype ownertype";
        if ("pdm_mftbom".equals(srcEntity)) {
            matFields = "createorg manuorg,material.masterid.masterid mainmaterial,entry.entrymaterial.masterid.masterid MaterialId,entry.entryownertype ownertype";
        }
        QFilter timeFilter = new QFilter("entry.entryvaliddate", "<=", (Object)standCostCalcParam.getCalcDate());
        timeFilter.and(new QFilter("entry.entryinvaliddate", ">=", (Object)standCostCalcParam.getCalcDate()));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"structBomVirtualItems", (String)srcEntity, (String)("id,id bomId,id pid,0L bomSettingId,auxproperty mainauxproperty,configuredcode mainconfiguredcode,yieldrate,entry.id bomEntryId,entry.entryversion.id MaterialVer,entry.entryauxproperty.id AuxPropId,entry.entryunit.id unitId,entry.entryqtytype entryqtytype,entry.entryqtynumerator entryqtynumerator,entry.entryqtydenominator entryqtydenominator,entry.entryfixscrap entryfixscrap,entry.entryscraprate entryscraprate,entry.entryvaliddate entryvaliddate,entry.entryinvaliddate entryinvaliddate,entry.entryconfiguredcode configuredcode,entry.entryconfiguredcode.number configuredcodenumber,' ' keycol," + matFields), (QFilter[])new QFilter[]{qFilter, timeFilter}, null);
        dataSet = dataSet.join(bomVirtualMatFilterByKeyCol, JoinType.INNER).on("mainmaterial", "material").on("mainauxproperty", "auxproperty").on("mainconfiguredcode", "configuredcode").select(dataSet.getRowMeta().getFieldNames()).finish();
        if (dataSet.isEmpty()) {
            return;
        }
        dataSet = dataSet.join(matInfoDataSet, JoinType.LEFT).on("MaterialId", "material").select(dataSet.getRowMeta().getFieldNames(), new String[]{"number", "name", "enableproduct", "enableoutsource", "isuseauxpty", "isaffectprice", "isenablematerialversion"}).finish();
        dataSet = dataSet.join(matProduceInfoDataSet, JoinType.LEFT).on("MaterialId", "masterid").select(dataSet.getRowMeta().getFieldNames(), new String[]{"materialattr", "isoutsource"}).finish();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            boolean isSupplierCustomerMat = "bd_supplier".equals(row.getString("ownertype")) || "bd_customer".equals(row.getString("ownertype"));
            HashMap<String, Object> keycolMap = new HashMap<String, Object>(16);
            keycolMap.put("material", row.get("mainmaterial"));
            keycolMap.put("auxproperty", row.getLong("mainauxproperty"));
            keycolMap.put("configuredcode", row.get("mainconfiguredcode"));
            String mainkeycol = CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true).getKeycol();
            if (!virtualMaterials.contains(mainkeycol)) continue;
            CostBOMDyo costBomDyo = this.createCostBomDyo(row, true, false);
            if (isSupplierCustomerMat) {
                standCostCalcParam.getCustomSuppliedMaterials().add(costBomDyo.getKeycol());
            }
            this.costBomDyoForVirtualMatMap.computeIfAbsent(mainkeycol, p -> new ArrayList()).add(costBomDyo);
        }
    }

    private void mergeSameMaterialUnderSameBom() {
        Map<Long, List<BOMExpandNode>> nodeListGroupByParentBomId = this.getNodeList().stream().collect(Collectors.groupingBy(BOMExpandNode::getParentBomId));
        long needMergeBomCount = 0L;
        for (Map.Entry<Long, List<BOMExpandNode>> entry : nodeListGroupByParentBomId.entrySet()) {
            List<BOMExpandNode> nodeListWithSameBomId = entry.getValue();
            Map<String, List<BOMExpandNode>> nodeListGroupByMatId = nodeListWithSameBomId.stream().collect(Collectors.groupingBy(item -> item.getMaterial().getEqualsCondition()));
            for (Map.Entry<String, List<BOMExpandNode>> entryNodes : nodeListGroupByMatId.entrySet()) {
                List<BOMExpandNode> bomExpandNodes = entryNodes.getValue();
                if (bomExpandNodes.size() <= 1) continue;
                BigDecimal totalQtyNumerator = BigDecimal.ZERO;
                BigDecimal totalQtyDenominator = BigDecimal.ONE;
                BigDecimal stdQty = BigDecimal.ZERO;
                for (int index = 0; index < bomExpandNodes.size(); ++index) {
                    BOMExpandNode calculationNode = bomExpandNodes.get(index);
                    if (calculationNode.getQtydenominator() == null || BigDecimal.ZERO.compareTo(calculationNode.getQtydenominator()) == 0) continue;
                    BigDecimal qty = calculationNode.getQtynumerator().divide(calculationNode.getQtydenominator(), 10, 4);
                    totalQtyNumerator = totalQtyNumerator.add(qty);
                    if (index != 0) {
                        calculationNode.setDelete(true);
                        ++needMergeBomCount;
                    }
                    stdQty = stdQty.add(calculationNode.getStdQty());
                }
                bomExpandNodes.get(0).setQtynumerator(totalQtyNumerator);
                bomExpandNodes.get(0).setQtydenominator(totalQtyDenominator);
                bomExpandNodes.get(0).setStdQty(stdQty);
            }
        }
        if (needMergeBomCount > 0L) {
            this.nodeList = this.nodeList.stream().filter(item -> !item.isDelete()).collect(Collectors.toList());
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u540c\u4e00BOM\u4e0b\u76f8\u540c\u7269\u6599\u7ec4\u4ef6\u7684\u5206\u5b50\u548c\u5206\u6bcd\uff0c\u4e00\u5171\u5408\u5e76%s\u4e2aBOM", (String)"BOMExpandDataSet_0", (String)"macc-cad-algox", (Object[])new Object[0]), needMergeBomCount));
        logger.info("\u5408\u5e76\u540c\u4e00BOM\u4e0b\u76f8\u540c\u7269\u6599\u7ec4\u4ef6\u7684\u5206\u5b50\u548c\u5206\u6bcd\uff0c\u4e00\u5171\u5408\u5e76{}\u4e2aBOM", (Object)needMergeBomCount);
    }

    private void mergeSameMaterialUnderSameBomForStruct() {
        Map<Long, List<BOMExpandNode>> nodeListGroupByParentBomId = this.getNodeList().stream().collect(Collectors.groupingBy(BOMExpandNode::getParentBomId));
        long needMergeBomCount = 0L;
        HashMap<Long, BigDecimal> bomStdQtyMap = new HashMap<Long, BigDecimal>(16);
        for (Map.Entry<Long, List<BOMExpandNode>> entry : nodeListGroupByParentBomId.entrySet()) {
            List<BOMExpandNode> list = entry.getValue();
            Map<String, List<BOMExpandNode>> nodeListGroupByMatId = list.stream().collect(Collectors.groupingBy(item -> item.getMaterial().getEqualsCondition()));
            for (Map.Entry<String, List<BOMExpandNode>> entryNodes : nodeListGroupByMatId.entrySet()) {
                List<BOMExpandNode> bomExpandNodes = entryNodes.getValue();
                if (bomExpandNodes.size() <= 1) continue;
                BigDecimal totalQtyNumerator = BigDecimal.ZERO;
                BigDecimal totalQtyDenominator = BigDecimal.ONE;
                BigDecimal stdQty = BigDecimal.ZERO;
                for (int index = 0; index < bomExpandNodes.size(); ++index) {
                    BOMExpandNode calculationNode = bomExpandNodes.get(index);
                    if (calculationNode.getQtydenominator() == null || BigDecimal.ZERO.compareTo(calculationNode.getQtydenominator()) == 0) continue;
                    BigDecimal qty = calculationNode.getQtynumerator().divide(calculationNode.getQtydenominator(), 10, 4);
                    totalQtyNumerator = totalQtyNumerator.add(qty);
                    if (index != 0) {
                        calculationNode.setDelete(true);
                        ++needMergeBomCount;
                    }
                    stdQty = stdQty.add(calculationNode.getStdQty());
                }
                bomExpandNodes.get(0).setQtynumerator(totalQtyNumerator);
                bomExpandNodes.get(0).setQtydenominator(totalQtyDenominator);
                bomExpandNodes.get(0).setStdQty(stdQty);
                long redundBomId = bomExpandNodes.get(0).getRedundBomId();
                if (CadEmptyUtils.isEmpty(redundBomId)) continue;
                bomStdQtyMap.put(redundBomId, stdQty);
            }
        }
        if (needMergeBomCount > 0L) {
            this.nodeList = this.nodeList.stream().filter(item -> !item.isDelete()).collect(Collectors.toList());
        }
        if (!CadEmptyUtils.isEmpty(bomStdQtyMap)) {
            HashMap<Long, BOMExpandNode> map = new HashMap<Long, BOMExpandNode>(16);
            for (BOMExpandNode bOMExpandNode : this.nodeList) {
                long redundBomId = bOMExpandNode.getRedundBomId();
                if (CadEmptyUtils.isEmpty(redundBomId)) continue;
                long parentBomId = bOMExpandNode.getParentBomId();
                map.put(parentBomId, bOMExpandNode);
            }
            for (Map.Entry entry : bomStdQtyMap.entrySet()) {
                Long key = (Long)entry.getKey();
                BigDecimal value = (BigDecimal)entry.getValue();
                this.resetStdQty(map, key, value);
            }
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u540c\u4e00BOM\u4e0b\u76f8\u540c\u7269\u6599\u7ec4\u4ef6\u7684\u5206\u5b50\u548c\u5206\u6bcd\uff0c\u4e00\u5171\u5408\u5e76%s\u4e2aBOM", (String)"BOMExpandDataSet_0", (String)"macc-cad-algox", (Object[])new Object[0]), needMergeBomCount));
        logger.info("\u5408\u5e76\u540c\u4e00BOM\u4e0b\u76f8\u540c\u7269\u6599\u7ec4\u4ef6\u7684\u5206\u5b50\u548c\u5206\u6bcd\uff0c\u4e00\u5171\u5408\u5e76{}\u4e2aBOM", (Object)needMergeBomCount);
    }

    private void resetStdQty(Map<Long, BOMExpandNode> map, Long key, BigDecimal value) {
        BOMExpandNode bomExpandNode = map.get(key);
        if (bomExpandNode == null) {
            return;
        }
        bomExpandNode.setStdQty(bomExpandNode.getStdQty().multiply(value));
        this.resetStdQty(map, bomExpandNode.getRedundBomId(), bomExpandNode.getStdQty());
    }

    private Set<Long> getRootMaterialIds(QFilter filter) {
        DataSet parentDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.algox.function.bomexpand.bom", (String)"cad_bomsetting", (String)"id,material.id MaterialId,bom.id BomId", (QFilter[])new QFilter[]{filter}, (String)"bom.id");
        HashMap<Long, Long> bomSettingIdMap = new HashMap<Long, Long>();
        for (Row row : parentDataSet.copy()) {
            Long bomId = row.getLong("BomId");
            Long id = row.getLong("id");
            bomSettingIdMap.put(bomId, id);
        }
        QFilter subMatFilter = new QFilter("id", "in", bomSettingIdMap.keySet());
        subMatFilter.and(new QFilter("entry.ownertype", "=", (Object)"bos_org"));
        DataSet subDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.algox.function.bomexpand.bom", (String)"cad_costbom", (String)"entry.id bomEntryId,entry.entrymaterial.masterid MaterialId", (QFilter[])new QFilter[]{subMatFilter}, (String)"id");
        DataSet nonRootDs = parentDataSet.copy().rightJoin(subDataSet).on("MaterialId", "MaterialId").select(new String[]{"MaterialId"}).finish();
        HashSet<Long> nonRootMaterialIds = new HashSet<Long>();
        for (Row nonRootD : nonRootDs) {
            Long materialId = nonRootD.getLong("MaterialId");
            nonRootMaterialIds.add(materialId);
        }
        HashSet<Long> rootMaterialIds = new HashSet<Long>();
        for (Row parentRow : parentDataSet) {
            Long materialId = parentRow.getLong("MaterialId");
            if (nonRootMaterialIds.contains(materialId)) continue;
            rootMaterialIds.add(materialId);
        }
        return rootMaterialIds;
    }

    private DataSet queryBomSettingDataSet(Long costTypeId) {
        QFilter qFilter = new QFilter("costtype.id", "=", (Object)costTypeId);
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        return QueryServiceHelper.queryDataSet((String)"kd.macc.cad.algox.function.bomexpand.queryBomSetting", (String)"cad_bomsetting", (String)"id,keycol,matcalcprop materialattr,case when matcalcprop='C' then '1' else '0' end isoutsource", (QFilter[])qFilter.toArray(), null);
    }

    private void queryCalcVirtualMaterialInfo(StandCostCalcParam standCostCalcParam, Set<Long> bomIds) {
        HashMap<String, BigDecimal> virtualMaterialQtyMap = new HashMap<String, BigDecimal>(16);
        QFilter filter = new QFilter("id", "in", bomIds);
        filter.and(new QFilter("entry.entryisjumplevel", "=", (Object)Boolean.TRUE));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.algox.function.bomexpand.queryCalculateVirtualMaterials", (String)"cad_costbom", (String)"keycol,entry.entrykeycol entrykeycol,entry.entryqtynumerator entryqtynumerator,entry.entryqtydenominator entryqtydenominator", (QFilter[])new QFilter[]{filter}, null);
        if (dataSet.isEmpty()) {
            return;
        }
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (row == null) continue;
            BigDecimal qtyNumerator = row.getBigDecimal("entryqtynumerator");
            BigDecimal qtyDenominator = row.getBigDecimal("entryqtydenominator");
            BigDecimal unitQty = qtyDenominator.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : qtyNumerator.divide(qtyDenominator, 10, 4);
            virtualMaterialQtyMap.put(row.getString("keycol") + "@" + row.getString("entrykeycol"), unitQty);
            standCostCalcParam.getVirtualMaterials().add(row.getString("entrykeycol"));
        }
        standCostCalcParam.setVirtualMaterialQtyMap(virtualMaterialQtyMap);
    }

    private void queryCalcVirtualMaterialInfoNew(String srcEntity, Map<String, Long> matBomIdMap, StandCostCalcParam standCostCalcParam) {
        DataSet dataSet;
        HashMap<String, BigDecimal> virtualMaterialQtyMap = new HashMap<String, BigDecimal>(16);
        QFilter filter = new QFilter("id", "in", matBomIdMap.values());
        filter.and(new QFilter("entry.entryisjumplevel", "=", (Object)Boolean.TRUE));
        String matFields = "material.masterid mainmaterial,entry.entrymaterial.masterid entrymaterial";
        if ("pdm_mftbom".equals(srcEntity)) {
            matFields = "material.masterid.masterid mainmaterial,entry.entrymaterial.masterid.masterid entrymaterial";
        }
        if ((dataSet = QueryServiceHelper.queryDataSet((String)"queryCalcVirtualMaterialInfoNew", (String)srcEntity, (String)("auxproperty mainauxproperty,configuredcode mainconfiguredcode,entry.entryauxproperty entryauxproperty,entry.entryconfiguredcode entryconfiguredcode,entry.entryqtynumerator entryqtynumerator,entry.entryqtydenominator entryqtydenominator," + matFields), (QFilter[])new QFilter[]{filter}, null)).isEmpty()) {
            logger.info("\u5377\u7b97-BOM\u5c55\u5f00\uff0c\u672c\u6b21\u8ba1\u7b97\u6ca1\u6709\u83b7\u53d6\u5230\u865a\u62df\u4ef6\uff0c\u865a\u62df\u4ef6\u5904\u7406\u7ed3\u675f\u3002");
            return;
        }
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (row == null) continue;
            HashMap<String, Object> keycolMap = new HashMap<String, Object>(16);
            keycolMap.put("material", row.get("mainmaterial"));
            keycolMap.put("auxproperty", row.getLong("mainauxproperty"));
            keycolMap.put("configuredcode", row.get("mainconfiguredcode"));
            String keycol = CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true).getKeycol();
            HashMap<String, Object> coKeycolMap = new HashMap<String, Object>(16);
            coKeycolMap.put("material", row.get("entrymaterial"));
            coKeycolMap.put("auxproperty", row.getLong("entryauxproperty"));
            coKeycolMap.put("configuredcode", row.get("entryconfiguredcode"));
            String entryKeycol = CalcKeyHelper.getCalcKey(coKeycolMap, new ArrayList(), (boolean)true).getKeycol();
            String key = keycol + "@" + entryKeycol;
            BigDecimal qtyNumerator = row.getBigDecimal("entryqtynumerator");
            BigDecimal qtyDenominator = row.getBigDecimal("entryqtydenominator");
            BigDecimal unitQty = qtyDenominator.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : qtyNumerator.divide(qtyDenominator, 10, 4);
            virtualMaterialQtyMap.put(key, unitQty);
            standCostCalcParam.getVirtualMaterials().add(entryKeycol);
        }
        logger.info("\u5377\u7b97-BOM\u5c55\u5f00\uff0c\u865a\u62df\u4ef6\uff1a{}", standCostCalcParam.getVirtualMaterials());
        standCostCalcParam.setVirtualMaterialQtyMap(virtualMaterialQtyMap);
    }

    private void queryCalcVirtualMaterialInfoForStruct(StandCostCalcParam standCostCalcParam, DataSet dataSet) {
        HashMap<String, BigDecimal> virtualMaterialQtyMap = new HashMap<String, BigDecimal>(16);
        if (dataSet.isEmpty()) {
            return;
        }
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long id = row.getLong("id");
            Long pid = row.getLong("pid");
            if (CadEmptyUtils.isEmpty(id)) continue;
            BigDecimal qtyNumerator = row.getBigDecimal("entryqtynumerator");
            BigDecimal qtyDenominator = row.getBigDecimal("entryqtydenominator");
            BigDecimal unitQty = qtyDenominator.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : qtyNumerator.divide(qtyDenominator, 10, 4);
            virtualMaterialQtyMap.put(pid + "@" + id, unitQty);
            standCostCalcParam.getVirtualMaterials().add(String.valueOf(id));
        }
        standCostCalcParam.setVirtualMaterialQtyMap(virtualMaterialQtyMap);
    }

    public void queryBomParent(StandCostCalcParam standCostCalcParam, Set<String> calcKeycols, Map<Long, Tuple<Boolean, Boolean>> bomInfoMap, Set<Long> bomSettingIds) {
        QFilter filter = new QFilter("id", "in", bomSettingIds);
        if (standCostCalcParam.getScopetype() == 1) {
            filter.and(new QFilter("keycol", "in", calcKeycols));
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryBomParent", (String)"cad_bomsetting", (String)"bom id,0L pid,id as bomSettingId,keycol,material.id MaterialId,material.number number,material.name name,bomversion.id MaterialVer,auxprop.id AuxPropId,ispurprices,considervalidperiod,material.enableproduct enableproduct,material.enableoutsource enableoutsource,matcalcprop materialattr,case when matcalcprop='C' then '1' else '0' end isoutsource,material.isuseauxpty isuseauxpty,material.auxptyentry.isaffectprice isaffectprice,material.isenablematerialversion isenablematerialversion,bom.id bomId,bom.yieldrate yieldrate,bom.material.baseunit unitId,configuredcode,configuredcode.number configuredcodenumber,tracknumber,project,lot", (QFilter[])new QFilter[]{filter}, null);
        dataSet = dataSet.select("id,pid,bomSettingId,keycol,MaterialId,number,name,MaterialVer,AuxPropId,ispurprices,considervalidperiod,enableproduct,enableoutsource,materialattr,isoutsource,isuseauxpty,isaffectprice,isenablematerialversion,bomId,yieldrate,unitId,configuredcode,configuredcodenumber,tracknumber,project,lot,case when isaffectprice =" + Boolean.TRUE + " then 1L else 0L end affectprice");
        dataSet = dataSet.groupBy(new String[]{"id", "pid", "bomSettingId", "keycol", "MaterialId", "number", "name", "MaterialVer", "AuxPropId", "ispurprices", "considervalidperiod", "enableproduct", "enableoutsource", "materialattr", "isoutsource", "isuseauxpty", "isenablematerialversion", "bomId", "yieldrate", "unitId", "configuredcode", "configuredcodenumber", "tracknumber", "project", "lot"}).maxP("affectprice", "isaffectprice").finish();
        int count = 0;
        HashSet<Long> bomIds = new HashSet<Long>(200);
        for (Row row : dataSet) {
            Long bomId = row.getLong("bomId");
            if (bomId == null) {
                logger.error(String.format("\u7269\u6599Id\uff1a%s\u5bf9\u5e94\u7684bom\u4e0d\u5b58\u5728\u3002", row.getLong("MaterialId")));
                continue;
            }
            CostBOMDyo costBomDyo = this.createCostBomDyo(row, false, true);
            costBomDyo.setTracknumber(row.getLong("tracknumber"));
            costBomDyo.setProject(row.getLong("project"));
            costBomDyo.setLot(row.getString("lot"));
            if (!CadEmptyUtils.isEmpty(costBomDyo.getTracknumber())) {
                standCostCalcParam.getMatConfigCodeTrackNumMap().computeIfAbsent(costBomDyo.getKeycol(), t -> new HashSet()).add(costBomDyo.getTracknumber());
            }
            bomInfoMap.put(row.getLong("bomId"), (Tuple<Boolean, Boolean>)new Tuple((Object)row.getBoolean("considervalidperiod"), (Object)row.getBoolean("ispurprices")));
            bomIds.add(bomId);
            this.transferConfigBomInfo(this.calcParam, row);
            ++count;
        }
        standCostCalcParam.setBomIdSet(bomIds);
        this.write2Log(String.format(ResManager.loadKDString((String)"\u83b7\u53d6BOM\u7236\u9879\u6570\u636e%s\u4e2a\u3002", (String)"BOMExpandDataSet_11", (String)"macc-cad-algox", (Object[])new Object[0]), count));
    }

    public void structBom(String srcEntity, Map<String, Long> matBomIdMap, DataSet matInfoDataSet, DataSet matProduceInfoDataSet) {
        QFilter calcFilter = new QFilter("id", "in", matBomIdMap.values());
        String matFields = "manuorg,material.masterid MaterialId,material.baseunit unitId";
        if ("pdm_mftbom".equals(srcEntity)) {
            matFields = "createorg manuorg,material.masterid.masterid MaterialId,material.masterid.baseunit unitId";
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"structBom", (String)srcEntity, (String)("id,0L pid,id bomId,0L bomSettingId,version.id MaterialVer,auxproperty.id AuxPropId,configuredcode,configuredcode.number configuredcodenumber,' ' keycol,yieldrate," + matFields), (QFilter[])new QFilter[]{calcFilter}, null);
        dataSet = dataSet.join(matInfoDataSet, JoinType.LEFT).on("MaterialId", "material").select(dataSet.getRowMeta().getFieldNames(), new String[]{"number", "name", "enableproduct", "enableoutsource", "isuseauxpty", "isaffectprice", "isenablematerialversion"}).finish();
        dataSet = dataSet.join(matProduceInfoDataSet, JoinType.LEFT).on("MaterialId", "masterid").select(dataSet.getRowMeta().getFieldNames(), new String[]{"materialattr", "isoutsource"}).finish();
        int count = 0;
        for (Row row : dataSet) {
            Long bomId = row.getLong("bomId");
            if (bomId == null) {
                logger.error(String.format("\u7269\u6599Id\uff1a%s\u5bf9\u5e94\u7684bom\u4e0d\u5b58\u5728\u3002", row.getLong("MaterialId")));
                continue;
            }
            String materialattr = row.getString("materialattr");
            if ("10040".equals(materialattr)) continue;
            CostBOMDyo costBomDyo = this.createCostBomDyo(row, false, true);
            costBomDyo.setId(bomId);
            this.transferConfigBomInfo(this.calcParam, row);
            ++count;
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u83b7\u53d6BOM\u7236\u9879\u6570\u636e%s\u4e2a\u3002", (String)"BOMExpandDataSet_11", (String)"macc-cad-algox", (Object[])new Object[0]), count));
    }

    private void getMostHightLevelMaterialBySpeciMat(Set<String> upLevelMatKeycols, Set<String> specifyMaterialKeycols, List<Long> allBomIds, int count) {
        if (CadEmptyUtils.isEmpty(specifyMaterialKeycols)) {
            return;
        }
        QFilter idFilter = new QFilter("id", "in", allBomIds);
        QFilter kcFilter = new QFilter("entry.entrykeycol", "in", specifyMaterialKeycols);
        DynamicObjectCollection boms = QueryServiceHelper.query((String)"cad_costbom", (String)"id,keycol,entry.entrykeycol entrykeycol", (QFilter[])new QFilter[]{idFilter, kcFilter});
        specifyMaterialKeycols.clear();
        boms.forEach(bom -> {
            upLevelMatKeycols.remove(bom.getString("entrykeycol"));
            specifyMaterialKeycols.add(bom.getString("keycol"));
        });
        upLevelMatKeycols.addAll(specifyMaterialKeycols);
        if (count > 20) {
            return;
        }
        this.getMostHightLevelMaterialBySpeciMat(upLevelMatKeycols, specifyMaterialKeycols, allBomIds, ++count);
    }

    private void getCalcKeyCols(Set<String> specifyKeycols, Set<String> calcKeycols, List<Long> bomIds, int count) {
        if (CadEmptyUtils.isEmpty(specifyKeycols)) {
            return;
        }
        QFilter idFilter = new QFilter("id", "in", bomIds);
        QFilter kcFilter = new QFilter("keycol", "in", specifyKeycols);
        DynamicObjectCollection boms = QueryServiceHelper.query((String)"cad_costbom", (String)"keycol,entry.entrykeycol entrykeycol", (QFilter[])new QFilter[]{idFilter, kcFilter});
        specifyKeycols.clear();
        boms.forEach(bom -> {
            calcKeycols.add(bom.getString("keycol"));
            specifyKeycols.add(bom.getString("entrykeycol"));
        });
        if (count > 20) {
            return;
        }
        this.getCalcKeyCols(specifyKeycols, calcKeycols, bomIds, ++count);
    }

    public void queryBomItems(StandCostCalcParam standCostCalcParam, Map<Long, Tuple<Boolean, Boolean>> bomInfoMap, Set<Long> bomSettingIds) {
        if (CadEmptyUtils.isEmpty(bomInfoMap)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", bomSettingIds);
        DataSet bomSettingDataSet = QueryServiceHelper.queryDataSet((String)"queryBomItems", (String)"cad_bomsetting", (String)"id,keycol,material,bom,considervalidperiod,matcalcprop materialattr,case when matcalcprop='C' then '1' else '0' end isoutsource", (QFilter[])new QFilter[]{filter}, null);
        QFilter qFilter = new QFilter("id", "in", bomInfoMap.keySet());
        QFilter timeFilter = new QFilter("entry.entryvaliddate", "<=", (Object)standCostCalcParam.getCalcDate());
        timeFilter.and(new QFilter("entry.entryinvaliddate", ">=", (Object)standCostCalcParam.getCalcDate()));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryBomItems", (String)"cad_costbom", (String)"id,id pid,id bomId,material mainmaterial,keycol mainkeycol,yieldrate yieldrate,entry.id bomEntryId,entry.entrykeycol keycol,entry.entrymaterial.masterid MaterialId,entry.entrymaterial.number number,entry.entrymaterial.name name,entry.entrymaterial.enableproduct enableproduct,entry.entrymaterial.enableoutsource enableoutsource,entry.entrymaterial.isuseauxpty isuseauxpty,entry.entrymaterial.auxptyentry.isaffectprice isaffectprice,entry.entrymaterial.isenablematerialversion isenablematerialversion,entry.entryversion.id MaterialVer,entry.entryauxproperty.id AuxPropId,entry.entryunit.id unitId,entry.entryqtytype entryqtytype,entry.entryqtynumerator entryqtynumerator,entry.entryqtydenominator entryqtydenominator,entry.entryfixscrap entryfixscrap,entry.entryscraprate entryscraprate,entry.entryvaliddate,entry.entryinvaliddate,entry.entryconfiguredcode configuredcode,entry.entryconfiguredcode.number configuredcodenumber,entry.ownertype ownertype", (QFilter[])new QFilter[]{qFilter, timeFilter}, null);
        dataSet = dataSet.select("id,pid,bomId,mainmaterial,mainkeycol,yieldrate,bomEntryId,keycol,MaterialId,number,name,enableproduct,enableoutsource,isuseauxpty,isaffectprice,isenablematerialversion,MaterialVer,AuxPropId,unitId,entryqtytype,entryqtynumerator,entryqtydenominator,entryfixscrap,entryscraprate,entry.entryvaliddate,entry.entryinvaliddate,configuredcode,configuredcodenumber,ownertype,case when isaffectprice =" + Boolean.TRUE + " then 1L else 0L end affectprice");
        dataSet = dataSet.groupBy(new String[]{"id", "pid", "bomId", "mainmaterial", "mainkeycol", "yieldrate", "bomEntryId", "keycol", "MaterialId", "number", "name", "enableproduct", "enableoutsource", "isuseauxpty", "isenablematerialversion", "MaterialVer", "AuxPropId", "unitId", "entryqtytype", "entryqtynumerator", "entryqtydenominator", "entryfixscrap", "entryscraprate", "entry.entryvaliddate", "entry.entryinvaliddate", "configuredcode", "configuredcodenumber", "ownertype"}).maxP("affectprice", "isaffectprice").finish();
        dataSet = dataSet.leftJoin(bomSettingDataSet).on("keycol", "keycol").select(dataSet.getRowMeta().getFieldNames(), new String[]{"id as bomSettingId", "materialattr", "isoutsource"}).finish();
        int count = 0;
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long bomId = row.getLong("bomId");
            if (CadEmptyUtils.isEmpty(bomId)) continue;
            boolean isSupplierCustomerMat = "bd_supplier".equals(row.getString("ownertype")) || "bd_customer".equals(row.getString("ownertype"));
            Long bomSettingId = row.getLong("bomSettingId");
            if (standCostCalcParam.getVirtualMaterials().contains(row.getString("keycol"))) {
                String keycol = row.getString("keycol");
                String mainKeycol = row.getString("mainkeycol");
                String key = mainKeycol + "@" + keycol;
                BigDecimal qty = this.calcParam.getVirtualMaterialQtyMap().getOrDefault(key, BigDecimal.ZERO);
                this.createCostBomDyoForVirtual(keycol, qty, bomId, bomSettingId, standCostCalcParam.getVirtualMaterials(), count);
            } else {
                CostBOMDyo costBomDyo = this.createCostBomDyo(row, true, true);
                costBomDyo.setId(0L);
                costBomDyo.setParentId(bomId);
                costBomDyo.setBomSettingId(bomSettingId);
                if (isSupplierCustomerMat) {
                    this.calcParam.getCustomSuppliedMaterials().add(costBomDyo.getKeycol());
                }
            }
            this.transferConfigBomInfo(this.calcParam, row);
            ++count;
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u83b7\u53d6BOM\u5b50\u9879\u6570\u636e%s\u4e2a\u3002", (String)"BOMExpandDataSet_12", (String)"macc-cad-algox", (Object[])new Object[0]), count));
    }

    public void structBomItems(String srcEntity, Map<String, Long> matBomIdMap, DynamicObject bomRuleSettingObj, StandCostCalcParam standCostCalcParam, DataSet matInfoDataSet, DataSet matProduceInfoDataSet) {
        QFilter calcFilter = new QFilter("id", "in", matBomIdMap.values());
        String matFields = "manuorg,material.masterid mainmaterial,entry.entrymaterial.masterid MaterialId,entry.ownertype ownertype";
        if ("pdm_mftbom".equals(srcEntity)) {
            matFields = "createorg manuorg,material.masterid.masterid mainmaterial,entry.entrymaterial.masterid.masterid MaterialId,entry.entryownertype ownertype";
        }
        QFilter timeFilter = new QFilter("entry.entryvaliddate", "<=", (Object)standCostCalcParam.getCalcDate());
        timeFilter.and(new QFilter("entry.entryinvaliddate", ">=", (Object)standCostCalcParam.getCalcDate()));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"structBomItems", (String)srcEntity, (String)("id,id bomId,id pid,0L bomSettingId,auxproperty mainauxproperty,configuredcode mainconfiguredcode,yieldrate,entry.id bomEntryId,entry.entryversion.id MaterialVer,entry.entryauxproperty.id AuxPropId,entry.entryunit.id unitId,entry.entryqtytype entryqtytype,entry.entryqtynumerator entryqtynumerator,entry.entryqtydenominator entryqtydenominator,entry.entryfixscrap entryfixscrap,entry.entryscraprate entryscraprate,entry.entryvaliddate entryvaliddate,entry.entryinvaliddate entryinvaliddate,entry.entryconfiguredcode configuredcode,entry.entryconfiguredcode.number configuredcodenumber,' ' keycol," + matFields), (QFilter[])new QFilter[]{calcFilter, timeFilter}, null);
        dataSet = dataSet.join(matInfoDataSet, JoinType.LEFT).on("MaterialId", "material").select(dataSet.getRowMeta().getFieldNames(), new String[]{"number", "name", "enableproduct", "enableoutsource", "isuseauxpty", "isaffectprice", "isenablematerialversion"}).finish();
        dataSet = dataSet.join(matProduceInfoDataSet, JoinType.LEFT).on("MaterialId", "masterid").select(dataSet.getRowMeta().getFieldNames(), new String[]{"materialattr", "isoutsource"}).finish();
        int count = 0;
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            boolean isSupplierCustomerMat = "bd_supplier".equals(row.getString("ownertype")) || "bd_customer".equals(row.getString("ownertype"));
            Long bomId = row.getLong("bomId");
            HashMap<String, Object> mainKeycolMap = new HashMap<String, Object>(16);
            mainKeycolMap.put("material", row.get("mainmaterial"));
            mainKeycolMap.put("auxproperty", row.getLong("mainauxproperty"));
            mainKeycolMap.put("configuredcode", row.get("mainconfiguredcode"));
            String mainKeycol = CalcKeyHelper.getCalcKey(mainKeycolMap, new ArrayList(), (boolean)true).getKeycol();
            HashMap<String, Object> keycolMap = new HashMap<String, Object>(16);
            keycolMap.put("material", row.get("MaterialId"));
            keycolMap.put("auxproperty", row.getLong("AuxPropId"));
            keycolMap.put("configuredcode", row.get("configuredcode"));
            String keycol = CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true).getKeycol();
            if (standCostCalcParam.getVirtualMaterials().contains(keycol)) {
                String key = mainKeycol + "@" + keycol;
                BigDecimal qty = this.calcParam.getVirtualMaterialQtyMap().getOrDefault(key, BigDecimal.ZERO);
                this.createCostBomDyoForVirtual(keycol, qty, bomId, 0L, standCostCalcParam.getVirtualMaterials(), count);
            } else {
                CostBOMDyo costBomDyo = this.createCostBomDyo(row, true, true);
                costBomDyo.setId(0L);
                costBomDyo.setParentId(bomId);
                costBomDyo.setBomSettingId(0L);
                if (isSupplierCustomerMat) {
                    this.calcParam.getCustomSuppliedMaterials().add(costBomDyo.getKeycol());
                }
            }
            this.transferConfigBomInfo(this.calcParam, row);
            ++count;
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u83b7\u53d6BOM\u5b50\u9879\u6570\u636e%s\u4e2a\u3002", (String)"BOMExpandDataSet_12", (String)"macc-cad-algox", (Object[])new Object[0]), count));
    }

    private CostBOMDyo createCostBomDyo(Row row, Boolean isBomItem, Boolean isAddNodeList) {
        if (row == null) {
            return null;
        }
        CostBOMDyo costBOMDyo = new CostBOMDyo();
        costBOMDyo.setId(row.getLong("bomId"));
        costBOMDyo.setBomSettingId(row.getLong("bomSettingId"));
        costBOMDyo.setMaterial(row.getLong("MaterialId"));
        costBOMDyo.setEnableProduct(row.getBoolean("enableproduct"));
        if (row.getBoolean("isoutsource") != null) {
            costBOMDyo.setOutSource(row.getBoolean("isoutsource"));
        }
        if (row.getBoolean("isenablematerialversion") != null) {
            costBOMDyo.setEnableMatversion(row.getBoolean("isenablematerialversion"));
        }
        if (row.getBoolean("isuseauxpty") != null) {
            costBOMDyo.setUseAuxpty(row.getBoolean("isuseauxpty"));
        }
        costBOMDyo.setAffectPrice(Boolean.TRUE);
        costBOMDyo.setMaterialAttr(row.getString("materialattr"));
        costBOMDyo.setMatAuxpty(row.getLong("AuxPropId"));
        if (costBOMDyo.isEnableMatversion().booleanValue()) {
            costBOMDyo.setMatVersion(row.getLong("MaterialVer"));
        }
        costBOMDyo.setConfiguredcode(row.getLong("configuredcode"));
        costBOMDyo.setYieldRate(row.getBigDecimal("yieldrate"));
        costBOMDyo.setBaseUnit(row.getLong("unitId"));
        String keycol = row.getString("keycol");
        if (CadEmptyUtils.isEmpty(keycol)) {
            keycol = this.getKeyCol(costBOMDyo);
        }
        costBOMDyo.setKeycol(keycol);
        if (isBomItem.booleanValue()) {
            costBOMDyo.setBaseUnit(row.getLong("unitId"));
            costBOMDyo.setQtyType(row.getString("entryqtytype"));
            costBOMDyo.setQtyNumerator(row.getBigDecimal("entryqtynumerator"));
            costBOMDyo.setQtyDenominator(row.getBigDecimal("entryqtydenominator"));
            costBOMDyo.setFixScrap(row.getBigDecimal("entryfixscrap"));
            costBOMDyo.setScrapRate(row.getBigDecimal("entryscraprate"));
        }
        if (isAddNodeList.booleanValue()) {
            this.costBOMDyoList.add(costBOMDyo);
        }
        return costBOMDyo;
    }

    private CostBOMDyo createCostBomDyoForVirtual(String materialKeycol, BigDecimal qty, Long parentBomId, Long bomSettingId, Set<String> virtualMaterials, int count) {
        if (CadEmptyUtils.isEmpty(materialKeycol)) {
            return null;
        }
        List<CostBOMDyo> costBOMDyoList = this.costBomDyoForVirtualMatMap.get(materialKeycol);
        if (CadEmptyUtils.isEmpty(costBOMDyoList)) {
            return null;
        }
        for (CostBOMDyo costBOMDyo : costBOMDyoList) {
            String matKeycol = costBOMDyo.getKeycol();
            if (virtualMaterials.contains(matKeycol) && !CadEmptyUtils.isEmpty(this.costBomDyoForVirtualMatMap.get(matKeycol))) {
                String key = materialKeycol + "@" + matKeycol;
                BigDecimal subQty = this.calcParam.getVirtualMaterialQtyMap().getOrDefault(key, BigDecimal.ZERO);
                BigDecimal newQty = qty.multiply(subQty);
                this.createCostBomDyoForVirtual(matKeycol, newQty, parentBomId, bomSettingId, virtualMaterials, count);
                continue;
            }
            CostBOMDyo costBOMDyo1 = costBOMDyo.copy();
            costBOMDyo1.setId(0L);
            costBOMDyo1.setParentId(parentBomId);
            costBOMDyo1.setBomSettingId(bomSettingId);
            costBOMDyo1.setQtyNumerator(costBOMDyo1.getQtyNumerator().multiply(qty));
            ++count;
            this.costBOMDyoList.add(costBOMDyo1);
        }
        return null;
    }

    private CostBOMDyo createCostBomDyoForVirtualStruct(String id, BigDecimal qty, Long parentId, Set<String> virtualMaterials, int count) {
        if (CadEmptyUtils.isEmpty(id)) {
            return null;
        }
        List<CostBOMDyo> costBOMDyoList = this.costBomDyoForVirtualMatMap.get(id);
        if (CadEmptyUtils.isEmpty(costBOMDyoList)) {
            return null;
        }
        for (CostBOMDyo costBOMDyo : costBOMDyoList) {
            String sid = String.valueOf(costBOMDyo.getId());
            if (virtualMaterials.contains(sid) && !CadEmptyUtils.isEmpty(this.costBomDyoForVirtualMatMap.get(sid))) {
                String key = id + "@" + sid;
                BigDecimal subqty = this.calcParam.getVirtualMaterialQtyMap().getOrDefault(key, BigDecimal.ZERO);
                BigDecimal newQty = qty.multiply(subqty);
                this.createCostBomDyoForVirtualStruct(sid, newQty, parentId, virtualMaterials, count);
                continue;
            }
            CostBOMDyo costBOMDyo1 = costBOMDyo.copy();
            costBOMDyo1.setId(0L);
            costBOMDyo1.setParentId(parentId);
            costBOMDyo1.setBomSettingId(0L);
            costBOMDyo1.setQtyNumerator(costBOMDyo1.getQtyNumerator().multiply(qty));
            ++count;
            this.costBOMDyoList.add(costBOMDyo1);
        }
        return null;
    }

    private Material toMaterial(CostBOMDyo costBOMDyo, Map<String, String> matDimKeycolMap) {
        Material material = new Material();
        material.setMaterialId(costBOMDyo.getMaterial());
        if (costBOMDyo.isEnableProduct() != null) {
            material.setEnableproduct(costBOMDyo.isEnableProduct());
        }
        if (costBOMDyo.isOutSource() != null) {
            material.setEnableoutsource(costBOMDyo.isOutSource());
        }
        if (costBOMDyo.isEnableMatversion() != null) {
            material.setIsenablematerialversion(costBOMDyo.isEnableMatversion());
        }
        if (costBOMDyo.isUseAuxpty() != null) {
            material.setIsuseauxpty(costBOMDyo.isUseAuxpty());
        }
        material.setAffectPrice(Boolean.TRUE);
        if (material.isIsuseauxpty() && material.isAffectPrice()) {
            material.setMaterialAuxPropId(costBOMDyo.getMatAuxpty());
        }
        if (material.isIsenablematerialversion()) {
            material.setMaterialVer(costBOMDyo.getMatVersion());
        }
        if (material.isIsenablematerialversion() && this.calcParam != null && !this.calcParam.isUseMatVersion()) {
            material.setMaterialVer(0L);
        }
        material.setConfiguredcode(costBOMDyo.getConfiguredcode());
        material.setTracknumber(costBOMDyo.getTracknumber());
        material.setProject(costBOMDyo.getProject());
        material.setLot(costBOMDyo.getLot());
        String key = material.getMaterialId() + "@" + material.getMaterialAuxPropId() + "@" + material.getConfiguredcode() + "@" + material.getTracknumber() + "@" + material.getProject() + "@" + material.getLot();
        if (matDimKeycolMap.containsKey(key)) {
            material.setKeycol(matDimKeycolMap.get(key));
        } else {
            material.setKeycol();
            matDimKeycolMap.put(key, material.getKeycol());
        }
        String materialAttr = costBOMDyo.getMaterialAttr();
        material.setMaterialAttr(materialAttr);
        if ("10030".equals(materialAttr)) {
            material.setMaterialAttr("A");
        } else if ("10040".equals(materialAttr)) {
            material.setMaterialAttr("B");
        } else if ("10050".equals(materialAttr)) {
            material.setMaterialAttr("C");
        } else if ("10020".equals(materialAttr)) {
            material.setMaterialAttr("D");
        } else if (CadEmptyUtils.isEmpty(material.getMaterialAttr())) {
            material.setMaterialAttr("B");
        }
        return material;
    }

    public List<Material> getCalculateMaterials() {
        return this.calculateMaterials;
    }

    public void setCalculateMaterials(List<Material> calculateMaterials) {
        this.calculateMaterials = calculateMaterials;
    }

    public void updateSubItemRelateBOM() {
        ArrayList<Integer> subMatItemsIndexInNodeList = new ArrayList<Integer>(this.nodeList.size());
        ArrayList<BOMExpandNode> matItemsWithBomId = new ArrayList<BOMExpandNode>(this.nodeList.size());
        for (int index = 0; index < this.nodeList.size(); ++index) {
            long bomId;
            BOMExpandNode bomExpandNode = this.nodeList.get(index);
            long parentBomId = bomExpandNode.getParentBomId();
            if (parentBomId != 0L && bomExpandNode.getExpandBomId() == 0L) {
                subMatItemsIndexInNodeList.add(index);
            }
            if ((bomId = bomExpandNode.getBomId()) == 0L) continue;
            matItemsWithBomId.add(bomExpandNode);
        }
        HashMap subMatItemIndexMap = Maps.newHashMapWithExpectedSize((int)subMatItemsIndexInNodeList.size());
        for (int index = 0; index < subMatItemsIndexInNodeList.size(); ++index) {
            Integer indexInNodeList = (Integer)subMatItemsIndexInNodeList.get(index);
            BOMExpandNode bomExpandNode = this.nodeList.get(indexInNodeList);
            this.setMatKeycolAndNodeMap(bomExpandNode, subMatItemIndexMap);
        }
        for (BOMExpandNode matItemWithBomId : matItemsWithBomId) {
            String materialKeycol = matItemWithBomId.getMaterial().getKeycol();
            List subMatItemList = (List)subMatItemIndexMap.get(materialKeycol);
            if (CadEmptyUtils.isEmpty(subMatItemList)) continue;
            for (BOMExpandNode bomExpandNode : subMatItemList) {
                bomExpandNode.setExpandBomId(matItemWithBomId.getBomId());
            }
        }
        subMatItemsIndexInNodeList.clear();
        subMatItemIndexMap.clear();
        this.write2Log(ResManager.loadKDString((String)"\u5173\u8054\u6240\u6709\u5b50\u9879\u4e8e\u7236\u9879\u5173\u7cfb", (String)"BOMExpandDataSet_6", (String)"macc-cad-algox", (Object[])new Object[0]));
    }

    public void setCalcMap() {
        for (int index = 0; index < this.nodeList.size(); ++index) {
            BOMExpandNode bomExpandNode = this.nodeList.get(index);
            long bomId = bomExpandNode.getBomId();
            this.bomIdAndNodeMap.put(bomId, bomExpandNode);
            this.setMatKeycolAndNodeMap(bomExpandNode, this.matKeycolAndNodeMap);
            this.setParentBomIdAndNodeMap(bomExpandNode, this.parentBomIdAndNodeMap);
        }
        this.nodeList.clear();
    }

    private void setMatKeycolAndNodeMap(BOMExpandNode bomExpandNode, Map<String, List<BOMExpandNode>> bomIdKeycolAndNodeMap) {
        String matKey = bomExpandNode.getMaterial().getEqualsCondition();
        bomIdKeycolAndNodeMap.computeIfAbsent(matKey, p -> new ArrayList()).add(bomExpandNode);
    }

    public List<BOMExpandNode> findSubNodes(BOMExpandNode parentNode) {
        long bomId;
        ArrayList<BOMExpandNode> subNodes = new ArrayList<BOMExpandNode>();
        long l = bomId = parentNode.getBomId() != 0L ? parentNode.getBomId() : parentNode.getExpandBomId();
        if (bomId == 0L) {
            return subNodes;
        }
        List<BOMExpandNode> bomExpandNodes = this.parentBomIdAndNodeMap.get(bomId);
        if (!CadEmptyUtils.isEmpty(bomExpandNodes)) {
            subNodes.addAll(bomExpandNodes);
        }
        return subNodes;
    }

    public List<BOMExpandNode> findRoots(Material material) {
        List<BOMExpandNode> nodes = this.findNodes(material);
        return this.findRootsByOneNodes(nodes, null);
    }

    private List<BOMExpandNode> findRootsByOneNodes(List<BOMExpandNode> nodes, String path) {
        ArrayList<BOMExpandNode> roots = new ArrayList<BOMExpandNode>();
        for (BOMExpandNode node : nodes) {
            List<BOMExpandNode> parentList = this.findParent(node, path);
            for (BOMExpandNode parentNode : parentList) {
                if (roots.contains(parentNode)) continue;
                roots.add(parentNode);
            }
        }
        return roots;
    }

    private List<BOMExpandNode> findParent(BOMExpandNode node, String path) {
        ArrayList<BOMExpandNode> roots = new ArrayList<BOMExpandNode>();
        if (node.getParentBomId() == 0L) {
            roots.add(node);
            return roots;
        }
        if (BOMExpand.isNest(path = path == null ? String.valueOf(node.getParentBomId()) : path + "@" + node.getParentBomId())) {
            return roots;
        }
        BOMExpandNode parentNode = this.findNodeByBOM(node.getParentBomId());
        if (parentNode == null) {
            return new ArrayList<BOMExpandNode>(10);
        }
        List<BOMExpandNode> subItems = this.findNodeInSub(parentNode);
        if (subItems.isEmpty()) {
            roots.add(parentNode);
            return roots;
        }
        return this.findRootsByOneNodes(subItems, path);
    }

    public List<BOMExpandNode> findNodes(Material material) {
        ArrayList<BOMExpandNode> nodes = new ArrayList<BOMExpandNode>();
        List<BOMExpandNode> bomExpandNodes = this.matKeycolAndNodeMap.get(material.getKeycol());
        if (!CadEmptyUtils.isEmpty(bomExpandNodes)) {
            nodes.addAll(bomExpandNodes);
        }
        return nodes;
    }

    public BOMExpandNode findParts(BOMExpandNode partNode) {
        for (BOMExpandNode node : this.nodeList) {
            if (node.equals(partNode) || !partNode.getMaterial().equals(node.getMaterial()) || partNode.getExpandBomId() != node.getExpandBomId()) continue;
            return node;
        }
        return null;
    }

    public List<BOMExpandNode> findNodeInSub(BOMExpandNode findNode) {
        ArrayList<BOMExpandNode> nodes = new ArrayList<BOMExpandNode>();
        List<BOMExpandNode> bomExpandNodes = this.matKeycolAndNodeMap.get(findNode.getMaterial().getEqualsCondition());
        if (!CadEmptyUtils.isEmpty(bomExpandNodes)) {
            for (BOMExpandNode bomExpandNode : bomExpandNodes) {
                if (findNode.equals(bomExpandNode) || bomExpandNode.getParentBomId() == 0L) continue;
                nodes.add(bomExpandNode);
            }
        }
        return nodes;
    }

    public List<BOMExpandNode> findNodeByTreePath(String treePathPrefix) {
        ArrayList<BOMExpandNode> nodes = new ArrayList<BOMExpandNode>();
        for (BOMExpandNode node : this.nodeList) {
            if (node.getBomTreePath() == null || !node.getBomTreePath().startsWith(treePathPrefix)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public BOMExpandNode findNodeByBOM(long bomId) {
        BOMExpandNode bomExpandNode = this.bomIdAndNodeMap.get(bomId);
        if (bomExpandNode != null && bomExpandNode.getParentBomId() == 0L) {
            return bomExpandNode;
        }
        return null;
    }

    public void partInPart() {
        Map<Long, Set<Long>> partInTreeMap = this.getPartBomInTrees();
        if (partInTreeMap.isEmpty()) {
            return;
        }
        HashMap<Long, List<BOMExpandNode>> listMap = new HashMap<Long, List<BOMExpandNode>>();
        for (BOMExpandNode node : this.nodeList) {
            if (node.getBomTreeRootId() == node.getBomId() || !this.getPartBomInTrees().containsKey(node.getBomTreeRootId())) continue;
            if (listMap.containsKey(node.getBomTreeRootId())) {
                ((List)listMap.get(node.getBomTreeRootId())).add(node);
                continue;
            }
            ArrayList<BOMExpandNode> list = new ArrayList<BOMExpandNode>();
            list.add(node);
            listMap.put(node.getBomTreeRootId(), list);
        }
        for (Long treeId : this.partBomInTrees.keySet()) {
            this.copySubPartTree2BigPart(treeId, listMap);
        }
    }

    private void copySubPartTree2BigPart(long bigPartTreeId, Map<Long, List<BOMExpandNode>> listMap) {
        for (BOMExpandNode node : listMap.get(bigPartTreeId)) {
            this.merge(node, node.getBomTreePath(), listMap);
        }
    }

    private void merge(BOMExpandNode node, String rootPth, Map<Long, List<BOMExpandNode>> listMap) {
        if (node.getExpandBomId() != 0L && listMap.containsKey(node.getExpandBomId())) {
            String oldBomTreePathPrex = node.getExpandBomId() + "@";
            String newBomTreePathPrex = rootPth + "@";
            for (BOMExpandNode subNode : listMap.get(node.getExpandBomId())) {
                BOMExpandNode subNodeNew = subNode.copy();
                String treePath = subNodeNew.getBomTreePath();
                treePath = treePath.replace(oldBomTreePathPrex, newBomTreePathPrex);
                String[] children = treePath.split("@");
                subNodeNew.setBomTreeRootId(node.getBomTreeRootId());
                subNodeNew.setBomTreePath(treePath);
                subNodeNew.setLevel(children.length - 1);
                this.nodeList.add(subNodeNew);
                this.merge(subNodeNew, subNodeNew.getBomTreePath(), listMap);
            }
        }
    }

    public int[] countBomTree() {
        int nonPartTreeCount = 0;
        int partTreeCount = 0;
        HashSet<Long> bomTreeRootIdMap = new HashSet<Long>();
        for (BOMExpandNode node : this.nodeList) {
            if (node.getBomTreeRootId() == 0L || bomTreeRootIdMap.contains(node.getBomTreeRootId())) continue;
            bomTreeRootIdMap.add(node.getBomTreeRootId());
            if (node.getNodeType() == 10) {
                ++nonPartTreeCount;
                continue;
            }
            ++partTreeCount;
        }
        return new int[]{nonPartTreeCount, partTreeCount};
    }

    public DataSet toDataSet() {
        Algo algo = Algo.create((String)"kd.macc.cad.algox.Data.BOMExpandDataSet.toDataSet");
        DataSetBuilder builder = algo.createDataSetBuilder(BOMExpandNode.getRowMeta());
        for (BOMExpandNode node : this.nodeList) {
            builder.append(node.toRow());
        }
        return builder.build();
    }

    public DataSet toCacheDataSet(List<BOMExpandNode> nodeList) {
        DataSetBuilder dsb = Algo.create((String)"kd.macc.cad.algox.Data.BOMExpandDataSet.fromCacheId").createDataSetBuilder(BOMExpandNode.getRowMeta());
        ArrayList<String> existKcs = new ArrayList<String>(200);
        Object calBomDistinct = StdCalculateHelper.getParamValue("calBomDistinct");
        Boolean isDistinct = "1".equals(calBomDistinct) ? Boolean.TRUE : Boolean.FALSE;
        for (BOMExpandNode bomExpandNode : nodeList) {
            if (isDistinct.booleanValue()) {
                if (existKcs.contains(bomExpandNode.getMaterial().getKeycol())) continue;
                existKcs.add(bomExpandNode.getMaterial().getKeycol());
            }
            dsb.append(bomExpandNode.values());
        }
        return dsb.build();
    }

    private void write2Log(String desc) {
        if (this.calcParam != null && this.calcParam.getBizLogger() != null) {
            this.calcParam.getBizLogger().writeInfo(ResManager.loadKDString((String)"\u6784\u5efaBOM\u6811", (String)"BOMExpandDataSet_7", (String)"macc-cad-algox", (Object[])new Object[0]), desc);
        }
    }

    public void writeDebugLog() {
        if (this.calcParam != null && this.calcParam.getBizLogger() != null) {
            this.calcParam.getBizLogger().writeDebug(ResManager.loadKDString((String)"BOM\u6811", (String)"BOMExpandDataSet_8", (String)"macc-cad-algox", (Object[])new Object[0]), ResManager.loadKDString((String)"Node ID\tBOM ID\t Material \t ParentBomId \tExpandBomId\tBOM TreeID\tBOM TreePath\tLevel\tIs Part\tIs Leaf\t\u6210\u54c1\u7387\t\u5206\u5b50\t\u5206\u6bcd\t", (String)"BOMExpandDataSet_9", (String)"macc-cad-algox", (Object[])new Object[0]));
            for (BOMExpandNode node : this.nodeList) {
                this.calcParam.getBizLogger().writeDebug(ResManager.loadKDString((String)"BOM\u6811", (String)"BOMExpandDataSet_8", (String)"macc-cad-algox", (Object[])new Object[0]), node.toDebugLog());
            }
        }
    }

    public List<BOMExpandNode> getNodeList() {
        return this.nodeList;
    }

    private void setParentBomIdAndNodeMap(BOMExpandNode bomExpandNode, Map<Long, List<BOMExpandNode>> nodeMap) {
        long parentBomId = bomExpandNode.getParentBomId();
        nodeMap.computeIfAbsent(parentBomId, p -> new ArrayList()).add(bomExpandNode);
    }

    public Set<Long> getAlreadyExpandedNodeIds() {
        return this.alreadyExpandedNodeIds;
    }

    public Set<Long> getAlreadyExpandedMatIds() {
        return this.alreadyExpandedMatIds;
    }

    public List<BOMExpandNode> getRoots() {
        return this.roots;
    }

    public void setBomIdAndNodeMap(Map<Long, BOMExpandNode> bomIdAndNodeMap) {
        this.bomIdAndNodeMap = bomIdAndNodeMap;
    }

    public void setMatKeycolAndNodeMap(Map<String, List<BOMExpandNode>> matKeycolAndNodeMap) {
        this.matKeycolAndNodeMap = matKeycolAndNodeMap;
    }

    public void setParentBomIdAndNodeMap(Map<Long, List<BOMExpandNode>> parentBomIdAndNodeMap) {
        this.parentBomIdAndNodeMap = parentBomIdAndNodeMap;
    }
}

