/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.algox.Data.Material;

public class BOMExpandNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(BOMExpandNode.class);
    private long nodeId = 0L;
    private boolean isPart = false;
    private long bomId = 0L;
    private long redundBomId = 0L;
    private BigDecimal yieldrate = BigDecimal.ONE;
    private Material material = null;
    private long unitId = 0L;
    private String qtytype;
    private BigDecimal qtynumerator;
    private BigDecimal qtydenominator;
    private BigDecimal fixscrap;
    private BigDecimal scraprate;
    private long parentBomId = 0L;
    private long expandBomId = 0L;
    private long bomTreeRootId = 0L;
    private String bomTreePath = null;
    private int level = 0;
    private boolean isLeaf = false;
    private long bomSettingID = 0L;
    private String keycol = null;
    private BigDecimal stdQty = BigDecimal.ONE;
    private boolean isDelete = false;
    private long parentBomExpandNodeId;
    public static final int BOMEXP_NONPART = 10;
    public static final int BOMEXP_PART = 11;
    public static final int CALC_RESULT = 20;
    private int nodeType = 10;
    public static final int IdIndex = 0;
    public static final int BOMTreeIDIndex = 22;
    public static final int PartIndex = 1;
    public static final int endIndex = 28;
    private static RowMeta rowMeta = null;

    public static RowMeta getRowMeta() {
        if (rowMeta == null) {
            Field[] fields = new Field[]{new Field("nodeId", (DataType)DataType.LongType), new Field("isPart", (DataType)DataType.BooleanType), new Field("bomId", (DataType)DataType.LongType), new Field("yieldrate", (DataType)DataType.createBigDecimalType((int)5)), new Field("materialId", (DataType)DataType.LongType), new Field("materialVer", (DataType)DataType.LongType), new Field("materialAuxPropId", (DataType)DataType.LongType), new Field("configuredcode", (DataType)DataType.LongType), new Field("tracknumber", (DataType)DataType.LongType), new Field("project", (DataType)DataType.LongType), new Field("lot", (DataType)DataType.StringType), new Field("isEnableoutsource", (DataType)DataType.BooleanType), new Field("isuseauxpty", (DataType)DataType.BooleanType), new Field("isaffectprice", (DataType)DataType.BooleanType), new Field("isenablematerialversion", (DataType)DataType.BooleanType), new Field("unitId", (DataType)DataType.LongType), new Field("qtytype", (DataType)DataType.StringType), new Field("qtynumerator", (DataType)DataType.BigDecimalType), new Field("qtydenominator", (DataType)DataType.BigDecimalType), new Field("fixscrap", (DataType)DataType.createBigDecimalType((int)5)), new Field("scraprate", (DataType)DataType.createBigDecimalType((int)5)), new Field("parentBomId", (DataType)DataType.LongType), new Field("expandBomId", (DataType)DataType.LongType), new Field("bomTreeRootId", (DataType)DataType.LongType), new Field("bomTreePath", (DataType)DataType.StringType), new Field("level", (DataType)DataType.IntegerType), new Field("isLeaf", (DataType)DataType.BooleanType), new Field("nodeType", (DataType)DataType.IntegerType), new Field("bomSettingID", (DataType)DataType.LongType), new Field("isPurPrice", (DataType)DataType.BooleanType), new Field("materialAttr", (DataType)DataType.StringType), new Field("parentBomExpandNodeId", (DataType)DataType.LongType), new Field("stdqty", (DataType)DataType.BigDecimalType), new Field("keycol", (DataType)DataType.StringType)};
            rowMeta = new RowMeta(fields);
        }
        return rowMeta;
    }

    public Row toRow() {
        return RowFactory.createRow((RowMeta)BOMExpandNode.getRowMeta(), (Object[])this.values());
    }

    public Object[] values() {
        int size = BOMExpandNode.getRowMeta().getFieldCount();
        Object[] values = new Object[size];
        int index = 0;
        values[index++] = this.getNodeId();
        values[index++] = this.isPart();
        values[index++] = this.getBomId();
        values[index++] = this.getYieldrate();
        values[index++] = this.material.getMaterialId();
        values[index++] = this.material.getMaterialVer();
        values[index++] = this.material.getMaterialAuxPropId();
        values[index++] = this.material.getConfiguredcode();
        values[index++] = this.material.getTracknumber();
        values[index++] = this.material.getProject();
        values[index++] = this.material.getLot();
        values[index++] = this.material.isEnableoutsource();
        values[index++] = this.material.isIsuseauxpty();
        values[index++] = this.material.isAffectPrice();
        values[index++] = this.material.isIsenablematerialversion();
        values[index++] = this.getUnitId();
        values[index++] = this.getQtytype();
        values[index++] = this.getQtynumerator();
        values[index++] = this.getQtydenominator();
        values[index++] = this.getFixscrap();
        values[index++] = this.getScraprate();
        values[index++] = this.getParentBomId();
        values[index++] = this.getExpandBomId();
        values[index++] = this.getBomTreeRootId();
        values[index++] = this.getBomTreePath();
        values[index++] = this.getLevel();
        values[index++] = this.isLeaf();
        values[index++] = this.getNodeType();
        values[index++] = this.getBomSettingID();
        values[index++] = this.material.isPurPrice();
        values[index++] = this.material.getMaterialAttr();
        values[index++] = this.getParentBomExpandNodeId();
        values[index++] = this.getStdQty();
        values[index++] = this.material.getKeycol();
        return values;
    }

    protected BOMExpandNode copyTo(BOMExpandNode node) {
        node.setNodeId(BOMExpandNode.genNodeId());
        node.setPart(this.isPart());
        node.setBomId(this.getBomId());
        node.setYieldrate(this.getYieldrate());
        node.setMaterial(this.getMaterial());
        node.setUnitId(this.getUnitId());
        node.setQtytype(this.getQtytype());
        node.setQtynumerator(this.getQtynumerator());
        node.setQtydenominator(this.getQtydenominator());
        node.setFixscrap(this.getFixscrap());
        node.setScraprate(this.getScraprate());
        node.setParentBomId(this.getParentBomId());
        node.setExpandBomId(this.getExpandBomId());
        node.setBomTreeRootId(this.getBomTreeRootId());
        node.setBomTreePath(this.getBomTreePath());
        node.setLevel(this.getLevel());
        node.setLeaf(this.isLeaf());
        node.setNodeType(this.getNodeType());
        node.setBomSettingID(this.getBomSettingID());
        node.setStdQty(this.getStdQty());
        node.setKeycol(this.getKeycol());
        return node;
    }

    public BOMExpandNode copy() {
        BOMExpandNode node = new BOMExpandNode();
        return this.copyTo(node);
    }

    public static long genNodeId() {
        return IDService.get().genLongId();
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public boolean isPart() {
        return this.isPart;
    }

    public void setPart(boolean part) {
        this.isPart = part;
    }

    public long getBomId() {
        return this.bomId;
    }

    public void setBomId(long bomId) {
        this.bomId = bomId;
    }

    public BigDecimal getYieldrate() {
        return this.yieldrate;
    }

    public void setYieldrate(BigDecimal yieldrate) {
        this.yieldrate = yieldrate;
    }

    public long getParentBomId() {
        return this.parentBomId;
    }

    public void setParentBomId(long parentBomId) {
        this.parentBomId = parentBomId;
    }

    public long getExpandBomId() {
        return this.expandBomId;
    }

    public void setExpandBomId(long expandBomId) {
        this.expandBomId = expandBomId;
    }

    public long getBomTreeRootId() {
        return this.bomTreeRootId;
    }

    public void setBomTreeRootId(long bomTreeRootId) {
        this.bomTreeRootId = bomTreeRootId;
    }

    public String getBomTreePath() {
        return this.bomTreePath;
    }

    public void setBomTreePath(String bomTreePath) {
        this.bomTreePath = bomTreePath;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean leaf) {
        this.isLeaf = leaf;
    }

    public long getUnitId() {
        return this.unitId;
    }

    public void setUnitId(long unitId) {
        this.unitId = unitId;
    }

    public String getQtytype() {
        return this.qtytype;
    }

    public void setQtytype(String qtytype) {
        this.qtytype = qtytype;
    }

    public BigDecimal getQtynumerator() {
        return this.qtynumerator;
    }

    public void setQtynumerator(BigDecimal qtynumerator) {
        this.qtynumerator = qtynumerator;
    }

    public BigDecimal getQtydenominator() {
        return this.qtydenominator;
    }

    public void setQtydenominator(BigDecimal qtydenominator) {
        this.qtydenominator = qtydenominator;
    }

    public BigDecimal getFixscrap() {
        return this.fixscrap;
    }

    public void setFixscrap(BigDecimal fixscrap) {
        this.fixscrap = fixscrap;
    }

    public BigDecimal getScraprate() {
        return this.scraprate;
    }

    public void setScraprate(BigDecimal scraprate) {
        this.scraprate = scraprate;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(int nodeType) {
        this.nodeType = nodeType;
    }

    public long getBomSettingID() {
        return this.bomSettingID;
    }

    public void setBomSettingID(long bomSettingID) {
        this.bomSettingID = bomSettingID;
    }

    public BigDecimal getStdQty() {
        return this.stdQty;
    }

    public void setStdQty(BigDecimal stdQty) {
        this.stdQty = stdQty;
    }

    public boolean appendToParent(BOMExpandNode parentNode, int level) {
        this.setBomTreeRootId(parentNode.getBomTreeRootId());
        if (this.getExpandBomId() != 0L) {
            String path = parentNode.getBomTreePath() + "@" + this.getExpandBomId();
            this.setBomTreePath(path);
        } else {
            String path = parentNode.getBomTreePath() + "@" + this.getMaterial().getMaterialId();
            this.setBomTreePath(path);
        }
        this.setLevel(level);
        return true;
    }

    public String toString() {
        return String.valueOf(this.getNodeId());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BOMExpandNode)) {
            return false;
        }
        return this.getNodeId() == ((BOMExpandNode)obj).getNodeId();
    }

    public int hashCode() {
        return String.valueOf(this.getNodeId()).hashCode();
    }

    public String toDebugLog() {
        return this.getNodeId() + "\t" + this.getBomId() + "\t" + this.getMaterial() + "\t" + this.getParentBomId() + "\t" + this.getExpandBomId() + "\t" + this.getBomTreeRootId() + "\t" + this.getBomTreePath() + "\t" + this.getLevel() + "\t" + this.isPart() + "\t" + this.isLeaf() + "\t" + this.getYieldrate() + "\t" + this.getQtynumerator() + "\t" + this.getQtydenominator();
    }

    public boolean isDelete() {
        return this.isDelete;
    }

    public void setDelete(boolean delete) {
        this.isDelete = delete;
    }

    public long getParentBomExpandNodeId() {
        return this.parentBomExpandNodeId;
    }

    public void setParentBomExpandNodeId(long parentBomExpandNodeId) {
        this.parentBomExpandNodeId = parentBomExpandNodeId;
    }

    public String getKeycol() {
        return this.keycol;
    }

    public void setKeycol(String keycol) {
        this.keycol = keycol;
    }

    public long getRedundBomId() {
        return this.redundBomId;
    }

    public void setRedundBomId(long redundBomId) {
        this.redundBomId = redundBomId;
    }
}

