/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algox.RowX;
import kd.macc.cad.algox.Data.BOMExpandNode;
import kd.macc.cad.algox.Data.CalculationNodeSubElement;
import kd.macc.cad.algox.Data.Material;

public class CalculationNode
extends BOMExpandNode
implements Serializable {
    public static final long FINISHED_ID = 999999L;
    private BigDecimal unitQty = BigDecimal.ONE;
    private List<CalculationNodeSubElement> subElementList = new ArrayList<CalculationNodeSubElement>();
    private List<CalculationNode> subNodes = new ArrayList<CalculationNode>();
    private boolean isCalculated = false;

    public BigDecimal getUnitQty() {
        return this.unitQty;
    }

    public void setUnitQty(BigDecimal unitQty) {
        this.unitQty = unitQty;
    }

    public List<CalculationNodeSubElement> getSubElementList() {
        return this.subElementList;
    }

    public List<CalculationNode> getSubNodes() {
        return this.subNodes;
    }

    public boolean isCalculated() {
        return this.isCalculated;
    }

    public void setCalculated(boolean calculated) {
        this.isCalculated = calculated;
    }

    @Override
    public CalculationNode copy() {
        CalculationNode node = new CalculationNode();
        this.copyTo(node);
        for (CalculationNodeSubElement subElement : this.getSubElementList()) {
            node.getSubElementList().add(subElement.copy());
        }
        return node;
    }

    public static CalculationNode fromRowX(RowX rowX, boolean isUseMatVersion) {
        CalculationNode node = new CalculationNode();
        int index = 0;
        node.setNodeId(rowX.getLong(index++));
        node.setPart(rowX.getBoolean(index++));
        node.setBomId(rowX.getLong(index++));
        node.setYieldrate(rowX.getBigDecimal(index++));
        Material material = new Material();
        material.setMaterialId(rowX.getLong(index++));
        material.setMaterialVer(rowX.getLong(index++));
        if (!isUseMatVersion) {
            material.setMaterialVer(0L);
        }
        material.setMaterialAuxPropId(rowX.getLong(index++));
        material.setConfiguredcode(rowX.getLong(index++));
        material.setTracknumber(rowX.getLong(index++));
        material.setProject(rowX.getLong(index++));
        material.setLot(rowX.getString(index++));
        material.setEnableoutsource(rowX.getBoolean(index++));
        material.setIsuseauxpty(rowX.getBoolean(index++));
        material.setAffectPrice(rowX.getBoolean(index++));
        material.setIsenablematerialversion(rowX.getBoolean(index++));
        node.setUnitId(rowX.getLong(index++));
        node.setQtytype(rowX.getString(index++));
        node.setQtynumerator(rowX.getBigDecimal(index++));
        node.setQtydenominator(rowX.getBigDecimal(index++));
        node.setFixscrap(rowX.getBigDecimal(index++));
        node.setScraprate(rowX.getBigDecimal(index++));
        node.setParentBomId(rowX.getLong(index++));
        node.setExpandBomId(rowX.getLong(index++));
        node.setBomTreeRootId(rowX.getLong(index++));
        node.setBomTreePath(rowX.getString(index++));
        node.setLevel(rowX.getInteger(index++));
        node.setLeaf(rowX.getBoolean(index++));
        node.setNodeType(rowX.getInteger(index++));
        node.setBomSettingID(rowX.getLong(index++));
        material.setPurPrice(rowX.getBoolean(index++));
        material.setMaterialAttr(rowX.getString(index++));
        node.setMaterial(material);
        node.setParentBomExpandNodeId(rowX.getLong(index++));
        node.setStdQty(rowX.getBigDecimal(index++));
        return node;
    }

    public RowX[] toRowX() {
        RowX[] rows = new RowX[this.getSubElementList().size()];
        int index = 0;
        for (CalculationNodeSubElement subElement : this.getSubElementList()) {
            Object[] rowValues = this.values();
            int i = 28;
            rowValues[i++] = subElement.getElement();
            rowValues[i++] = subElement.getSubElement();
            rowValues[i++] = subElement.getQty();
            rowValues[i++] = subElement.getPrice();
            rowValues[i++] = subElement.getCost();
            rowValues[i++] = subElement.getType();
            rowValues[i++] = subElement.getActivityId();
            rowValues[i++] = subElement.getCalcbasis();
            if (subElement.getMaterial() != null) {
                rowValues[i++] = subElement.getMaterial().getMaterialId();
                rowValues[i++] = subElement.getMaterial().getMaterialAuxPropId();
                rowValues[i] = subElement.getMaterial().getMaterialVer();
            } else {
                rowValues[i++] = 0L;
                rowValues[i++] = 0L;
                rowValues[i] = 0L;
            }
            rows[index++] = new RowX(rowValues);
        }
        return rows;
    }

    @Override
    public String toDebugLog() {
        StringBuilder sb = new StringBuilder();
        String mainStr = super.toDebugLog();
        for (CalculationNodeSubElement subElement : this.getSubElementList()) {
            sb.append(mainStr).append("\t").append(subElement.getElement()).append("\t").append(subElement.getSubElement()).append("\t").append(subElement.getQty()).append("\t").append(subElement.getPrice()).append("\t").append(subElement.getCost()).append("\t").append(subElement.getType()).append("\t").append(subElement.getElement()).append("\t").append(subElement.getElement()).append("\t").append(subElement.getElement()).append("\t").append(subElement.getElement());
            if (subElement.getMaterial() != null) {
                sb.append("\t").append(subElement.getMaterial().getMaterialId()).append("\t").append(subElement.getMaterial().getMaterialAuxPropId()).append("\t").append(subElement.getMaterial().getMaterialVer());
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

