/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.Data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.Data.BOMExpandNode;
import kd.macc.cad.algox.Data.CalculationNode;
import kd.macc.cad.algox.utils.CadEmptyUtils;

public class CalculationTree {
    private static final String FIND_SUBNODE_STR = "|";
    private static final Log logger = LogFactory.getLog(CalculationTree.class);
    private List<CalculationNode> nodeList = new ArrayList<CalculationNode>();
    private CalculationNode root = null;
    private Map<Long, DynamicObject> bomSettingMap = new HashMap<Long, DynamicObject>();

    public DynamicObject getBomSetting(long bomId) {
        return this.bomSettingMap.get(bomId);
    }

    public void getBomSetting(Set<Long> bomSettingSet) {
        QFilter filter = new QFilter("id", "in", bomSettingSet);
        DynamicObjectCollection objCol = QueryServiceHelper.query((String)"cad_bomsetting", (String)"id,bom.id,consideryieldrate,considersubmaterialloss,lossrateformula,chargedefsubelement.id,chargestdrate", (QFilter[])new QFilter[]{filter});
        for (DynamicObject obj : objCol) {
            this.bomSettingMap.put(obj.getLong("bom.id"), obj);
        }
    }

    public void buildTree() {
        Map<String, List<CalculationNode>> calculationNodeMap = this.constructNodeMapFromNodeList(this.nodeList);
        this.addSubNodes(calculationNodeMap);
    }

    private Map<String, List<CalculationNode>> constructNodeMapFromNodeList(List<CalculationNode> nodeList) {
        HashMap<String, List<CalculationNode>> calculationNodeMap = new HashMap<String, List<CalculationNode>>(nodeList.size());
        for (CalculationNode calculationNode : nodeList) {
            String bomTreePath = calculationNode.getBomTreePath();
            int level = calculationNode.getLevel();
            String fullBomTreePathKey = bomTreePath + FIND_SUBNODE_STR + level;
            ArrayList<CalculationNode> calculationNodes = (ArrayList<CalculationNode>)calculationNodeMap.get(fullBomTreePathKey);
            if (calculationNodes == null) {
                calculationNodes = new ArrayList<CalculationNode>(10);
                calculationNodes.add(calculationNode);
                calculationNodeMap.put(fullBomTreePathKey, calculationNodes);
                continue;
            }
            calculationNodes.add(calculationNode);
        }
        return calculationNodeMap;
    }

    private void addSubNodes(Map<String, List<CalculationNode>> calculationNodeMap) {
        String splitChar = "@";
        Pattern pathPattern = Pattern.compile(splitChar);
        for (CalculationNode node : this.nodeList) {
            String bomTreePath = node.getBomTreePath();
            Matcher pathMatcher = pathPattern.matcher(bomTreePath);
            ArrayList<Integer> splitCharIndexes = new ArrayList<Integer>(10);
            while (pathMatcher.find()) {
                splitCharIndexes.add(pathMatcher.start());
            }
            int level = node.getLevel() - 1;
            block2: for (Integer splitCharIndex : splitCharIndexes) {
                String subBoomTreePathKey = bomTreePath.substring(0, splitCharIndex) + FIND_SUBNODE_STR + level;
                List<CalculationNode> parentNodes = calculationNodeMap.get(subBoomTreePathKey);
                if (CadEmptyUtils.isEmpty(parentNodes)) continue;
                for (CalculationNode parentNode : parentNodes) {
                    boolean isMatVersionAndAuxEquals = true;
                    if (node.getParentBomExpandNodeId() != 0L) {
                        boolean bl = isMatVersionAndAuxEquals = parentNode.getNodeId() == node.getParentBomExpandNodeId();
                    }
                    if (parentNode.isLeaf() || parentNode.getSubNodes().contains(node) || !isMatVersionAndAuxEquals) continue;
                    parentNode.getSubNodes().add(node);
                    continue block2;
                }
            }
        }
    }

    private boolean isSubNode(CalculationNode node1, CalculationNode node2) {
        if (!node1.isLeaf() && node1.getLevel() + 1 == node2.getLevel() && node2.getBomTreePath().startsWith(node1.getBomTreePath())) {
            if (!node1.getSubNodes().contains(node2)) {
                node1.getSubNodes().add(node2);
            }
            return true;
        }
        return false;
    }

    public void appendRow(CalculationNode node) {
        this.nodeList.add(node);
        if (node.getBomId() != 0L) {
            this.root = node;
        }
    }

    public List<CalculationNode> getNodeList() {
        return this.nodeList;
    }

    public CalculationNode getRoot() {
        return this.root;
    }

    public void toLog() {
        logger.info("Node ID\tBOM ID\t Material \t ParentBomId \tExpandBomId\tBOM TreeID\tBOM TreePath\tLevel\tIs Part\tIs Leaf\t\u6210\u54c1\u7387\t\u5206\u5b50\t\u5206\u6bcd\t");
        for (BOMExpandNode bOMExpandNode : this.getNodeList()) {
            logger.info(bOMExpandNode.toDebugLog());
        }
    }
}

