/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.IgnoreOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.cad.algox.BizLogger;
import kd.macc.cad.algox.Data.BOMExpandDataSet;
import kd.macc.cad.algox.Data.BOMExpandNode;
import kd.macc.cad.algox.Data.CheckResult;
import kd.macc.cad.algox.calc.checker.CheckerConstant;
import kd.macc.cad.algox.calc.helper.CalcCheckerHelper;
import kd.macc.cad.algox.calc.helper.CalcMutexHelper;
import kd.macc.cad.algox.calc.helper.CostTypeHelper;
import kd.macc.cad.algox.calc.helper.NewStdCalculateHelper;
import kd.macc.cad.algox.calc.helper.StandCalcCheckHelper;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.calc.helper.TaskServiceHelper;
import kd.macc.cad.algox.function.BOMExpand;
import kd.macc.cad.algox.function.NewFinishFunction;
import kd.macc.cad.algox.function.ProcessRouteCost;
import kd.macc.cad.algox.function.StandCostCalculationFunction;
import kd.macc.cad.algox.input.CalcStandCostCalcParam;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.lock.RedisBatchLock;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.DateUtils;

public class StandCostCalculateService {
    private static final Log logger = LogFactory.getLog(StandCostCalculateService.class);
    private BizLogger bizLogger = null;

    public void calculate(StandCostCalcParam standCostCalcParam) {
        this.bizLogger = new BizLogger();
        this.bizLogger.setTaskId(standCostCalcParam.getTaskId());
        this.bizLogger.setCostTypeId(standCostCalcParam.getCostTypeId());
        standCostCalcParam.setUseMatVersion(CostTypeHelper.isUseMatVersion(standCostCalcParam.getCostTypeId()));
        standCostCalcParam.setBizLogger(this.bizLogger);
        this.bizLogger.writeInfo(ResManager.loadKDString((String)"\u5377\u7b97", (String)"StandCostCalculateService_0", (String)"macc-cad-algox", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f00\u59cb\u8fdb\u884c\u5377\u7b97", (String)"StandCostCalculateService_1", (String)"macc-cad-algox", (Object[])new Object[0]));
        try {
            String noPassCheckItem;
            this.calculateInner(standCostCalcParam, standCostCalcParam.getCheckResult());
            if (standCostCalcParam.getScopetype() == 1 && !standCostCalcParam.isCalcCurLevel() && !CadEmptyUtils.isEmpty(noPassCheckItem = CalcCheckerHelper.getNoPassCheckItem(standCostCalcParam.getCostTypeId(), standCostCalcParam.getCheckTaskId(), null))) {
                return;
            }
            standCostCalcParam.setCheckResult(null);
            this.calculateForPurMaterial(standCostCalcParam);
        }
        catch (Exception exp) {
            logger.error("\u5377\u7b97\u51fa\u9519:" + exp.getMessage(), (Throwable)exp);
            this.bizLogger.writeError(ResManager.loadKDString((String)"\u5377\u7b97", (String)"StandCostCalculateService_0", (String)"macc-cad-algox", (Object[])new Object[0]), exp);
            throw exp;
        }
        finally {
            if (CadEmptyUtils.isEmpty(standCostCalcParam.getCheckType())) {
                TaskServiceHelper.updateProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getTaskId(), 100, 1);
                StdCalculateHelper.updateReport(standCostCalcParam);
            }
        }
    }

    public void calculateForStruct(StandCostCalcParam standCostCalcParam) {
        if (CadEmptyUtils.isEmpty(standCostCalcParam.getManuOrgConfigBomInfoJsStrList())) {
            return;
        }
        this.clearProcessRouterCost(standCostCalcParam);
        StdCalculateHelper.createReport(standCostCalcParam, ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7\u6210\u672c\u81ea\u52a8\u5377\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"StandCostCalculateService_10", (String)"macc-cad-algox", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7\u6210\u672c\u81ea\u52a8\u5377\u7b97", (String)"StandCostCalculateService_11", (String)"macc-cad-algox", (Object[])new Object[0]));
        StdCalculateHelper.updateRecordMatInfoBeforeCalc(standCostCalcParam.getTaskId(), standCostCalcParam.getCheckTaskId(), standCostCalcParam.getScopetype(), new HashSet<String>(standCostCalcParam.getWizardMatScopInfos()));
        this.bizLogger = new BizLogger();
        this.bizLogger.setTaskId(standCostCalcParam.getTaskId());
        this.bizLogger.setCostTypeId(standCostCalcParam.getCostTypeId());
        standCostCalcParam.setBizLogger(this.bizLogger);
        BOMExpand bomExpand = new BOMExpand();
        bomExpand.setStandCostCalcParam(standCostCalcParam);
        bomExpand.prepareDataForStruct();
        bomExpand.expand();
        BOMExpandDataSet dataSet = bomExpand.getBomExpandResult();
        StandCalcCheckHelper.doCheckForStruct(standCostCalcParam);
        standCostCalcParam.getWizardMatScopInfos().clear();
        ProcessRouteCost processRouteCost = new ProcessRouteCost();
        processRouteCost.setStandCostCalcParam(standCostCalcParam);
        processRouteCost.calcAllProcessRouteCostForStruct();
        standCostCalcParam.getRouterIdAndRouterObjMap().clear();
        int[] countArray = dataSet.countBomTree();
        int nonPartTreeCount = countArray[0];
        int partTreeCount = countArray[1];
        DataSet bomExpandDataSet = dataSet.toDataSet();
        try {
            if (bomExpandDataSet.isEmpty()) {
                return;
            }
            NewStdCalculateHelper.clearCalcResultForStruct(standCostCalcParam);
            this.bizLogger.writeInfo(ResManager.loadKDString((String)"\u5377\u7b97", (String)"StandCostCalculateService_0", (String)"macc-cad-algox", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6e05\u9664\u4e0a\u4e00\u6b21\u7ed3\u679c", (String)"StandCostCalculateService_2", (String)"macc-cad-algox", (Object[])new Object[0]));
            Map<Long, Set<Long>> partBomInTrees = dataSet.getPartBomInTrees();
            this.bizLogger.writeInfo(ResManager.loadKDString((String)"\u6784\u5efaBOM\u6811\u3001\u5d4c\u5957\u68c0\u67e5", (String)"StandCostCalculateService_3", (String)"macc-cad-algox", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u975e\u516c\u5171\u4ef6BOM\u6811%1$s\u4e2a\uff0c\u516c\u5171\u4ef6BOM\u6811%2$s\u4e2a", (String)"StandCostCalculateService_9", (String)"macc-cad-algox", (Object[])new Object[0]), nonPartTreeCount, partTreeCount));
            int bomTreeCount = nonPartTreeCount + partTreeCount;
            standCostCalcParam.getConfigBomInfoList().clear();
            standCostCalcParam.setLastBatchCalculate(true);
            HashSet<String> bomTreeRootIdWithByPro = new HashSet<String>(10);
            HashSet<String> onlyCalcBomTreeRootIds = new HashSet<String>(10);
            if (!CadEmptyUtils.isEmpty(standCostCalcParam.getCoByProductWithBom()) || !CadEmptyUtils.isEmpty(standCostCalcParam.getMatConfigCodeTrackNumMap().keySet())) {
                this.getBomTreeRootId(bomExpandDataSet.copy(), standCostCalcParam.getCoByProductWithBom(), standCostCalcParam.getMatConfigCodeTrackNumMap().keySet(), bomTreeRootIdWithByPro, onlyCalcBomTreeRootIds);
            }
            Set<Object> notNeedCalBomTreeRootId = new HashSet(10);
            if (standCostCalcParam.isCalcCurLevel()) {
                notNeedCalBomTreeRootId = this.getNotNeedCalBomTreeRootId(bomExpandDataSet.copy(), standCostCalcParam.getCheckFailMaterials());
            }
            onlyCalcBomTreeRootIds.removeAll(notNeedCalBomTreeRootId);
            bomTreeRootIdWithByPro.removeAll(notNeedCalBomTreeRootId);
            if (CadEmptyUtils.isEmpty(onlyCalcBomTreeRootIds)) {
                logger.info("\u9700\u8981\u5377\u7b97\u7684\u8ddf\u8e2a\u53f7\u7269\u6599\u6839\u8282\u70b9\u4e3a\u7a7a\uff0c\u7ed3\u675f\u8ba1\u7b97\u3002");
                return;
            }
            if (CadEmptyUtils.isEmpty(bomTreeRootIdWithByPro)) {
                bomExpandDataSet = bomExpandDataSet.filter("bomTreeRootId in (" + String.join((CharSequence)",", onlyCalcBomTreeRootIds) + ")");
                this.batchCalByBoomTreeDataSet(standCostCalcParam, partBomInTrees, processRouteCost, bomExpandDataSet);
            } else {
                DataSet bomExpandDataSetWithByPro = bomExpandDataSet.copy().filter("bomTreeRootId in (" + String.join((CharSequence)",", bomTreeRootIdWithByPro) + ")");
                bomExpandDataSet = bomExpandDataSet.copy().filter("bomTreeRootId in (" + String.join((CharSequence)",", onlyCalcBomTreeRootIds) + ")");
                if (!bomExpandDataSetWithByPro.isEmpty()) {
                    this.batchCalByBoomTreeDataSet(standCostCalcParam, partBomInTrees, processRouteCost, bomExpandDataSetWithByPro);
                }
                if (!bomExpandDataSet.isEmpty()) {
                    this.batchCalByBoomTreeDataSet(standCostCalcParam, partBomInTrees, processRouteCost, bomExpandDataSet);
                }
            }
            TaskServiceHelper.addProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getTaskId(), bomTreeCount);
        }
        catch (Exception exp) {
            logger.error("\u9500\u552e\u8ba2\u5355\u6210\u672c\u5377\u7b97\u51fa\u9519:" + exp.getMessage(), (Throwable)exp);
            this.bizLogger.writeError(ResManager.loadKDString((String)"\u5377\u7b97", (String)"StandCostCalculateService_0", (String)"macc-cad-algox", (Object[])new Object[0]), exp);
            throw exp;
        }
        finally {
            TaskServiceHelper.updateProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getTaskId(), 100, 1);
            StdCalculateHelper.updateReport(standCostCalcParam);
        }
    }

    public void calculateInner(StandCostCalcParam standCostCalcParam, CheckResult checkResult) {
        Map<Long, Set<Long>> partBomInTrees = null;
        this.clearProcessRouterCost(standCostCalcParam);
        ProcessRouteCost processRouteCost = new ProcessRouteCost();
        processRouteCost.setStandCostCalcParam(standCostCalcParam);
        processRouteCost.calcAllProcessRouteCost();
        standCostCalcParam.getRouterIdAndRouterObjMap().clear();
        TaskServiceHelper.addProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getTaskId(), 10);
        List<DataSet> checkDataSetCaches = null;
        if (checkResult == null) {
            CheckResult result = this.checkDataInner(standCostCalcParam);
            checkDataSetCaches = result.getCheckDataSetCaches();
            partBomInTrees = result.getPartBomInTrees();
        } else {
            checkDataSetCaches = checkResult.getCheckDataSetCaches();
            partBomInTrees = checkResult.getPartBomInTrees();
        }
        this.bizLogger.writeInfo(ResManager.loadKDString((String)"\u5377\u7b97", (String)"StandCostCalculateService_0", (String)"macc-cad-algox", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ece\u7f13\u5b58\u4e2d\u52a0\u8f7dBOM\u6811", (String)"StandCostCalculateService_7", (String)"macc-cad-algox", (Object[])new Object[0]));
        double percentPerEach = 70.0 / (double)checkDataSetCaches.size();
        if (checkDataSetCaches.size() > 0) {
            if (standCostCalcParam.isTrackCalc().booleanValue()) {
                NewStdCalculateHelper.clearCalcResultForStruct(standCostCalcParam);
            } else {
                NewStdCalculateHelper.clearCalcResult(standCostCalcParam);
            }
            this.bizLogger.writeInfo(ResManager.loadKDString((String)"\u5377\u7b97", (String)"StandCostCalculateService_0", (String)"macc-cad-algox", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6e05\u9664\u4e0a\u4e00\u6b21\u7ed3\u679c", (String)"StandCostCalculateService_2", (String)"macc-cad-algox", (Object[])new Object[0]));
        }
        int index = 1;
        logger.info("\u5377\u7b97\u5f00\u59cb");
        for (int cacheIndex = 0; cacheIndex < checkDataSetCaches.size(); ++cacheIndex) {
            logger.info("\u7b2c{}\u6279\u5377\u7b97\u5f00\u59cb", (Object)index);
            DataSet bomExpandDataSet = checkDataSetCaches.get(cacheIndex);
            if (bomExpandDataSet == null) continue;
            if (cacheIndex == checkDataSetCaches.size() - 1) {
                standCostCalcParam.setLastBatchCalculate(true);
            }
            long progressPercent = Math.round(percentPerEach * (double)(cacheIndex + 1));
            HashSet<String> bomTreeRootIdWithByPro = new HashSet<String>(10);
            HashSet<String> onlyCalcBomTreeRootIds = new HashSet<String>(10);
            if (!CadEmptyUtils.isEmpty(standCostCalcParam.getCoByProductWithBom()) || standCostCalcParam.isCalcCurLevel()) {
                this.getBomTreeRootId(bomExpandDataSet.copy(), standCostCalcParam.getCoByProductWithBom(), new HashSet<String>(standCostCalcParam.getKeycols()), bomTreeRootIdWithByPro, onlyCalcBomTreeRootIds);
            }
            Set<Object> notNeedCalBomTreeRootId = new HashSet(10);
            if (standCostCalcParam.isCalcCurLevel()) {
                notNeedCalBomTreeRootId = this.getNotNeedCalBomTreeRootId(bomExpandDataSet.copy(), standCostCalcParam.getCheckFailMaterials());
            }
            bomTreeRootIdWithByPro.removeAll(notNeedCalBomTreeRootId);
            if (CadEmptyUtils.isEmpty(bomTreeRootIdWithByPro)) {
                logger.info("\u7b2c{}\u6279\u5377\u7b97\uff0c\u6ca1\u6709\u6709BOM\u8bbe\u7f6e\u7684\u8054\u526f\u4ea7\u54c1", (Object)index);
                if (!CadEmptyUtils.isEmpty(notNeedCalBomTreeRootId)) {
                    bomExpandDataSet = bomExpandDataSet.filter("bomTreeRootId not in (" + String.join((CharSequence)",", notNeedCalBomTreeRootId) + ")");
                }
                if (!CadEmptyUtils.isEmpty(onlyCalcBomTreeRootIds)) {
                    bomExpandDataSet = bomExpandDataSet.filter("bomTreeRootId in (" + String.join((CharSequence)",", onlyCalcBomTreeRootIds) + ")");
                }
                this.batchCalByBoomTreeDataSet(standCostCalcParam, partBomInTrees, processRouteCost, bomExpandDataSet);
            } else {
                logger.info("\u7b2c{}\u6279\u5377\u7b97\uff0c\u5b58\u5728\u6709BOM\u8bbe\u7f6e\u7684\u8054\u526f\u4ea7\u54c1", (Object)index);
                DataSet bomExpandDataSetWithByPro = bomExpandDataSet.filter("bomTreeRootId in (" + String.join((CharSequence)",", bomTreeRootIdWithByPro) + ")");
                bomTreeRootIdWithByPro.addAll(notNeedCalBomTreeRootId);
                bomExpandDataSet = bomExpandDataSet.filter("bomTreeRootId not in (" + String.join((CharSequence)",", bomTreeRootIdWithByPro) + ")");
                if (!bomExpandDataSetWithByPro.isEmpty()) {
                    this.batchCalByBoomTreeDataSet(standCostCalcParam, partBomInTrees, processRouteCost, bomExpandDataSetWithByPro);
                }
                if (!CadEmptyUtils.isEmpty(onlyCalcBomTreeRootIds)) {
                    bomExpandDataSet = bomExpandDataSet.filter("bomTreeRootId in (" + String.join((CharSequence)",", onlyCalcBomTreeRootIds) + ")");
                }
                if (!bomExpandDataSet.isEmpty()) {
                    this.batchCalByBoomTreeDataSet(standCostCalcParam, partBomInTrees, processRouteCost, bomExpandDataSet);
                }
            }
            ++index;
            TaskServiceHelper.addProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getTaskId(), (int)progressPercent);
        }
        logger.info("\u5377\u7b97\u7ed3\u675f");
        TaskServiceHelper.updateProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getTaskId(), 95, 1);
    }

    private void getBomTreeRootId(DataSet bomExpandDataSet, List<String> coByProductWithBom, Set<String> matConfigKCsByTrack, Set<String> bomTreeRootIdWithByPro, Set<String> onlyCalcBomTreeRootIds) {
        String str;
        HashSet<String> keycols = new HashSet<String>(10);
        for (String s : coByProductWithBom) {
            str = "'" + s + "'";
            keycols.add(str);
        }
        for (String s : matConfigKCsByTrack) {
            str = "'" + s + "'";
            keycols.add(str);
        }
        if (CadEmptyUtils.isEmpty(keycols)) {
            return;
        }
        DataSet dataSet = bomExpandDataSet.filter("keycol in (" + String.join((CharSequence)",", keycols) + ")").select("keycol,bomTreeRootId");
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String keycol = row.getString("keycol");
            String bomTreeRootId = row.getString("bomTreeRootId");
            if (CadEmptyUtils.isEmpty(bomTreeRootId)) continue;
            if (bomTreeRootIdWithByPro != null && coByProductWithBom.contains(keycol)) {
                bomTreeRootIdWithByPro.add(bomTreeRootId);
                continue;
            }
            if (onlyCalcBomTreeRootIds == null) continue;
            onlyCalcBomTreeRootIds.add(bomTreeRootId);
        }
    }

    private Set<String> getNotNeedCalBomTreeRootId(DataSet bomExpandDataSet, Set<String> checkFailMaterials) {
        HashSet<String> notNeedCalBomTreeRootId = new HashSet<String>(10);
        if (CadEmptyUtils.isEmpty(checkFailMaterials)) {
            return notNeedCalBomTreeRootId;
        }
        HashSet<String> keycols = new HashSet<String>(10);
        for (String s : checkFailMaterials) {
            String str = "'" + s + "'";
            keycols.add(str);
        }
        DataSet dataSet = bomExpandDataSet.filter("keycol in (" + String.join((CharSequence)",", keycols) + ")").select("bomTreeRootId");
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String bomTreeRootId = row.getString("bomTreeRootId");
            if (CadEmptyUtils.isEmpty(bomTreeRootId)) continue;
            notNeedCalBomTreeRootId.add(bomTreeRootId);
        }
        return notNeedCalBomTreeRootId;
    }

    private void batchCalByBoomTreeDataSet(StandCostCalcParam standCostCalcParam, Map<Long, Set<Long>> partBomInTrees, ProcessRouteCost processRouteCost, DataSet bomExpandDataSet) {
        JobSession session = AlgoX.createSession((String)"kd.macc.cad.algox.StandCostCal.calculate");
        DataSetInput bomExpandInput = new DataSetInput(bomExpandDataSet);
        DataSetX fullDs = session.fromInput((Input)bomExpandInput);
        Object batch = StdCalculateHelper.getParamValue("batch");
        int writeToDBBatch = batch == null ? 500 : Integer.parseInt(String.valueOf(batch));
        CalcStandCostCalcParam calcStandCostCalcParam = this.buildCalcParam(standCostCalcParam);
        logger.info("2.\u8ba1\u7b97\u975e\u516c\u5171\u4ef6\uff0c\u5305\u62ec\u516c\u5171\u4ef6");
        StandCostCalculationFunction fun2NonPart = new StandCostCalculationFunction();
        fun2NonPart.setProcessRouteCost(processRouteCost);
        fun2NonPart.setStandCostCalcParam(calcStandCostCalcParam);
        fun2NonPart.setOutputType(StandCostCalculationFunction.OutputType.ToDB);
        fun2NonPart.setPartBomInTrees(partBomInTrees);
        fun2NonPart.setWriteToDBBatch(writeToDBBatch);
        DataSetX mainDs = fullDs.groupBy(new String[]{"bomTreeRootId"}).reduceGroup((GroupReduceFunction)fun2NonPart);
        NewFinishFunction finishFunction = new NewFinishFunction();
        finishFunction.setStandCostCalcParam(calcStandCostCalcParam);
        mainDs = mainDs.reduceGroup((GroupReduceFunction)finishFunction);
        mainDs.output((Output)new IgnoreOutput());
        session.commit(5, TimeUnit.HOURS);
        if (standCostCalcParam.isLastBatchCalculate()) {
            finishFunction.dealFinalResult();
        }
    }

    public CheckResult checkData(StandCostCalcParam standCostCalcParam) {
        return this.checkDataInner(standCostCalcParam);
    }

    private CheckResult checkDataInner(StandCostCalcParam standCostCalcParam) {
        BOMExpand bomExpand = new BOMExpand();
        bomExpand.setStandCostCalcParam(standCostCalcParam);
        bomExpand.prepareData();
        bomExpand.prepareBomData(standCostCalcParam);
        bomExpand.expand();
        BOMExpandDataSet bomExpandDataSet = bomExpand.getBomExpandResult();
        CheckResult result = new CheckResult();
        this.toCachedDataSetByBoomTreeId(result, bomExpandDataSet);
        bomExpand.clear();
        bomExpand.preparePriceData(standCostCalcParam);
        bomExpand.prepareRouteData(standCostCalcParam);
        bomExpand.clear();
        return result;
    }

    private void toCachedDataSetByBoomTreeId(CheckResult result, BOMExpandDataSet bomExpandDataSet) {
        Map<Long, List<BOMExpandNode>> bomTreeIdAndNodesMap = bomExpandDataSet.getNodeList().stream().collect(Collectors.groupingBy(BOMExpandNode::getBomTreeRootId));
        DynamicObjectCollection batchCalcSizes = QueryServiceHelper.query((String)"cad_stdcalbatchsizeparam", (String)"batchsize", (QFilter[])new QFilter[]{new QFilter("batchsize", "!=", (Object)0)});
        result.setCheckDataSetCaches(Lists.newArrayList());
        int batchCalcSize = 500000;
        if (!CadEmptyUtils.isEmpty(batchCalcSizes)) {
            batchCalcSize = ((DynamicObject)batchCalcSizes.get(0)).getInt("batchsize");
        }
        int index = 0;
        ArrayList<BOMExpandNode> batchBomExpandNodes = new ArrayList<BOMExpandNode>(10);
        int boomTreeSize = bomTreeIdAndNodesMap.size();
        int batchCalcBoomTreeSize = 0;
        for (Map.Entry<Long, List<BOMExpandNode>> entry : bomTreeIdAndNodesMap.entrySet()) {
            boolean isNotFirstAndLastBomTree;
            ++batchCalcBoomTreeSize;
            List<BOMExpandNode> bomExpandNodes = entry.getValue();
            boolean isFirstBomTree = ++index == 1;
            boolean isNotLastBomTree = index != boomTreeSize;
            boolean bl = isNotFirstAndLastBomTree = index != 1 && isNotLastBomTree;
            if (isFirstBomTree && isNotLastBomTree) {
                batchBomExpandNodes.addAll(bomExpandNodes);
            }
            int nextBatchBomExpandNodesSize = batchBomExpandNodes.size() + bomExpandNodes.size();
            if (isNotFirstAndLastBomTree && nextBatchBomExpandNodesSize < batchCalcSize) {
                batchBomExpandNodes.addAll(bomExpandNodes);
            }
            if (isNotFirstAndLastBomTree && nextBatchBomExpandNodesSize >= batchCalcSize) {
                batchBomExpandNodes.addAll(bomExpandNodes);
                logger.info(String.format("\u6309%s\u68f5BOM\u6811\u8fdb\u884c\u6279\u6b21\u5377\u7b97\uff0c\u5377\u7b97\u7684\u7269\u6599\u603b\u6570\u4e3a\uff1a%s\u4e2a", batchCalcBoomTreeSize, batchBomExpandNodes.size()));
                result.getCheckDataSetCaches().add(bomExpandDataSet.toCacheDataSet(batchBomExpandNodes));
                batchBomExpandNodes.clear();
                batchCalcBoomTreeSize = 0;
            }
            if (index != bomTreeIdAndNodesMap.size()) continue;
            batchBomExpandNodes.addAll(bomExpandNodes);
            logger.info(String.format("\u6309%s\u68f5BOM\u6811\u8fdb\u884c\u6279\u6b21\u5377\u7b97\uff0c\u5377\u7b97\u7684\u7269\u6599\u603b\u6570\u4e3a\uff1a%s\u4e2a", batchCalcBoomTreeSize, batchBomExpandNodes.size()));
            result.getCheckDataSetCaches().add(bomExpandDataSet.toCacheDataSet(batchBomExpandNodes));
            batchCalcBoomTreeSize = 0;
        }
    }

    private void matIdsToCache(StandCostCalcParam standCostCalcParam, CheckResult result, BOMExpandDataSet bomExpandDataSet) {
        List<BOMExpandNode> nodeList = bomExpandDataSet.getNodeList();
        if (CadEmptyUtils.isEmpty(nodeList)) {
            return;
        }
        Set materialIds = nodeList.stream().map(item -> item.getMaterial().getKeycol()).collect(Collectors.toSet());
        if (standCostCalcParam.getScopetype() == 1) {
            standCostCalcParam.getParams().put("specifyMaterialIds", materialIds);
        }
    }

    private void clearProcessRouterCost(StandCostCalcParam standCostCalcParam) {
        QFilter timeFilter = new QFilter("createtime", "<", (Object)DateUtils.getPreSeveralBeginDay((Date)TimeServiceHelper.now(), (int)2));
        DeleteServiceHelper.delete((String)"cad_calprocessroutecost", (QFilter[])new QFilter[]{timeFilter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void doCheckCalculate(StandCostCalcParam standCostCalcParam) {
        block21: {
            block15: {
                block13: {
                    block20: {
                        block14: {
                            block11: {
                                block19: {
                                    block12: {
                                        block9: {
                                            block18: {
                                                block10: {
                                                    this.bizLogger = new BizLogger();
                                                    standCostCalcParam.setUseMatVersion(CostTypeHelper.isUseMatVersion(standCostCalcParam.getCostTypeId()));
                                                    StdCalculateHelper.createReport(standCostCalcParam, ResManager.loadKDString((String)"\u5377\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"StandCostCalculateService_8", (String)"macc-cad-algox", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5377\u7b97", (String)"StandCostCalculateService_0", (String)"macc-cad-algox", (Object[])new Object[0]));
                                                    StdCalculateHelper.beforeCalc(standCostCalcParam, this.bizLogger);
                                                    StandCalcCheckHelper.doCheck(standCostCalcParam);
                                                    if (!standCostCalcParam.isCalcCurLevel()) ** GOTO lbl40
                                                    affectAllCheckItems = Lists.newArrayList((Object[])new Long[]{CheckerConstant.SCA_COSTTYPEREFCOSTUPDATEBILL_ITME, CheckerConstant.ACA_COSTTYPEREFCOSTUPDATEBILL_ITME, CheckerConstant.SCA_DIRECTRANKCODECYCLE_ITME, CheckerConstant.ACA_DIRECTRANKCODECYCLE_ITME, CheckerConstant.SCA_RECORDCASE_ITME, CheckerConstant.ACA_RECORDCASE_ITME});
                                                    noPassCheckItem = CalcCheckerHelper.getNoPassCheckItem(standCostCalcParam.getCostTypeId(), standCostCalcParam.getCheckTaskId(), affectAllCheckItems);
                                                    if (!standCostCalcParam.isTrackCalc().booleanValue() && standCostCalcParam.isExecutByProductsStdCostChecker() || CadEmptyUtils.isEmpty(noPassCheckItem)) break block9;
                                                    standCostCalcParam.getBizLogger().writeError(ResManager.loadKDString((String)"\u5377\u7b97\u5931\u8d25", (String)"StandCostCalculateService_12", (String)"macc-cad-algox", (Object[])new Object[0]), (Exception)new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u68c0\u67e5\u9879\uff1a%s\u3002", (String)"StandCostCalculateService_13", (String)"macc-cad-algox", (Object[])new Object[0]), new Object[]{noPassCheckItem})));
                                                    TaskServiceHelper.updateProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getTaskId(), 100, 2);
                                                    if (standCostCalcParam.getScopetype() != 0 && (standCostCalcParam.isCalcCurLevel() || standCostCalcParam.isTrackCalc().booleanValue())) break block10;
                                                    CalcMutexHelper.releaseXMutex("stdcalc", (Set<Long>)new HashSet<Long>(standCostCalcParam){
                                                        final /* synthetic */ StandCostCalcParam val$standCostCalcParam;
                                                        {
                                                            this.val$standCostCalcParam = standCostCalcParam;
                                                            this.add(this.val$standCostCalcParam.getCostTypeId());
                                                        }
                                                    });
                                                    break block18;
                                                }
                                                redisBatchLock = new RedisBatchLock("stdcalc", standCostCalcParam.getCostTypeId(), new HashSet<String>(standCostCalcParam.getKeycols()), standCostCalcParam.getAppNum());
                                                redisBatchLock.unlock(new HashSet<String>(standCostCalcParam.getKeycols()));
                                            }
                                            StdCalculateHelper.updateReport(standCostCalcParam);
                                            return;
                                        }
                                        if (!CadEmptyUtils.isEmpty(standCostCalcParam.getCheckSuccessProducts())) break block11;
                                        TaskServiceHelper.updateProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getTaskId(), 100, 2);
                                        if (standCostCalcParam.getScopetype() != 0 && (standCostCalcParam.isCalcCurLevel() || standCostCalcParam.isTrackCalc().booleanValue())) break block12;
                                        CalcMutexHelper.releaseXMutex("stdcalc", (Set<Long>)new /* invalid duplicate definition of identical inner class */);
                                        break block19;
                                    }
                                    redisBatchLock = new RedisBatchLock("stdcalc", standCostCalcParam.getCostTypeId(), new HashSet<String>(standCostCalcParam.getKeycols()), standCostCalcParam.getAppNum());
                                    redisBatchLock.unlock(new HashSet<String>(standCostCalcParam.getKeycols()));
                                }
                                StdCalculateHelper.updateReport(standCostCalcParam);
                                return;
                            }
                            break block13;
lbl40:
                            // 1 sources

                            noPassCheckItem = CalcCheckerHelper.getNoPassCheckItem(standCostCalcParam.getCostTypeId(), standCostCalcParam.getCheckTaskId(), null);
                            if (!standCostCalcParam.isTrackCalc().booleanValue() && standCostCalcParam.isExecutByProductsStdCostChecker() || CadEmptyUtils.isEmpty(noPassCheckItem)) break block13;
                            standCostCalcParam.getBizLogger().writeError(ResManager.loadKDString((String)"\u5377\u7b97\u5931\u8d25", (String)"StandCostCalculateService_12", (String)"macc-cad-algox", (Object[])new Object[0]), (Exception)new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u68c0\u67e5\u9879\uff1a%s\u3002", (String)"StandCostCalculateService_13", (String)"macc-cad-algox", (Object[])new Object[0]), new Object[]{noPassCheckItem})));
                            TaskServiceHelper.updateProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getTaskId(), 100, 2);
                            if (standCostCalcParam.getScopetype() != 0 && (standCostCalcParam.isCalcCurLevel() || standCostCalcParam.isTrackCalc().booleanValue())) break block14;
                            CalcMutexHelper.releaseXMutex("stdcalc", (Set<Long>)new /* invalid duplicate definition of identical inner class */);
                            break block20;
                        }
                        redisBatchLock = new RedisBatchLock("stdcalc", standCostCalcParam.getCostTypeId(), new HashSet<String>(standCostCalcParam.getKeycols()), standCostCalcParam.getAppNum());
                        redisBatchLock.unlock(new HashSet<String>(standCostCalcParam.getKeycols()));
                    }
                    StdCalculateHelper.updateReport(standCostCalcParam);
                    return;
                }
                try {
                    standCostCalcParam.getConfigBomInfoList().clear();
                    standCostCalcParam.getWizardMatScopInfos().clear();
                    this.calculate(standCostCalcParam);
                    TaskServiceHelper.updateProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getTaskId(), 100, 1);
                    if (standCostCalcParam.getScopetype() != 0 && (standCostCalcParam.isCalcCurLevel() || standCostCalcParam.isTrackCalc().booleanValue())) break block15;
                }
                catch (Exception e) {
                    block22: {
                        block16: {
                            try {
                                TaskServiceHelper.updateProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getTaskId(), 100, 2);
                                StandCostCalculateService.logger.error((Throwable)e);
                                this.bizLogger.writeError(ResManager.loadKDString((String)"\u5377\u7b97\u5931\u8d25", (String)"StandCostCalculateService_12", (String)"macc-cad-algox", (Object[])new Object[0]), e);
                                if (standCostCalcParam.getScopetype() != 0 && (standCostCalcParam.isCalcCurLevel() || standCostCalcParam.isTrackCalc().booleanValue())) break block16;
                            }
                            catch (Throwable var5_9) {
                                if (standCostCalcParam.getScopetype() == 0 || !standCostCalcParam.isCalcCurLevel() && !standCostCalcParam.isTrackCalc().booleanValue()) {
                                    CalcMutexHelper.releaseXMutex("stdcalc", (Set<Long>)new /* invalid duplicate definition of identical inner class */);
                                } else {
                                    redisBatchLock = new RedisBatchLock("stdcalc", standCostCalcParam.getCostTypeId(), new HashSet<String>(standCostCalcParam.getKeycols()), standCostCalcParam.getAppNum());
                                    redisBatchLock.unlock(new HashSet<String>(standCostCalcParam.getKeycols()));
                                }
                                StdCalculateHelper.updateReport(standCostCalcParam);
                                throw var5_9;
                            }
                            CalcMutexHelper.releaseXMutex("stdcalc", (Set<Long>)new /* invalid duplicate definition of identical inner class */);
                            break block22;
                        }
                        redisBatchLock = new RedisBatchLock("stdcalc", standCostCalcParam.getCostTypeId(), new HashSet<String>(standCostCalcParam.getKeycols()), standCostCalcParam.getAppNum());
                        redisBatchLock.unlock(new HashSet<String>(standCostCalcParam.getKeycols()));
                    }
                    StdCalculateHelper.updateReport(standCostCalcParam);
                }
                CalcMutexHelper.releaseXMutex("stdcalc", (Set<Long>)new /* invalid duplicate definition of identical inner class */);
                break block21;
            }
            redisBatchLock = new RedisBatchLock("stdcalc", standCostCalcParam.getCostTypeId(), new HashSet<String>(standCostCalcParam.getKeycols()), standCostCalcParam.getAppNum());
            redisBatchLock.unlock(new HashSet<String>(standCostCalcParam.getKeycols()));
        }
        StdCalculateHelper.updateReport(standCostCalcParam);
    }

    public void calculateForPurMaterial(StandCostCalcParam standCostCalcParam) {
        if (CadEmptyUtils.isEmpty(standCostCalcParam.getCalcPurMaterials())) {
            return;
        }
        TaskServiceHelper.addProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getTaskId(), 5);
        try {
            QFilter recordFilter;
            logger.error("\u5916\u8d2d\u4ef6\u5377\u7b97\uff1a\u6e05\u9664\u4e0a\u4e00\u6b21\u7ed3\u679c");
            QFilter costtypeFilter = new QFilter("costtype", "=", (Object)standCostCalcParam.getCostTypeId());
            QFilter purKCFilter = new QFilter("keycol", "in", standCostCalcParam.getCalcPurMaterials());
            if (standCostCalcParam.isSaveRecord().booleanValue()) {
                recordFilter = new QFilter("calcrecord.name", "=", (Object)standCostCalcParam.getRecordName());
                DeleteServiceHelper.delete((String)"cad_calcpurprices", (QFilter[])new QFilter[]{costtypeFilter, recordFilter, purKCFilter});
                recordFilter = new QFilter("name", "=", (Object)standCostCalcParam.getRecordName());
                DeleteServiceHelper.delete((String)"cad_stdcalcrecord", (QFilter[])new QFilter[]{costtypeFilter, recordFilter, purKCFilter});
            } else {
                recordFilter = new QFilter("calcrecord", "is null", null);
                recordFilter.or(new QFilter("calcrecord", "<=", (Object)0L));
                DeleteServiceHelper.delete((String)"cad_calcpurprices", (QFilter[])new QFilter[]{costtypeFilter, recordFilter, purKCFilter});
            }
            this.bizLogger.writeInfo(ResManager.loadKDString((String)"\u5916\u8d2d\u4ef6\u5377\u7b97", (String)"StandCostCalculateService_14", (String)"macc-cad-algox", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6e05\u9664\u4e0a\u4e00\u6b21\u7ed3\u679c", (String)"StandCostCalculateService_2", (String)"macc-cad-algox", (Object[])new Object[0]));
            String selectPurFields = "id,costtype,billno,currency,datasrc,material,matversion,auxpty,lot,configuredcode,tracknumber,project,pricerule,amount,keycol,keycolid,entryentity.element,entryentity.subelement,entryentity.price,entryentity.rate";
            List<Long> purPriceObjIds = StdCalculateHelper.getPurPriceObjIds(standCostCalcParam.getCostTypeId(), standCostCalcParam.getHsCostTypeId(), standCostCalcParam.getCustomSuppliedMaterials(), standCostCalcParam.getPriceRuleScheme(), standCostCalcParam.getCalcDate(), standCostCalcParam.getPurMatCostInfoMap());
            int calcPurPriceBatchSize = CadBgParamUtils.getCadParamForInt((String)"calcPurPriceBatchSize", (int)200000);
            for (List purPriceObjIdList : Lists.partition(purPriceObjIds, (int)calcPurPriceBatchSize)) {
                QFilter filter = new QFilter("id", "in", (Object)purPriceObjIdList);
                filter.and(new QFilter("keycol", "in", standCostCalcParam.getCalcPurMaterials()));
                Object[] purPrices = BusinessDataServiceHelper.load((String)"cad_purprices", (String)selectPurFields, (QFilter[])new QFilter[]{filter});
                if (CadEmptyUtils.isEmpty(purPrices)) continue;
                logger.error("\u5916\u8d2d\u4ef6\u5377\u7b97\uff1a\u5199\u7ed3\u679c\u8868");
                StdCalculateHelper.writeToCalcPurPrices(standCostCalcParam, (DynamicObject[])purPrices);
                logger.error("\u5916\u8d2d\u4ef6\u5377\u7b97\uff1a\u5199\u7269\u6599\u6210\u672c\u4fe1\u606f");
                StdCalculateHelper.writeToMatCostInfo(standCostCalcParam.getCostTypeId(), new ArrayList<String>(standCostCalcParam.getCalcPurMaterials()), (DynamicObject[])purPrices, Boolean.FALSE);
            }
            this.bizLogger.writeInfo(ResManager.loadKDString((String)"\u5916\u8d2d\u4ef6\u5377\u7b97", (String)"StandCostCalculateService_14", (String)"macc-cad-algox", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b8c\u6210", (String)"StandCostCalculateService_15", (String)"macc-cad-algox", (Object[])new Object[0]));
        }
        catch (Exception exp) {
            logger.error("\u5916\u8d2d\u4ef6\u6210\u672c\u5377\u7b97\u51fa\u9519:" + exp.getMessage(), (Throwable)exp);
            this.bizLogger.writeError(ResManager.loadKDString((String)"\u5916\u8d2d\u4ef6\u5377\u7b97", (String)"StandCostCalculateService_14", (String)"macc-cad-algox", (Object[])new Object[0]), exp);
            throw exp;
        }
        finally {
            TaskServiceHelper.updateProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getTaskId(), 100, 1);
            StdCalculateHelper.updateReport(standCostCalcParam);
        }
    }

    public void calculateForPurMaterial(Long costTypeId, List<Long> purPriceObjIds, Date calcDate, String entity) {
        if (CadEmptyUtils.isEmpty(purPriceObjIds)) {
            return;
        }
        try {
            Object[] purPrices;
            Long taskId = DB.genGlobalLongId();
            String selectPurFields = "id,costtype,billno,datasrc,currency,material,auxpty,lot,configuredcode,tracknumber,project,pricerule,amount,keycol,keycolid,entryentity.element,entryentity.subelement,entryentity.price,entryentity.rate";
            if ("cad_batmodifyprice".equals(entity)) {
                selectPurFields = "id,costtype,datasrc,currency,material,auxpty,lot,configuredcode,tracknumber,project,pricerule,amount,keycol,keycolid,entryentity.element,entryentity.subelement,entryentity.price";
            }
            if (CadEmptyUtils.isEmpty(purPrices = BusinessDataServiceHelper.load((String)entity, (String)selectPurFields, (QFilter[])new QFilter[]{new QFilter("id", "in", purPriceObjIds)}))) {
                return;
            }
            ArrayList<String> purPricesMatKc = new ArrayList<String>(10);
            for (Object purPrice : purPrices) {
                purPricesMatKc.add(purPrice.getString("keycol"));
            }
            logger.error("\u5916\u8d2d\u4ef6\u6210\u672c\u5377\u7b97\uff1a\u6e05\u9664\u4e0a\u4e00\u6b21\u7ed3\u679c");
            StdCalculateHelper.clearCalcPurPricesResult(costTypeId, purPricesMatKc);
            logger.error("\u5916\u8d2d\u4ef6\u6210\u672c\u5377\u7b97\uff1a\u5199\u7ed3\u679c\u8868");
            StdCalculateHelper.writeToCalcPurPrices(calcDate, taskId, (DynamicObject[])purPrices);
            logger.error("\u5916\u8d2d\u4ef6\u6210\u672c\u5377\u7b97\uff1a\u5199\u7269\u6599\u6210\u672c\u4fe1\u606f");
            StdCalculateHelper.writeToMatCostInfo(costTypeId, purPricesMatKc, (DynamicObject[])purPrices, Boolean.TRUE);
        }
        catch (Exception exp) {
            logger.error("\u5916\u8d2d\u4ef6\u6210\u672c\u5377\u7b97\u51fa\u9519:" + exp.getMessage(), (Throwable)exp);
            throw exp;
        }
    }

    private CalcStandCostCalcParam buildCalcParam(StandCostCalcParam standCostCalcParam) {
        CalcStandCostCalcParam calcStandCostCalcParam = new CalcStandCostCalcParam();
        calcStandCostCalcParam.setCostTypeId(standCostCalcParam.getCostTypeId());
        calcStandCostCalcParam.setHsCostTypeId(standCostCalcParam.getHsCostTypeId());
        calcStandCostCalcParam.setCalcDate(standCostCalcParam.getCalcDate());
        calcStandCostCalcParam.setTaskId(standCostCalcParam.getTaskId());
        calcStandCostCalcParam.setCheckTaskId(standCostCalcParam.getCheckTaskId());
        calcStandCostCalcParam.setScopetype(standCostCalcParam.getScopetype());
        calcStandCostCalcParam.setPriceRuleScheme(standCostCalcParam.getPriceRuleScheme());
        calcStandCostCalcParam.setCalcCurLevel(standCostCalcParam.isCalcCurLevel());
        calcStandCostCalcParam.setBomRuleSetting(standCostCalcParam.getBomRuleSetting());
        calcStandCostCalcParam.setTrackCalc(standCostCalcParam.isTrackCalc());
        calcStandCostCalcParam.setStartBomRuleCalc(standCostCalcParam.isStartBomRuleCalc());
        calcStandCostCalcParam.setStartRouteRuleCalc(standCostCalcParam.isStartRouteRuleCalc());
        calcStandCostCalcParam.setDebug(standCostCalcParam.isDebug());
        calcStandCostCalcParam.setBizLogger(standCostCalcParam.getBizLogger());
        calcStandCostCalcParam.setSaveRecord(standCostCalcParam.isSaveRecord());
        calcStandCostCalcParam.setRecordCount(standCostCalcParam.getRecordCount());
        calcStandCostCalcParam.setRecordName(standCostCalcParam.getRecordName());
        calcStandCostCalcParam.setAutoReplaceRecord(standCostCalcParam.isAutoReplaceRecord());
        calcStandCostCalcParam.setCoByMaterialKeycols(standCostCalcParam.getCoByMaterialKeycols());
        calcStandCostCalcParam.setKeycols(standCostCalcParam.getKeycols());
        calcStandCostCalcParam.setExecutByProductsStdCostChecker(standCostCalcParam.isExecutByProductsStdCostChecker());
        calcStandCostCalcParam.setCoByProductWithBom(standCostCalcParam.getCoByProductWithBom());
        calcStandCostCalcParam.setLastBatchCalculate(standCostCalcParam.isLastBatchCalculate());
        calcStandCostCalcParam.setMainAndCoByProductWithBomMap(standCostCalcParam.getMainAndCoByProductWithBomMap());
        calcStandCostCalcParam.setMatConfigCodeTrackNumMap(standCostCalcParam.getMatConfigCodeTrackNumMap());
        calcStandCostCalcParam.setOutPriceObjIds(standCostCalcParam.getOutPriceObjIds());
        calcStandCostCalcParam.setPriceprecision(standCostCalcParam.getPriceprecision());
        calcStandCostCalcParam.setPruPriceObjIds(standCostCalcParam.getPruPriceObjIds());
        calcStandCostCalcParam.setUseMatVersion(standCostCalcParam.isUseMatVersion());
        calcStandCostCalcParam.setPurMatCostInfoMap(standCostCalcParam.getPurMatCostInfoMap());
        calcStandCostCalcParam.setCustomSuppliedMaterials(standCostCalcParam.getCustomSuppliedMaterials());
        calcStandCostCalcParam.setMainAndCoByProductWithOutBomMap(standCostCalcParam.getMainAndCoByProductWithOutBomMap());
        calcStandCostCalcParam.setMainAndCoByProductWithPurPriceMap(standCostCalcParam.getMainAndCoByProductWithPurPriceMap());
        calcStandCostCalcParam.setResourcePriceRuleMap(standCostCalcParam.getResourcePriceRuleMap());
        calcStandCostCalcParam.setResourcePriceIdMap(standCostCalcParam.getResourcePriceIdMap());
        calcStandCostCalcParam.setAppNum(standCostCalcParam.getAppNum());
        calcStandCostCalcParam.setVirtualMaterials(standCostCalcParam.getVirtualMaterials());
        calcStandCostCalcParam.setDefaultConfigKeycols(standCostCalcParam.getDefaultConfigKeycols());
        calcStandCostCalcParam.setCheckSuccessProducts(standCostCalcParam.getCheckSuccessProducts());
        calcStandCostCalcParam.setBomIdSet(standCostCalcParam.getBomIdSet());
        return calcStandCostCalcParam;
    }
}

