/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc;

import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.algox.BizLogger;
import kd.macc.cad.algox.calc.CalcTask;
import kd.macc.cad.algox.calc.helper.StandCalcCheckHelper;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.calc.helper.TaskServiceHelper;
import kd.macc.cad.algox.input.StandCostCalcParam;

public class CalcCheckTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(CalcTask.class);
    private BizLogger bizLogger = null;
    private RequestContext rc;
    private StandCostCalcParam standCostCalcParam;

    public CalcCheckTask(RequestContext rc, String pageId, StandCostCalcParam standCostCalcParam) {
        this.rc = rc;
        this.standCostCalcParam = standCostCalcParam;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        this.doTask();
    }

    private void doTask() {
        try {
            this.bizLogger = new BizLogger();
            TaskServiceHelper.addProgress(this.standCostCalcParam.getCostTypeId(), this.standCostCalcParam.getTaskId(), 5);
            StdCalculateHelper.beforeCalc(this.standCostCalcParam, this.bizLogger);
            StandCalcCheckHelper.doCheck(this.standCostCalcParam);
        }
        catch (Exception e) {
            TaskServiceHelper.updateProgress(this.standCostCalcParam.getCostTypeId(), this.standCostCalcParam.getTaskId(), 100, 2);
            logger.error("\u8c03\u7528\u5408\u6cd5\u6027\u68c0\u67e5\u9519\u8bef\u3002", (Throwable)e);
        }
        finally {
            StdCalculateHelper.updateReport(this.standCostCalcParam);
        }
    }
}

