/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.checker;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.calc.helper.BomRuleSettingStdCalcHelper;
import kd.macc.cad.algox.calc.helper.StandCalcCheckHelper;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.calc.pojo.ConfigBomInfo;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;

public class BomSettingForJumpLevelChecker
extends AbstractSingleCalcCheckAction {
    private String algokey = "kd.macc.cad.algox.calc.checker.BomSettingForJumpLevelChecker";

    public void doCheck() {
        CalcCheckContext context = this.getContext();
        if (context.getParams().get("standCostCalcParam") == null) {
            return;
        }
        StandCostCalcParam standCostCalcParam = (StandCostCalcParam)this.getContext().getParams().get("standCostCalcParam");
        List<ConfigBomInfo> configBomInfoList = standCostCalcParam.getConfigBomInfoList();
        HashSet<String> virtualKeycols = new HashSet<String>(10);
        HashMap<String, Set<Long>> configBomKeycolPidsMap = new HashMap<String, Set<Long>>(16);
        HashMap<Long, ConfigBomInfo> idConfigBomMap = new HashMap<Long, ConfigBomInfo>(16);
        for (ConfigBomInfo configBomInfo : configBomInfoList) {
            if (configBomInfo.isVirtual().booleanValue()) {
                virtualKeycols.add(configBomInfo.getKeycol());
            }
            Set parentIds = configBomKeycolPidsMap.computeIfAbsent(configBomInfo.getKeycol(), p -> new HashSet());
            if (configBomInfo.getPid() != 0L) {
                parentIds.add(configBomInfo.getPid());
            }
            if (configBomInfo.getPid() != 0L) continue;
            idConfigBomMap.put(configBomInfo.getId(), configBomInfo);
        }
        if (CadEmptyUtils.isEmpty(virtualKeycols)) {
            return;
        }
        DataSet jumpLevelMatDataSet = this.getJumpLevelMatDataSet(virtualKeycols);
        if (standCostCalcParam.isStartBomRuleCalc().booleanValue()) {
            DynamicObject bomRuleSettingObj = StdCalculateHelper.getBomRuleSettingObj(standCostCalcParam.getBomRuleSetting());
            String srcBomEntity = bomRuleSettingObj.getString("srcbom");
            Set<Long> bomIdSet = standCostCalcParam.getBomIdSet();
            DataSet virtualMatBomDataSet = this.getVirtualMatBomDataSet(srcBomEntity, bomIdSet);
            DataSet keyColDataSetBySpecifyMat = BomRuleSettingStdCalcHelper.getBomMatDataSetByKeyCol(standCostCalcParam.getVirtualMaterials());
            Set<String> jumpLevelMat = this.getJumpLevelMatNew(jumpLevelMatDataSet, virtualMatBomDataSet = virtualMatBomDataSet.join(keyColDataSetBySpecifyMat, JoinType.INNER).on("material", "material").on("auxproperty", "auxproperty").on("configuredcode", "configuredcode").select(virtualMatBomDataSet.getRowMeta().getFieldNames()).finish());
            if (CadEmptyUtils.isEmpty(jumpLevelMat)) {
                return;
            }
            DataSet bomDataSet = this.getBomsNew(srcBomEntity, bomIdSet, jumpLevelMat);
            String error = ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\u201d\u5728\u6210\u672cBOM\u201c\u7f16\u7801\uff1a%3$s\u201d\u7ef4\u62a4\u4e86\u8df3\u5c42\uff0c\u672a\u83b7\u53d6\u5230\u6210\u672cBOM\u3002", (String)"BomSettingForJumpLevelChecker_3", (String)"macc-cad-algox", (Object[])new Object[0]);
            if ("pdm_mftbom".equals(srcBomEntity)) {
                error = ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\u201d\u5728\u5236\u9020BOM\u201c\u7f16\u7801\uff1a%3$s\u201d\u7ef4\u62a4\u4e86\u8df3\u5c42\uff0c\u672a\u83b7\u53d6\u5230\u5236\u9020BOM\u3002", (String)"BomSettingForJumpLevelChecker_4", (String)"macc-cad-algox", (Object[])new Object[0]);
            }
            if (bomDataSet.isEmpty()) {
                return;
            }
            while (bomDataSet.hasNext()) {
                Row row = bomDataSet.next();
                if (row == null) continue;
                CalcCheckDetailResultInfo detailinfo = new CalcCheckDetailResultInfo();
                detailinfo.setCheckDetailResult(String.format(error, row.getString("materialnumber"), row.getString("materialname"), row.getString("bomnumber")));
                this.getSingleCheckContext().getCheckDetailResult().add(detailinfo);
            }
            if (standCostCalcParam.isCalcCurLevel() && "2".equals(this.getSingleCheckContext().getCheckLevel())) {
                for (String jumpKeycol : jumpLevelMat) {
                    StringBuilder path = new StringBuilder();
                    StringBuilder tempPath = new StringBuilder(jumpKeycol);
                    StandCalcCheckHelper.getCalcTopLevelMat(jumpKeycol, configBomKeycolPidsMap, idConfigBomMap, (Set<String>)this.getContext().getFailProductKeycols(), path, tempPath);
                }
            }
        } else {
            DataSet bomSettingDataSet = this.getBomSettings(context.getCostTypeId(), new HashSet<String>(standCostCalcParam.getKeycols()));
            Set<String> jumpLevelMat = this.getJumpLevelMat(jumpLevelMatDataSet, bomSettingDataSet);
            if (CadEmptyUtils.isEmpty(jumpLevelMat)) {
                return;
            }
            Set<Long> bomIds = this.getBomIdsBySetting(bomSettingDataSet);
            DataSet bomDataSet = this.getBoms(bomIds, jumpLevelMat);
            DataSet resultDataSet = bomDataSet.join(bomSettingDataSet, JoinType.LEFT).on("id", "bom").select(bomDataSet.getRowMeta().getFieldNames(), new String[]{"bomsetnumber"}).finish();
            if (resultDataSet.isEmpty()) {
                return;
            }
            String error = ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\u201d\u5728\u6210\u672cBOM\u8bbe\u7f6e\u201c\u7f16\u7801\uff1a%3$s\u201d\u5bf9\u5e94\u7684\u6210\u672cBOM\u201c\u7f16\u7801\uff1a%4$s\u201d\u7ef4\u62a4\u4e86\u8df3\u5c42\uff0c\u672a\u8bc6\u522b\u5230\u6210\u672cBOM\u8bbe\u7f6e\u3002", (String)"BomSettingForJumpLevelChecker_2", (String)"macc-cad-algox", (Object[])new Object[0]);
            while (resultDataSet.hasNext()) {
                Row row = resultDataSet.next();
                if (row == null) continue;
                CalcCheckDetailResultInfo detailinfo = new CalcCheckDetailResultInfo();
                detailinfo.setCheckDetailResult(String.format(error, row.getString("materialnumber"), row.getString("materialname"), row.getString("bomsetnumber"), row.getString("bomnumber")));
                this.getSingleCheckContext().getCheckDetailResult().add(detailinfo);
            }
            if (standCostCalcParam.isCalcCurLevel() && "2".equals(this.getSingleCheckContext().getCheckLevel())) {
                for (String jumpKeycol : jumpLevelMat) {
                    StringBuilder path = new StringBuilder();
                    StringBuilder tempPath = new StringBuilder(jumpKeycol);
                    StandCalcCheckHelper.getCalcTopLevelMat(jumpKeycol, configBomKeycolPidsMap, idConfigBomMap, (Set<String>)this.getContext().getFailProductKeycols(), path, tempPath);
                }
            }
        }
        if (CadEmptyUtils.isEmpty(this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        String result = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"BomSettingForJumpLevelChecker_0", (String)"macc-cad-algox", (Object[])new Object[0]);
        this.getSingleCheckContext().setCheckResult(result);
        this.getSingleCheckContext().setPass(false);
    }

    private Set<String> getJumpLevelMat(DataSet jumpLevelMatDataSet, DataSet bomSettingDataSet) {
        DataSet bomSetDataSet = bomSettingDataSet.copy();
        DataSet dataSet = jumpLevelMatDataSet.join(bomSetDataSet, JoinType.LEFT).on("keycol", "bskeycol").select(jumpLevelMatDataSet.getRowMeta().getFieldNames(), bomSetDataSet.getRowMeta().getFieldNames()).finish();
        dataSet = dataSet.filter("material is null");
        HashSet<String> matIds = new HashSet<String>(16);
        if (dataSet.isEmpty()) {
            return matIds;
        }
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (row == null) continue;
            matIds.add(row.getString("keycol"));
        }
        return matIds;
    }

    private Set<String> getJumpLevelMatNew(DataSet jumpLevelMatDataSet, DataSet bomDataSet) {
        DataSet resultDataSet = jumpLevelMatDataSet.join(bomDataSet, JoinType.LEFT).on("material", "material").on("auxproperty", "auxproperty").on("configuredcode", "configuredcode").select(jumpLevelMatDataSet.getRowMeta().getFieldNames(), new String[]{"bomsetnumber"}).finish();
        resultDataSet = resultDataSet.filter("bomsetnumber is null");
        HashSet<String> matKeyCols = new HashSet<String>(16);
        while (resultDataSet.hasNext()) {
            Row row = resultDataSet.next();
            if (row == null) continue;
            matKeyCols.add(row.getString("keycol"));
        }
        return matKeyCols;
    }

    private Set<Long> getBomIdsBySetting(DataSet bomSettingDataSet) {
        HashSet<Long> bomIds = new HashSet<Long>(200);
        DataSet bs = bomSettingDataSet.copy();
        while (bs.hasNext()) {
            Row row = bs.next();
            if (row == null) continue;
            bomIds.add(row.getLong("bom"));
        }
        return bomIds;
    }

    private DataSet getBoms(Set<Long> bomIds, Set<String> matIds) {
        QFilter filter = new QFilter("id", "in", bomIds);
        filter.and(new QFilter("entry.entrykeycol", "in", matIds));
        return QueryServiceHelper.queryDataSet((String)this.algokey, (String)"cad_costbom", (String)"id,number bomnumber,entry.entrymaterial material,entry.entrymaterial.number materialnumber,entry.entrymaterial.name materialname", (QFilter[])new QFilter[]{filter}, null);
    }

    private DataSet getBomsNew(String srcEntity, Set<Long> bomIds, Set<String> jumpLevelMat) {
        DataSet jumpLevelMatDataSet = this.getJumpLevelMatDataSet(jumpLevelMat);
        QFilter filter = new QFilter("id", "in", bomIds);
        String matFields = "entry.entrymaterial material,entry.entrymaterial.number materialnumber,entry.entrymaterial.name materialname,entry.entryauxproperty auxpropid,entry.entryconfiguredcode configuredcode";
        if ("pdm_mftbom".equals(srcEntity)) {
            matFields = "entry.entrymaterial.masterid material,entry.entrymaterial.masterid.number materialnumber,entry.entrymaterial.masterid.name materialname,entry.entryauxproperty auxpropid,entry.entryconfiguredcode configuredcode";
        }
        DataSet bomDataSet = QueryServiceHelper.queryDataSet((String)this.algokey, (String)srcEntity, (String)("id,number bomnumber," + matFields), (QFilter[])new QFilter[]{filter}, null);
        DataSet dataSet = bomDataSet.join(jumpLevelMatDataSet, JoinType.INNER).on("material", "material").on("auxpropid", "auxproperty").on("configuredcode", "configuredcode").select(bomDataSet.getRowMeta().getFieldNames()).finish().distinct();
        return dataSet;
    }

    private DataSet getBomSettings(Long costType, Set<String> specifyMaterialKeycols) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter costtypeFilter = new QFilter("costtype.masterid", "=", (Object)costType);
        if (!CadEmptyUtils.isEmpty(specifyMaterialKeycols)) {
            costtypeFilter.and(new QFilter("keycol", "in", specifyMaterialKeycols));
        }
        return QueryServiceHelper.queryDataSet((String)this.algokey, (String)"cad_bomsetting", (String)"id,material.masterid material,number bomsetnumber,bom,keycol bskeycol", (QFilter[])new QFilter[]{costtypeFilter, statusFilter, enableFilter}, null);
    }

    private DataSet getVirtualMatBomDataSet(String srcEntity, Set<Long> bomIdSet) {
        QFilter filter = new QFilter("id", "in", bomIdSet);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        String matFields = "material.masterid material,material.number materialnumber,material.name materialname";
        if ("pdm_mftbom".equals(srcEntity)) {
            matFields = "material.masterid.masterid material,material.masterid.number materialnumber,material.masterid.name materialname";
        }
        return QueryServiceHelper.queryDataSet((String)this.algokey, (String)srcEntity, (String)("id,number bomsetnumber,auxproperty,configuredcode," + matFields), (QFilter[])new QFilter[]{filter, statusFilter, enableFilter}, null);
    }

    private DataSet getJumpLevelMatDataSet(Set<String> keycols) {
        return QueryServiceHelper.queryDataSet((String)"getJumpLevelMatDataSet", (String)"cad_keycol", (String)"material,auxproperty,tracknumber,configuredcode,keycol", (QFilter[])new QFilter[]{new QFilter("keycol", "in", keycols)}, null);
    }
}

