/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.checker;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.calc.helper.BomRuleSettingStdCalcHelper;
import kd.macc.cad.algox.calc.helper.StandCalcCheckHelper;
import kd.macc.cad.algox.calc.pojo.ConfigBomInfo;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;

public class ByProductUnPurPricesChecker
extends AbstractSingleCalcCheckAction {
    protected void doCheck() {
        CalcCheckContext context = this.getContext();
        if (context.getParams().get("standCostCalcParam") == null) {
            return;
        }
        StandCostCalcParam standCostCalcParam = (StandCostCalcParam)this.getContext().getParams().get("standCostCalcParam");
        Map<String, Map<String, BigDecimal>> mainAndCoByProductWithPurPriceMap = standCostCalcParam.getMainAndCoByProductWithPurPriceMap();
        if (CadEmptyUtils.isEmpty(mainAndCoByProductWithPurPriceMap)) {
            return;
        }
        HashSet<String> byProducts = new HashSet<String>(10);
        for (Map.Entry<String, Map<String, BigDecimal>> entry : mainAndCoByProductWithPurPriceMap.entrySet()) {
            Map<String, BigDecimal> value = entry.getValue();
            byProducts.addAll(value.keySet());
        }
        Date now = new Date();
        Long costTypeId = standCostCalcParam.getCostTypeId();
        QFilter qFilter = new QFilter("keycol", "in", byProducts);
        qFilter.and("costtype", "=", (Object)costTypeId);
        qFilter.and("effectdate", "<=", (Object)now);
        qFilter.and("expdate", ">", (Object)now);
        qFilter.and("billstatus", "=", (Object)"C");
        DataSet purDataSet = QueryServiceHelper.queryDataSet((String)"ByProductUnPurPricesChecker_2", (String)"cad_purprices", (String)"costtype,keycol,material.id purMatId", (QFilter[])new QFilter[]{qFilter}, null);
        HashSet<String> hasPriceByProducts = new HashSet<String>(10);
        while (purDataSet.hasNext()) {
            Row row = purDataSet.next();
            hasPriceByProducts.add(row.getString("keycol"));
        }
        byProducts.removeAll(hasPriceByProducts);
        if (CadEmptyUtils.isEmpty(byProducts)) {
            return;
        }
        QFilter filter = new QFilter("keycol", "in", byProducts);
        DynamicObjectCollection keycolDyos = QueryServiceHelper.query((String)"cad_keycol", (String)"material.number matnumber,material.name matname,auxproperty,project.number project,tracknumber.number tracknumber,configuredcode.number configuredcode,lot", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty(keycolDyos)) {
            return;
        }
        HashSet<Long> auxptyIds = new HashSet<Long>(10);
        for (DynamicObject keyColDyo : keycolDyos) {
            auxptyIds.add(keyColDyo.getLong("auxproperty"));
        }
        HashMap<Long, String> auxptyMap = new HashMap<Long, String>(16);
        HashMap<String, String> typeNameMap = new HashMap<String, String>(16);
        HashMap<Long, String> auxpValueMap = new HashMap<Long, String>(16);
        BomRuleSettingStdCalcHelper.getMatAuxptyInfo(auxptyIds, auxptyMap, typeNameMap, auxpValueMap);
        String checkDesc = ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u526f\u4ea7\u54c1\u7684\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u3002", (String)"ByProductUnPurPricesChecker_0", (String)"macc-cad-algox", (Object[])new Object[0]);
        String unCheckDesc = ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u5bf9\u5e94\u526f\u4ea7\u54c1\u4ece\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u53d6\u6570\uff0c\u4f46\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u3002", (String)"ByProductUnPurPricesChecker_9", (String)"macc-cad-algox", (Object[])new Object[0]);
        String number = ResManager.loadKDString((String)"\u7f16\u7801\uff1a", (String)"ByProductUnPurPricesChecker_7", (String)"macc-cad-algox", (Object[])new Object[0]);
        String name = ResManager.loadKDString((String)"\uff1b\u540d\u79f0\uff1a", (String)"ByProductUnPurPricesChecker_8", (String)"macc-cad-algox", (Object[])new Object[0]);
        for (DynamicObject keycolDyo : keycolDyos) {
            String matNumber = keycolDyo.getString("matnumber");
            String matName = keycolDyo.getString("matname");
            Long auxproperty = keycolDyo.getLong("auxproperty");
            String configuredcode = keycolDyo.getString("configuredcode");
            String tracknumber = keycolDyo.getString("tracknumber");
            String project = keycolDyo.getString("project");
            String lot = keycolDyo.getString("lot");
            StringBuilder sg = new StringBuilder();
            sg.append(number);
            sg.append(matNumber);
            sg.append(name);
            sg.append(matName);
            if (!CadEmptyUtils.isEmpty(auxproperty)) {
                String auxValueStr = (String)auxptyMap.get(auxproperty);
                JSONObject value = (JSONObject)JSON.parse((String)auxValueStr);
                if (value == null) continue;
                StringBuilder auxStr = new StringBuilder();
                for (Map.Entry val : value.entrySet()) {
                    auxStr.append((String)typeNameMap.get(val.getKey())).append(':');
                    if (String.valueOf(val.getValue()).matches("[0-9]+") && auxpValueMap.containsKey(Long.parseLong(val.getValue().toString()))) {
                        auxStr.append((String)auxpValueMap.get(Long.parseLong(val.getValue().toString()))).append(';');
                        continue;
                    }
                    auxStr.append(val.getValue()).append(';');
                }
                sg.append(String.format(ResManager.loadKDString((String)"\uff1b\u8f85\u52a9\u5c5e\u6027\uff1a%s", (String)"ByProductUnPurPricesChecker_2", (String)"macc-cad-algox", (Object[])new Object[0]), auxStr));
            }
            if (!CadEmptyUtils.isEmpty(configuredcode)) {
                sg.append(String.format(ResManager.loadKDString((String)"\uff1b\u914d\u7f6e\u53f7\uff1a%s", (String)"ByProductUnPurPricesChecker_3", (String)"macc-cad-algox", (Object[])new Object[0]), configuredcode));
            }
            if (!CadEmptyUtils.isEmpty(tracknumber)) {
                sg.append(String.format(ResManager.loadKDString((String)"\uff1b\u8ddf\u8e2a\u53f7\uff1a%s", (String)"ByProductUnPurPricesChecker_4", (String)"macc-cad-algox", (Object[])new Object[0]), tracknumber));
            }
            if (!CadEmptyUtils.isEmpty(project)) {
                sg.append(String.format(ResManager.loadKDString((String)"\uff1b\u9879\u76ee\u53f7\uff1a%s", (String)"ByProductUnPurPricesChecker_5", (String)"macc-cad-algox", (Object[])new Object[0]), project));
            }
            if (!CadEmptyUtils.isEmpty(lot)) {
                sg.append(String.format(ResManager.loadKDString((String)"\uff1b\u6279\u53f7\uff1a%s", (String)"ByProductUnPurPricesChecker_6", (String)"macc-cad-algox", (Object[])new Object[0]), lot));
            }
            CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
            info.setCheckDetailResult(String.format(unCheckDesc, sg.toString()));
            this.getSingleCheckContext().getCheckDetailResult().add(info);
        }
        if (CadEmptyUtils.isEmpty(this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        if (standCostCalcParam.isCalcCurLevel() && "2".equals(this.getSingleCheckContext().getCheckLevel())) {
            HashMap<String, Set<Long>> configBomKeycolPidsMap = new HashMap<String, Set<Long>>(16);
            HashMap<Long, ConfigBomInfo> idConfigBomMap = new HashMap<Long, ConfigBomInfo>(16);
            for (ConfigBomInfo configBomInfo : standCostCalcParam.getConfigBomInfoList()) {
                Set pids = configBomKeycolPidsMap.computeIfAbsent(configBomInfo.getKeycol(), p -> new HashSet());
                if (configBomInfo.getPid() != 0L) {
                    pids.add(configBomInfo.getPid());
                }
                if (configBomInfo.getPid() != 0L) continue;
                idConfigBomMap.put(configBomInfo.getId(), configBomInfo);
            }
            HashSet<String> noPassKeycols = new HashSet<String>(10);
            for (Map.Entry<String, Map<String, BigDecimal>> entry : mainAndCoByProductWithPurPriceMap.entrySet()) {
                Map<String, BigDecimal> value = entry.getValue();
                for (String byProduct : byProducts) {
                    if (!value.containsKey(byProduct)) continue;
                    noPassKeycols.add(entry.getKey());
                }
            }
            for (String keycol : noPassKeycols) {
                StringBuilder path = new StringBuilder();
                StringBuilder tempPath = new StringBuilder(keycol);
                StandCalcCheckHelper.getCalcTopLevelMat(keycol, configBomKeycolPidsMap, idConfigBomMap, (Set<String>)this.getContext().getFailProductKeycols(), path, tempPath);
            }
        }
        this.getSingleCheckContext().setPass(false);
        this.getSingleCheckContext().setCheckResult(checkDesc);
    }
}

