/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.checker;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.macc.cad.algox.calc.helper.BomRuleSettingStdCalcHelper;
import kd.macc.cad.algox.calc.helper.StandCalcCheckHelper;
import kd.macc.cad.algox.calc.pojo.ConfigBomInfo;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;

public class ByProductsRefMultMatChecker
extends AbstractSingleCalcCheckAction {
    public void doCheck() {
        CalcCheckContext context = this.getContext();
        if (context.getParams().get("standCostCalcParam") == null) {
            return;
        }
        StandCostCalcParam standCostCalcParam = (StandCostCalcParam)this.getContext().getParams().get("standCostCalcParam");
        Map<String, Map<String, BigDecimal>> mainAndCoByProductWithOutBomMap = standCostCalcParam.getMainAndCoByProductWithOutBomMap();
        if (CadEmptyUtils.isEmpty(mainAndCoByProductWithOutBomMap)) {
            return;
        }
        HashMap<String, Set> byProductAndMainProductMap = new HashMap<String, Set>(16);
        for (Map.Entry<String, Map<String, BigDecimal>> entry : mainAndCoByProductWithOutBomMap.entrySet()) {
            String string = entry.getKey();
            Map<String, BigDecimal> value = entry.getValue();
            for (Map.Entry<String, BigDecimal> vEntry : value.entrySet()) {
                byProductAndMainProductMap.computeIfAbsent(vEntry.getKey(), p -> new HashSet()).add(string);
            }
        }
        HashSet<String> keycols = new HashSet<String>(10);
        for (Map.Entry entry : byProductAndMainProductMap.entrySet()) {
            String byProduct = (String)entry.getKey();
            Set mainProducts = (Set)entry.getValue();
            if (mainProducts.size() <= 1) continue;
            keycols.add(byProduct);
            keycols.addAll(mainProducts);
        }
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>(16);
        DataSet dataSet = BomRuleSettingStdCalcHelper.getBomMatDataSetByKeyCol(keycols);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String keycol = row.getString("keycol");
            Iterator matName = row.getString("matname");
            String matNumber = row.getString("matnumber");
            Long auxpty = row.getLong("auxproperty");
            String configuredcodenum = row.getString("configuredcodenum");
            String tracknumbernum = row.getString("tracknumbernum");
            hashMap.put(keycol, new Object[]{matNumber, matName, auxpty, configuredcodenum, tracknumbernum});
        }
        HashMap<String, Set<Long>> configBomKeycolPidsMap = new HashMap<String, Set<Long>>(16);
        HashMap<Long, ConfigBomInfo> idConfigBomMap = new HashMap<Long, ConfigBomInfo>(16);
        for (ConfigBomInfo configBomInfo : standCostCalcParam.getConfigBomInfoList()) {
            Set pids = configBomKeycolPidsMap.computeIfAbsent(configBomInfo.getKeycol(), p -> new HashSet());
            if (configBomInfo.getPid() != 0L) {
                pids.add(configBomInfo.getPid());
            }
            if (configBomInfo.getPid() != 0L) continue;
            idConfigBomMap.put(configBomInfo.getId(), configBomInfo);
        }
        for (Map.Entry entry : byProductAndMainProductMap.entrySet()) {
            Object[] objects;
            String byProduct = (String)entry.getKey();
            Set mainProducts = (Set)entry.getValue();
            if (mainProducts.size() <= 1 || CadEmptyUtils.isEmpty(objects = (Object[])hashMap.get(byProduct))) continue;
            String prodcutInfoMess = String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\u201d", (String)"ByProductsRefMultMatChecker_4", (String)"macc-cad-algox", (Object[])new Object[0]), objects[0], objects[1]);
            StringBuilder mianProductMess = new StringBuilder();
            for (String mainProduct : mainProducts) {
                if (standCostCalcParam.isCalcCurLevel() && "2".equals(this.getSingleCheckContext().getCheckLevel())) {
                    StringBuilder path = new StringBuilder();
                    StringBuilder tempPath = new StringBuilder(mainProduct);
                    StandCalcCheckHelper.getCalcTopLevelMat(mainProduct, configBomKeycolPidsMap, idConfigBomMap, (Set<String>)this.getContext().getFailProductKeycols(), path, tempPath);
                }
                Object[] mainObjects = (Object[])hashMap.get(mainProduct);
                mianProductMess.append(String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\u201d\u3001", (String)"ByProductsRefMultMatChecker_5", (String)"macc-cad-algox", (Object[])new Object[0]), mainObjects[0], mainObjects[1]));
            }
            CalcCheckDetailResultInfo detailinfo = new CalcCheckDetailResultInfo();
            String error = String.format(ResManager.loadKDString((String)"\u8054\u4ea7\u54c1%1$s\u5728\u7269\u6599%2$s\u4e2d\u88ab\u8bbe\u7f6e\uff0c\u4e14\u8be5\u8054\u4ea7\u54c1\u6ca1\u6709\u81ea\u5df1\u7684\u6210\u672c\uff0c\u6807\u51c6\u6210\u672c\u4e0d\u552f\u4e00\u3002", (String)"ByProductsRefMultMatChecker_6", (String)"macc-cad-algox", (Object[])new Object[0]), prodcutInfoMess, mianProductMess.substring(0, mianProductMess.length() - 1));
            detailinfo.setCheckDetailResult(error);
            this.getSingleCheckContext().getCheckDetailResult().add(detailinfo);
        }
        if (CadEmptyUtils.isEmpty(this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        String result = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"ByProductsRefMultMatChecker_3", (String)"macc-cad-algox", (Object[])new Object[0]);
        this.getSingleCheckContext().setCheckResult(result);
        this.getSingleCheckContext().setPass(false);
    }
}

