/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.checker;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.algox.StandCostCalculateService;
import kd.macc.cad.algox.calc.checker.CheckerConstant;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;

public class ByProductsStdCostChecker
extends AbstractSingleCalcCheckAction {
    public void doCheck() {
        CalcCheckContext context = this.getContext();
        if (context.getParams().get("standCostCalcParam") == null) {
            return;
        }
        if (context.getCheckMode() == 2) {
            return;
        }
        StandCostCalcParam standCostCalcParam = (StandCostCalcParam)context.getParams().get("standCostCalcParam");
        Map<String, Map<String, BigDecimal>> mainAndCoByProductWithPurPriceMap = standCostCalcParam.getMainAndCoByProductWithPurPriceMap();
        Map<String, List<String>> mainAndCoByProductWithBomMap = standCostCalcParam.getMainAndCoByProductWithBomMap();
        Map<String, Map<String, BigDecimal>> mainAndCoByProductWithOutBomMap = standCostCalcParam.getMainAndCoByProductWithOutBomMap();
        if (CadEmptyUtils.isEmpty(mainAndCoByProductWithPurPriceMap) && CadEmptyUtils.isEmpty(mainAndCoByProductWithBomMap) && CadEmptyUtils.isEmpty(mainAndCoByProductWithOutBomMap)) {
            return;
        }
        StandCostCalculateService calcService = new StandCostCalculateService();
        calcService.calculate(standCostCalcParam);
        QFilter checkItmeFilter = new QFilter("checkitem", "=", (Object)("sca".equals(context.getAppNum()) ? CheckerConstant.SCA_BYPRODUCTSSTDCOSTINVALI_ITME : CheckerConstant.ACA_BYPRODUCTSSTDCOSTINVALI_ITME));
        QFilter taskFilter = new QFilter("calctaskrecord", "=", (Object)standCostCalcParam.getCheckTaskId());
        DynamicObject checkResult = BusinessDataServiceHelper.loadSingle((String)"cad_calccheckresult", (String)"checkresult,checkresultdesc,entryentity.seq,entryentity.errordesc,entryentity.suggest", (QFilter[])new QFilter[]{checkItmeFilter, taskFilter});
        if (checkResult == null) {
            return;
        }
        DynamicObjectCollection checkRsDetails = checkResult.getDynamicObjectCollection("entryentity");
        for (DynamicObject checkRsDetail : checkRsDetails) {
            CalcCheckDetailResultInfo detailinfo = new CalcCheckDetailResultInfo();
            detailinfo.setCheckDetailResult(checkRsDetail.getString("errordesc"));
            this.getSingleCheckContext().getCheckDetailResult().add(detailinfo);
        }
        if (CadEmptyUtils.isEmpty(this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        String result = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"ByProductsStdCostChecker_0", (String)"macc-cad-algox", (Object[])new Object[0]);
        this.getSingleCheckContext().setCheckResult(result);
        this.getSingleCheckContext().setPass(false);
    }
}

