/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.checker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.calc.helper.StandCalcCheckHelper;
import kd.macc.cad.algox.calc.pojo.ConfigBomInfo;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;

public class CostTypeRefCostUpdateBillChecker
extends AbstractSingleCalcCheckAction {
    public void doCheck() {
        List<String> unEffCostUpdateBills;
        CalcCheckContext context = this.getContext();
        if (context.getParams().get("standCostCalcParam") == null) {
            return;
        }
        StandCostCalcParam standCostCalcParam = (StandCostCalcParam)this.getContext().getParams().get("standCostCalcParam");
        Set<String> specifyMaterialIds = new HashSet<String>(10);
        if (standCostCalcParam.getScopetype() == 1) {
            if (standCostCalcParam.isCalcCurLevel() && "2".equals(this.getSingleCheckContext().getCheckLevel())) {
                specifyMaterialIds = StandCalcCheckHelper.getAppointMat(standCostCalcParam.getWizardMatScopInfos(), null);
            } else {
                for (ConfigBomInfo configBomInfo : standCostCalcParam.getConfigBomInfoList()) {
                    specifyMaterialIds.add(configBomInfo.getKeycol());
                }
            }
        }
        if (CadEmptyUtils.isEmpty(unEffCostUpdateBills = this.getUnEffCostUpdateBills(context.getCostTypeId(), specifyMaterialIds))) {
            return;
        }
        for (String unEffCostUpdateBill : unEffCostUpdateBills) {
            CalcCheckDetailResultInfo detailinfo = new CalcCheckDetailResultInfo();
            String error = String.format(ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0\u7533\u8bf7\u5355\u201c%s\u201d\u672a\u751f\u6548\u3002", (String)"CostTypeRefCostUpdateBillChecker_0", (String)"macc-cad-algox", (Object[])new Object[0]), unEffCostUpdateBill);
            detailinfo.setCheckDetailResult(error);
            this.getSingleCheckContext().getCheckDetailResult().add(detailinfo);
        }
        String string = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"CostTypeRefCostUpdateBillChecker_1", (String)"macc-cad-algox", (Object[])new Object[0]);
        this.getSingleCheckContext().setCheckResult(string);
        this.getSingleCheckContext().setPass(false);
    }

    private List<String> getUnEffCostUpdateBills(Long costTypeId, Set<String> specifyMaterialIds) {
        DynamicObjectCollection costUpdateBills;
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)"cad_keycol", (String)"id,keycol,material", (QFilter[])new QFilter[]{new QFilter("keycol", "in", specifyMaterialIds)});
        HashMap<String, Long> keycolMatMap = new HashMap<String, Long>(16);
        for (Object dyo : dyos) {
            keycolMatMap.put(dyo.getString("keycol"), dyo.getLong("material"));
        }
        HashSet materialIds = new HashSet(10);
        for (Map.Entry entry : keycolMatMap.entrySet()) {
            materialIds.add(entry.getValue());
        }
        ArrayList<String> costUpdateBillNoList = new ArrayList<String>(200);
        QFilter qFilter = new QFilter("srccosttype", "=", (Object)costTypeId);
        qFilter.and("updatestatus", "=", (Object)"N");
        if (!CadEmptyUtils.isEmpty(materialIds)) {
            qFilter.and("entryentity.material.masterid", "in", materialIds);
        }
        if (CadEmptyUtils.isEmpty(costUpdateBills = QueryServiceHelper.query((String)"cad_costupdatenew", (String)"billno", (QFilter[])new QFilter[]{qFilter}))) {
            return costUpdateBillNoList;
        }
        for (DynamicObject costUpdateBill : costUpdateBills) {
            String billno = costUpdateBill.getString("billno");
            if (costUpdateBillNoList.contains(billno)) continue;
            costUpdateBillNoList.add(billno);
        }
        return costUpdateBillNoList;
    }
}

