/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.checker;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.macc.cad.algox.calc.helper.BomRuleSettingStdCalcHelper;
import kd.macc.cad.algox.calc.helper.StandCalcCheckHelper;
import kd.macc.cad.algox.calc.pojo.ConfigBomInfo;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;

public class OutSourceMaterialToDetailChecker
extends AbstractSingleCalcCheckAction {
    public void doCheck() {
        CalcCheckContext context = this.getContext();
        if (context.getParams().get("standCostCalcParam") == null) {
            return;
        }
        StandCostCalcParam standCostCalcParam = (StandCostCalcParam)this.getContext().getParams().get("standCostCalcParam");
        List<ConfigBomInfo> configBomInfoList = standCostCalcParam.getConfigBomInfoList();
        HashSet<String> pidKeycols = new HashSet<String>(16);
        HashSet<String> outSourceKeycols = new HashSet<String>(10);
        HashMap<String, Set<Long>> configBomKeycolPidsMap = new HashMap<String, Set<Long>>(16);
        HashMap<Long, ConfigBomInfo> idConfigBomMap = new HashMap<Long, ConfigBomInfo>(16);
        for (ConfigBomInfo configBomInfo : configBomInfoList) {
            if (configBomInfo.isOutSource().booleanValue()) {
                outSourceKeycols.add(configBomInfo.getKeycol());
            }
            if (!standCostCalcParam.isTrackCalc().booleanValue() && !standCostCalcParam.isDefaultConfigCalc().booleanValue() && CadEmptyUtils.isEmpty(configBomInfo.getPid())) {
                pidKeycols.add(configBomInfo.getKeycol());
            }
            Set parentIds = configBomKeycolPidsMap.computeIfAbsent(configBomInfo.getKeycol(), p -> new HashSet());
            if (configBomInfo.getPid() != 0L) {
                parentIds.add(configBomInfo.getPid());
            }
            if (configBomInfo.getPid() != 0L) continue;
            idConfigBomMap.put(configBomInfo.getId(), configBomInfo);
        }
        if (standCostCalcParam.isTrackCalc().booleanValue() || standCostCalcParam.isDefaultConfigCalc().booleanValue()) {
            for (Long pid : standCostCalcParam.getBomPidsForTrackCalc()) {
                if (!idConfigBomMap.containsKey(pid) || idConfigBomMap.get(pid) == null) continue;
                pidKeycols.add(((ConfigBomInfo)idConfigBomMap.get(pid)).getKeycol());
            }
        }
        Set<String> appointMats = StandCalcCheckHelper.getAppointMat(standCostCalcParam.getWizardMatScopInfos(), Lists.newArrayList((Object[])new String[]{"C"}));
        outSourceKeycols.addAll(appointMats);
        outSourceKeycols.removeAll(pidKeycols);
        if (CadEmptyUtils.isEmpty(outSourceKeycols)) {
            return;
        }
        DataSet bomMatDataSetByKeyCol = BomRuleSettingStdCalcHelper.getBomMatDataSetByKeyCol(outSourceKeycols);
        HashSet<Long> auxptyIds = new HashSet<Long>(16);
        DataSet cpDataSet = bomMatDataSetByKeyCol.copy();
        while (cpDataSet.hasNext()) {
            Row row = cpDataSet.next();
            Long auxpty = row.getLong("auxproperty");
            if (CadEmptyUtils.isEmpty(auxpty)) continue;
            auxptyIds.add(auxpty);
        }
        HashMap<Long, String> auxptyMap = new HashMap<Long, String>(16);
        HashMap<String, String> typeNameMap = new HashMap<String, String>(16);
        HashMap<Long, String> auxpValueMap = new HashMap<Long, String>(16);
        BomRuleSettingStdCalcHelper.getMatAuxptyInfo(auxptyIds, auxptyMap, typeNameMap, auxpValueMap);
        while (bomMatDataSetByKeyCol.hasNext()) {
            StringBuilder auxStr;
            JSONObject value;
            String auxValueStr;
            Row row = bomMatDataSetByKeyCol.next();
            String keycol = row.getString("keycol");
            Long material = row.getLong("material");
            Long auxpropId = row.getLong("auxproperty");
            Long configuredCode = row.getLong("configuredcode");
            if (CadEmptyUtils.isEmpty(material)) continue;
            String error = "";
            CalcCheckDetailResultInfo detailinfo = new CalcCheckDetailResultInfo();
            if (!CadEmptyUtils.isEmpty(auxpropId) && !CadEmptyUtils.isEmpty(configuredCode)) {
                auxValueStr = (String)auxptyMap.get(auxpropId);
                value = (JSONObject)JSON.parse((String)auxValueStr);
                if (value == null) continue;
                auxStr = new StringBuilder();
                for (Map.Entry val : value.entrySet()) {
                    auxStr.append((String)typeNameMap.get(val.getKey())).append(':');
                    if (String.valueOf(val.getValue()).matches("[0-9]+") && auxpValueMap.containsKey(Long.parseLong(val.getValue().toString()))) {
                        auxStr.append((String)auxpValueMap.get(Long.parseLong(val.getValue().toString()))).append(';');
                        continue;
                    }
                    auxStr.append(val.getValue()).append(';');
                }
                error = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\uff1b\u8f85\u52a9\u5c5e\u6027\uff1a%3$s\uff1b\u914d\u7f6e\u53f7\uff1a%4$s\u201d\uff0c\u672a\u5c55\u5f00\u5230\u6700\u660e\u7ec6\u3002", (String)"OutSourceMaterialToDetailChecker_2", (String)"macc-cad-algox", (Object[])new Object[0]), row.getString("matnumber"), row.getString("matname"), auxStr.toString().substring(0, auxStr.toString().lastIndexOf(";")), row.getString("configuredcodenum"));
            } else if (!CadEmptyUtils.isEmpty(auxpropId)) {
                auxValueStr = (String)auxptyMap.get(auxpropId);
                value = (JSONObject)JSON.parse((String)auxValueStr);
                if (value == null) continue;
                auxStr = new StringBuilder();
                for (Map.Entry val : value.entrySet()) {
                    auxStr.append((String)typeNameMap.get(val.getKey())).append(':');
                    if (String.valueOf(val.getValue()).matches("[0-9]+") && auxpValueMap.containsKey(Long.parseLong(val.getValue().toString()))) {
                        auxStr.append((String)auxpValueMap.get(Long.parseLong(val.getValue().toString()))).append(';');
                        continue;
                    }
                    auxStr.append(val.getValue()).append(';');
                }
                error = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\uff1b\u8f85\u52a9\u5c5e\u6027\uff1a%3$s\u201d\uff0c\u672a\u5c55\u5f00\u5230\u6700\u660e\u7ec6\u3002", (String)"OutSourceMaterialToDetailChecker_3", (String)"macc-cad-algox", (Object[])new Object[0]), row.getString("matnumber"), row.getString("matname"), auxStr.toString().substring(0, auxStr.toString().lastIndexOf(";")));
            } else {
                error = !CadEmptyUtils.isEmpty(configuredCode) ? String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\uff1b\u914d\u7f6e\u53f7\uff1a%3$s\u201d\uff0c\u672a\u5c55\u5f00\u5230\u6700\u660e\u7ec6\u3002", (String)"OutSourceMaterialToDetailChecker_4", (String)"macc-cad-algox", (Object[])new Object[0]), row.getString("matnumber"), row.getString("matname"), row.getString("configuredcodenum")) : String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\u201d\uff0c\u672a\u5c55\u5f00\u5230\u6700\u660e\u7ec6\u3002", (String)"OutSourceMaterialToDetailChecker_5", (String)"macc-cad-algox", (Object[])new Object[0]), row.getString("matnumber"), row.getString("matname"));
            }
            detailinfo.setCheckDetailResult(error);
            this.getSingleCheckContext().getCheckDetailResult().add(detailinfo);
            if (!standCostCalcParam.isCalcCurLevel() || !"2".equals(this.getSingleCheckContext().getCheckLevel())) continue;
            StringBuilder path = new StringBuilder();
            StringBuilder tempPath = new StringBuilder(keycol);
            StandCalcCheckHelper.getCalcTopLevelMat(keycol, configBomKeycolPidsMap, idConfigBomMap, (Set<String>)this.getContext().getFailProductKeycols(), path, tempPath);
        }
        if (CadEmptyUtils.isEmpty(this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        String result = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"OutSourceMaterialToDetailChecker_1", (String)"macc-cad-algox", (Object[])new Object[0]);
        this.getSingleCheckContext().setCheckResult(result);
        this.getSingleCheckContext().setPass(false);
    }
}

